/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.mservice.service.offer;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.mservice.api.offer.HomePageServiceApi;
import kd.tsc.tso.mservice.vo.req.GetOfferAuditReqVO;
import kd.tsc.tso.mservice.vo.req.GetOfferPeopleReqVO;
import kd.tsc.tspr.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsrbd.common.constants.DateFormatConstants;
import kd.tsc.tsrbd.common.enums.DatePeriodEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.common.enums.DeleteEnum;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;
import org.apache.commons.lang3.StringUtils;

public class HomePageServiceApiImpl
implements HomePageServiceApi {
    private static final Log log = LogFactory.getLog(HomePageServiceApiImpl.class);
    private static final String POSITION_STATUS = "appfile.position.positionstatus";
    private static final String POSITION_RECRUPROC = "appfile.recruproc";
    private static final String BASE_DATA_ID = "FBASEDATAID";
    private static Map<String, Long> offerStatusMap = new HashMap<String, Long>();

    public Integer getOfferAuditNumberByDate(String requestParam) {
        log.info("getOfferAuditNumberByDate method begin, requestParam is -> {}", (Object)requestParam);
        if (StringUtils.isEmpty((CharSequence)requestParam)) {
            log.warn("getOfferAuditNumberByDate requestParam is empty!");
            return null;
        }
        GetOfferAuditReqVO reqVO = (GetOfferAuditReqVO)JSON.parseObject((String)requestParam, GetOfferAuditReqVO.class);
        if (reqVO.isInvalid().booleanValue()) {
            log.warn("GetOfferAuditReqVO exists empty param!");
            return 0;
        }
        return this.countAuditNumberHandle(reqVO);
    }

    public Map<String, Integer> getOfferPeopleNumber(String requestParam) {
        log.info("getOfferPeopleNumber method begin, requestParam is -> {}", (Object)requestParam);
        if (StringUtils.isEmpty((CharSequence)requestParam)) {
            log.warn("getOfferPeopleNumber requestParam is empty!");
            return null;
        }
        GetOfferPeopleReqVO reqVO = (GetOfferPeopleReqVO)JSON.parseObject((String)requestParam, GetOfferPeopleReqVO.class);
        if (reqVO.isInvalid().booleanValue()) {
            log.warn("getOfferPeopleNumber exists empty param!");
            return null;
        }
        return this.countNumberHandle(reqVO);
    }

    private Integer countAuditNumberHandle(GetOfferAuditReqVO reqVO) {
        ArrayList<String> auditStatusList = new ArrayList<String>();
        auditStatusList.add(OfferAuditStatus.ALR_SUBMIT.getCode());
        auditStatusList.add(OfferAuditStatus.AUDITING.getCode());
        auditStatusList.add(OfferAuditStatus.WAIT_RESUBMIT.getCode());
        QFilter offerBillFilter = new QFilter("billstatus", "in", auditStatusList).and("applicant", "=", (Object)UserServiceHelper.getCurrentUserId());
        DatePeriodEnum datePeriodEnum = DatePeriodEnum.getByCode((String)reqVO.getDatePeriodCode());
        if (Objects.nonNull(datePeriodEnum)) {
            offerBillFilter.and(this.getDateFilterHandle(datePeriodEnum, "applytime"));
        }
        return TsrbsHelper.count((QFilter[])offerBillFilter.toArray(), (String)"tso_somk_offerbill");
    }

    private Map<String, Integer> countNumberHandle(GetOfferPeopleReqVO reqVO) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        offerStatusMap.forEach((key, offerStatus) -> map.put((String)key, this.getCountByStatus(reqVO, (Long)offerStatus)));
        return map;
    }

    private Integer getCountByStatus(GetOfferPeopleReqVO reqVO, Long offerStatus) {
        List<DynamicObject> offerList = this.getFilterOfferList(reqVO, offerStatus);
        long count = offerList.stream().map(offer -> {
            DynamicObject appFile = offer.getDynamicObject("appfile");
            if (Objects.nonNull(appFile)) {
                return appFile.getLong("id");
            }
            return null;
        }).distinct().count();
        return Integer.valueOf(String.valueOf(count));
    }

    public List<DynamicObject> getFilterOfferList(GetOfferPeopleReqVO reqVO, Long offerStatus) {
        QFilter offerFilter = new QFilter(POSITION_STATUS, "=", (Object)"A").and("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode());
        if (0L != reqVO.getBusunitId()) {
            offerFilter.and("busunit", "=", (Object)reqVO.getBusunitId());
        }
        if (0L != reqVO.getRecruproc()) {
            offerFilter.and(POSITION_RECRUPROC, "=", (Object)reqVO.getRecruproc());
        }
        offerFilter.and(this.offerStatusFilterHandle(reqVO, offerStatus));
        return TsrbsHelper.selectByFilter((QFilter[])offerFilter.toArray(), (String)"tso_somk_offerbase");
    }

    private QFilter offerStatusFilterHandle(GetOfferPeopleReqVO reqVO, Long offerStatus) {
        QFilter qFilter = new QFilter("applicant", "=", (Object)UserServiceHelper.getCurrentUserId());
        DatePeriodEnum datePeriodEnum = DatePeriodEnum.getByCode((String)reqVO.getDatePeriodCode());
        Boolean isAll = reqVO.getAll();
        if (!isAll.booleanValue()) {
            qFilter.and(TSCBaseUtils.getSelPropDot((String[])new String[]{"deliver", BASE_DATA_ID}), "in", (Object)UserServiceHelper.getCurrentUserId());
        }
        if (OfferStatus.PRE_APPLY.getCode().equals(offerStatus)) {
            this.preApplyHandle(qFilter, datePeriodEnum, offerStatus, isAll);
        } else if (OfferStatus.APPLYING.getCode().equals(offerStatus)) {
            this.applyingHandle(qFilter, datePeriodEnum, offerStatus);
        } else {
            this.sendHandle(qFilter, datePeriodEnum);
        }
        return qFilter;
    }

    private void sendHandle(QFilter qFilter, DatePeriodEnum datePeriodEnum) {
        List<Long> offerLetterIdList;
        if (Objects.nonNull(datePeriodEnum) && !CollectionUtils.isEmpty(offerLetterIdList = this.getOfferLetterIdListHandle(datePeriodEnum))) {
            qFilter.and("offerletter", "in", offerLetterIdList);
        }
    }

    private void applyingHandle(QFilter qFilter, DatePeriodEnum datePeriodEnum, Long offerStatus) {
        List<String> offerApproveIdList;
        qFilter.and("status", "=", (Object)offerStatus);
        if (Objects.nonNull(datePeriodEnum) && !CollectionUtils.isEmpty(offerApproveIdList = this.getOfferApproveNoListHandle(datePeriodEnum))) {
            qFilter.and("offerauditno", "in", offerApproveIdList);
        }
    }

    private void preApplyHandle(QFilter qFilter, DatePeriodEnum datePeriodEnum, Long offerStatus, Boolean isAll) {
        qFilter.and("status", "=", (Object)offerStatus);
        if (isAll.booleanValue()) {
            qFilter = qFilter.or("applicant", "=", null).or("applicant", "=", (Object)0L);
            if (Objects.nonNull(datePeriodEnum)) {
                QFilter dateFilter = this.getDateFilterHandle(datePeriodEnum, "applytime").or(this.getDateFilterHandle(datePeriodEnum, "createtime"));
                qFilter.and(dateFilter);
            }
        } else if (Objects.nonNull(datePeriodEnum)) {
            qFilter.and(this.getDateFilterHandle(datePeriodEnum, "applytime"));
        }
    }

    private List<Long> getOfferLetterIdListHandle(DatePeriodEnum datePeriodEnum) {
        ArrayList<Long> offerLetterReplyStatusList = new ArrayList<Long>();
        offerLetterReplyStatusList.add(OfferLetterReplyStatus.PRE_REPLY.getCode());
        offerLetterReplyStatusList.add(OfferLetterReplyStatus.ALR_OUTTIME.getCode());
        offerLetterReplyStatusList.add(OfferLetterReplyStatus.ALR_ACCEPT.getCode());
        offerLetterReplyStatusList.add(OfferLetterReplyStatus.ALR_REFUSE.getCode());
        QFilter qFilter = this.getDateFilterHandle(datePeriodEnum, "sendtime").and("replystatus", "in", offerLetterReplyStatusList);
        List offerLetterList = TsrbsHelper.selectByFilter((QFilter[])qFilter.toArray(), (String)"tso_offerletter");
        if (CollectionUtils.isEmpty((Collection)offerLetterList)) {
            return null;
        }
        return offerLetterList.stream().map(offerApprove -> offerApprove.getLong("id")).distinct().collect(Collectors.toList());
    }

    private List<String> getOfferApproveNoListHandle(DatePeriodEnum datePeriodEnum) {
        QFilter qFilter = this.getDateFilterHandle(datePeriodEnum, "applytime");
        List offerApproveList = TsrbsHelper.selectByFilter((QFilter[])qFilter.toArray(), (String)"tso_somk_offerbill");
        if (CollectionUtils.isEmpty((Collection)offerApproveList)) {
            return null;
        }
        return offerApproveList.stream().map(offerApprove -> offerApprove.getString("billno")).distinct().collect(Collectors.toList());
    }

    private QFilter getDateFilterHandle(DatePeriodEnum datePeriodEnum, String timeType) {
        String startTime = DateUtils.getDayStartTime((LocalDate)DateUtils.getByPeriod((DatePeriodEnum)datePeriodEnum));
        String endTime = DateUtils.getDayEndTime((LocalDate)LocalDate.now());
        return new QFilter(timeType, ">=", (Object)LocalDateTime.parse(startTime, DateFormatConstants.NORM_DATETIME_FORM)).and(timeType, "<=", (Object)LocalDateTime.parse(endTime, DateFormatConstants.NORM_DATETIME_FORM));
    }

    static {
        offerStatusMap.put("preApply", OfferStatus.PRE_APPLY.getCode());
        offerStatusMap.put("applying", OfferStatus.APPLYING.getCode());
        offerStatusMap.put("alrSend", OfferLetterStatus.ALR_SEND.getCode());
    }
}

