/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.mservice.service.offer;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.letter.OfferLetterService;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.mservice.api.offer.OfferBaseServiceApi;
import kd.tsc.tso.mservice.service.offer.HomePageServiceApiImpl;
import kd.tsc.tso.mservice.vo.req.GetOfferPeopleReqVO;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public class OfferBaseServiceImpl
implements OfferBaseServiceApi {
    private static final Log logger = LogFactory.getLog(OfferBaseServiceImpl.class);
    private static final HomePageServiceApiImpl homePageService = new HomePageServiceApiImpl();
    private OfferLetterServiceHelper letterServiceHelper = OfferLetterServiceHelper.getInstance();
    private final OfferServiceHelper offerServiceHelper = OfferServiceHelper.getInstance();

    public boolean isInvalid(Long appFileId) {
        logger.info("\u3010OfferBaseServiceImpl\u3011print isInvalid param \"{}\"", (Object)appFileId);
        QFilter qFilter = new QFilter("pindexes", "=", (Object)String.valueOf(appFileId));
        DynamicObject dynamicObject = this.offerServiceHelper.queryOne(qFilter.toArray());
        logger.info("\u3010OfferBaseServiceImpl\u3011print isInvalid value \"{}\" by \"{}\"", (Object)dynamicObject, (Object)appFileId);
        return dynamicObject == null;
    }

    public boolean hasOfferData(Long appFileId) {
        logger.info("\u3010OfferBaseServiceImpl\u3011print hasOfferData param \"{}\"", (Object)appFileId);
        QFilter qFilter = new QFilter("appfile", "=", (Object)appFileId).and(new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode()));
        DynamicObject dynamicObject = this.offerServiceHelper.queryOne(qFilter.toArray());
        logger.info("\u3010OfferBaseServiceImpl\u3011print hasOfferData value \"{}\" by \"{}\"", (Object)dynamicObject, (Object)appFileId);
        return dynamicObject != null;
    }

    public List<Long> getPreApplyOfferList(Boolean isAll, Long recruproc, String datePeriodCode, Long busunitId) {
        GetOfferPeopleReqVO offerPeopleReqVO = new GetOfferPeopleReqVO();
        offerPeopleReqVO.setAll(isAll);
        offerPeopleReqVO.setRecruproc(recruproc);
        offerPeopleReqVO.setDatePeriodCode(datePeriodCode);
        offerPeopleReqVO.setBusunitId(busunitId);
        logger.info("\u3010OfferBaseServiceImpl\u3011getPreApplyOfferList param \"{}\"", (Object)offerPeopleReqVO);
        List<Long> appfileList = this.getAppfileList(offerPeopleReqVO, OfferStatus.PRE_APPLY.getCode());
        logger.info("\u3010OfferBaseServiceImpl\u3011getPreApplyOfferList  return value \"{}\"", (Object)JSON.toJSONString(appfileList));
        return appfileList;
    }

    public List<Long> getApplyingOfferList(Boolean isAll, Long recruproc, String datePeriodCode, Long busunitId) {
        GetOfferPeopleReqVO offerPeopleReqVO = new GetOfferPeopleReqVO();
        offerPeopleReqVO.setAll(isAll);
        offerPeopleReqVO.setRecruproc(recruproc);
        offerPeopleReqVO.setDatePeriodCode(datePeriodCode);
        offerPeopleReqVO.setBusunitId(busunitId);
        logger.info("\u3010OfferBaseServiceImpl\u3011getApplyingOfferList param \"{}\"", (Object)offerPeopleReqVO);
        List<Long> appfileList = this.getAppfileList(offerPeopleReqVO, OfferStatus.APPLYING.getCode());
        logger.info("\u3010OfferBaseServiceImpl\u3011getApplyingOfferList  return value \"{}\"", (Object)JSON.toJSONString(appfileList));
        return appfileList;
    }

    public List<Long> getAlrSendOfferList(Boolean isAll, Long recruproc, String datePeriodCode, Long busunitId) {
        GetOfferPeopleReqVO offerPeopleReqVO = new GetOfferPeopleReqVO();
        offerPeopleReqVO.setAll(isAll);
        offerPeopleReqVO.setRecruproc(recruproc);
        offerPeopleReqVO.setDatePeriodCode(datePeriodCode);
        offerPeopleReqVO.setBusunitId(busunitId);
        logger.info("\u3010OfferBaseServiceImpl\u3011getAlrSendOfferList param \"{}\"", (Object)offerPeopleReqVO);
        List<Long> appfileList = this.getAppfileList(offerPeopleReqVO, OfferLetterStatus.ALR_SEND.getCode());
        logger.info("\u3010OfferBaseServiceImpl\u3011getAlrSendOfferList return value \"{}\"", (Object)JSON.toJSONString(appfileList));
        return appfileList;
    }

    public Map<Long, Map<String, Long>> getOfferJobInfoBatch(List<String> appfileIdList) {
        logger.info("\u3010OfferBaseServiceImpl\u3011print getOfferJobInfoBatch param \"{}\"", appfileIdList);
        QFilter qFilter = new QFilter("pindexes", "in", appfileIdList);
        String selectProperties = "joblevel,jobgrade,appfile,jobscm";
        DynamicObject[] offerObjs = this.offerServiceHelper.query(selectProperties, qFilter.toArray());
        if (offerObjs == null || offerObjs.length == 0) {
            return Maps.newHashMap();
        }
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)offerObjs.length);
        for (DynamicObject offerObj : offerObjs) {
            HashMap jobInfoMap = Maps.newHashMapWithExpectedSize((int)8);
            if (offerObj.get("jobgrade") != null) {
                jobInfoMap.put("jobgrade", offerObj.getLong("jobgrade.id"));
            }
            if (offerObj.get("joblevel") != null) {
                jobInfoMap.put("joblevel", offerObj.getLong("joblevel.id"));
            }
            if (jobInfoMap.size() <= 0) continue;
            jobInfoMap.put("jobscm", offerObj.getLong("jobscm.id"));
            returnMap.put(offerObj.getLong("appfile.id"), jobInfoMap);
        }
        logger.info("\u3010OfferBaseServiceImpl\u3011print getOfferJobInfoBatch value \"{}\" by \"{}\"", (Object)returnMap, appfileIdList);
        return returnMap;
    }

    private List<Long> getAppfileList(GetOfferPeopleReqVO reqVO, Long offerStatus) {
        logger.info("\u3010OfferBaseServiceImpl\u3011getAppfileList param \"{}\" offerStatus \"{}\"", (Object)reqVO, (Object)offerStatus);
        List<DynamicObject> offerList = homePageService.getFilterOfferList(reqVO, offerStatus);
        LinkedList<Long> appfileList = new LinkedList<Long>();
        Optional.ofNullable(offerList).ifPresent(dynamics -> this.setAppfileList((List<DynamicObject>)dynamics, (List<Long>)appfileList));
        return appfileList;
    }

    private void setAppfileList(List<DynamicObject> dynamicObjects, List<Long> appfileList) {
        dynamicObjects.forEach(offerObj -> {
            DynamicObject appFileObj = offerObj.getDynamicObject("appfile");
            if (appFileObj != null) {
                appfileList.add(appFileObj.getLong("id"));
            }
        });
    }

    public boolean acceptOffer(Long appFileId) {
        logger.info("OfferBaseServiceImpl.acceptOffer param \"{}\"", (Object)appFileId);
        if (appFileId == null) {
            return false;
        }
        QFilter qFilter = new QFilter("pindexes", "=", (Object)String.valueOf(appFileId));
        DynamicObject offerObj = this.offerServiceHelper.queryOne("offerletter", qFilter.toArray());
        if (offerObj == null) {
            return false;
        }
        boolean acceptOffer = OfferLetterService.Singleton.INSTANCE.getInstance().acceptOffer(Long.valueOf(offerObj.getLong("offerletter.id")));
        logger.info("OfferBaseServiceImpl.acceptOffer result \"{}\" by \"{}\"", (Object)acceptOffer, (Object)appFileId);
        return acceptOffer;
    }
}

