/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.mservice.service.offer;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tso.business.domain.moka.offer.induction.MkOfferStartInductionService;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.bo.VerifyOfferFailedInfo;
import kd.tsc.tso.common.constants.offer.multilanguage.InductionOpMultiLangConstants;
import kd.tsc.tso.common.enums.offer.OfferVerifyResultEnum;
import kd.tsc.tso.mservice.api.offer.OfferLaunchToInductionServiceApi;
import kd.tsc.tspr.business.domain.util.ValidateUtils;
import org.apache.commons.lang3.tuple.Pair;

public class OfferLaunchToInductionServiceImpl
implements OfferLaunchToInductionServiceApi {
    private static final Log LOG = LogFactory.getLog(OfferLaunchToInductionServiceImpl.class);
    private static final MkOfferStartInductionService inductionService = MkOfferStartInductionService.getInstance();

    public String launchToInduction(List<Long> offerIdList) {
        LOG.info("OfferLaunchToInductionServiceImpl.launchToInduction params {}", offerIdList);
        Pair validateVerifyCert = ValidateUtils.validateVerifyCert((String)"1WXB5G9/BL46", (String)"hom_onbrdpersonlist", (Integer)offerIdList.size());
        LOG.info("OfferLaunchToInductionServiceImpl.launchToInduction validateVerifyCert {}", (Object)validateVerifyCert);
        if (!((Boolean)validateVerifyCert.getLeft()).booleanValue()) {
            return (String)validateVerifyCert.getRight();
        }
        OfferVerifyResult offerVerifyResult = inductionService.canExecute(offerIdList);
        return this.doLaunchInduction(offerVerifyResult);
    }

    private String doLaunchInduction(OfferVerifyResult offerVerifyResult) {
        Integer verifyFlag = offerVerifyResult.getResultType();
        OfferVerifyResultEnum resultEnum = OfferVerifyResultEnum.getEnumByCode((Integer)verifyFlag);
        String returnValue = "";
        switch (resultEnum) {
            case ALL_FAIL: {
                returnValue = offerVerifyResult.getFailInfos().stream().map(VerifyOfferFailedInfo::getFailedMsg).collect(Collectors.joining());
                break;
            }
            case PART_PASS: 
            case ALL_PASS: {
                returnValue = this.doStartInduction(offerVerifyResult);
            }
        }
        LOG.info("OfferLaunchToInductionServiceImpl.doLaunchInduction returnValue {}", (Object)returnValue);
        return returnValue;
    }

    protected boolean checkIsPartSuccess(OfferVerifyResult offerVerifyResult) {
        if (offerVerifyResult == null) {
            return false;
        }
        Integer verifyFlag = offerVerifyResult.getResultType();
        if (verifyFlag == null) {
            return false;
        }
        OfferVerifyResultEnum enumByCode = OfferVerifyResultEnum.getEnumByCode((Integer)verifyFlag);
        return enumByCode == OfferVerifyResultEnum.PART_PASS;
    }

    private String doStartInduction(OfferVerifyResult offerVerifyResult) {
        inductionService.endStartInduction(offerVerifyResult);
        if (this.checkIsPartSuccess(offerVerifyResult)) {
            return offerVerifyResult.getFailInfos().stream().map(VerifyOfferFailedInfo::getFailedMsg).collect(Collectors.joining());
        }
        return InductionOpMultiLangConstants.successIdcStart();
    }
}

