/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.mservice.api.offer;

import com.google.common.collect.Maps;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public interface CreateOfferServiceApi {
    public static final Map<String, SoftReference<Object>> OBJECT_CACHE = Maps.newConcurrentMap();
    public static final Log LOG = LogFactory.getLog(CreateOfferServiceApi.class);

    default public String createOfferBatch(String requestParam) {
        return null;
    }

    default public Object createOffer(String className, String methodName, Map<String, String> requestParam) {
        StringUtils.isEmpty((CharSequence)className);
        StringUtils.isEmpty((CharSequence)methodName);
        SoftReference<Object> objectSoftReference = OBJECT_CACHE.get(className);
        try {
            Object obj;
            Class<?> clz = Class.forName(className);
            Method method = clz.getMethod(methodName, Map.class);
            if (objectSoftReference != null) {
                obj = objectSoftReference.get();
                if (obj == null) {
                    obj = clz.newInstance();
                    OBJECT_CACHE.put(className, new SoftReference<Object>(obj));
                }
            } else {
                obj = clz.newInstance();
                OBJECT_CACHE.put(className, new SoftReference<Object>(obj));
            }
            return method.invoke(obj, requestParam);
        }
        catch (ClassNotFoundException ex) {
            LOG.error("not found the class for {}", (Object)className);
            return "not found the class for " + className;
        }
        catch (NoSuchMethodException ex) {
            LOG.error("not found the method for {} and param type is Map", (Object)methodName);
            return "not found the method for " + methodName + " and param type is Map ";
        }
        catch (InvocationTargetException ex) {
            LOG.error("invoke {} error {}", (Object)methodName, (Object)ex);
            return "invoke " + methodName + " error";
        }
        catch (IllegalAccessException ex) {
            LOG.error("found illegal error ", (Throwable)ex);
            return "found illegal error";
        }
        catch (InstantiationException ex) {
            LOG.error("new Object fail ", (Throwable)ex);
            return "invoke instance error";
        }
    }
}

