/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.formplugin.web.appfile.list;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.filter.FilterContainer;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tsc.tspr.business.domain.appfile.service.AppFileRightHelper;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class AppFileBuAndAdminOrgList
extends HRCoreBaseList
implements BeforeFilterF7SelectListener {
    private static final Log LOG = LogFactory.getLog(AppFileBuAndAdminOrgList.class);
    private static final String BU_FIELD = "createorg";
    private static final String ADMINORG_FIELD = "adminorg";

    public void registerListener(EventObject eventObject) {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        if (fc != null) {
            fc.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        QFilter userAdminOrgFilter;
        String fieldName = args.getFieldName();
        if (this.checkAdminOrg(fieldName) && !PermissionServiceHelper.isSuperUser((long)TSCRequestContext.getUserId()) && (userAdminOrgFilter = this.getAdminOrgsQFilter(ADMINORG_FIELD)) != null) {
            args.getQFilters().add(userAdminOrgFilter);
        }
    }

    private boolean checkAdminOrg(String fieldName) {
        return HRStringUtils.equals((String)"adminorg.name", (String)fieldName) || HRStringUtils.equals((String)"adminorg.number", (String)fieldName);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
        this.setAdminOrgBeforeF7Select(evt);
    }

    public void setFilter(SetFilterEvent eventObject) {
        QFilter userAdminOrgFilter;
        this.setF7BUFilter(eventObject);
        boolean isSuperUser = PermissionServiceHelper.isSuperUser((long)TSCRequestContext.getUserId());
        if (!isSuperUser && (userAdminOrgFilter = this.getAdminOrgsQFilter(ADMINORG_FIELD)) != null) {
            eventObject.getQFilters().add(userAdminOrgFilter);
        }
        QFilter secLevelQFilter = this.getSecLevelQFilter();
        if (!isSuperUser && secLevelQFilter != null) {
            LOG.info("appfile.setFilter.secLevelQFilter:{}", (Object)secLevelQFilter);
            eventObject.getQFilters().add(secLevelQFilter);
        }
    }

    private void setF7BUFilter(SetFilterEvent eventObject) {
        ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listParameter.isLookUp()) {
            eventObject.getQFilters().add(new QFilter(BU_FIELD, "in", this.getPermHROrgs(listParameter)));
        }
    }

    private QFilter getSecLevelQFilter() {
        long userId = TSCRequestContext.getUserId();
        Long secLevelId = AppFileRightHelper.getUserSecLevelId((Long)userId);
        return AppFileRightHelper.getSecLevelQFilter((Long)secLevelId, (Long)userId);
    }

    private void setAdminOrgBeforeF7Select(BeforeFilterF7SelectEvent evt) {
        QFilter userAdminOrgFilter;
        boolean checkResult;
        if (!HRStringUtils.isEmpty((String)ADMINORG_FIELD) && (checkResult = this.checkAdmin(evt.getFieldName(), evt)) && !PermissionServiceHelper.isSuperUser((long)TSCRequestContext.getUserId()) && (userAdminOrgFilter = this.getAdminOrgsQFilter("id")) != null) {
            evt.getQfilters().add(userAdminOrgFilter);
        }
    }

    private boolean checkAdmin(String fieldName, BeforeFilterF7SelectEvent evt) {
        return fieldName.contains(ADMINORG_FIELD) && "haos_adminorghr".equals(evt.getRefEntityId());
    }

    private QFilter getAdminOrgsQFilter(String qFilterField) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String adminOrgStr = this.getPageCache().get(ADMINORG_FIELD);
        if (HRStringUtils.isNotEmpty((String)adminOrgStr)) {
            return QFilter.fromSerializedString((String)adminOrgStr);
        }
        QFilter userAdminOrgFilter = TSCBizDataPermService.getUserAdminOrgsQFilter((Long)TSCRequestContext.getUserId(), (String)listShowParameter.getAppId(), (String)listShowParameter.getBillFormId(), (String)"47150e89000000ac", (String)ADMINORG_FIELD, Collections.emptyMap(), (String)qFilterField);
        if (userAdminOrgFilter != null) {
            this.getPageCache().put(ADMINORG_FIELD, SerializationUtils.toJsonString((Object)userAdminOrgFilter.toSerializedString()));
        }
        return userAdminOrgFilter;
    }

    private List<Long> getPermHROrgs(ListShowParameter listParameter) {
        AppInfo appInfo;
        String appNumber;
        String createOrgIdsStr = this.getView().getPageCache().get(BU_FIELD);
        if (HRStringUtils.isNotEmpty((String)createOrgIdsStr)) {
            List createOrgIds = SerializationUtils.fromJsonStringToList((String)createOrgIdsStr, Long.class);
            return createOrgIds;
        }
        String entityName = listParameter.getBillFormId();
        String appId = listParameter.getAppId();
        if (HRStringUtils.isEmpty((String)appId) && HRStringUtils.isNotEmpty((String)(appNumber = listParameter.getAppId())) && (appInfo = AppMetadataCache.getAppInfo((String)appNumber)) != null) {
            appId = appInfo.getId();
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        String orgViewType = PermCommonUtil.getPermOrgViewSchemeByOrgField((MainEntityType)dataEntityType, (String)BU_FIELD);
        long userId = TSCRequestContext.getUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)orgViewType, (String)appId, (String)entityName, (String)"47150e89000000ac");
        List createOrgIds = result.hasAllOrgPerm() ? OrgUnitServiceHelper.getAllOrg((String)orgViewType) : result.getHasPermOrgs();
        this.getView().getPageCache().put(BU_FIELD, SerializationUtils.toJsonString((Object)createOrgIds));
        return createOrgIds;
    }
}

