/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.formplugin.web.appfile.list;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListFieldsControlEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tsc.tspr.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileSRHelper;
import kd.tsc.tspr.common.constants.appfile.AppFileListConstants;
import kd.tsc.tspr.common.constants.appfile.AppFileOperateEnum;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import org.apache.commons.lang3.tuple.Pair;

public class AppFileList
extends HRCoreBaseList {
    private static final Log logger = LogFactory.getLog(AppFileList.class);
    private static final Integer[] FILTER_FEEDBACK_VALUES = new Integer[]{1, 2, 3, 4, 5};
    private static final String[] FILTER_FEEDBACK_KEYS = new String[]{"fifbnum1", "fifbnum2", "fifbnum3", "fifbnum4", "fifbnum5"};
    private static final String[] FILTER_FEEDBACK_PIC_KEYS = new String[]{"fifbpic1", "fifbpic2", "fifbpic3", "fifbpic4", "fifbpic5"};
    private static final String POSITION_NUMBER_NAME = "positionnumbername";
    private static final String FIELD_POSITION_NAME = "position.name";
    private static final String FIELD_POSITION_NUMBER = "position.number";
    private static final String COL_SIMILARRES = "similarres";
    private static final String COL_PORTRAIT = "portrait";
    private static final String COL_FIFB = "fifb";
    private static final String[] FILTER_FIELDS = new String[]{"nofkfilterfknum", "suitfilterfknum", "nosuitfilterfknum", "pendfilterfknum", "tfposfilterfknum"};
    private static final String KEY_STDRSM_DATASTATUS = "stdrsm.datastatus";
    private final Map<Long, Map<String, String>> packData = new HashMap<Long, Map<String, String>>(30);
    private Map<Long, Boolean> suspectData;
    private Map<Long, String> flowLockData;
    private final Map<String, Integer> colMap = Maps.newHashMap();
    private final Pair<Collection<String>, Collection<String>> operationVisibleTuple = Pair.of((Object)Sets.newHashSet(), (Object)Sets.newHashSet());

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BillList billList = (BillList)this.getControl("billlistap");
        AppFileList listPlugin = this;
        billList.addListFieldsControlListeners(arg_0 -> AppFileList.lambda$registerListener$0((AbstractListPlugin)listPlugin, billList, arg_0));
    }

    public void beforePackageData(BeforePackageDataEvent evt) {
        logger.debug("start get listdata");
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        DynamicObjectCollection pageData = evt.getPageData();
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)pageData.size());
        for (DynamicObject pageDatum : pageData) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)FILTER_FIELDS.length);
            long rowId = pageDatum.getLong("id");
            for (int i = 0; i < FILTER_FIELDS.length; ++i) {
                map.put(FILTER_FEEDBACK_KEYS[i], pageDatum.getInt(FILTER_FIELDS[i]));
            }
            dataMap.put(rowId, map);
        }
        for (Map.Entry rowDataEntry : dataMap.entrySet()) {
            this.packData.put((Long)rowDataEntry.getKey(), AppFileList.getRowMap((Map)rowDataEntry.getValue()));
        }
        this.flowLockData = AppFileFlowLockHelper.getFlowLockData((List)pageData);
        this.suspectData = Maps.newHashMap();
        if (!listShowParameter.isLookUp()) {
            // empty if block
        }
        this.getPageCache().put(COL_SIMILARRES, SerializationUtils.toJsonString(this.suspectData));
        this.getPageCache().put("flowlockstatus", SerializationUtils.toJsonString(this.flowLockData));
        Object unShowLabel = listShowParameter.getCustomParam(AppFileListConstants.KEY_UN_SHOW_LABEL);
        if (unShowLabel instanceof String) {
            this.getPageCache().put(AppFileListConstants.KEY_UN_SHOW_LABEL, String.valueOf(unShowLabel));
        }
    }

    public void packageData(PackageDataEvent evt) {
        DynamicObject rowData = evt.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (fieldKey.startsWith(COL_FIFB)) {
            Long id = rowData.getLong("id");
            Map<String, String> rowMap = this.packData.get(id);
            if (rowMap != null) {
                evt.setFormatValue((Object)rowMap.get(fieldKey));
            }
        } else if (POSITION_NUMBER_NAME.equals(fieldKey)) {
            String posNumber = rowData.getString(FIELD_POSITION_NUMBER);
            String noPrefixNumber = posNumber != null && posNumber.length() > 5 ? posNumber.substring(5) : "";
            evt.setFormatValue((Object)(noPrefixNumber + "-" + rowData.getString(FIELD_POSITION_NAME)));
        } else if (COL_SIMILARRES.equals(fieldKey)) {
            Long stdRsmId = rowData.getLong("stdrsm.id");
            if (Boolean.TRUE.equals(this.suspectData.get(stdRsmId))) {
                evt.setFormatValue((Object)"1");
            } else {
                evt.setFormatValue((Object)"0");
            }
        } else if ("filterstatus".equals(fieldKey)) {
            evt.setFormatValue((Object)"");
        } else if ("flowlockstatus".equals(fieldKey)) {
            Long appFileId = rowData.getLong("id");
            evt.setFormatValue((Object)this.flowLockData.get(appFileId));
        } else if ("blackliststatus".equals(fieldKey)) {
            if (ResumeHisDataStatusEnum.BLACK_LIST.getStatus().equals(rowData.getString(KEY_STDRSM_DATASTATUS))) {
                evt.setFormatValue((Object)"1");
            }
        } else if (COL_PORTRAIT.equals(fieldKey)) {
            String showLabel = this.getPageCache().get(AppFileListConstants.KEY_UN_SHOW_LABEL);
            if ("unShowLabel".equals(showLabel)) {
                evt.setFormatValue((Object)"0");
            } else {
                evt.setFormatValue((Object)"1");
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow selectedRow = list.getCurrentSelectedRowInfo();
        Long appFileId = (Long)selectedRow.getPrimaryKeyValue();
        String fieldName = args.getFieldName();
        if ("qacheckresult".equals(fieldName)) {
            args.setCancel(true);
            this.showQACheckDetailPage(appFileId);
        } else if ("blackliststatus".equals(fieldName)) {
            args.setCancel(true);
            DynamicObject dynamicObject = AppFileHelper.queryOne((long)appFileId);
        } else if (COL_SIMILARRES.equals(fieldName)) {
            args.setCancel(true);
            this.clickSimilarColumn(appFileId);
        } else if ("flowlockstatus".equals(fieldName)) {
            args.setCancel(true);
            this.clickFlowColumn(appFileId);
        } else if (COL_PORTRAIT.equals(fieldName)) {
            args.setCancel(true);
            DynamicObject appFile = AppFileHelper.queryOne((long)appFileId);
            long rsmId = appFile.getLong("appres.id");
            LabelDataHelper.showAppRsmPortraitPage((IFormView)this.getView(), (Long)rsmId, (Long)LabelTagObjTypeEnum.OUT_RESUME.getId());
        } else if (fieldName.startsWith(COL_FIFB)) {
            args.setCancel(true);
            this.clickRowHandle(fieldName, appFileId);
        }
    }

    private static Map<String, String> getRowMap(Map<String, Integer> rowData) {
        int i;
        HashMap<String, String> rowMap = new HashMap<String, String>(16);
        ArrayList fifbvals = new ArrayList(FILTER_FEEDBACK_VALUES.length);
        Collections.addAll(fifbvals, FILTER_FEEDBACK_VALUES);
        for (i = FILTER_FEEDBACK_KEYS.length - 1; i >= 0; --i) {
            Integer filterNum = rowData.get(FILTER_FEEDBACK_KEYS[i]);
            if (filterNum != null && filterNum != 0) continue;
            fifbvals.remove(i);
        }
        for (i = 0; i < FILTER_FEEDBACK_KEYS.length; ++i) {
            if (i < fifbvals.size()) {
                rowMap.put(FILTER_FEEDBACK_PIC_KEYS[i], String.valueOf(fifbvals.get(i)));
                rowMap.put(FILTER_FEEDBACK_KEYS[i], String.valueOf(rowData.get(FILTER_FEEDBACK_KEYS[(Integer)fifbvals.get(i) - 1])));
                continue;
            }
            rowMap.put(FILTER_FEEDBACK_PIC_KEYS[i], "");
            rowMap.put(FILTER_FEEDBACK_KEYS[i], "");
        }
        return rowMap;
    }

    private void clickRowHandle(String focusField, Long clickId) {
    }

    private void clickFlowColumn(Long clickId) {
        Map currFlowLockDataMap;
        String flowLockDataStr = this.getPageCache().get("flowlockstatus");
        if (HRStringUtils.isNotEmpty((String)flowLockDataStr) && HRStringUtils.isNotEmpty((String)((String)(currFlowLockDataMap = (Map)SerializationUtils.fromJsonString((String)flowLockDataStr, Map.class)).get(String.valueOf(clickId))))) {
            AppFileFlowLockHelper.showFlowLockInfoPage((Long)clickId, (IFormView)this.getView());
        }
    }

    private void clickSimilarColumn(Long appFileId) {
        DynamicObject appFile;
        long stdRsmId;
        Map currSuspectDataMap;
        String suspectDataStr = this.getPageCache().get(COL_SIMILARRES);
        if (HRStringUtils.isNotEmpty((String)suspectDataStr) && Boolean.TRUE.equals((currSuspectDataMap = (Map)SerializationUtils.fromJsonString((String)suspectDataStr, Map.class)).get(String.valueOf(stdRsmId = (appFile = AppFileHelper.queryOne((long)appFileId)).getLong("stdrsm.id"))))) {
            AppFileSRHelper.showSimilarPage((Long)appFileId, (IFormView)this.getView());
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final BillList billList = (BillList)this.getControl("billlistap");
        final ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                logger.debug("start get listData");
                AppFileList.this.handleOpBtnsAndFields();
                this.loadOtherMustFields();
                this.setColumnVisible();
                return super.getData(start, limit);
            }

            private void setColumnVisible() {
                List listFieldsControlColumns;
                if (!(listShowParameter.isLookUp() || AppFileList.this.colMap.isEmpty() || (listFieldsControlColumns = billList.getListFieldsControlColumns()) != null && !listFieldsControlColumns.isEmpty())) {
                    AppFileListHelper.setListFieldVisible((BillList)billList, (Map)AppFileList.this.colMap);
                }
            }

            private void loadOtherMustFields() {
                ListField posName = new ListField(AppFileList.FIELD_POSITION_NAME);
                posName.setFieldName(AppFileList.FIELD_POSITION_NAME);
                this.getListFields().add(posName);
                ListField posNumber = new ListField(AppFileList.FIELD_POSITION_NUMBER);
                posNumber.setFieldName(AppFileList.FIELD_POSITION_NUMBER);
                this.getListFields().add(posNumber);
                ListField stdRsmId = new ListField(AppFileList.KEY_STDRSM_DATASTATUS);
                stdRsmId.setFieldName(AppFileList.KEY_STDRSM_DATASTATUS);
                this.getListFields().add(stdRsmId);
                for (String field : FILTER_FIELDS) {
                    ListField listField = new ListField(field);
                    listField.setFieldName(field);
                    this.getListFields().add(listField);
                }
            }
        });
    }

    public void afterBindData(EventObject evt) {
        this.setOperationBtnVisible();
    }

    private void setOperationBtnVisible() {
        this.getView().setVisible(Boolean.FALSE, ((Collection)this.operationVisibleTuple.getRight()).toArray(new String[0]));
        this.getView().setVisible(Boolean.TRUE, ((Collection)this.operationVisibleTuple.getLeft()).toArray(new String[0]));
        boolean hasAddRsm = ((Collection)this.operationVisibleTuple.getRight()).contains(AppFileOperateEnum.OPENFILLRESADD.getCtrlKey());
        boolean showAnalysisRsm = ((Collection)this.operationVisibleTuple.getLeft()).contains(AppFileOperateEnum.ANALYSISRESADD.getCtrlKey());
        this.getView().setVisible(Boolean.valueOf(hasAddRsm && showAnalysisRsm), new String[]{"baranalysisresadd1"});
        Boolean hasAddTag = ((Collection)this.operationVisibleTuple.getRight()).contains(AppFileOperateEnum.ADDTAG.getCtrlKey());
        Boolean showRmTag = ((Collection)this.operationVisibleTuple.getLeft()).contains(AppFileOperateEnum.REMOVETAG.getCtrlKey());
        this.getView().setVisible(Boolean.valueOf(hasAddTag != false && showRmTag != false), new String[]{"barremovetag1"});
        Boolean hasTpTag = ((Collection)this.operationVisibleTuple.getRight()).contains(AppFileOperateEnum.TRANSFERPOS.getCtrlKey());
        Boolean showSaveTalentTag = ((Collection)this.operationVisibleTuple.getLeft()).contains(AppFileOperateEnum.SAVETALENT.getCtrlKey());
        this.getView().setVisible(Boolean.valueOf(hasTpTag != false && showSaveTalentTag != false), new String[]{"barsavetalent1"});
        boolean hasHireOkTag = ((Collection)this.operationVisibleTuple.getRight()).contains(AppFileOperateEnum.HIRERECOMEND.getCtrlKey());
        boolean hasHireJobRankTag = ((Collection)this.operationVisibleTuple.getRight()).contains(AppFileOperateEnum.HIREJOBRANK.getCtrlKey());
        boolean hasHireSalaryTag = ((Collection)this.operationVisibleTuple.getRight()).contains(AppFileOperateEnum.HIRESALARY.getCtrlKey());
        this.getView().setVisible(Boolean.valueOf(hasHireOkTag && !hasHireJobRankTag), new String[]{"barhirejobrank1"});
        this.getView().setVisible(Boolean.valueOf(hasHireOkTag && hasHireJobRankTag && !hasHireSalaryTag), new String[]{"barhiresalary1"});
    }

    private void handleOpBtnsAndFields() {
        long[] procInfoArr = AppFileListHelper.getProcIdAndStgId((AbstractListPlugin)this);
        long procId = procInfoArr[0];
        long stgId = procInfoArr[1];
        AppFileListHelper.handleOperateBtnAndField((long)procId, (long)stgId, this.colMap, this.operationVisibleTuple);
    }

    private void showQACheckDetailPage(Long appFileId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tspr_qacheckdetail");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("appFileId", (Object)appFileId);
        this.getView().showForm(showParameter);
    }

    private static /* synthetic */ void lambda$registerListener$0(AbstractListPlugin listPlugin, BillList billList, ListFieldsControlEvent evt) {
        long[] procInfoArr = AppFileListHelper.getProcIdAndStgId((AbstractListPlugin)listPlugin);
        HashMap tplAllColMap = Maps.newHashMapWithExpectedSize((int)128);
        AppFileListHelper.handleFieldVisible((long)procInfoArr[0], (long)procInfoArr[1], (Map)tplAllColMap);
        AppFileListHelper.setListFieldVisible((BillList)billList, (Map)tplAllColMap);
    }
}

