/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.formplugin.web.appfile.list;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterKeyValueCollection;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tsc.tspr.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileHomePageHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFilePositionHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileRightHelper;
import kd.tsc.tspr.common.constants.appfile.AppFileConstants;
import kd.tsc.tspr.common.constants.appfile.AppFileListConstants;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.utils.ListViewUtils;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;

public class AppFileSearchList
extends HRCoreBaseList
implements BeforeFilterF7SelectListener {
    private static final Log LOG = LogFactory.getLog(AppFileSearchList.class);
    public static final String KEY_LASTFILTERDATA = "lastFilterData";
    private static final String KEY_POSITION_ID = "position.id";
    private static final HashMap<Object, Object> LABEL_CATEGORY_MAP = Maps.newHashMapWithExpectedSize((int)3);
    private static final Map<Integer, QueryAppFileIdsFunction> GEN_DEF_QUERY_MAP;
    private long positionId = 0L;
    private long stgId = 0L;
    private final Map<String, List<Object>> filterDataMap = new HashMap<String, List<Object>>(16);
    private Map<String, List<Object>> lastFilterDataMap;
    private List<Long> currFilterStgIds;
    private List<Long> currFilterStatusIds;

    public void registerListener(EventObject evt) {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        if (fc != null) {
            fc.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if ("refresh".equals(operate.getOperateKey()) || "openfillresadd".equals(operate.getOperateKey()) || "analysisresadd".equals(operate.getOperateKey())) {
            this.getView().getPageCache().remove("defaultQFilter");
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        if (this.filterDataMap.isEmpty()) {
            this.handleFilterValues();
        }
        switch (args.getFieldName()) {
            case "recrustg.name": {
                this.clearStage(args);
                break;
            }
            case "recrustat.name": {
                this.clearPosAndStageFilter(args);
                break;
            }
            case "offerstatus.name": {
                args.getQFilters().add(AppFileSearchList.getOfferStatusQFilter());
                args.setOrderBy("index");
                break;
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        this.addPositionFilterColumn(args);
        AppFileSearchList.addLabelFilterColumn(args);
        this.setCommonFilterColumnsDefaultValue(args);
        this.setDefaultValueToFilterValueMap(args);
        this.setCommonStgFilterItems(args);
    }

    public void beforeBindData(EventObject evt) {
        if (this.filterDataMap.isEmpty()) {
            this.handleFilterValues();
        }
        AppFileListHelper.putProcInfoToCache((AbstractListPlugin)this, (long)this.positionId, (long)this.stgId);
    }

    public void setFilter(SetFilterEvent evt) {
        evt.setOrderBy("enterlinktime DESC,createtime DESC");
        if (this.positionId != 0L) {
            QFilter positionQFilter = new QFilter(KEY_POSITION_ID, "=", (Object)this.positionId);
            evt.getQFilters().add(positionQFilter);
        }
        evt.getQFilters().removeIf(qFilter -> qFilter == null || "chanrgrange".equals(qFilter.getProperty()) || "candidatelabel.id".equals(qFilter.getProperty()));
        AppFileSearchList.handleSchemeFilter(evt);
        this.handleCommonFilter(evt);
        String defaultQFilterStr = this.getView().getPageCache().get("defaultQFilter");
        if (HRStringUtils.isNotEmpty((String)defaultQFilterStr)) {
            QFilter defaultQFilter = QFilter.fromSerializedString((String)defaultQFilterStr);
            evt.getQFilters().add(defaultQFilter);
        }
        this.handleMyHandFilter(evt);
        LOG.info("appfileList.setFilter.Qfilters {}", (Object)evt.getQFilters());
    }

    private void setDefaultValueToFilterValueMap(FilterContainerInitArgs args) {
        Integer queryType;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (this.filterDataMap.isEmpty()) {
            for (FilterColumn commonFilterColumn : args.getCommonFilterColumns()) {
                this.filterDataMap.put(commonFilterColumn.getFilterField().getFieldName(), commonFilterColumn.getDefaultValues());
            }
            this.getPositionIdAndStgId();
            this.getPageCache().put(KEY_LASTFILTERDATA, SerializationUtils.toJsonString(this.filterDataMap));
        }
        if ((queryType = (Integer)formShowParameter.getCustomParam(AppFileListConstants.CUSTOM_FILTER_QUERY_TYPE)) != null) {
            Long recruitProcId = Long.parseLong((String)formShowParameter.getCustomParam(AppFileListConstants.CUSTOM_FILTER_RECRUIT_PROC_ID));
            String timeRangeType = (String)formShowParameter.getCustomParam(AppFileListConstants.CUSTOM_FILTER_TIME_RANG_TYPE);
            boolean isOwner = (Boolean)formShowParameter.getCustomParam(AppFileListConstants.CUSTOM_FILTER_IS_OWNER);
            Long orgId = Long.parseLong((String)formShowParameter.getCustomParam(AppFileListConstants.DEFAULT_FILTER_ORG_ID));
            QFilter queryQFilter = AppFileSearchList.generateQFilterByParams(isOwner, recruitProcId, timeRangeType, orgId, queryType);
            this.getView().getPageCache().put("defaultQFilter", queryQFilter.toSerializedString());
            formShowParameter.getCustomParams().remove(AppFileListConstants.CUSTOM_FILTER_QUERY_TYPE);
            this.getView().cacheFormShowParameter();
        }
    }

    private static QFilter generateQFilterByParams(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId, Integer queryType) {
        QueryAppFileIdsFunction queryAppFileIdsFunction = GEN_DEF_QUERY_MAP.get(queryType);
        Collection<Object> appFileIds = queryAppFileIdsFunction != null ? queryAppFileIdsFunction.queryAppFileIds(isOwner, recruitProcId, timeRangeType, orgId) : Sets.newHashSet();
        return new QFilter("id", "in", (Object)appFileIds);
    }

    private void addPositionFilterColumn(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        CommonBaseDataFilterColumn positionColumn = new CommonBaseDataFilterColumn();
        positionColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e94\u8058\u804c\u4f4d", (String)"AppFileSearchList_0", (String)"tsc-tspr-formplugin", (Object[])new Object[0])));
        positionColumn.setFieldName(KEY_POSITION_ID);
        positionColumn.setEntityField(false);
        positionColumn.setDefaultValue("");
        positionColumn.setEntityType(EntityMetadataCache.getDataEntityType((String)"tssrm_appfile_view"));
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(16);
        this.setPositionFilterColItems(combos);
        positionColumn.setComboItems(combos);
        positionColumn.setType("enum");
        int pos = 0;
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            ++pos;
            if (!"position.positionstatus".equals(commonFilterColumn.getFieldName())) continue;
            break;
        }
        commonFilterColumns.add(pos, positionColumn);
    }

    private void setPositionFilterColItems(List<ComboItem> combos) {
        DynamicObject[] positions;
        QFilter positionQFilter = this.getPositionQFilter();
        for (DynamicObject position : positions = AppFilePositionHelper.queryPositions((QFilter)positionQFilter)) {
            ComboItem item = new ComboItem();
            String posNumber = position.getString("number");
            String fullPosName = "";
            if (!HRStringUtils.isEmpty((String)posNumber)) {
                fullPosName = posNumber.substring(5) + "-" + position.getString("name");
            }
            item.setCaption(new LocaleString(fullPosName));
            item.setValue(position.getString("id"));
            combos.add(item);
        }
    }

    private static void addLabelFilterColumn(FilterContainerInitArgs args) {
        DynamicObject[] labels;
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        CommonBaseDataFilterColumn labelColumn = new CommonBaseDataFilterColumn();
        labelColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6807\u7b7e", (String)"AppFileSearchList_1", (String)"tsc-tspr-formplugin", (Object[])new Object[0])));
        labelColumn.setFieldName("candidatelabel.id");
        labelColumn.setEntityField(false);
        labelColumn.setMulti(true);
        labelColumn.setDefaultValue("");
        labelColumn.setEntityType(EntityMetadataCache.getDataEntityType((String)"tssrm_appfile_view"));
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(16);
        ArrayList tagObjTypeIds = Lists.newArrayList((Object[])new Long[]{LabelTagObjTypeEnum.APPFILE.getId(), LabelTagObjTypeEnum.OUT_RESUME.getId()});
        for (DynamicObject label : labels = LabelDataHelper.getLabelsByObjType((List)tagObjTypeIds)) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(label.getString("name") + LABEL_CATEGORY_MAP.get(label.getString("labelcategory"))));
            item.setValue(label.getString("id"));
            combos.add(item);
        }
        labelColumn.setComboItems(combos);
        labelColumn.setType("enum");
        commonFilterColumns.add(labelColumn);
    }

    private void setCommonFilterColumnsDefaultValue(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String positionIdStr = TSCBaseUtils.getString((String)((String)formShowParameter.getCustomParam(AppFileListConstants.DEFAULT_FILTER_POSITION_ID)));
        String orgIdStr = TSCBaseUtils.getString((String)((String)formShowParameter.getCustomParam(AppFileListConstants.DEFAULT_FILTER_ORG_ID)));
        String stgIdStr = TSCBaseUtils.getString((String)((String)formShowParameter.getCustomParam(AppFileListConstants.DEFAULT_FILTER_RECRUSTG_ID)));
        block12: for (FilterColumn commonFilterColumn : commonFilterColumns) {
            switch (commonFilterColumn.getFieldName()) {
                case "createorg.name": {
                    commonFilterColumn.setDefaultValue(orgIdStr);
                    continue block12;
                }
                case "position.id": {
                    commonFilterColumn.setDefaultValue(positionIdStr);
                    continue block12;
                }
                case "recrustg.name": {
                    commonFilterColumn.setDefaultValue(stgIdStr);
                    continue block12;
                }
                case "filestatus": {
                    if (!HRStringUtils.isEmpty((String)positionIdStr) || !HRStringUtils.isEmpty((String)orgIdStr) || !HRStringUtils.isEmpty((String)stgIdStr)) continue block12;
                    commonFilterColumn.setDefaultValue(AppFileConstants.APP_FILE_STATUS_IN);
                    continue block12;
                }
            }
            if (commonFilterColumn.getDefaultValues() != null && !commonFilterColumn.getDefaultValues().isEmpty()) continue;
            commonFilterColumn.setDefaultValue("");
        }
    }

    private void handleMyHandFilter(SetFilterEvent evt) {
        if (this.getIsMyCharge()) {
            Long userId = TSCRequestContext.getUserId();
            String myHandFilterSql = String.format(Locale.ROOT, "select fid from t_tspr_posprin where fbasedataid = %d", userId);
            evt.getQFilters().add(QFilter.sqlExpress((String)"position.manageinfo", (String)"in", (String)myHandFilterSql));
        }
    }

    private static void handleSchemeFilter(SetFilterEvent evt) {
        for (int i = 0; i < evt.getQFilters().size(); ++i) {
            QFilter qFilter = (QFilter)evt.getQFilters().get(i);
            if (!"candidatelabel.name".equals(qFilter.getProperty())) continue;
            QFilter newCandidateSchameQfilter = AppFileListHelper.getLabelSchemaFilter((QFilter)qFilter);
            evt.getQFilters().set(i, newCandidateSchameQfilter);
            break;
        }
    }

    private void handleCommonFilter(SetFilterEvent evt) {
        List<Object> candidateLabels;
        List<Object> changeRanges = this.filterDataMap.get("chanrgrange");
        if (changeRanges != null && !changeRanges.isEmpty() && "1".equals(changeRanges.get(0))) {
            Long userId = TSCRequestContext.getUserId();
            LOG.debug("change filter");
            QFilter chargeQFilter = new QFilter("position.posprin.fbasedataid", "=", (Object)userId);
            evt.getQFilters().add(chargeQFilter);
        }
        if ((candidateLabels = this.filterDataMap.get("candidatelabel.id")) != null && !candidateLabels.isEmpty() && !candidateLabels.get(0).toString().isEmpty()) {
            String labelIdStr = candidateLabels.stream().map(Object::toString).filter(HRStringUtils::isNotEmpty).collect(Collectors.joining(","));
            AppFileListHelper.setCommonLabelQFilter((SetFilterEvent)evt, (String)labelIdStr);
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent f7SelectEvent) {
        block16: {
            if (KEY_POSITION_ID.equals(f7SelectEvent.getFieldName())) {
                f7SelectEvent.getQfilters().add(this.getPositionQFilter());
            } else if ("offerstatus.name".equals(f7SelectEvent.getFieldName())) {
                f7SelectEvent.getQfilters().add(AppFileSearchList.getOfferStatusQFilter());
                f7SelectEvent.addCustomParam("notShowOfferValidateStatus", (Object)"1");
            } else if (f7SelectEvent.getFieldName().startsWith("candidatelabel")) {
                f7SelectEvent.getQfilters().add(LabelDataHelper.getLabelQfilter((List)Lists.newArrayList((Object[])new Long[]{LabelTagObjTypeEnum.APPFILE.getId(), LabelTagObjTypeEnum.OUT_RESUME.getId()})));
            } else if ("recrustg.id".equals(f7SelectEvent.getFieldName())) {
                try {
                    LOG.info("AppFileSearchList.beforeF7Select.recrustg.id");
                    if (this.positionId != 0L) {
                        this.currFilterStgIds = AppFilePositionHelper.queryPosProcStageIdList((long)this.positionId);
                        f7SelectEvent.getQfilters().add(new QFilter("id", "in", this.currFilterStgIds));
                        break block16;
                    }
                    f7SelectEvent.getQfilters().add(new QFilter("1", "!=", (Object)1));
                }
                catch (Exception e) {
                    LOG.info(e.getMessage());
                }
            } else if ("recrustat.id".equals(f7SelectEvent.getFieldName())) {
                try {
                    LOG.info("AppFileSearchList.beforeF7Select.recrustat.id");
                    if (this.positionId != 0L && this.stgId != 0L) {
                        this.currFilterStatusIds = AppFilePositionHelper.queryPosProcStageStatusIdList((long)this.positionId, (long)this.stgId);
                        f7SelectEvent.getQfilters().add(new QFilter("id", "in", this.currFilterStatusIds));
                    } else {
                        f7SelectEvent.getQfilters().add(new QFilter("1", "!=", (Object)1));
                    }
                }
                catch (Exception e) {
                    LOG.info(e.getMessage());
                }
            }
        }
    }

    private QFilter getPositionQFilter() {
        QFilter positionQfilter = new QFilter("positionstatus", "!=", (Object)"B");
        this.positionOrgFilter(positionQfilter, "createorg.id", "createorg", this.getView().getPageCache(), "position.createorg");
        this.positionOrgFilter(positionQfilter, "adminorgs", "adminorgs.fbasedataid", this.getPageCache(), "adminorg");
        this.positionChargeFilter(positionQfilter);
        return positionQfilter;
    }

    private void positionChargeFilter(QFilter positionQfilter) {
        Long secLevelId;
        Long currUserId = TSCRequestContext.getUserId();
        if (this.getIsMyCharge()) {
            positionQfilter.and(new QFilter("manageinfo.posprin.fbasedataid", "=", (Object)currUserId));
        } else if (!PermissionServiceHelper.isSuperUser((long)currUserId) && (secLevelId = AppFileRightHelper.getUserSecLevelId((Long)currUserId)) != null) {
            positionQfilter.and(AppFileRightHelper.getPostionSecLevelQFilter((Long)secLevelId, (Long)currUserId));
            this.getPageCache().put("positionSecLevel", Long.toString(secLevelId));
        }
    }

    private boolean getIsMyCharge() {
        if ("1".equals(this.getPageCache().get("chanrgrange"))) {
            return true;
        }
        List<Object> changeRanges = this.filterDataMap.get("chanrgrange");
        return AppFileSearchList.isNotEmptyList(changeRanges) && "1".equals(changeRanges.get(0));
    }

    private void positionOrgFilter(QFilter positionQFilter, String keyCreateOrgId, String useOrg, IPageCache pageCache, String keyCreateOrg) {
        List<Object> createOrgs = this.filterDataMap.get(keyCreateOrgId);
        if (AppFileSearchList.isNotEmptyList(createOrgs)) {
            positionQFilter.and(new QFilter(useOrg, "in", createOrgs.stream().map(org -> Long.parseLong((String)org)).collect(Collectors.toList())));
        } else {
            String createOrgIdsStr = pageCache.get(keyCreateOrg);
            List positionRightOrgIds = null;
            if (HRStringUtils.isNotEmpty((String)createOrgIdsStr)) {
                positionRightOrgIds = SerializationUtils.fromJsonStringToList((String)createOrgIdsStr, Long.class);
            } else if ("position.createorg".equals(keyCreateOrg)) {
                positionRightOrgIds = AppFileRightHelper.getAllPermOrg((String)"tssrm", (String)"tssrm_position_add", (Long)TSCRequestContext.getUserId(), (String)"47150e89000000ac");
            } else if ("adminorg".equals(keyCreateOrg)) {
                if (PermissionServiceHelper.isSuperUser((long)TSCRequestContext.getUserId())) {
                    return;
                }
                positionRightOrgIds = TSCBizDataPermService.getUserAdminOrgList((Long)TSCRequestContext.getUserId(), (String)"tssrm", (String)"tssrm_position_add", (String)"47150e89000000ac", (String)"adminorg", Collections.emptyMap());
            }
            positionQFilter.and(new QFilter(useOrg, "in", (Object)positionRightOrgIds));
            pageCache.put(keyCreateOrg, SerializationUtils.toJsonString((Object)positionRightOrgIds));
        }
    }

    private void clearStage(SetFilterEvent args) {
        if (this.positionId != 0L) {
            this.currFilterStgIds = AppFilePositionHelper.queryPosProcStageIdList((long)this.positionId);
            args.getQFilters().add(new QFilter("id", "in", this.currFilterStgIds));
            args.setOrderBy("createtime");
        } else {
            args.getQFilters().add(new QFilter("1", "!=", (Object)1));
        }
    }

    private void clearPosAndStageFilter(SetFilterEvent args) {
        if (this.positionId != 0L && this.stgId != 0L) {
            this.currFilterStatusIds = AppFilePositionHelper.queryPosProcStageStatusIdList((long)this.positionId, (long)this.stgId);
            args.getQFilters().add(new QFilter("id", "in", this.currFilterStatusIds));
            args.setOrderBy("createtime");
        } else {
            args.getQFilters().add(new QFilter("1", "!=", (Object)1));
        }
    }

    private static QFilter getOfferStatusQFilter() {
        return new QFilter("index", "<>", (Object)0);
    }

    private void handleFilterValues() {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        FilterKeyValueCollections otherFilterValues = fc.getCachedFilterValues().getOtherFilterValues();
        if (otherFilterValues != null) {
            String lastFilterDataJsonStr = this.getPageCache().get(KEY_LASTFILTERDATA);
            if (HRStringUtils.isNotEmpty((String)lastFilterDataJsonStr)) {
                this.lastFilterDataMap = (Map)SerializationUtils.fromJsonString((String)lastFilterDataJsonStr, Map.class);
            }
            if (this.lastFilterDataMap.size() == otherFilterValues.getFilterValueCollection().size()) {
                for (FilterKeyValueCollection filterKeyValueCollection : otherFilterValues.getFilterValueCollection()) {
                    List filterKeyValues = filterKeyValueCollection.getFilterKeyValues();
                    ListViewUtils.handleFilterKeyValue((List)filterKeyValues, this.filterDataMap);
                }
            } else {
                this.filterDataMap.putAll(this.lastFilterDataMap);
            }
            this.clearFilterData();
            this.getPositionIdAndStgId();
            this.getPageCache().put(KEY_LASTFILTERDATA, SerializationUtils.toJsonString(this.filterDataMap));
        }
    }

    private void setCommonStgFilterItems(FilterContainerInitArgs args) {
        if (this.currFilterStgIds != null && !this.currFilterStgIds.isEmpty()) {
            FilterColumn statFilterColumn;
            FilterColumn stgFilterColumn = (FilterColumn)args.getCommonFilterColumns().get(4);
            if (stgFilterColumn instanceof CommonBaseDataFilterColumn && stgFilterColumn.getFieldName().startsWith("recrustg")) {
                CommonBaseDataFilterColumn filterCol = (CommonBaseDataFilterColumn)stgFilterColumn;
                this.filterComboItemSort(filterCol.getComboItems(), this.currFilterStgIds);
            }
            if (this.currFilterStatusIds != null && !this.currFilterStatusIds.isEmpty() && (statFilterColumn = (FilterColumn)args.getCommonFilterColumns().get(4)) instanceof CommonBaseDataFilterColumn && statFilterColumn.getFieldName().startsWith("recrustat")) {
                CommonBaseDataFilterColumn filterCol = (CommonBaseDataFilterColumn)statFilterColumn;
                this.filterComboItemSort(filterCol.getComboItems(), this.currFilterStatusIds);
            }
        }
    }

    private void filterComboItemSort(List<ComboItem> items, List<Long> sortValues) {
        for (int i = 0; i < sortValues.size(); ++i) {
            for (int j = i + 1; j < items.size(); ++j) {
                if (!sortValues.get(i).toString().equals(items.get(j).getValue())) continue;
                Collections.swap(items, i, j);
            }
        }
    }

    private void getPositionIdAndStgId() {
        String value;
        List<Object> stgObjects;
        String value2;
        List<Object> posObjects = this.filterDataMap.get(KEY_POSITION_ID);
        if (posObjects != null && !posObjects.isEmpty() && HRStringUtils.isNotEmpty((String)(value2 = (String)posObjects.get(0)))) {
            this.positionId = Long.parseLong(value2);
        }
        if ((stgObjects = this.filterDataMap.get("recrustg.id")) != null && !stgObjects.isEmpty() && HRStringUtils.isNotEmpty((String)(value = (String)stgObjects.get(0)))) {
            this.stgId = Long.parseLong(value);
        }
    }

    private void clearFilterData() {
        if (this.lastFilterDataMap != null && !this.lastFilterDataMap.isEmpty()) {
            if (!(HRObjectUtils.equals(this.lastFilterDataMap.get("chanrgrange"), this.filterDataMap.get("chanrgrange")) && HRObjectUtils.equals(this.lastFilterDataMap.get("createorg.id"), this.filterDataMap.get("createorg.id")) && HRObjectUtils.equals(this.lastFilterDataMap.get("adminorg.id"), this.filterDataMap.get("adminorg.id")))) {
                List<Object> positionFilters = this.filterDataMap.get(KEY_POSITION_ID);
                AppFileSearchList.clearList(positionFilters);
            }
            if (!HRObjectUtils.equals(this.lastFilterDataMap.get(KEY_POSITION_ID), this.filterDataMap.get(KEY_POSITION_ID))) {
                List<Object> stgFilters = this.filterDataMap.get("recrustg.id");
                AppFileSearchList.clearList(stgFilters);
            }
            if (!HRObjectUtils.equals(this.lastFilterDataMap.get("recrustg.id"), this.filterDataMap.get("recrustg.id"))) {
                List<Object> stsFilters = this.filterDataMap.get("recrustat.id");
                AppFileSearchList.clearList(stsFilters);
            }
        }
    }

    private static void clearList(List<Object> list) {
        if (list != null) {
            list.clear();
        }
    }

    private static boolean isNotEmptyList(List<Object> list) {
        return list != null && !list.isEmpty() && !"".equals(list.get(0));
    }

    static {
        LABEL_CATEGORY_MAP.put("A", "(IL)");
        LABEL_CATEGORY_MAP.put("B", "(PL)");
        LABEL_CATEGORY_MAP.put("C", "(AI)");
        GEN_DEF_QUERY_MAP = Maps.newHashMap();
        GEN_DEF_QUERY_MAP.put(1, AppFileHomePageHelper::queryTobeFilterWaitedAppFileIdSet);
        GEN_DEF_QUERY_MAP.put(2, AppFileHomePageHelper::queryFilterSentAppFileIdSet);
        GEN_DEF_QUERY_MAP.put(3, AppFileHomePageHelper::queryFilterFinishedAppFileIdSet);
        GEN_DEF_QUERY_MAP.put(4, AppFileHomePageHelper::queryTobeArrangedAppFileIdList);
        GEN_DEF_QUERY_MAP.put(5, AppFileHomePageHelper::queryTobeInterviewedAppFileIdList);
        GEN_DEF_QUERY_MAP.put(6, AppFileHomePageHelper::queryToBeAdvancedAppFileIdList);
        GEN_DEF_QUERY_MAP.put(7, AppFileHomePageHelper::getWaitedHireAppFileIdSet);
        GEN_DEF_QUERY_MAP.put(8, AppFileHomePageHelper::getHireAuditingAppFileIdSet);
        GEN_DEF_QUERY_MAP.put(9, AppFileHomePageHelper::getHireAuditedAppFileIdSet);
        GEN_DEF_QUERY_MAP.put(10, AppFileHomePageHelper::getOfferWaitedIds);
        GEN_DEF_QUERY_MAP.put(11, AppFileHomePageHelper::getOfferInIds);
        GEN_DEF_QUERY_MAP.put(12, AppFileHomePageHelper::getOfferDoneIds);
    }

    static interface QueryAppFileIdsFunction {
        public Collection<Long> queryAppFileIds(boolean var1, Long var2, String var3, Long var4);
    }
}

