/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.formplugin.web.appfile.portrait;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tspr.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tspr.business.domain.appfile.portrait.CommonSelectedAppFileService;
import kd.tsc.tspr.formplugin.web.appfile.portrait.CommonPortraitUtil;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;

public class CommonSelectedAppFilePlugin
extends HRDynamicFormBasePlugin {
    private CommonSelectedAppFileService selectedAppFileService = CommonSelectedAppFileService.getInstance();
    private static final String TOTAL_LABEL_AP = "totallabelap";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Label label = (Label)this.getControl("labelap");
        label.addClickListener((ClickListener)this);
        Button btnAdd = (Button)this.getControl("btn_add");
        btnAdd.addClickListener((ClickListener)this);
        Button btnDelete = (Button)this.getControl("deleteap");
        btnDelete.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.selectedAppFileService.initAppFileInfo(this.getView());
        List selectedAppFileIds = this.selectedAppFileService.getSelectedAppFileIds(this.getView());
        this.setViewBtnVisible(selectedAppFileIds != null ? selectedAppFileIds.size() : 0);
        this.updateSelectAppFileNumberLabel();
        CommonPortraitUtil.setCommonVisible(this.getView(), "cardentryfixrowap1");
        CommonPortraitUtil.setCommonVisible(this.getView(), "cardentryfixrowap");
        CommonPortraitUtil.setCommonVisible(this.getView(), "deleteap");
    }

    public void click(EventObject eventObject) {
        super.click(eventObject);
        Button button = (Button)eventObject.getSource();
        switch (button.getKey()) {
            case "labelap": {
                this.showViewSelectedAppFilePage();
                break;
            }
            case "btn_add_after": 
            case "btn_add": {
                this.showAddAppFileF7Page();
                break;
            }
            case "deleteap": {
                this.selectedAppFileService.deleteAppFiles(this.getView());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (HRObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"viewAllappFilePage")) {
            String appFileIdStr = (String)returnData;
            this.selectedAppFileService.updateAppFileInfo(this.getView(), appFileIdStr);
        }
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"addAppFilePage")) {
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
            ArrayList<Long> appFileIds = new ArrayList<Long>(listSelectedRows.size());
            for (ListSelectedRow selectRow : listSelectedRows) {
                appFileIds.add((Long)selectRow.getPrimaryKeyValue());
            }
            String appFileIdStr = SerializationUtils.toJsonString(appFileIds);
            this.selectedAppFileService.updateAppFileInfo(this.getView(), appFileIdStr);
        }
        this.getView().invokeOperation("refresh");
    }

    private void updateSelectAppFileNumberLabel() {
        Label label = (Label)this.getView().getControl(TOTAL_LABEL_AP);
        label.setText(ResManager.loadKDString((String)String.format("(\u5171%s\u4eba)", this.selectedAppFileService.getSelectedAppFileIds(this.getView()).size()), (String)"CommonSelectedAppFilePlugin_0", (String)"tsc-tspr-formplugin", (Object[])new Object[0]));
    }

    private void setViewBtnVisible(int size) {
        Boolean showViewBtnFlag = size > 10;
        this.getView().setVisible(showViewBtnFlag, new String[]{"labelap"});
    }

    private void showViewSelectedAppFilePage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("tspr_headframe_portrait");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("appFileIds", (Object)this.selectedAppFileService.getSelectedAppFileIdListStr(this.getView()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "viewAllappFilePage");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void showAddAppFileF7Page() {
        ListShowParameter listShowParameter = GenerateFormShowParamUtils.listShowParameterF7((String)"tspr_appfile_view", (String)"tspr_appfilelistf7", (String)this.getAddAppfileCaptureMultiLanguage(), (boolean)true, (boolean)false, (boolean)true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addAppFilePage");
        listShowParameter.setCloseCallBack(closeCallBack);
        Object[] selectAppFileIds = this.selectedAppFileService.getSelectedAppFileIds(this.getView()).toArray(new Long[0]);
        listShowParameter.setSelectedRows(selectAppFileIds);
        ListFilterParameter selectF7Filter = new ListFilterParameter();
        selectF7Filter.setFilter(AppFileListHelper.getIsInProcessQFilter());
        listShowParameter.setListFilterParameter(selectF7Filter);
        listShowParameter.setCustomParam("maxSelectNumber", (Object)200);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private String getAddAppfileCaptureMultiLanguage() {
        return ResManager.loadKDString((String)"\u6dfb\u52a0\u5019\u9009\u4eba", (String)"CommonSelectedAppFilePlugin_0", (String)"tsc-tspr-formplugin", (Object[])new Object[0]);
    }
}

