/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.formplugin.web.appfile.qacheck;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.qacheck.QACheckKDStringHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileQACheckHelper;

public class AppFileCheckPopPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(AppFileCheckPopPlugin.class);
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNQA = "btnownqa";
    private static final String KEY_QAUSER = "qauser";
    private static final String KEY_CHECK_MODE = "radiogroupfield";

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNQA});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(KEY_QAUSER);
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener(evt -> evt.getCustomQFilters().add(new QFilter("id", "in", (Object)AppFileQACheckHelper.getAllHRPersonIds())));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String idStr = (String)this.getView().getFormShowParameter().getCustomParam("appFileId");
        LOG.info("AppFileCheckPopPlugin.click:{},{}", (Object)control.getKey(), (Object)idStr);
        Long appFileId = Long.valueOf(idStr);
        OperationResult operationResult = AppFileQACheckHelper.validateAppFileQARight((String)this.getView().getParentView().getEntityId(), (Long)appFileId);
        if (operationResult.isSuccess()) {
            boolean isExistQa = AppFileQACheckHelper.validateIsExistQa((Long)appFileId, (String)control.getKey(), (AbstractFormPlugin)this);
            if (!isExistQa) {
                this.excute(idStr, false);
            }
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String idStr = (String)this.getView().getFormShowParameter().getCustomParam("appFileId");
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.excute(idStr, true);
        }
    }

    private void excute(String idStr, boolean desertOld) {
        String checkMode = this.getModel().getDataEntity().getString(KEY_CHECK_MODE);
        if ("2".equals(checkMode)) {
            if (HRStringUtils.isNotEmpty((String)idStr)) {
                if (desertOld) {
                    AppFileQACheckHelper.desertQACheck((Long)Long.valueOf(idStr));
                }
                DynamicObject qaUser = this.getModel().getDataEntity().getDynamicObject(KEY_QAUSER);
                AppFileQACheckHelper.startTask((Long)Long.valueOf(idStr), (DynamicObject)qaUser);
                this.getView().getParentView().showSuccessNotification(QACheckKDStringHelper.qaCheckStartDesc());
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
            }
        } else if ("1".equals(checkMode)) {
            this.openQaCheckBillPage(idStr);
            this.getView().close();
        }
    }

    private void openQaCheckBillPage(String appFileIdStr) {
        DynamicObject appFile = AppFileHelper.queryOne((long)Long.parseLong(appFileIdStr));
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("tspr_qacheck");
        billShowParameter.setCaption(String.format(Locale.ROOT, QACheckKDStringHelper.qaCheckCaption(), appFile.getString("name")));
        billShowParameter.setCustomParam("appFileId", (Object)appFileIdStr);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().getParentView().showForm((FormShowParameter)billShowParameter);
        this.getView().sendFormAction(this.getView().getParentView());
    }
}

