/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.formplugin.web.appfile.qacheck;

import com.google.common.collect.Maps;
import java.security.SecureRandom;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.service.AppFileQACheckHelper;

public class AppFileQACheckInfoPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(AppFileQACheckInfoPlugin.class);
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_QACHECKRES = "qacheckres";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_CUSTOMCONTROLAP = "customcontrolap";

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{KEY_BTNOK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (HRStringUtils.equals((String)key, (String)KEY_BTNOK)) {
            CustomControl customcontrol = (CustomControl)this.getControl(KEY_CUSTOMCONTROLAP);
            HashMap submitCmdMap = Maps.newHashMap();
            submitCmdMap.put("submit", new SecureRandom().nextInt());
            customcontrol.setData((Object)submitCmdMap);
        }
    }

    public void afterCreateNewData(EventObject evt) {
        Object description;
        super.afterCreateNewData(evt);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        LOG.info("qaCheckInfo.params:{}", (Object)customParams);
        Object evlFormObj = customParams.get("evlform");
        List evlConfigData = AppFileQACheckHelper.getEvlConfigData((long)Long.parseLong(evlFormObj.toString()));
        Object formDataObj = customParams.get("formdata");
        if (!HRObjectUtils.isEmpty(formDataObj)) {
            AppFileQACheckHelper.setResToEvlFormSys((String)formDataObj.toString(), (List)evlConfigData);
        }
        String evlJson = SerializationUtils.toJsonString((Object)evlConfigData);
        CustomControl customcontrolap = (CustomControl)this.getControl(KEY_CUSTOMCONTROLAP);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String customInitEventName = status == OperationStatus.ADDNEW ? "initData" : "initDataView";
        HashMap customParam = Maps.newHashMapWithExpectedSize((int)1);
        customParam.put(customInitEventName, HRStringUtils.isEmpty((String)evlJson) ? "[]" : evlJson);
        customcontrolap.setData((Object)customParam);
        Object result = customParams.get("result");
        if (!HRObjectUtils.isEmpty(result)) {
            this.getModel().setValue(KEY_QACHECKRES, result);
        }
        if (!HRObjectUtils.isEmpty(description = customParams.get(KEY_DESCRIPTION))) {
            this.getModel().setValue(KEY_DESCRIPTION, description);
        }
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName;
        super.customEvent(evt);
        switch (eventName = evt.getEventName()) {
            case "cache": {
                IFormView parentView;
                Map argMap = (Map)SerializationUtils.fromJsonString((String)evt.getEventArgs(), Map.class);
                Object evlResult = argMap.get("evalResult");
                String formData = "";
                if (evlResult != null) {
                    formData = SerializationUtils.toJsonString(evlResult);
                }
                if ((parentView = this.getView().getParentView()) != null) {
                    IDataModel model = parentView.getModel();
                    model.setValue("formdata", (Object)formData);
                }
                this.getView().sendFormAction(parentView);
                this.getPageCache().put("isUpdate", "1");
                break;
            }
            case "submit": {
                this.submit(evt.getEventArgs());
                break;
            }
        }
    }

    private void submit(String eventArgs) {
        Map argMap = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
        boolean hasResult = this.hasResult();
        if (!hasResult || !Boolean.TRUE.equals(argMap.get("isTestPass"))) {
            return;
        }
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            DynamicObject billData = parentView.getModel().getDataEntity();
            if (HRStringUtils.isEmpty((String)billData.getString("flowtasknum"))) {
                boolean validate = false;
                if (parentView.getParentView() != null) {
                    OperationResult operationResult = AppFileQACheckHelper.validateAppFileQARight((String)parentView.getParentView().getEntityId(), (Long)billData.getLong("appfile.id"));
                    if (operationResult.isSuccess()) {
                        validate = true;
                    } else {
                        this.getView().showOperationResult(operationResult);
                    }
                }
                if (!validate) {
                    return;
                }
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Object evlResult = argMap.get("evalResult");
            String formData = "";
            if (evlResult != null) {
                formData = SerializationUtils.toJsonString(evlResult);
            }
            AppFileQACheckHelper.submitData((IFormView)parentView, (String)dataEntity.getString(KEY_QACHECKRES), (String)formData, (String)dataEntity.getString(KEY_DESCRIPTION));
            parentView.setStatus(OperationStatus.VIEW);
            parentView.getFormShowParameter().setStatus(OperationStatus.VIEW);
            parentView.cacheFormShowParameter();
            this.getView().sendFormAction(parentView);
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        if (KEY_QACHECKRES.equals(evt.getProperty().getName())) {
            this.hasResult();
        } else if (KEY_DESCRIPTION.equals(evt.getProperty().getName())) {
            Object desc = this.getModel().getDataEntity().get(KEY_DESCRIPTION);
            this.getView().getParentView().getModel().setValue(KEY_DESCRIPTION, desc);
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private boolean hasResult() {
        String result = this.getModel().getDataEntity().getString(KEY_QACHECKRES);
        this.getView().getParentView().getModel().setValue("result", (Object)result);
        this.getView().sendFormAction(this.getView().getParentView());
        boolean hasResult = HRStringUtils.isNotEmpty((String)result);
        this.getView().setVisible(Boolean.valueOf(!hasResult), new String[]{"resultemptytip"});
        return hasResult;
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.getView().setVisible(Boolean.valueOf(this.getView().getFormShowParameter().getOpenStyle().getShowType() == ShowType.Modal || this.getView().getFormShowParameter().getOpenStyle().getShowType() == ShowType.NonModal), new String[]{"btnclose"});
        String billIdStr = (String)this.getView().getFormShowParameter().getCustomParam("billPkId");
        long billPkId = Long.parseLong(billIdStr);
        if (billPkId != 0L) {
            List attachments = AttachmentServiceHelper.getAttachments((String)"tspr_qacheck", (Object)billPkId, (String)"attachmentpanel");
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
            attachmentPanel.bindData(attachments);
        }
    }
}

