/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.formplugin.web.appfile.qacheck;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tspr.business.domain.appfile.qacheck.QACheckDataHelper;
import kd.tsc.tspr.business.domain.appfile.qacheck.QACheckKDStringHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileRightHelper;
import kd.tsc.tspr.common.constants.appfile.qacheck.AppFileQACheckConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class QACheckDetailPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(QACheckDetailPlugin.class);
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_POSNAME = "positionname";
    private static final String KEY_CREATETIME = "createtime";
    private static final String KEY_QACHECKTIME = "qachecktime";
    private static final String KEY_QACHECKID = "qacheckid";
    private static final String LABELAP_PRESSFILTERED = "pressfilteredlabelap";
    private static final String LABELAP_PRESSFILETER = "pressqachecklabelap";
    private static final String LABELAP_SUCCESS = "successlabelap";
    private static final String LABELAP_FAILL = "faillabelap";
    private static final String LABELAP_UNDETERMINED = "undeterminedlabelap";
    private static final String TIMESTR = " 23:59:59";
    private static final String APPFILE_QACHECK_REGION = "appfile_qacheck_region";
    private static final String DTEXT = "d";
    private static final String HTEXT = "h";
    private static final String MINTEXT = "min";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{LABELAP_PRESSFILETER});
    }

    public void afterCreateNewData(EventObject eventObject) {
        Long appFileId = this.getAppFileId();
        DynamicObject appFileDy = AppFileDataHelper.queryAppFileById((Object)appFileId);
        if (HRObjectUtils.isEmpty((Object)appFileDy)) {
            return;
        }
        Label lblPosName = (Label)this.getControl(KEY_POSNAME);
        lblPosName.setText(this.getDynamicObjectName(appFileDy, "position"));
        DynamicObject[] qaCheckArr = QACheckDataHelper.getQACheckByAppFileId((Long)appFileId);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(KEY_QACHECKID, new Object[0]);
        vs.addField(KEY_CREATETIME, new Object[0]);
        vs.addField("recrustg", new Object[0]);
        vs.addField("handler", new Object[0]);
        vs.addField("description", new Object[0]);
        vs.addField(KEY_QACHECKTIME, new Object[0]);
        vs.addField("handletime", new Object[0]);
        this.setEntryEntityValue(vs, qaCheckArr, appFileId);
        model.batchCreateNewEntryRow(KEY_ENTRY_ENTITY, vs);
        model.endInit();
    }

    private void setEntryEntityValue(TableValueSetter vs, DynamicObject[] qaCheckArr, Long appFileId) {
        for (int index = 0; index < qaCheckArr.length; ++index) {
            DynamicObject qaCheckDy = qaCheckArr[index];
            long qaCheckId = qaCheckDy.getLong("id");
            vs.set(KEY_QACHECKID, (Object)qaCheckId, index);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date createTime = qaCheckDy.getDate(KEY_CREATETIME);
            vs.set(KEY_CREATETIME, (Object)String.format(sdf.format(createTime), new Object[0]), index);
            vs.set("recrustg", (Object)this.getDynamicObjectName(qaCheckDy, "recrustg"), index);
            vs.set("handler", (Object)this.getDynamicObjectName(qaCheckDy, "handler"), index);
            vs.set("description", (Object)qaCheckDy.getString("description"), index);
            Date handleTime = qaCheckDy.getDate("handletime");
            if (handleTime != null) {
                vs.set("handletime", (Object)String.format(sdf.format(handleTime), new Object[0]), index);
            } else {
                handleTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
            }
            vs.set(KEY_QACHECKTIME, (Object)this.timeInterval(createTime, handleTime), index);
            CardEntry cardEntry = (CardEntry)this.getView().getControl(KEY_ENTRY_ENTITY);
            this.dealWithResult(index, qaCheckDy, cardEntry);
            this.dealWithStatus(appFileId, index, qaCheckDy, qaCheckId, cardEntry);
        }
    }

    private void dealWithResult(int index, DynamicObject qaCheckDy, CardEntry cardEntry) {
        String result = qaCheckDy.getString("result");
        if (HRStringUtils.equals((String)result, (String)AppFileQACheckConstants.Status.PASS.getStatus())) {
            cardEntry.setChildVisible(false, index, new String[]{LABELAP_FAILL, LABELAP_UNDETERMINED});
        } else if (HRStringUtils.equals((String)result, (String)AppFileQACheckConstants.Status.NOT_PASS.getStatus())) {
            cardEntry.setChildVisible(false, index, new String[]{LABELAP_SUCCESS, LABELAP_UNDETERMINED});
        } else if (HRStringUtils.equals((String)result, (String)AppFileQACheckConstants.Status.PENDING.getStatus())) {
            cardEntry.setChildVisible(false, index, new String[]{LABELAP_SUCCESS, LABELAP_FAILL});
        } else {
            cardEntry.setChildVisible(false, index, new String[]{LABELAP_FAILL, LABELAP_SUCCESS, LABELAP_UNDETERMINED});
        }
    }

    private void dealWithStatus(Long appFileId, int index, DynamicObject qaCheckDy, long qaCheckId, CardEntry cardEntry) {
        String auditStatus = qaCheckDy.getString("auditstatus");
        if (HRStringUtils.equals((String)auditStatus, (String)AppFileQACheckConstants.AuditStatus.TEMP.getStatus())) {
            DistributeSessionlessCache cache = QACheckDetailPlugin.getDistributeSessionlessCache();
            String cacheValue = (String)cache.get(appFileId + "" + qaCheckId);
            if (HRStringUtils.isEmpty((String)cacheValue)) {
                cardEntry.setChildVisible(false, index, new String[]{LABELAP_PRESSFILTERED});
            } else {
                cardEntry.setChildVisible(false, index, new String[]{LABELAP_PRESSFILETER});
            }
        } else {
            cardEntry.setChildVisible(false, index, new String[]{LABELAP_PRESSFILTERED, LABELAP_PRESSFILETER});
        }
    }

    private String timeInterval(Date begin, Date end) {
        String timeInterval = "";
        if (begin == null || end == null) {
            return timeInterval;
        }
        long diff = end.getTime() - begin.getTime();
        long nm = 60000L;
        long nh = 3600000L;
        long hour = diff / nh;
        long nd = 86400000L;
        timeInterval = hour % 24L == 0L && hour != 0L ? hour / 24L + DTEXT : (hour < 24L ? diff / nh + HTEXT + diff % nh / nm + MINTEXT : diff / nd + DTEXT + diff % nd / nh + HTEXT + diff % nd % nh / nm + MINTEXT);
        return timeInterval;
    }

    private String getDynamicObjectName(DynamicObject dataDyn, String fieldName) {
        Object obj = dataDyn.get(fieldName);
        if (obj == null) {
            return null;
        }
        String name = obj instanceof DynamicObject ? ((DynamicObject)obj).getString("name") : (String)obj;
        return name;
    }

    private Long getAppFileId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (Long)formShowParameter.getCustomParam("appFileId");
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (!HRStringUtils.equals((String)key, (String)LABELAP_PRESSFILETER)) {
            return;
        }
        Long appFileId = this.getAppFileId();
        boolean hasRight = AppFileRightHelper.hasRight((Long)appFileId, (String)"tssrm", (Long)TSCRequestContext.getUserId(), (String)"4715a0df000000ac");
        if (!hasRight) {
            this.getView().showErrorNotification(QACheckKDStringHelper.notHaveRight());
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
        DynamicObject pageQACheckDy = this.getModel().getEntryRowEntity(KEY_ENTRY_ENTITY, index);
        Long qaCheckId = pageQACheckDy.getLong(KEY_QACHECKID);
        DynamicObject qaCheckDy = QACheckDataHelper.getQACheckById((Long)qaCheckId);
        String auditStatus = qaCheckDy.getString("auditstatus");
        if (!HRStringUtils.equals((String)auditStatus, (String)AppFileQACheckConstants.AuditStatus.TEMP.getStatus())) {
            this.getView().showErrorNotification(QACheckKDStringHelper.statusCheck());
            this.getView().invokeOperation("refresh");
            return;
        }
        this.sendMessage(qaCheckDy);
        try {
            long curTime = System.currentTimeMillis();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String curTimeStr = sdf.format(new Date());
            SimpleDateFormat sdfToday = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            DistributeSessionlessCache cache = QACheckDetailPlugin.getDistributeSessionlessCache();
            Date todayDate = sdfToday.parse(curTimeStr + TIMESTR);
            int timeoutSeconds = (int)(todayDate.getTime() / 1000L - curTime / 1000L);
            cache.put(appFileId + "" + qaCheckId, (Object)QACheckKDStringHelper.pressQACheck(), timeoutSeconds);
            this.getView().invokeOperation("refresh");
        }
        catch (ParseException e) {
            LOGGER.error("pressfilter set pressErr");
        }
    }

    private void sendMessage(DynamicObject qaCheckDy) {
        MessageInfo messageInfo = new MessageInfo();
        Long sendId = TSCRequestContext.getUserId();
        LocaleString messageContent = new LocaleString();
        String format = String.format(Locale.ROOT, QACheckKDStringHelper.petitioner(), this.getDynamicObjectName(qaCheckDy, "creator"));
        messageContent.setLocaleValue(format + "\n" + QACheckKDStringHelper.messageContent());
        messageInfo.setMessageContent((ILocaleString)messageContent);
        LocaleString messageTitle = new LocaleString();
        messageTitle.setLocaleValue(QACheckKDStringHelper.title());
        messageInfo.setMessageTitle((ILocaleString)messageTitle);
        ArrayList userIds = Lists.newArrayListWithExpectedSize((int)1);
        userIds.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)qaCheckDy, (String)"handler"));
        messageInfo.setUserIds((List)userIds);
        messageInfo.setType("notice");
        messageInfo.setTag(QACheckKDStringHelper.tag() + TSCRequestContext.getUserName());
        messageInfo.setEntityNumber("tspr_qacheck");
        messageInfo.setSenderId(sendId);
        messageInfo.setBizDataId(Long.valueOf(qaCheckDy.getLong("id")));
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private static DistributeSessionlessCache getDistributeSessionlessCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(APPFILE_QACHECK_REGION);
    }
}

