/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.formplugin.web.appfile.qacheck;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.form.AppFileFormHelper;
import kd.tsc.tspr.business.domain.appfile.form.AppFileTabHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileQACheckHelper;
import kd.tsc.tspr.common.constants.label.AppfileLabelShowParam;

public class QACheckEdit
extends HRCoreBaseBillEdit {
    private static final Log LOG = LogFactory.getLog(QACheckEdit.class);
    private static final String KEY_TAB_RSM = "tabapprsm";
    private static final String KEY_TAB_ORIGIN_RSM = "taboriginrsm";
    private static final String KEY_FLEX_HEAD = "flex_head";

    public void afterCreateNewData(EventObject event) {
        super.afterCreateNewData(event);
        String idStr = (String)this.getView().getFormShowParameter().getCustomParam("appFileId");
        Long appFileId = Long.valueOf(idStr);
        DynamicObject appfile = AppFileHelper.queryOne((long)appFileId, (String)"createorg,position,recrustg,qacheckresult");
        Map evlFormResMap = AppFileQACheckHelper.getEvlFormIdByAppFile((DynamicObject[])new DynamicObject[]{appfile});
        this.getModel().setValue("appfile", (Object)appfile);
        this.getModel().setValue("recrustg", appfile.get("recrustg"));
        this.getModel().setValue("evlform", evlFormResMap.get(appFileId));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            boolean isExistQa;
            FormOperate source = (FormOperate)args.getSource();
            DynamicObject dataEntity = this.getModel().getDataEntity();
            if ("submit".equals(source.getOperateKey()) && HRStringUtils.isEmpty((String)dataEntity.getString("flowtasknum")) && (isExistQa = AppFileQACheckHelper.validateIsExistQa((Long)dataEntity.getLong("appfile.id"), (String)"submit", (AbstractFormPlugin)this))) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("submit".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String formPageId = this.getPageCache().get("tspr_qacheckinfo");
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getView(formPageId).getControl("attachmentpanel");
                    List attachmentData = attachmentPanel.getAttachmentData();
                    if (attachmentData != null && !attachmentData.isEmpty()) {
                        HashMap attachmentKeyAndData = Maps.newHashMapWithExpectedSize((int)1);
                        attachmentKeyAndData.put("attachmentpanel", attachmentData);
                        AttachmentServiceHelper.saveTempAttachments((String)"tspr_qacheck", (Object)this.getModel().getDataEntity().getLong("id"), (String)"tspr", (Map)attachmentKeyAndData);
                    }
                }
                catch (RuntimeException ex) {
                    LOG.error("qaCheckAttach.saveTempAttachments.error", (Throwable)ex);
                    txHandle.markRollback();
                    throw ex;
                }
            }
            this.getView().updateView();
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject appFile = dataEntity.getDynamicObject("appfile");
        LOG.info("QACheckInfo.init:{},{}", appFile.getPkValue(), dataEntity.getPkValue());
        this.initHead(appFile);
        this.initTab(appFile);
        this.initPortrait(appFile);
        this.initAccessForm();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            AppFileQACheckHelper.desertQACheck((Long)this.getModel().getDataEntity().getLong("appfile.id"));
            this.getView().invokeOperation("submit");
        }
    }

    private void initHead(DynamicObject appFile) {
        AppFileFormHelper.showAppFileHeaderForm((IFormView)this.getView(), (long)appFile.getLong("id"), (String)KEY_FLEX_HEAD, null);
    }

    private void initPortrait(DynamicObject appFile) {
        AppfileLabelShowParam appfileLabelShowParam = new AppfileLabelShowParam(this.getView(), appFile, true, false, Boolean.valueOf(true), (List)Lists.newArrayList((Object[])new String[]{"A"}), null);
        AppFileTabHelper.showAppFileDefaultLabelPage((AppfileLabelShowParam)appfileLabelShowParam);
    }

    private void initAccessForm() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormShowParameter showParameter = new FormShowParameter();
        AppFileQACheckHelper.handleQAInfoShowParameter((DynamicObject)dataEntity, (FormShowParameter)showParameter);
        OperationStatus status = "A".equals(dataEntity.getString("auditstatus")) && this.getView().getFormShowParameter().getStatus() != OperationStatus.VIEW ? OperationStatus.ADDNEW : OperationStatus.VIEW;
        showParameter.setStatus(status);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("flexpanelap2");
        showParameter.setSendToClient(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tspr_qacheckinfo"));
        this.getView().showForm(showParameter);
        this.getPageCache().put("tspr_qacheckinfo", showParameter.getPageId());
    }

    private void initTab(DynamicObject appFile) {
        Long appRsmId = appFile.getLong("appres.id");
        HRBaseServiceHelper rsmHelper = new HRBaseServiceHelper("tstpm_rsm");
        DynamicObject appRsm = rsmHelper.queryOne((Object)appRsmId);
        AppFileTabHelper.showAppResPage((String)KEY_TAB_RSM, (String)KEY_TAB_RSM, (AbstractFormPlugin)this, (DynamicObject)appRsm, (OperationStatus)OperationStatus.VIEW);
        AppFileTabHelper.previewOriginalResume(null, (String)KEY_TAB_ORIGIN_RSM, (DynamicObject)appRsm, (String)KEY_TAB_ORIGIN_RSM, (IFormView)this.getView(), (boolean)false);
        if (this.getPageCache().get("firstEnter") == null) {
            Tab tabAp = (Tab)this.getView().getControl("tabap");
            tabAp.activeTab(KEY_TAB_RSM);
            this.getPageCache().put("firstEnter", "0");
        }
    }
}

