/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.formplugin.web.bgsurvey;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AttachmentDownLoadEvent;
import kd.bos.form.control.events.AttachmentDownloadListener;
import kd.bos.form.control.events.BeforeAttachmentRemoveEvent;
import kd.bos.form.control.events.BeforeAttachmentRemoveListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tspr.business.domain.bgsurvey.service.BackgroundSurveyDomainService;
import kd.tsc.tspr.common.constants.bgsurvey.BackGroundSurveyConEnum;
import kd.tsc.tsrbd.business.domain.perm.PermissionHelper;

public class BackgroundSurveyEdit
extends HRDataBaseEdit
implements BeforeAttachmentRemoveListener,
UploadListener,
AttachmentDownloadListener {
    private static final Log logger = LogFactory.getLog(BackgroundSurveyEdit.class);

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            Long appFileId = (Long)formShowParameter.getCustomParam("appFileId");
            this.getModel().setValue("appfile", (Object)appFileId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        try {
            IDataModel dataModel = this.getModel();
            List originAttachments = null;
            String attach = this.getView().getPageCache().get("BackgroundSurveyAttach");
            if (attach != null) {
                originAttachments = (List)JSON.parse((String)attach);
            }
            Long pkValue = (Long)dataModel.getDataEntity().getPkValue();
            DynamicObject appFile = dataModel.getDataEntity().getDynamicObject("appfile");
            Long appFileId = appFile.getLong("id");
            BackgroundSurveyDomainService.sendAttachOperateRecord((Long)pkValue, (Long)appFileId, (List)originAttachments);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
        IFormView parentView = this.getView().getParentView();
        this.getView().returnDataToParent((Object)"refresh");
        this.getView().sendFormAction(parentView);
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
    }

    public void afterBindData(EventObject evt) {
        Long appFileId;
        String permItemId;
        String formId;
        super.afterBindData(evt);
        Label backgroundno = (Label)this.getControl("lblbackgroundno");
        String number = String.valueOf(this.getModel().getValue("txtnumber"));
        backgroundno.setText(number);
        String conclusion = String.valueOf(this.getModel().getValue("cmbconclusion"));
        if (BackGroundSurveyConEnum.N.getCode().equals(conclusion)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"lblconclusionexist"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"lblconclusionnormal"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"lblconclusionexist"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"lblconclusionnormal"});
        }
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        if (attachmentPanel != null) {
            List data = attachmentPanel.getAttachmentData();
            String attachFileJson = JSON.toJSONString((Object)data);
            this.getView().getPageCache().put("BackgroundSurveyAttach", attachFileJson);
        }
        if (PermissionHelper.hasOpPerm((String)(formId = this.getView().getParentView().getEntityId()), (String)(permItemId = "2C8JVDE25MYW"), (Object)(appFileId = Long.valueOf(this.getView().getModel().getDataEntity().getLong("appfile.id"))))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"editbackgroundsurvey"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"editbackgroundsurvey"});
        }
    }

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{"editbackgroundsurvey"});
        AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanelap");
        panel.addBeforeRemoveListener((BeforeAttachmentRemoveListener)this);
        panel.addUploadListener((UploadListener)this);
        panel.addDownloadListener((AttachmentDownloadListener)this);
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if ("editbackgroundsurvey".equals(key)) {
            this.getView().getParentView().invokeOperation("savebackgroundsurvey");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void beforeAttachmentRemove(BeforeAttachmentRemoveEvent e) {
    }

    public void remove(UploadEvent e) {
        try {
            IDataModel dataModel = this.getModel();
            Long pkValue = (Long)dataModel.getDataEntity().getPkValue();
            DynamicObject appFile = dataModel.getDataEntity().getDynamicObject("appfile");
            Long appFileId = appFile.getLong("id");
            Object[] removeAttachs = e.getUrls();
            if (removeAttachs != null && removeAttachs.length > 0) {
                for (int i = 0; i < removeAttachs.length; ++i) {
                    Map attach = (Map)removeAttachs[i];
                    Object attPkId = attach.get("attPkId");
                    String uid = String.valueOf(attach.get("uid"));
                    if (attPkId == null) continue;
                    String fileName = (String)attach.get("name");
                    BackgroundSurveyDomainService.sendDeleteAttachOperateRecord((Long)pkValue, (Long)appFileId, (String)fileName);
                    String attachJson = this.getView().getPageCache().get("BackgroundSurveyAttach");
                    this.getView().getPageCache().put("BackgroundSurveyAttach", BackgroundSurveyDomainService.removeAttachCache((String)uid, (String)attachJson));
                }
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
    }

    public void attachmentAfterDownload(AttachmentDownLoadEvent evt) {
        try {
            super.attachmentAfterDownload(evt);
            IDataModel dataModel = this.getModel();
            Long pkValue = (Long)dataModel.getDataEntity().getPkValue();
            DynamicObject appFile = dataModel.getDataEntity().getDynamicObject("appfile");
            List attachments = (List)evt.getTargetAttachments();
            Long appFileId = appFile.getLong("id");
            BackgroundSurveyDomainService.sendDownloadOperateRecord((Long)pkValue, (Long)appFileId, (List)attachments);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
    }
}

