/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.formplugin.web.intv;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.common.utils.TSCQFilterUtils;
import kd.tsc.tsrbs.common.utils.TscTreeUtils;

public class SelectIntEvaDetailPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener,
ClickListener {
    private static final Log logger = LogFactory.getLog(SelectIntEvaDetailPlugin.class);
    private static final String AP_TREEVIEW = "treeview";
    private static final String PANEL_INTVEVL = "panel_intvevl";
    private static final String PANEL_DEFINTVEVL = "panel_defintvevl";
    private static final String AP_IMGDEF = "imgdef";
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String INAGESURL = "/images/pc/emotion/rcgyy_xzmsb_280_160.png";
    public static final String POSITION_RECRUSCENE = "recruscene";
    public static final String KEY_LABELAP1 = "labelap1";

    public void initialize() {
        super.initialize();
        TreeView treeView = (TreeView)this.getView().getControl(AP_TREEVIEW);
        String evlType = (String)this.getView().getFormShowParameter().getCustomParam("evltype");
        logger.info("initialize evlType: {}", (Object)evlType);
        if (StringUtils.isEmpty((String)evlType) || evlType.equals("1")) {
            this.createTalentTree(treeView);
        } else {
            this.createTalentTreeType2(treeView);
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        TreeView tplTree = (TreeView)this.getView().getControl(AP_TREEVIEW);
        tplTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Button confirmBtn = (Button)this.getView().getControl(BTN_CONFIRM);
        confirmBtn.addClickListener((ClickListener)this);
        Button cancelBtn = (Button)this.getView().getControl(BTN_CANCEL);
        cancelBtn.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        String defaultId = this.getView().getParentView().getPageCache().get("opendefaultid");
        if (defaultId != null) {
            this.openInterviewPage(defaultId);
            this.getView().getPageCache().put("defaultid", defaultId);
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_DEFINTVEVL});
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_INTVEVL});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_DEFINTVEVL});
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_INTVEVL});
            Image image = (Image)this.getView().getControl(AP_IMGDEF);
            image.setUrl(INAGESURL);
        }
    }

    public void search(SearchEnterEvent event) {
        super.search(event);
        String searchText = event.getText();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        TscTreeUtils.searchTalentTree((String)searchText, (IFormView)view, (IPageCache)pageCache, null);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        String nodeId = evt.getNodeId().toString();
        this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_DEFINTVEVL});
        this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_INTVEVL});
        Image image = (Image)this.getView().getControl(AP_IMGDEF);
        image.setUrl(INAGESURL);
        this.openInterviewPage(nodeId);
        this.getView().getPageCache().put("defaultid", nodeId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (BTN_CONFIRM.equals(key)) {
            HashMap<String, String> returnData = new HashMap<String, String>(1);
            returnData.put("defaultid", this.getView().getPageCache().get("defaultid"));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if (BTN_CANCEL.equals(key)) {
            this.getView().close();
        }
    }

    private void createTalentTree(TreeView treeView) {
        DynamicObject[] objects;
        String defaultId = this.getView().getParentView().getPageCache().get("defaultid");
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("createorg");
        String recruitTypId = (String)this.getView().getFormShowParameter().getCustomParam("recruittypid");
        String recSceneId = (String)this.getView().getFormShowParameter().getCustomParam(POSITION_RECRUSCENE);
        TreeNode root = TscTreeUtils.renderRoot();
        root.setIsOpened(true);
        TreeNode treeNodeId = null;
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"tsrbd_intvevlqunr", orgId != null ? Long.valueOf(Long.parseLong(orgId)) : null);
        if (orgFilter == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc4\u4ef7\u8868\u57fa\u7840\u8d44\u6599\u672a\u914d\u7f6e\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SelectIntEvaDetailPlugin_0", (String)"tsc-tspr-formplugin", (Object[])new Object[0]));
            this.getView().getParentView().getPageCache().put("opendefaultid", null);
            return;
        }
        if (recruitTypId != null) {
            QFilter defaultFilter = new QFilter("group", "=", (Object)Long.parseLong(recruitTypId));
            orgFilter.and(defaultFilter);
        }
        if (recSceneId != null) {
            QFilter recSceneFilter = new QFilter("recruscene.fbasedataid_id", "=", (Object)Long.parseLong(recSceneId));
            recSceneFilter.or(new QFilter("recruscene.fbasedataid_id", "is null", null));
            orgFilter.and(recSceneFilter);
        }
        orgFilter.and(new QFilter("evltype", "=", (Object)"1"));
        orgFilter.and(new QFilter("enable", "=", (Object)"1"));
        HRBaseServiceHelper intEvaPool = new HRBaseServiceHelper("tsrbd_intvevlqunr");
        String selectProperties = "id,number,name,recruscene";
        for (DynamicObject dy : objects = intEvaPool.query("id,number,name,recruscene", new QFilter[]{orgFilter}, "createtime desc,number")) {
            TreeNode treeNode = TscTreeUtils.getTreeNode((DynamicObject)dy, (String)root.getId());
            root.addChild(treeNode);
            if (!dy.get("id").toString().equals(defaultId)) continue;
            treeNodeId = treeNode;
        }
        treeView.addNode(root);
        if (defaultId != null) {
            treeView.focusNode(treeNodeId);
            this.getView().getParentView().getPageCache().remove("defaultid");
        }
        this.getPageCache().put(treeView.getKey(), SerializationUtils.toJsonString((Object)root));
    }

    private void createTalentTreeType2(TreeView treeView) {
        DynamicObject[] objects;
        QFilter filter;
        String defaultId = this.getView().getParentView().getPageCache().get("defaultid");
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("createorg");
        String recruitTypId = (String)this.getView().getFormShowParameter().getCustomParam("recruittypid");
        String recSceneId = (String)this.getView().getFormShowParameter().getCustomParam(POSITION_RECRUSCENE);
        Label labelap1 = (Label)this.getControl(KEY_LABELAP1);
        labelap1.setText(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d44\u683c\u5ba1\u67e5\u8868\u8fdb\u884c\u9884\u89c8", (String)"SelectIntEvaDetailPlugin_1", (String)"tsc-tspr-formplugin", (Object[])new Object[0]));
        logger.info("createTalentTreeType2 defaultId:{} orgId: {}, recruitTypId: {}, recSceneId: {}", new Object[]{defaultId, orgId, recruitTypId, recSceneId});
        TreeNode root = TscTreeUtils.renderRoot();
        root.setIsOpened(true);
        TreeNode treeNodeId = null;
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"tsrbd_intvevlqunr", orgId != null ? Long.valueOf(Long.parseLong(orgId)) : null);
        if (orgFilter == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc4\u4ef7\u8868\u57fa\u7840\u8d44\u6599\u672a\u914d\u7f6e\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SelectIntEvaDetailPlugin_2", (String)"tsc-tspr-formplugin", (Object[])new Object[0]));
            this.getView().getParentView().getPageCache().put("opendefaultid", null);
            return;
        }
        if (StringUtils.isEmpty((String)recruitTypId) || StringUtils.isEmpty((String)recSceneId)) {
            filter = TSCQFilterUtils.cFalse();
        } else {
            filter = orgFilter;
            QFilter defaultFilter = new QFilter("group", "=", (Object)Long.parseLong(recruitTypId));
            filter.and(defaultFilter);
            QFilter recSceneFilter = new QFilter("recruscene.fbasedataid_id", "=", (Object)Long.parseLong(recSceneId));
            recSceneFilter.or(new QFilter("recruscene.fbasedataid_id", "is null", null));
            filter.and(recSceneFilter);
            filter.and(new QFilter("evltype", "=", (Object)"2"));
            filter.and(new QFilter("enable", "=", (Object)"1"));
        }
        HRBaseServiceHelper intEvaPool = new HRBaseServiceHelper("tsrbd_intvevlqunr");
        String selectProperties = "id,number,name,recruscene";
        for (DynamicObject dy : objects = intEvaPool.query("id,number,name,recruscene", new QFilter[]{filter}, "number")) {
            TreeNode treeNode = TscTreeUtils.getTreeNode((DynamicObject)dy, (String)root.getId());
            root.addChild(treeNode);
            if (!dy.get("id").toString().equals(defaultId)) continue;
            treeNodeId = treeNode;
        }
        treeView.addNode(root);
        if (defaultId != null) {
            treeView.focusNode(treeNodeId);
            this.getView().getParentView().getPageCache().remove("defaultid");
        }
        this.getPageCache().put(treeView.getKey(), SerializationUtils.toJsonString((Object)root));
    }

    private void openInterviewPage(String nodeId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("tspr_intvevl");
        showParameter.setCustomParam("evlFormId", (Object)nodeId);
        showParameter.setCustomParam("sourceType", (Object)"select");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(PANEL_INTVEVL);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

