/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.advertising.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.advertising.service.AdvertConfigHelper;
import kd.tsc.tspr.business.domain.advertising.service.AdvertDetailExDataHelper;
import kd.tsc.tspr.business.domain.advertising.service.AdvertTplExCommonHelper;
import kd.tsc.tspr.common.util.CommonUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.collections.CollectionUtils;

public class AdvertApprovalDataHelper
extends HRBaseServiceHelper {
    Log log = LogFactory.getLog(AdvertApprovalDataHelper.class);
    private AdvertDetailExDataHelper detailExDataHelper = AdvertDetailExDataHelper.getInstance();

    public static AdvertApprovalDataHelper getInstance() {
        return AdvertApprovalHelperHolder.INSTANCE;
    }

    private AdvertApprovalDataHelper(String entityName) {
        super(entityName);
    }

    public List<Long> getPosIdsByBillId(List<Long> billIds) {
        QFilter qFilter = new QFilter("id", "in", billIds);
        DynamicObject[] approvalArr = this.query("id,position", qFilter.toArray());
        ArrayList<Long> posIds = new ArrayList<Long>(billIds.size());
        for (DynamicObject approval : approvalArr) {
            DynamicObject position = approval.getDynamicObject("position");
            long positionId = position.getLong("id");
            posIds.add(positionId);
        }
        return posIds;
    }

    public void updateSnapIsAuditAndChannelNames(DynamicObject advertBill, List<Long> needAuditList, List<Long> notAuditList) {
        DynamicObjectCollection entryEntity = advertBill.getDynamicObjectCollection("entryentity");
        StringBuilder channelNamesSbf = new StringBuilder();
        for (DynamicObject advSnap : entryEntity) {
            long channelId = advSnap.getDynamicObject("channel").getLong("id");
            if (CollectionUtils.isNotEmpty(needAuditList) && needAuditList.contains(channelId)) {
                advSnap.set("isaudit", (Object)Boolean.TRUE);
                channelNamesSbf.append(advSnap.getDynamicObject("channel").getString("name")).append(",");
            }
            if (!CollectionUtils.isNotEmpty(notAuditList) || !notAuditList.contains(channelId)) continue;
            advSnap.set("isaudit", (Object)Boolean.FALSE);
        }
        String channelNames = channelNamesSbf.toString();
        if (HRStringUtils.isNotEmpty((String)channelNames)) {
            channelNames = CommonUtils.subStrBySize((String)channelNames, (int)190);
            advertBill.set("category", (Object)channelNames);
        }
        this.save(new DynamicObject[]{advertBill});
    }

    public List<Long> getLatestChannelIdList(Long positionId, Long userId) {
        QFilter qFilter1 = new QFilter("position", "=", (Object)positionId);
        QFilter qFilter2 = new QFilter("creator", "=", (Object)userId);
        Object[] dynamicObjects = this.query("id,entryentity.channel", new QFilter[]{qFilter1, qFilter2}, "createtime desc", 1);
        if (!HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return dynamicObjects[0].getDynamicObjectCollection("entryentity").stream().map(xKey -> xKey.getLong("channel_id")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<Long> getLatestChannelIdList(Long positionId) {
        return this.getLatestChannelIdList(positionId, TSCRequestContext.getUserId());
    }

    public boolean canEditByAdvertId(DynamicObject approval) {
        if (HRObjectUtils.isEmpty((Object)approval)) {
            return true;
        }
        String auditStatus = approval.getString("billstatus");
        return !HRStringUtils.equals((String)auditStatus, (String)"A") && !HRStringUtils.equals((String)auditStatus, (String)"B") && !HRStringUtils.equals((String)auditStatus, (String)"G") && !HRStringUtils.equals((String)auditStatus, (String)"D");
    }

    public boolean canPubByAdvertId(DynamicObject approval) {
        if (HRObjectUtils.isEmpty((Object)approval)) {
            return true;
        }
        String auditStatus = approval.getString("billstatus");
        return !HRStringUtils.equals((String)auditStatus, (String)"B") && !HRStringUtils.equals((String)auditStatus, (String)"D");
    }

    public DynamicObject getApprovalStatusById(Long approvalId) {
        DynamicObject approval = this.queryOne("id,billstatus,position,billno", approvalId);
        return approval;
    }

    public DynamicObject[] loadApprovalData(Iterable<Long> approvalIds) {
        return this.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", approvalIds)});
    }

    public DynamicObject loadApprovalData(Long approvalId) {
        Object[] approvalDatas = this.loadApprovalData(Lists.newArrayList((Object[])new Long[]{approvalId}));
        if (HRArrayUtils.isEmpty((Object[])approvalDatas)) {
            return null;
        }
        return approvalDatas[0];
    }

    public DynamicObject[] loadApprovalData(DynamicObject[] dataEntity) {
        List<Long> approvalIds = Arrays.stream(dataEntity).map(xKey -> xKey.getLong("id")).collect(Collectors.toList());
        return this.loadApprovalData(approvalIds);
    }

    public DynamicObject[] getNoEndApproval(Long advertId) {
        QFilter of = QFilter.of((String)"entryentity.advertid = ? and billstatus in (?, ?, ?)", (Object[])new Object[]{advertId, "B", "D", "G"});
        return this.query("billno", of.toArray());
    }

    public DynamicObject[] getApprovalByAdvertId(List<Long> advertIds, Long approvalId) {
        QFilter of = new QFilter("id", "!=", (Object)approvalId);
        QFilter advertFilter = new QFilter("entryentity.advertid", "in", advertIds);
        return this.loadDynamicObjectArray(new QFilter[]{of, advertFilter});
    }

    public void deleteById(Iterable<Long> approvalId) {
        QFilter of = new QFilter("id", "in", approvalId);
        this.deleteByFilter(of.toArray());
    }

    public void deleteById(Long approvalId) {
        this.deleteById(Lists.newArrayList((Object[])new Long[]{approvalId}));
    }

    public void deleteApprovalAndUpdateAdvert(Long approvalId) {
        try (TXHandle advertDel = TX.required((String)"tspr_advertbilltpl");){
            try {
                DynamicObject approval = AdvertApprovalDataHelper.getInstance().loadApprovalData(approvalId);
                if (!Objects.isNull(approval)) {
                    List<Long> advertIds = approval.getDynamicObjectCollection("entryentity").stream().map(xKey -> xKey.getLong("advertid_id")).collect(Collectors.toList());
                    Object[] adverts = AdvertDetailExDataHelper.getInstance().getAdvertListByIds(advertIds);
                    if (!HRArrayUtils.isEmpty((Object[])adverts)) {
                        DynamicObject[] approvals = AdvertApprovalDataHelper.getInstance().getApprovalByAdvertId(advertIds, approvalId);
                        Map<Long, DynamicObject> advertIdApprovalObjMap = this.getAdvertIdApprovalObjMap(approvals);
                        this.updateAdvertLastApproval((DynamicObject[])adverts, advertIdApprovalObjMap);
                        this.log.info("update adverts : {}", advertIdApprovalObjMap);
                        AdvertDetailExDataHelper.getInstance().saveAdvertDetail((DynamicObject[])adverts);
                    }
                    AdvertApprovalDataHelper.getInstance().deleteById(approvalId);
                }
            }
            catch (Throwable e) {
                advertDel.markRollback();
                throw e;
            }
        }
    }

    public void deleteApprovalAndUpdateAdvertByAdvertId(Long advertId) {
        DynamicObject advertListByIds = AdvertDetailExDataHelper.getInstance().getAdvertListByIds(advertId);
        long approvalId = advertListByIds.getLong("approvalid");
        this.deleteApprovalAndUpdateAdvert(approvalId);
    }

    public void deleteApprovalAndUpdateAdvertByAdvertApprovalIds(List<Long> advertApprovalIds) {
        for (long approvalId : advertApprovalIds) {
            this.deleteApprovalAndUpdateAdvert(approvalId);
        }
    }

    private void updateAdvertLastApproval(DynamicObject[] adverts, Map<Long, DynamicObject> advertIdApprovalObjMap) {
        for (DynamicObject advert : adverts) {
            DynamicObject lastApproval = advertIdApprovalObjMap.get(advert.getLong("id"));
            if (!HRObjectUtils.isEmpty((Object)lastApproval)) {
                advert.set("approvalid", lastApproval.getPkValue());
                advert.set("advbillno", (Object)lastApproval.getString("billno"));
                advert.set("approvestatus", (Object)lastApproval.getString("billstatus"));
                continue;
            }
            advert.set("approvalid", null);
            advert.set("advbillno", null);
            advert.set("approvestatus", null);
        }
    }

    private Map<Long, DynamicObject> getAdvertIdApprovalObjMap(DynamicObject[] approvals) {
        HashMap advertIdApprovalObjMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject approvalObj : approvals) {
            Date curApprovalDate = approvalObj.getDate("createtime");
            DynamicObjectCollection advertSnapCol = approvalObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject advertSnap : advertSnapCol) {
                long advertSnapId = advertSnap.getLong("advertid_id");
                DynamicObject dynamicObject = (DynamicObject)advertIdApprovalObjMap.get(advertSnapId);
                if (!HRObjectUtils.isEmpty((Object)dynamicObject)) {
                    Date lastDate = dynamicObject.getDate("createtime");
                    if (curApprovalDate.compareTo(lastDate) <= 0) continue;
                    advertIdApprovalObjMap.put(advertSnapId, approvalObj);
                    continue;
                }
                advertIdApprovalObjMap.put(advertSnapId, approvalObj);
            }
        }
        return advertIdApprovalObjMap;
    }

    public void saveByList(List<DynamicObject> advBillList) {
        if (CollectionUtils.isEmpty(advBillList)) {
            return;
        }
        this.save(advBillList.toArray(new DynamicObject[0]));
    }

    public void snapWriteBackToAdvert(DynamicObject advBill) {
        DynamicObjectCollection snaps = advBill.getDynamicObjectCollection("entryentity");
        String auditStatus = advBill.getString("billstatus");
        if (!HRStringUtils.equals((String)auditStatus, (String)"A") && !HRStringUtils.equals((String)auditStatus, (String)"G")) {
            return;
        }
        Map<Long, DynamicObject> advertMaps = snaps.stream().collect(Collectors.toMap(snap -> snap.getLong("advertid_id"), snap -> snap));
        DynamicObject[] advertList = this.detailExDataHelper.getAdvertListByIds(advertMaps.keySet());
        ArrayList saveAdvList = Lists.newArrayListWithExpectedSize((int)advertList.length);
        for (DynamicObject advert : advertList) {
            String pubStatus = advert.getString("status");
            if (!HRStringUtils.equals((String)pubStatus, (String)"A") || !AdvertConfigHelper.needAuditByChannel(advert).booleanValue()) continue;
            DynamicObject advertSnap = advertMaps.get(advert.getLong("id"));
            AdvertTplExCommonHelper.advertCopySrcToDest(advert, advertSnap);
            saveAdvList.add(advert);
        }
        this.detailExDataHelper.saveAdvertDetail(saveAdvList);
    }

    private static class AdvertApprovalHelperHolder {
        private static final AdvertApprovalDataHelper INSTANCE = new AdvertApprovalDataHelper("tspr_advertbilltpl");

        private AdvertApprovalHelperHolder() {
        }
    }
}

