/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.advertising.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.advertising.service.AdvBillTplDataHelper;
import kd.tsc.tspr.business.domain.advertising.service.AdvertApprovalDataHelper;
import kd.tsc.tspr.business.domain.advertising.service.AdvertDetailExDataHelper;
import kd.tsc.tspr.business.domain.advertising.service.AdvertPermHelper;
import kd.tsc.tspr.business.domain.advertising.service.AdvertTplExCommonHelper;
import kd.tsc.tspr.business.domain.advertising.service.AdvertTplExDataHelper;
import kd.tsc.tspr.business.domain.position.service.PositionDataHelper;
import kd.tsc.tspr.common.constants.advertising.AdvertFieldConstants;
import kd.tsc.tspr.common.entity.advertising.HandlerResult;
import kd.tsc.tspr.common.enums.ChannelFieldEnum;
import kd.tsc.tspr.common.util.CommonUtils;
import kd.tsc.tsrbd.common.constants.ChannelConstants;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AdvertBizService {
    public static final String ADVERT_CONFIRM_AUDIT = "advert_confirm_audit";
    public static final String ADVERT_CONFIRM_SAVE = "advert_confirm_save";
    public static final String ADVERT_BILL_CONFIRM = "advbill_confirm";
    private static final Log logger = LogFactory.getLog(AdvertBizService.class);
    private static final String MODULE = AdvertBizService.class.getName();
    private AdvertDetailExDataHelper detailExDataHelper = AdvertDetailExDataHelper.getInstance();
    private AdvertApprovalDataHelper approvalDataHelper = AdvertApprovalDataHelper.getInstance();

    private AdvertBizService() {
    }

    public static AdvertBizService getInstance() {
        return AdvertBizServiceHolder.HELPER;
    }

    public String checkAdvPub(DynamicObject advert) {
        String posStatus;
        DynamicObject position = advert.getDynamicObject("position");
        String string = posStatus = HRObjectUtils.isEmpty((Object)position) ? null : position.getString("positionstatus");
        if ("D".equals(posStatus) || HRStringUtils.isEmpty((String)posStatus)) {
            return this.posCloseTip();
        }
        return this.checkAdvDisable(advert);
    }

    public String posCloseTip() {
        return ResManager.loadKDString((String)"\u804c\u4f4d\u5df2\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)(MODULE + "_0"), (String)"tsc-tspr-business", (Object[])new Object[0]);
    }

    public String checkAdvDisable(DynamicObject advert) {
        String errorMsg = null;
        String advertStatus = advert.getString("status");
        if (HRStringUtils.equals((String)advertStatus, (String)"D")) {
            errorMsg = ResManager.loadKDString((String)"\u5e7f\u544a\u5df2\u505c\u7528\uff0c\u8bf7\u5148\u542f\u7528\u5e7f\u544a\u3002", (String)(MODULE + "_2"), (String)"tsc-tspr-business", (Object[])new Object[0]);
        }
        return errorMsg;
    }

    public String checkAdvAuditStatus(DynamicObject advert, boolean isDirectPub) {
        long approvalId = advert.getLong("approvalid");
        if (approvalId == 0L) {
            return "";
        }
        DynamicObject approval = this.approvalDataHelper.getApprovalStatusById(approvalId);
        boolean flag = isDirectPub ? this.approvalDataHelper.canPubByAdvertId(approval) : this.approvalDataHelper.canEditByAdvertId(approval);
        if (!flag) {
            String billNo = approval.getString("billno");
            String tip = ResManager.loadKDString((String)"\u5f53\u524d\u5e7f\u544a\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u5ba1\u6279\u5355%s\uff0c\u65e0\u6cd5\u63d0\u4ea4\u65b0\u7684\u4fee\u6539\u5e7f\u544a\u7533\u8bf7", (String)(MODULE + "_1"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            return String.format(Locale.ROOT, tip, billNo);
        }
        return "";
    }

    public long editAdvertInfoByAudit(DynamicObject advert, OperationResult operationResult) {
        DynamicObject newAdvertBill = AdvBillTplDataHelper.getInstance().genAdvBillByAdvertEdit(advert);
        newAdvertBill.set("billstatus", (Object)"A");
        newAdvertBill.set("auditstatus", (Object)"B");
        try {
            AdvertTplExCommonHelper.touchOffWorkFlow(newAdvertBill);
        }
        catch (Exception e) {
            logger.error("\u5e7f\u544a\u53d1\u5e03\u53d8\u5ba1\u6279\u65f6\u8c03\u7528\u5e73\u53f0\u5de5\u4f5c\u6d41\u5931\u8d25", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5e7f\u544a\u5ba1\u6279\u8c03\u7528\u5e73\u53f0\u5de5\u4f5c\u6d41\u5931\u8d25", (String)(MODULE + "_5"), (String)"tsc-tspr-business", (Object[])new Object[0]));
        }
        this.detailExDataHelper.updateByNewAdvBill(newAdvertBill, advert.getLong("id"), "B");
        String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5df2\u6210\u529f\u63d0\u4ea4\u5ba1\u6279\uff0c\u5ba1\u6279\u5355\u7f16\u53f7\u4e3a%s", (String)(MODULE + "_4"), (String)"tsc-tspr-business", (Object[])new Object[0]), newAdvertBill.getString("billno"));
        operationResult.setMessage(message);
        operationResult.setSuccess(true);
        operationResult.setShowMessage(false);
        InteractionContext interactionContext = new InteractionContext();
        HashMap param = Maps.newHashMapWithExpectedSize((int)1);
        long billId = newAdvertBill.getLong("id");
        param.put("id", String.valueOf(billId));
        interactionContext.setCustShowParameter((Map)param);
        operationResult.setInteractionContext(interactionContext);
        return billId;
    }

    public void popConfirmForOp(String popKey, String content, String btnName, OperateOption operateOption) {
        InteractionContext interactionContext = new InteractionContext();
        interactionContext.setCustShowFormId("tspr_custconfirm");
        interactionContext.getCustShowParameter().put("btn_content", btnName);
        String title = ResManager.loadKDString((String)"\u6d41\u7a0b\u53d8\u66f4\u63d0\u9192", (String)(MODULE + "_7"), (String)"tsc-tspr-business", (Object[])new Object[0]);
        interactionContext.getCustShowParameter().put("head", title);
        interactionContext.getCustShowParameter().put("message", content);
        operateOption.setVariableValue("interactionconfirmresult", "");
        throw new KDInteractionException(popKey, interactionContext);
    }

    public void reverseSnapToAdvert(DynamicObject dataEntity, OperationResult operationResult) {
        DynamicObjectCollection approvalEntry = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject advertSnap : approvalEntry) {
            advertSnap.set("isaudit", (Object)Boolean.FALSE);
        }
        DynamicObject fetchAdvertBill = this.approvalDataHelper.loadApprovalData(dataEntity.getLong("id"));
        List<DynamicObject> newAdvert = AdvertTplExCommonHelper.updateAdvertByApproval(new DynamicObject[]{fetchAdvertBill}, true);
        operationResult.setSuccess(true);
        operationResult.setMessage(this.getDirectPublishMsg(newAdvert));
        this.approvalDataHelper.deleteById(dataEntity.getLong("id"));
        InteractionContext interactionContext = new InteractionContext();
        HashMap param = Maps.newHashMapWithExpectedSize((int)1);
        param.put("id", String.valueOf(0));
        interactionContext.setCustShowParameter((Map)param);
        operationResult.setInteractionContext(interactionContext);
    }

    public Map<Long, List<DynamicObject>> getPubAdvertByPositionId(List<Long> positionIds, String props) {
        QFilter qSuccess = new QFilter("status", "=", (Object)"S");
        QFilter qChannel = new QFilter("channel", "!=", (Object)1180);
        QFilter qReccategory = new QFilter("reccategory", "=", (Object)1020L);
        QFilter and = qSuccess.and(qChannel).and(qReccategory);
        if (CollectionUtils.isNotEmpty(positionIds)) {
            and.and(new QFilter("position", "in", positionIds));
        }
        DynamicObject[] adverts = this.detailExDataHelper.getAdvertListByFilter(and.toArray(), props);
        Map<Long, List<DynamicObject>> result = Arrays.stream(adverts).collect(Collectors.groupingBy(adv -> adv.getDynamicObject("channel").getLong("id")));
        return result;
    }

    public boolean checkPositionClose(DynamicObject advertDetail) {
        DynamicObject position = advertDetail.getDynamicObject("position");
        if (HRObjectUtils.isEmpty((Object)position)) {
            return true;
        }
        String positionStatus = position.getString("positionstatus");
        return HRStringUtils.equals((String)positionStatus, (String)"D");
    }

    public boolean checkPositionClose(Long positionId) {
        DynamicObject position = PositionDataHelper.queryOneByPositionId(positionId);
        if (HRObjectUtils.isEmpty((Object)position)) {
            return true;
        }
        String positionStatus = position.getString("positionstatus");
        return HRStringUtils.equals((String)positionStatus, (String)"D");
    }

    public void beforeSubmit2Flow(DynamicObject dataEntity, OperationResult operationResult) {
        dataEntity.set("billstatus", (Object)"B");
        this.detailExDataHelper.updateApproveStatusByApprovalIdsWhenAgain(Collections.singletonList(dataEntity.getLong("id")), "B", "A");
        operationResult.setSuccess(true);
        operationResult.setMessage(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u63d0\u4ea4\u5ba1\u6279\u3002", (String)(MODULE + "_8"), (String)"tsc-tspr-business", (Object[])new Object[0]));
    }

    public void auditAndPubAdvert(DynamicObject dataEntity, List<Long> notAuditList, OperationResult operationResult) {
        DynamicObjectCollection approvalEntry = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject advertSnap : approvalEntry) {
            long channelId = advertSnap.getDynamicObject("channel").getLong("id");
            if (notAuditList.contains(channelId)) {
                advertSnap.set("isaudit", (Object)Boolean.FALSE);
                continue;
            }
            advertSnap.set("isaudit", (Object)Boolean.TRUE);
        }
        int channelNum = approvalEntry.size();
        dataEntity.set("billstatus", (Object)"B");
        this.detailExDataHelper.updateApproveStatusByAuditSnap(approvalEntry, "B");
        DynamicObject fetchAdvertBill = this.approvalDataHelper.loadApprovalData(dataEntity.getLong("id"));
        List<DynamicObject> directAdverts = AdvertTplExCommonHelper.updateAdvertByApproval(new DynamicObject[]{fetchAdvertBill}, true);
        this.approvalDataHelper.saveByList(Collections.singletonList(fetchAdvertBill));
        operationResult.setSuccess(true);
        int directNum = 0;
        int waitNum = 0;
        for (DynamicObject advert : directAdverts) {
            Date endDate;
            Date startDate = advert.getDate("startdate");
            if (this.advIsDirectPub(startDate, endDate = advert.getDate("enddate"), new Date())) {
                ++directNum;
                continue;
            }
            ++waitNum;
        }
        String returnMsg = directNum > 0 && waitNum == 0 ? String.format(ResManager.loadKDString((String)"\u5171%d\u4e2a\u6e20\u9053\uff0c\u5e7f\u544a\u53d1\u5e03\u6210\u529f%d\u6761\uff0c\u63d0\u4ea4\u5ba1\u6279%d\u6761\u3002", (String)(MODULE + "_9"), (String)"tsc-tspr-business", (Object[])new Object[0]), channelNum, notAuditList.size(), channelNum - notAuditList.size()) : (waitNum > 0 && directNum == 0 ? String.format(ResManager.loadKDString((String)"\u5171%d\u4e2a\u6e20\u9053\uff0c\u5e7f\u544a\u4fdd\u5b58\u6210\u529f\uff0c\u5f85\u751f\u6548%d\u6761\uff0c\u63d0\u4ea4\u5ba1\u6279%d\u6761\u3002", (String)(MODULE + "_23"), (String)"tsc-tspr-business", (Object[])new Object[0]), channelNum, notAuditList.size(), channelNum - notAuditList.size()) : String.format(ResManager.loadKDString((String)"\u5171%d\u4e2a\u6e20\u9053\uff0c\u5e7f\u544a\u4fdd\u5b58\u6210\u529f\uff0c\u5f85\u751f\u6548%d\u6761\uff0c\u53d1\u5e03\u6210\u529f%d\u6761\uff0c\u63d0\u4ea4\u5ba1\u6279%d\u6761\u3002", (String)(MODULE + "_24"), (String)"tsc-tspr-business", (Object[])new Object[0]), channelNum, waitNum, directNum, channelNum - notAuditList.size()));
        operationResult.setMessage(returnMsg);
    }

    public void setAdvFullName(DynamicObject advert) {
        boolean isDisPosCode = advert.getBoolean("isdisposcode");
        OrmLocaleValue advName = (OrmLocaleValue)advert.get("name");
        if (isDisPosCode) {
            LocaleString fullName = new LocaleString();
            DynamicObject position = advert.getDynamicObject("position");
            String posNumber = position.getString("number");
            advName.forEach((key, value) -> {
                String cfr_ignored_0 = (String)fullName.put(key, (Object)(value + "\uff08" + posNumber + "\uff09"));
            });
            advert.set("fullname", (Object)fullName);
        } else {
            advert.set("fullname", (Object)advName);
        }
    }

    public void updateOnePosAdvCount(List<DynamicObject> adverts) {
        if (CollectionUtils.isEmpty(adverts)) {
            return;
        }
        long positionId = adverts.get(0).getDynamicObject("position").getLong("id");
        List<Long> positionIds = Collections.singletonList(positionId);
        Map<Long, HandlerResult> positionAdvCounts = AdvertTplExDataHelper.getInstance().countAdvert(positionIds);
        PositionDataHelper.updatePubCountByPositionId(positionAdvCounts, positionIds);
    }

    public void judgeFieldShow(IFormView formView, long channelId, OperationStatus operationStatus, boolean isDetailPage) {
        Object[] fieldsByChannels = ChannelFieldEnum.getFieldsByChannel((long)channelId);
        if (ArrayUtils.isEmpty((Object[])fieldsByChannels)) {
            this.hiddenFields(formView, ChannelFieldEnum.ALL.getFields(), null, isDetailPage);
        } else {
            this.hiddenFields(formView, (String[])fieldsByChannels, operationStatus, isDetailPage);
            this.intrecoChannelRule(formView, channelId);
        }
    }

    private void intrecoChannelRule(IFormView formView, long channelId) {
        if (channelId == ChannelConstants.INTRECO_CHANNEL_ID) {
            Long rewardRule = (Long)formView.getFormShowParameter().getCustomParam("rewardrule");
            Long detailRewardRuleId = formView.getModel().getDataEntity().getLong("rewardrule.id");
            if (!(null != rewardRule && rewardRule != 0L || null != detailRewardRuleId && detailRewardRuleId != 0L)) {
                formView.setVisible(Boolean.FALSE, new String[]{"reward", "rewardrule", "rewardpoint", "rewardruledesc"});
                formView.setVisible(Boolean.FALSE, new String[]{"rewardamountflex"});
            } else {
                formView.setEnable(Boolean.FALSE, new String[]{"rewardrule"});
            }
            formView.setVisible(Boolean.FALSE, new String[]{"isreward", "rewardcurrency"});
        }
    }

    private void hiddenFields(IFormView formView, String[] fields, OperationStatus operationStatus, boolean isDetailPage) {
        for (String field : fields) {
            formView.setVisible(Boolean.TRUE, new String[]{field});
            if (operationStatus == null) {
                if (isDetailPage && ChannelFieldEnum.isPublicForDetail((String)field)) continue;
                formView.setVisible(Boolean.FALSE, new String[]{field});
                continue;
            }
            if (operationStatus.getValue() == OperationStatus.VIEW.getValue()) {
                formView.setEnable(Boolean.FALSE, new String[]{field});
                continue;
            }
            formView.setEnable(Boolean.TRUE, new String[]{field});
            this.hasOpPerm(field, formView);
            this.hasOpPerm(field, formView);
        }
    }

    private void hasOpPerm(String field, IFormView formView) {
        if (HRStringUtils.equals((String)field, (String)"istop") || HRStringUtils.equals((String)field, (String)"isurgent")) {
            boolean hasPerm = AdvertPermHelper.getInstance().verifyHasAdvertPerm(field);
            formView.setEnable(Boolean.valueOf(hasPerm), new String[]{field});
        }
    }

    public boolean pubOrWaitByStart(DynamicObject advertEntity) {
        Date pubDate = new Date();
        Date now = CommonUtils.getBeginDate((Date)pubDate);
        Date startDate = advertEntity.getDate("startdate");
        Date endDate = advertEntity.getDate("enddate");
        String pubStatus = advertEntity.getString("status");
        boolean isDirectPub = false;
        if (null != endDate && CommonUtils.dateAfter((Date)now, (Date)endDate)) {
            advertEntity.set("status", (Object)"A");
        } else if (null == startDate || CommonUtils.equalLessDate((Date)startDate, (Date)now)) {
            advertEntity.set("pubtime", (Object)pubDate);
            advertEntity.set("refreshtime", (Object)pubDate);
            advertEntity.set("status", (Object)"S");
            isDirectPub = true;
        } else if (null != startDate && CommonUtils.dateAfter((Date)startDate, (Date)now) && HRStringUtils.equals((String)"S", (String)pubStatus)) {
            advertEntity.set("status", (Object)"A");
        }
        advertEntity.set("approvestatus", (Object)"Z");
        return isDirectPub;
    }

    public boolean advPubStatusByRangeDate(DynamicObject advertDetail, Date passDate) {
        Date endDate;
        Date startDate = advertDetail.getDate("startdate");
        boolean isDirectPub = this.advIsDirectPub(startDate, endDate = advertDetail.getDate("enddate"), passDate);
        if (isDirectPub) {
            advertDetail.set("pubtime", (Object)passDate);
            advertDetail.set("refreshtime", (Object)passDate);
        } else {
            advertDetail.set("status", (Object)"A");
        }
        return isDirectPub;
    }

    private boolean advIsDirectPub(Date startDate, Date endDate, Date passDate) {
        Date nowDate = CommonUtils.getBeginDate((Date)passDate);
        boolean isDirectPub = true;
        if (null != startDate && CommonUtils.dateAfter((Date)startDate, (Date)nowDate)) {
            isDirectPub = false;
        } else if (null != endDate && CommonUtils.dateAfter((Date)nowDate, (Date)endDate)) {
            isDirectPub = false;
        }
        return isDirectPub;
    }

    public Pair<String, List<String>> getPublishMsg(List<DynamicObject> needApprovalAdverts, List<DynamicObject> directPubList, List<DynamicObject> waitPubList, List<IOperateInfo> notConfChannels, List<IOperateInfo> errorList, boolean isEnable) {
        String channelName;
        String opName = this.getPubName();
        if (isEnable) {
            opName = this.getEnableName();
        }
        int size = needApprovalAdverts.size() + directPubList.size() + waitPubList.size() + notConfChannels.size() + errorList.size();
        ArrayList resultMsg = Lists.newArrayListWithExpectedSize((int)size);
        String title = "";
        int auditNum = needApprovalAdverts.size();
        int pubNum = directPubList.size();
        int waitPubNum = waitPubList.size();
        int noConfNum = notConfChannels.size();
        int errorNum = errorList.size();
        if (size == needApprovalAdverts.size()) {
            resultMsg.add(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u63d0\u4ea4\u5ba1\u6279\u3002", (String)(MODULE + "_10"), (String)"tsc-tspr-business", (Object[])new Object[0]));
            return Pair.of((Object)title, (Object)resultMsg);
        }
        if (size == directPubList.size()) {
            resultMsg.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5e7f\u544a%s\u6210\u529f\u3002", (String)(MODULE + "_11"), (String)"tsc-tspr-business", (Object[])new Object[0]), opName));
            return Pair.of((Object)title, (Object)resultMsg);
        }
        if (size == waitPubList.size()) {
            resultMsg.add(ResManager.loadKDString((String)"\u5e7f\u544a\u4fdd\u5b58\u6210\u529f\uff0c\u5f85\u53d1\u5e03\u3002", (String)(MODULE + "_12"), (String)"tsc-tspr-business", (Object[])new Object[0]));
            return Pair.of((Object)title, (Object)resultMsg);
        }
        if (size == notConfChannels.size()) {
            resultMsg.add(AdvertFieldConstants.notHasWorkFlow());
            return Pair.of((Object)"fail", (Object)resultMsg);
        }
        title = title + String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5171%d\u6761\u5355\u636e\uff0c", (String)(MODULE + "_3"), (String)"tsc-tspr-business", (Object[])new Object[0]), size);
        if (waitPubNum > 0) {
            title = title + String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5e7f\u544a\u4fdd\u5b58\u6210\u529f\uff0c\u5f85\u53d1\u5e03%d\u6761\uff0c", (String)(MODULE + "_13"), (String)"tsc-tspr-business", (Object[])new Object[0]), waitPubNum);
        }
        if (pubNum > 0) {
            title = title + String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u6210\u529f%d\u6761\uff0c", (String)(MODULE + "_14"), (String)"tsc-tspr-business", (Object[])new Object[0]), opName, pubNum);
        }
        if (auditNum > 0) {
            title = title + String.format(Locale.ROOT, ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6279%d\u6761\uff0c", (String)(MODULE + "_15"), (String)"tsc-tspr-business", (Object[])new Object[0]), auditNum);
        }
        if (noConfNum + errorNum > 0) {
            title = title + String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5931\u8d25%d\u6761\uff0c", (String)(MODULE + "_16"), (String)"tsc-tspr-business", (Object[])new Object[0]), noConfNum + errorNum);
        }
        if (HRStringUtils.isNotEmpty((String)title)) {
            title = title.substring(0, title.length() - 1) + "\u3002";
        }
        for (DynamicObject needApprovalAdvert : needApprovalAdverts) {
            channelName = needApprovalAdvert.getDynamicObject("channel").getString("name");
            resultMsg.add(needApprovalAdvert.get("number") + ":\"" + channelName + "\"" + ResManager.loadKDString((String)"\u6e20\u9053\u5e7f\u544a\u5df2\u6210\u529f\u63d0\u4ea4\u5ba1\u6279\u3002", (String)(MODULE + "_17"), (String)"tsc-tspr-business", (Object[])new Object[0]));
        }
        for (DynamicObject directPub : directPubList) {
            channelName = directPub.getDynamicObject("channel").getString("name");
            resultMsg.add(directPub.get("number") + ":\"" + channelName + "\"" + String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6e20\u9053\u5e7f\u544a%s\u6210\u529f\u3002", (String)(MODULE + "_18"), (String)"tsc-tspr-business", (Object[])new Object[0]), opName));
        }
        for (DynamicObject waitPub : waitPubList) {
            channelName = waitPub.getDynamicObject("channel").getString("name");
            resultMsg.add(waitPub.get("number") + ":\"" + channelName + "\"" + ResManager.loadKDString((String)"\u6e20\u9053\u5e7f\u544a\u4fdd\u5b58\u6210\u529f\uff0c\u5f85\u53d1\u5e03\u3002", (String)(MODULE + "_19"), (String)"tsc-tspr-business", (Object[])new Object[0]));
        }
        for (IOperateInfo iOperateInfo : notConfChannels) {
            resultMsg.add(iOperateInfo.getMessage());
        }
        for (IOperateInfo errInfo : errorList) {
            resultMsg.add(errInfo.getMessage());
        }
        return Pair.of((Object)title, (Object)resultMsg);
    }

    public String getDirectPublishMsg(List<DynamicObject> adverts) {
        int directNum = 0;
        int waitNum = 0;
        for (DynamicObject advert : adverts) {
            Date endDate;
            Date startDate = advert.getDate("startdate");
            if (this.advIsDirectPub(startDate, endDate = advert.getDate("enddate"), new Date())) {
                ++directNum;
                continue;
            }
            ++waitNum;
        }
        String returnMsg = directNum > 0 && waitNum == 0 ? AdvertFieldConstants.successPub() : (waitNum > 0 && directNum == 0 ? ResManager.loadKDString((String)"\u5e7f\u544a\u4fdd\u5b58\u6210\u529f\uff0c\u5f85\u751f\u6548\u3002", (String)(MODULE + "_12"), (String)"tsc-tspr-business", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u5e7f\u544a\u4fdd\u5b58\u6210\u529f\uff0c\u5f85\u751f\u6548%d\u6761\uff0c\u53d1\u5e03\u6210\u529f%d\u6761\u3002", (String)(MODULE + "_22"), (String)"tsc-tspr-business", (Object[])new Object[0]), waitNum, directNum));
        return returnMsg;
    }

    private String getPubName() {
        return ResManager.loadKDString((String)"\u53d1\u5e03", (String)(MODULE + "_20"), (String)"tsc-tspr-business", (Object[])new Object[0]);
    }

    private String getEnableName() {
        return ResManager.loadKDString((String)"\u542f\u7528", (String)(MODULE + "_21"), (String)"tsc-tspr-business", (Object[])new Object[0]);
    }

    public String checkAdvEndDate(Date endDate) {
        if (null != endDate) {
            String opName = this.getEnableName();
            Date now = CommonUtils.getBeginDate((Date)new Date());
            if (CommonUtils.dateAfter((Date)now, (Date)endDate)) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u4e0d\u5141\u8bb8%s\u3002", (String)"AdvertOpValidator_14", (String)"tsc-tspr-opplugin", (Object[])new Object[0]), opName);
            }
        }
        return "";
    }

    private static class AdvertBizServiceHolder {
        private static final AdvertBizService HELPER = new AdvertBizService();

        private AdvertBizServiceHolder() {
        }
    }
}

