/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.advertising.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.common.util.CommonUtils;
import kd.tsc.tsrbd.business.domain.config.service.BizConfigParamHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdvertConfigHelper {
    private static final String MODULE = AdvertConfigHelper.class.getName();
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertConfigHelper.class);
    private static final String CONF_PAGE_ID = "tsrbd_adconfig";
    private static final String CONF_AUDIT = "audit";
    private static final String CONF_CHANNEL = "recruchnlnm";
    private static final BizConfigParamHelper BIZ_CONFIG = new BizConfigParamHelper();

    private AdvertConfigHelper() {
    }

    public static Boolean needAuditByChannel(Long channelId) {
        String data = AdvertConfigHelper.auditConfOrigin();
        Boolean isNeedAudit = Boolean.TRUE;
        Object[] channels = new Object[]{};
        if (HRStringUtils.equals((String)data, (String)"3")) {
            isNeedAudit = Boolean.FALSE;
        } else if (HRStringUtils.equals((String)data, (String)"2")) {
            channels = (Object[])BIZ_CONFIG.get(CONF_PAGE_ID, CONF_CHANNEL);
            LOGGER.info("needAuditByChannel get part conf are {}", (Object)Arrays.toString(channels));
            if (!ArrayUtils.contains((Object[])channels, (Object)channelId)) {
                isNeedAudit = Boolean.FALSE;
            }
        }
        LOGGER.info("getAuditConf get conf is {},part channel are {}", (Object)data, (Object)Arrays.toString(channels));
        return isNeedAudit;
    }

    private static String auditConfOrigin() {
        String data = (String)BIZ_CONFIG.get(CONF_PAGE_ID, CONF_AUDIT);
        LOGGER.info("needAuditByChannel get conf is {}", (Object)data);
        if (HRStringUtils.isEmpty((String)data)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5e7f\u544a\u5ba1\u6279\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)(MODULE + "_1"), (String)"tsc-tspr-business", (Object[])new Object[0]));
        }
        return data;
    }

    public static boolean isAllAudit() {
        String data = AdvertConfigHelper.auditConfOrigin();
        return HRStringUtils.equals((String)data, (String)"1");
    }

    public static Boolean needAuditByChannel(DynamicObject advert) {
        DynamicObject channel = advert.getDynamicObject("channel");
        long channelId = 0L;
        if (!HRObjectUtils.isEmpty((Object)channel)) {
            channelId = channel.getLong("id");
        }
        return AdvertConfigHelper.needAuditByChannel(channelId);
    }

    public static Pair<Boolean, List<Long>> getAuditConf() {
        String data = (String)BIZ_CONFIG.get(CONF_PAGE_ID, CONF_AUDIT);
        if (HRStringUtils.isEmpty((String)data)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5e7f\u544a\u5ba1\u6279\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)(MODULE + "_1"), (String)"tsc-tspr-business", (Object[])new Object[0]));
        }
        Boolean isNeedAudit = Boolean.TRUE;
        Object[] channelArr = new Object[]{};
        ArrayList channels = null;
        if (HRStringUtils.equals((String)data, (String)"3")) {
            isNeedAudit = Boolean.FALSE;
        } else if (HRStringUtils.equals((String)data, (String)"2") && ArrayUtils.isNotEmpty((Object[])(channelArr = (Object[])BIZ_CONFIG.get(CONF_PAGE_ID, CONF_CHANNEL)))) {
            channels = Lists.newArrayListWithExpectedSize((int)channelArr.length);
            for (Object obj : channelArr) {
                channels.add((Long)obj);
            }
        }
        LOGGER.info("getAuditConf get conf is {},part channel are {}", (Object)data, (Object)Arrays.toString(channelArr));
        return Pair.of((Object)isNeedAudit, channels);
    }

    public static Pair<Boolean, List<Long>> getConfByChannel(List<Long> channelIds) {
        Pair<Boolean, List<Long>> auditConf = AdvertConfigHelper.getAuditConf();
        if (((Boolean)auditConf.getLeft()).booleanValue()) {
            List confAuditChannels = (List)auditConf.getRight();
            if (CollectionUtils.isNotEmpty((Collection)confAuditChannels)) {
                confAuditChannels.retainAll(channelIds);
                return Pair.of((Object)Boolean.TRUE, (Object)confAuditChannels);
            }
            return Pair.of((Object)Boolean.TRUE, channelIds);
        }
        return Pair.of((Object)Boolean.FALSE, null);
    }

    public static Boolean isHasAdvertWorkFlow() {
        String sql = "SELECT COUNT(1) AS HASFLOW FROM T_WF_PROCDEF WHERE FENTRABILL = ? and fenable='enable'";
        Boolean isHas = (Boolean)HRDBUtil.query((DBRoute)new DBRoute("wfs"), (String)sql, (Object[])new Object[]{"tssrm_advertbill"}, resultSet -> {
            boolean next = resultSet.next();
            if (next) {
                return resultSet.getInt("HASFLOW") >= 1;
            }
            return Boolean.FALSE;
        });
        return isHas;
    }

    public static Pair<Boolean, List<Long>> isAuditChannelChange(List<Long> channelIds, List<Long> notAuditChannelIds) {
        List newNotChannelIds = CommonUtils.copyList(notAuditChannelIds);
        Pair<Boolean, List<Long>> auditConf = AdvertConfigHelper.getAuditConf();
        if (((Boolean)auditConf.getLeft()).booleanValue()) {
            List right = (List)auditConf.getRight();
            if (CollectionUtils.isEmpty((Collection)right)) {
                if (CollectionUtils.isEmpty(notAuditChannelIds)) {
                    return Pair.of((Object)Boolean.FALSE, notAuditChannelIds);
                }
                return Pair.of((Object)Boolean.TRUE, notAuditChannelIds);
            }
            List copyNeedChannelIds = CommonUtils.copyList(channelIds);
            List copyNotChannelIds = CommonUtils.copyList(notAuditChannelIds);
            copyNeedChannelIds.removeAll(right);
            copyNotChannelIds.retainAll(right);
            if (CollectionUtils.isEmpty((Collection)copyNeedChannelIds) && CollectionUtils.isEmpty((Collection)copyNotChannelIds)) {
                return Pair.of((Object)Boolean.FALSE, notAuditChannelIds);
            }
            newNotChannelIds.addAll(copyNeedChannelIds);
            newNotChannelIds.removeAll(copyNotChannelIds);
            return Pair.of((Object)Boolean.TRUE, (Object)newNotChannelIds);
        }
        if (CollectionUtils.isEmpty(channelIds)) {
            return Pair.of((Object)Boolean.FALSE, notAuditChannelIds);
        }
        notAuditChannelIds.addAll(channelIds);
        return Pair.of((Object)Boolean.TRUE, notAuditChannelIds);
    }
}

