/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.advertising.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.advertising.service.AdvertBizService;
import kd.tsc.tspr.business.domain.advertising.service.AdvertConfigHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class AdvertDetailExDataHelper {
    private static final String MODULE = AdvertDetailExDataHelper.class.getName();
    private HRBaseServiceHelper ADVERT_DETAIL_HELPER = new HRBaseServiceHelper("tspr_advertdetailex");
    public static final String DETAIL_QUERY_PARAM = "id,number,isurgent,istop,status,refreshtime,stoptime,pubtime,advertpubstatus,selectpubchannel,channel,position,auditstatus,approvestatus,enable,advbillno,approvalid,vid,startdate,enddate";
    private static final String DETAIL_APPROVAL_PARAM = "id,approvalid,approvestatus,advbillno";
    private static final String CHANGE_APPROVAL_PARAM = "id,approvalid,status,approvestatus,pubtime,position,refreshtime,stoptime,startdate,enddate,modifier,channel";
    private static final String CHANGE_MODIFYUSER_PARAM = "id,approvalid,modifyuser";

    private AdvertDetailExDataHelper() {
    }

    public void updateByNewAdvBill(DynamicObject newAdvertBill, Long advertDetailId, String approveStatus) {
        DynamicObject advert = this.queryAdvertAuditDetail(advertDetailId);
        advert.set("approvalid", (Object)newAdvertBill.getLong("id"));
        advert.set("approvestatus", (Object)approveStatus);
        advert.set("advbillno", (Object)newAdvertBill.getString("billno"));
        this.saveAdvertDetail(Collections.singletonList(advert));
    }

    public void updateApproveStatusByAuditSnap(DynamicObjectCollection approvalEntry, String approveStatus) {
        ArrayList advIdList = Lists.newArrayListWithExpectedSize((int)approvalEntry.size());
        for (DynamicObject advertSnap : approvalEntry) {
            if (!advertSnap.getBoolean("isaudit")) continue;
            long advId = advertSnap.getDynamicObject("advertid").getLong("id");
            advIdList.add(advId);
        }
        QFilter qFilter = new QFilter("id", "in", (Object)advIdList);
        DynamicObject[] advertDetails = this.ADVERT_DETAIL_HELPER.query("id,approvestatus", qFilter.toArray());
        if (advertDetails == null || advertDetails.length == 0) {
            return;
        }
        Arrays.stream(advertDetails).forEach(advertDetail -> advertDetail.set("approvestatus", (Object)approveStatus));
        this.ADVERT_DETAIL_HELPER.save(advertDetails);
    }

    public static AdvertDetailExDataHelper getInstance() {
        return AdvertDetailExDataHelperHolder.HELPER;
    }

    public void saveAdvertDetail(List<DynamicObject> adverts) {
        if (CollectionUtils.isEmpty(adverts)) {
            return;
        }
        this.ADVERT_DETAIL_HELPER.save(adverts.toArray(new DynamicObject[0]));
    }

    public void saveAdvertDetail(DynamicObject[] adverts) {
        this.ADVERT_DETAIL_HELPER.save(adverts);
    }

    public DynamicObject[] queryAdvertDetail(Long[] advertIds) {
        QFilter filter = new QFilter("id", "in", (Object)advertIds);
        return this.ADVERT_DETAIL_HELPER.query(DETAIL_QUERY_PARAM, new QFilter[]{filter});
    }

    public DynamicObject queryAdvertAuditDetail(Long advertId) {
        return this.ADVERT_DETAIL_HELPER.queryOne(DETAIL_APPROVAL_PARAM, (Object)advertId);
    }

    public DynamicObject queryAdvertDetail(Long advertId) {
        return this.ADVERT_DETAIL_HELPER.queryOne((Object)advertId);
    }

    public DynamicObject generateEmptyAdvert() {
        return this.ADVERT_DETAIL_HELPER.generateEmptyDynamicObject();
    }

    public void saveAdverts(List<DynamicObject> adverts) {
        if (CollectionUtils.isEmpty(adverts)) {
            return;
        }
        this.ADVERT_DETAIL_HELPER.save(adverts.toArray(new DynamicObject[0]));
    }

    public void updateApproveStatusByApprovalId(Long billId, String approveStatus) {
        if (HRObjectUtils.isEmpty((Object)billId) || StringUtils.isEmpty((CharSequence)approveStatus)) {
            return;
        }
        DynamicObject[] advertDetails = this.ADVERT_DETAIL_HELPER.query("id,approvalid,approvestatus", new QFilter[]{new QFilter("approvalid", "=", (Object)billId)});
        if (advertDetails == null || advertDetails.length == 0) {
            return;
        }
        Arrays.stream(advertDetails).forEach(advertDetail -> advertDetail.set("approvestatus", (Object)approveStatus));
        this.ADVERT_DETAIL_HELPER.save(advertDetails);
    }

    public void updateApproveStatusByApprovalIds(List<Long> billIds, String approveStatus, String status) {
        if (CollectionUtils.isEmpty(billIds) || StringUtils.isEmpty((CharSequence)approveStatus) || StringUtils.isEmpty((CharSequence)status)) {
            return;
        }
        DynamicObject[] advertDetails = this.ADVERT_DETAIL_HELPER.query(CHANGE_APPROVAL_PARAM, this.getApprovalBillFilter(billIds));
        if (advertDetails == null || advertDetails.length == 0) {
            return;
        }
        Arrays.stream(advertDetails).forEach(advertDetail -> {
            if (AdvertBizService.getInstance().checkPositionClose((DynamicObject)advertDetail)) {
                this.updateAdvert(approveStatus, "D", (DynamicObject)advertDetail);
            } else {
                this.updateAdvert(approveStatus, status, (DynamicObject)advertDetail);
            }
        });
        this.ADVERT_DETAIL_HELPER.save(advertDetails);
    }

    public QFilter[] getApprovalBillFilter(List<Long> billIds) {
        QFilter billFilter = new QFilter("approvalid", "in", billIds);
        return new QFilter[]{billFilter};
    }

    public void updateApproveStatusByApprovalIdsWhenAgain(List<Long> billIds, String approveStatus, String status) {
        if (CollectionUtils.isEmpty(billIds) || StringUtils.isEmpty((CharSequence)approveStatus) || StringUtils.isEmpty((CharSequence)status)) {
            return;
        }
        Object[] advertDetails = this.ADVERT_DETAIL_HELPER.query(CHANGE_APPROVAL_PARAM, this.getApprovalBillFilter(billIds));
        if (advertDetails == null || advertDetails.length == 0) {
            return;
        }
        for (Object advertDetail : advertDetails) {
            String publishStatus = advertDetail.getString("status");
            if (publishStatus.equals("S")) {
                this.updateAdvert(approveStatus, "S", (DynamicObject)advertDetail);
                continue;
            }
            if (publishStatus.equals("D") && HRStringUtils.equals((String)"A", (String)status)) {
                this.updateAdvert(approveStatus, "D", (DynamicObject)advertDetail);
                continue;
            }
            if (HRStringUtils.equals((String)"K", (String)status) && AdvertBizService.getInstance().checkPositionClose((DynamicObject)advertDetail)) {
                status = "D";
            }
            this.updateAdvert(approveStatus, status, (DynamicObject)advertDetail);
        }
        if (ArrayUtils.isNotEmpty((Object[])advertDetails)) {
            this.ADVERT_DETAIL_HELPER.save((DynamicObject[])advertDetails);
        }
    }

    private void updateAdvert(String approveStatus, String status, DynamicObject advertDetail) {
        String advertApproveStatus = advertDetail.getString("approvestatus");
        boolean isRealStop = true;
        if (HRStringUtils.equals((String)"Z", (String)advertApproveStatus)) {
            if (HRStringUtils.equals((String)"B", (String)approveStatus) && AdvertConfigHelper.needAuditByChannel(advertDetail).booleanValue()) {
                isRealStop = false;
            } else {
                return;
            }
        }
        advertDetail.set("approvestatus", (Object)approveStatus);
        advertDetail.set("status", (Object)status);
        Date passDate = new Date();
        if (HRStringUtils.equals((String)status, (String)"S")) {
            AdvertBizService.getInstance().advPubStatusByRangeDate(advertDetail, passDate);
        } else if (HRStringUtils.equals((String)status, (String)"D") && isRealStop) {
            advertDetail.set("stoptime", (Object)passDate);
        }
    }

    public DynamicObject[] getAdvertListByIds(Iterable<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        return this.ADVERT_DETAIL_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject getAdvertListByIds(Long id) {
        Object[] advertListByIds = this.getAdvertListByIds(Lists.newArrayList((Object[])new Long[]{id}));
        if (HRArrayUtils.isEmpty((Object[])advertListByIds)) {
            return null;
        }
        return advertListByIds[0];
    }

    public DynamicObject[] getAdvertListByFilter(QFilter[] filters, String props) {
        if (HRStringUtils.isEmpty((String)props)) {
            return this.ADVERT_DETAIL_HELPER.loadDynamicObjectArray(filters);
        }
        return this.ADVERT_DETAIL_HELPER.query(props, filters);
    }

    public void saveAdvertModifyUser(DynamicObject approval) {
        Long billId = approval.getLong("id");
        QFilter billFilter = new QFilter("approvalid", "=", (Object)billId);
        DynamicObject[] advertDetails = this.ADVERT_DETAIL_HELPER.query(CHANGE_MODIFYUSER_PARAM, new QFilter[]{billFilter});
        Arrays.stream(advertDetails).forEach(advertDetail -> advertDetail.set("modifyuser", (Object)TSCRequestContext.getUserId()));
        this.ADVERT_DETAIL_HELPER.save(advertDetails);
    }

    public DynamicObject getAdvertById(Long id, String props) {
        if (HRStringUtils.isEmpty((String)props)) {
            return this.ADVERT_DETAIL_HELPER.loadSingle((Object)id);
        }
        return this.ADVERT_DETAIL_HELPER.queryOne(props, (Object)id);
    }

    private static class AdvertDetailExDataHelperHolder {
        private static final AdvertDetailExDataHelper HELPER = new AdvertDetailExDataHelper();

        private AdvertDetailExDataHelperHolder() {
        }
    }
}

