/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.advertising.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.common.enums.intv.AdvertPermEnum;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public final class AdvertPermHelper {
    private static Map<String, String> PERM_MAP = new HashMap<String, String>();
    public static final String MODIFY_PERM = "4715a0df000000ac";
    public static final String PUBLISH_PERM = "1CAAHEJOTG0U";
    public static final String DISABLE_PERM = "2DVE/GVD6PEF";
    public static final String ENABLE_PERM = "4730fc5d000000ac";
    public static final String EDIT_PERM = "0AQ3YJ2LET+U";
    public static final String TOP_PERM = "2//4E5KLBIP2";
    public static final String URGENT_PERM = "2//4FU09PRTP";
    public static final String QUERY_PERM = "47150e89000000ac";
    public static final String SUBMIT_PERM = "804f6478000000ac";
    public static final String UNSUBMIT_PERM = "80513207000000ac";
    public static final String DELETE_PERM = "4715e1f1000000ac";
    public static final String REFRESH_PERM = "2//6J40DHL5E";
    public static final String APPLY_MODIFY_PERM = "29AQ5CSZ63T3";

    public static AdvertPermHelper getInstance() {
        return AdvertPermHelperHolder.ADVERT_PERM_HELPER;
    }

    private AdvertPermHelper() {
    }

    public boolean verifyHasPerm(String entityId, String operateCode, long useOrgId) {
        String permCode = PERM_MAP.get(operateCode);
        if (HRStringUtils.isEmpty((String)permCode)) {
            return true;
        }
        String appId = AppMetadataCache.getAppInfo((String)"tssrm").getId();
        return PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (String)appId, (String)entityId, (String)permCode);
    }

    public boolean verifyHasAdvertPerm(String operateCode) {
        return this.verifyHasPerm("tssrm_advertpublish", operateCode, TSCRequestContext.getOrgId());
    }

    public boolean verifyHasAdvBillPerm(String operateCode) {
        return this.verifyHasPerm("tssrm_advertbill", operateCode, TSCRequestContext.getOrgId());
    }

    public String getVerifyTip(String entityName, String operateCode) {
        return String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c%s\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"AdvertPermHelper_0", (String)"tsc-tspr-business", (Object[])new Object[0]), entityName, AdvertPermEnum.getDesc((String)operateCode));
    }

    public String getVerifyTipAdvert(String operateCode) {
        return this.getVerifyTip(ResManager.loadKDString((String)"\u62db\u8058\u5e7f\u544a", (String)"AdvertPermHelper_1", (String)"tsc-tspr-business", (Object[])new Object[0]), operateCode);
    }

    public String getVerifyTipAdvertApproval(String operateCode) {
        return this.getVerifyTip(ResManager.loadKDString((String)"\u62db\u8058\u5e7f\u544a\u7533\u8bf7\u5355", (String)"AdvertPermHelper_2", (String)"tsc-tspr-business", (Object[])new Object[0]), operateCode);
    }

    static {
        PERM_MAP.put("modify", MODIFY_PERM);
        PERM_MAP.put("publish", PUBLISH_PERM);
        PERM_MAP.put("stopadvert", DISABLE_PERM);
        PERM_MAP.put("startadvert", ENABLE_PERM);
        PERM_MAP.put("edit", APPLY_MODIFY_PERM);
        PERM_MAP.put("top", TOP_PERM);
        PERM_MAP.put("istop", TOP_PERM);
        PERM_MAP.put("untop", TOP_PERM);
        PERM_MAP.put("urgent", URGENT_PERM);
        PERM_MAP.put("isurgent", URGENT_PERM);
        PERM_MAP.put("unurgent", URGENT_PERM);
        PERM_MAP.put("submit", SUBMIT_PERM);
        PERM_MAP.put("unsubmit", UNSUBMIT_PERM);
        PERM_MAP.put("advertdelete", DELETE_PERM);
        PERM_MAP.put("advertlistdelete", DELETE_PERM);
        PERM_MAP.put("refreashadvert", REFRESH_PERM);
        PERM_MAP.put("save", MODIFY_PERM);
        PERM_MAP.put("waitpubmodify", MODIFY_PERM);
        PERM_MAP.put("savewithnoaudit", PUBLISH_PERM);
    }

    private static class AdvertPermHelperHolder {
        private static final AdvertPermHelper ADVERT_PERM_HELPER = new AdvertPermHelper();

        private AdvertPermHelperHolder() {
        }
    }
}

