/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.advertising.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.advertising.service.AdvBillTplDataHelper;
import kd.tsc.tspr.business.domain.advertising.service.AdvHisChannelHelper;
import kd.tsc.tspr.business.domain.advertising.service.AdvertBizService;
import kd.tsc.tspr.business.domain.advertising.service.AdvertConfigHelper;
import kd.tsc.tspr.business.domain.advertising.service.AdvertDetailExDataHelper;
import kd.tsc.tspr.common.constants.advertising.AdvertFieldConstants;
import kd.tsc.tspr.common.enums.ChannelFieldEnum;
import kd.tsc.tspr.common.util.CommonUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AdvertTplExCommonHelper {
    private static final Log logger = LogFactory.getLog(AdvertTplExCommonHelper.class);
    private static AdvertBizService advertBizService = AdvertBizService.getInstance();

    public static Pair<String, List<String>> fastRelease(DynamicObject dataEntity) {
        advertBizService.setAdvFullName(dataEntity);
        DynamicObjectCollection channelDetails = dataEntity.getDynamicObjectCollection("entryentity");
        int channelNum = channelDetails.size();
        ArrayList adverts = Lists.newArrayListWithCapacity((int)channelNum);
        long[] ids = ID.genLongIds((int)channelNum);
        DynamicObjectCollection advertCollection = dataEntity.getDynamicObjectCollection("selectpubchannel");
        ArrayList channelIdList = Lists.newArrayListWithExpectedSize((int)channelNum);
        for (int num2 = 0; num2 < channelNum; ++num2) {
            DynamicObject emptyAdvert = AdvertTplExCommonHelper.getAdvert(dataEntity, (DynamicObject)channelDetails.get(num2), ids[num2], (DynamicObject)advertCollection.get(num2));
            adverts.add(emptyAdvert);
            channelIdList.add(emptyAdvert.getDynamicObject("channel").getLong("id"));
        }
        List numberArr = CodeRuleServiceHelper.getNumbers((String)"tssrm_advertpublish", (List)adverts);
        IntStream.range(0, adverts.size()).forEach(num -> ((DynamicObject)adverts.get(num)).set("number", numberArr.get(num)));
        Pair<List<DynamicObject>, List<DynamicObject>> approvalResult = AdvertTplExCommonHelper.getNeedApprovalAdverts(channelNum, adverts, channelIdList);
        DynamicObject posCategory = dataEntity.getDynamicObject("poscategory");
        AdvHisChannelHelper.putHisChannel(posCategory.getString("number"), channelIdList);
        return AdvertTplExCommonHelper.touchOffWorkFlowOrNot(adverts, (List)approvalResult.getLeft(), (List)approvalResult.getRight());
    }

    private static List<IOperateInfo> getAuditAdvErrors(List<DynamicObject> notHasWorkFlowList) {
        ArrayList errorInfoList = Lists.newArrayListWithExpectedSize((int)10);
        if (CollectionUtils.isEmpty(notHasWorkFlowList)) {
            return errorInfoList;
        }
        for (DynamicObject advert : notHasWorkFlowList) {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            String channelName = advert.getDynamicObject("channel").getString("name");
            errorInfo.setPkValue((Object)advert.getLong("id"));
            errorInfo.setMessage(advert.get("number") + ":\"" + channelName + "\"" + AdvertFieldConstants.notHasWorkFlow());
            errorInfoList.add(errorInfo);
        }
        return errorInfoList;
    }

    private static Pair<String, List<String>> touchOffWorkFlowOrNot(List<DynamicObject> adverts, List<DynamicObject> needApprovalAdverts, List<DynamicObject> notConfChannels) {
        ArrayList directPubList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList waitPubList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList auditAdverts = Lists.newArrayListWithExpectedSize((int)10);
        auditAdverts.addAll(needApprovalAdverts);
        auditAdverts.addAll(notConfChannels);
        List<DynamicObject> notCommentAdvert = adverts.stream().filter(notComment -> !auditAdverts.stream().map(all -> all.getDynamicObject("channel").getLong("id")).collect(Collectors.toList()).contains(notComment.getDynamicObject("channel").getLong("id"))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notCommentAdvert)) {
            for (DynamicObject advert : notCommentAdvert) {
                boolean isDirectPub = advertBizService.pubOrWaitByStart(advert);
                if (isDirectPub) {
                    directPubList.add(advert);
                    continue;
                }
                waitPubList.add(advert);
            }
            AdvertDetailExDataHelper.getInstance().saveAdverts(notCommentAdvert);
            advertBizService.updateOnePosAdvCount(notCommentAdvert);
        }
        if (!CollectionUtils.isEmpty(needApprovalAdverts)) {
            DynamicObject advbillTpl = AdvertTplExCommonHelper.generateAdvbillTpl(needApprovalAdverts);
            AdvertTplExCommonHelper.setAdverts(adverts, needApprovalAdverts, advbillTpl);
            AdvertDetailExDataHelper.getInstance().saveAdverts(needApprovalAdverts);
            AdvertTplExCommonHelper.touchOffWorkFlow(advbillTpl);
        }
        List<IOperateInfo> notConfErrors = AdvertTplExCommonHelper.getAuditAdvErrors(notConfChannels);
        Pair<String, List<String>> publishMsg = advertBizService.getPublishMsg(needApprovalAdverts, directPubList, waitPubList, notConfErrors, Collections.emptyList(), false);
        return publishMsg;
    }

    private static Pair<List<DynamicObject>, List<DynamicObject>> getNeedApprovalAdverts(int channelNum, List<DynamicObject> adverts, List<Long> channelIdList) {
        ArrayList channelNeedApprovals = Lists.newArrayListWithExpectedSize((int)channelNum);
        Pair<Boolean, List<Long>> confByChannel = AdvertConfigHelper.getConfByChannel(channelIdList);
        if (((Boolean)confByChannel.getLeft()).booleanValue()) {
            channelNeedApprovals.addAll(CollectionUtils.isEmpty((Collection)((Collection)confByChannel.getRight())) ? Collections.emptyList() : (Collection)confByChannel.getRight());
        }
        ArrayList needApprovalAdverts = Lists.newArrayListWithCapacity((int)channelNum);
        ArrayList errorAdvertList = Lists.newArrayListWithCapacity((int)channelNum);
        boolean advertWorkFlow = AdvertConfigHelper.isHasAdvertWorkFlow();
        adverts.forEach(advert -> {
            long advertChannelId = advert.getDynamicObject("channel").getLong("id");
            if (!channelNeedApprovals.isEmpty() && channelNeedApprovals.contains(advertChannelId)) {
                if (advertWorkFlow) {
                    needApprovalAdverts.add(advert);
                } else {
                    errorAdvertList.add(advert);
                }
            }
        });
        return Pair.of((Object)needApprovalAdverts, (Object)errorAdvertList);
    }

    private static void setAdverts(List<DynamicObject> adverts, List<DynamicObject> needApprovalAdverts, DynamicObject advbillTpl) {
        adverts.forEach(advert -> {
            if (needApprovalAdverts.contains(advert)) {
                advert.set("approvalid", (Object)advbillTpl.getLong("id"));
                advert.set("approvestatus", (Object)"B");
                advert.set("advbillno", (Object)advbillTpl.getString("billno"));
            } else {
                advert.set("approvalid", (Object)0L);
                advert.set("approvestatus", (Object)"");
                advert.set("advbillno", (Object)"");
                advert.set("status", (Object)"S");
            }
        });
    }

    private static DynamicObject getAdvert(DynamicObject dataEntity, DynamicObject channelObject, long id, DynamicObject channel) {
        DynamicObject emptyAdvert = AdvertDetailExDataHelper.getInstance().generateEmptyAdvert();
        HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)emptyAdvert);
        emptyAdvert.set("id", (Object)id);
        long channelId = channelObject.getLong("channelet");
        Object[] fieldsByChannel = ChannelFieldEnum.getFieldsByChannel((long)channelId);
        if (ArrayUtils.isNotEmpty((Object[])fieldsByChannel)) {
            Arrays.stream(fieldsByChannel).forEach(fieldName -> {
                String entryEntityFieldName = fieldName + "et";
                emptyAdvert.set(fieldName, channelObject.get(entryEntityFieldName));
            });
        }
        emptyAdvert.set("channel", (Object)channel.getDynamicObject("fbasedataid"));
        emptyAdvert.set("status", (Object)"A");
        emptyAdvert.set("approvestatus", (Object)"A");
        emptyAdvert.set("advertisementrd", (Object)channel.getDynamicObject("fbasedataid").getString("advertisement"));
        return emptyAdvert;
    }

    public static void activeOldAdvertBill(DynamicObject dataEntity, List<DynamicObject> advertBillList, Boolean needAuditByChannel) {
        boolean isNotAuditDisable;
        String status = dataEntity.getString("status");
        boolean bl = isNotAuditDisable = "D".equals(status) && needAuditByChannel == false;
        if ("D".equals(status) && needAuditByChannel.booleanValue()) {
            dataEntity.set("approvestatus", (Object)"B");
            dataEntity.set("enable", (Object)1);
            dataEntity.set("status", (Object)"D");
            DynamicObject advBillTpl = AdvertTplExCommonHelper.generateAdvbillTpl(Collections.singletonList(dataEntity));
            if (advBillTpl != null) {
                advertBillList.add(advBillTpl);
                dataEntity.set("advbillno", (Object)advBillTpl.getString("billno"));
                dataEntity.set("approvalid", (Object)advBillTpl.getLong("id"));
                dataEntity.set("vid", (Object)((DynamicObject)advBillTpl.getDynamicObjectCollection("entryentity").get(0)).getLong("id"));
            }
        } else if ("E".equals(status) || isNotAuditDisable) {
            dataEntity.set("status", (Object)"S");
            if (!needAuditByChannel.booleanValue()) {
                dataEntity.set("approvestatus", (Object)"Z");
            }
            advertBizService.advPubStatusByRangeDate(dataEntity, new Date());
        }
    }

    public static void touchOffWorkFlow(DynamicObject advbillTpl) {
        OperateOption options = OperateOption.create();
        options.setVariableValue("ishasright", String.valueOf(true));
        options.setVariableValue("isStrict", String.valueOf(false));
        options.setVariableValue("ignoreValidation", String.valueOf(true));
        options.setVariableValue("ignorewarn", String.valueOf(true));
        OperationServiceHelper.executeOperate((String)"submit", (String)"tssrm_advertbill", (DynamicObject[])new DynamicObject[]{advbillTpl}, (OperateOption)options);
    }

    public static void touchOffWorkFlows(List<DynamicObject> advbillTplList) {
        OperateOption options = OperateOption.create();
        options.setVariableValue("ishasright", String.valueOf(true));
        options.setVariableValue("isStrict", String.valueOf(false));
        options.setVariableValue("ignoreValidation", String.valueOf(true));
        options.setVariableValue("ignorewarn", String.valueOf(true));
        OperationServiceHelper.executeOperate((String)"submit", (String)"tssrm_advertbill", (DynamicObject[])advbillTplList.toArray(new DynamicObject[advbillTplList.size()]), (OperateOption)options);
    }

    private static DynamicObject generateAdvbillTpl(List<DynamicObject> adverts) {
        if (CollectionUtils.isEmpty(adverts)) {
            logger.error("advert is empty ,return empty data ,flow is over");
            return null;
        }
        DynamicObject firstAdvert = adverts.get(0);
        DynamicObject advertBill = AdvBillTplDataHelper.getInstance().generateEmptyAdvertBill();
        advertBill.set("id", (Object)ID.genLongId());
        String number = CodeRuleServiceHelper.getNumber((String)"tssrm_advertbill", (DynamicObject)advertBill, null);
        advertBill.set("billno", (Object)number);
        advertBill.set("billstatus", (Object)"A");
        advertBill.set("auditstatus", (Object)"B");
        String billName = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5e7f\u544a\u7533\u8bf7\u5355", (String)"AdvertTplExCommonHelper_0", (String)"tsc-tspr-business", (Object[])new Object[0]), firstAdvert.getString("name"));
        advertBill.set("name", (Object)billName);
        DynamicObjectCollection currencyColl = advertBill.getDynamicObjectCollection("adminorgs");
        DynamicObjectCollection adminOrgs = firstAdvert.getDynamicObject("position").getDynamicObjectCollection("adminorgs");
        currencyColl.clear();
        for (DynamicObject currency : adminOrgs) {
            DynamicObject newCurrency = new DynamicObject(currencyColl.getDynamicObjectType());
            newCurrency.set("fbasedataid", (Object)currency.getDynamicObject("fbasedataid"));
            currencyColl.add((Object)newCurrency);
        }
        advertBill.set("adminorgs", (Object)currencyColl);
        advertBill.set("advertbuorg", (Object)firstAdvert.getDynamicObject("position").getDynamicObject("createorg"));
        advertBill.set("position", (Object)firstAdvert.getDynamicObject("position"));
        String channelNames = adverts.stream().map(adv -> adv.getDynamicObject("channel").getString("name") + ",").collect(Collectors.joining());
        channelNames = CommonUtils.subStrBySize((String)channelNames, (int)190);
        advertBill.set("category", (Object)channelNames);
        advertBill.set("creator", (Object)TSCRequestContext.getUserId());
        DynamicObjectCollection billEntity = advertBill.getDynamicObjectCollection("entryentity");
        int index = 0;
        for (DynamicObject advert : adverts) {
            DynamicObject billEntry = billEntity.addNew();
            HRDynamicObjectUtils.copy((DynamicObject)advert, (DynamicObject)billEntry);
            billEntry.set("entityname", (Object)advert.getString("name"));
            billEntry.set("advertid", (Object)advert.getLong("id"));
            billEntry.set("seq", (Object)index);
            ++index;
        }
        return advertBill;
    }

    public static List<DynamicObject> updateAdvertByApproval(DynamicObject[] dynamicObjects, boolean isDirectPub) {
        LinkedList<DynamicObject> saveObjs = new LinkedList<DynamicObject>();
        ArrayList directPubAdvList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject advertApproval : dynamicObjects) {
            DynamicObject[] advertObjs;
            DynamicObjectCollection approvalEntry = advertApproval.getDynamicObjectCollection("entryentity");
            Map<Long, DynamicObject> approvalAdvertMap = approvalEntry.stream().collect(Collectors.toMap(approve -> approve.getLong("advertid_id"), approvalAdvert -> approvalAdvert));
            for (DynamicObject advertObj : advertObjs = AdvertDetailExDataHelper.getInstance().getAdvertListByIds(approvalAdvertMap.keySet())) {
                long advertId = advertObj.getLong("id");
                DynamicObject advertSnap = approvalAdvertMap.get(advertId);
                if (!(advertSnap.getBoolean("isaudit") ^ isDirectPub)) continue;
                AdvertTplExCommonHelper.advertCopySrcToDest(advertObj, advertSnap);
                if (isDirectPub) {
                    advertBizService.pubOrWaitByStart(advertObj);
                    approvalEntry.remove((Object)advertSnap);
                    directPubAdvList.add(advertObj);
                }
                saveObjs.add(advertObj);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)directPubAdvList)) {
            advertBizService.updateOnePosAdvCount(directPubAdvList);
        }
        AdvertDetailExDataHelper.getInstance().saveAdvertDetail(saveObjs);
        return saveObjs;
    }

    public static void advertCopySrcToDest(DynamicObject dest, DynamicObject src) {
        AdvertTplExCommonHelper.advertCopySrcToDest(dest, src, null, true);
    }

    public static void advertCopySrcToDest(DynamicObject dest, DynamicObject src, DynamicObject channelData, boolean isSetChannel) {
        block9: {
            Object[] fieldsByChannel;
            block8: {
                dest.set("fullname", src.get("fullname"));
                String srcObjName = src.getDynamicObjectType().getName();
                String destObjName = dest.getDynamicObjectType().getName();
                Object srcName = HRStringUtils.equals((String)srcObjName, (String)"entryentity") ? src.get("entityname") : src.get("name");
                if (HRStringUtils.equals((String)destObjName, (String)"entryentity")) {
                    dest.set("entityname", srcName);
                } else {
                    dest.set("name", srcName);
                }
                dest.set("isdisposcode", src.get("isdisposcode"));
                dest.set("reccategory", src.get("reccategory"));
                dest.set("recruscene", src.get("recruscene"));
                dest.set("poscategory", src.get("poscategory"));
                DynamicObjectCollection destWkAddr = dest.getDynamicObjectCollection("workaddr");
                if (CollectionUtils.isEmpty((Collection)destWkAddr)) {
                    dest.set("workaddr", (Object)src.getDynamicObjectCollection("workaddr"));
                } else {
                    List collect = src.getDynamicObjectCollection("workaddr").stream().map(wprkAddr -> wprkAddr.getLong("fbasedataid_id")).collect(Collectors.toList());
                    destWkAddr.clear();
                    for (Long workAddrId : collect) {
                        DynamicObject dynamicObject = new DynamicObject(destWkAddr.getDynamicObjectType());
                        dynamicObject.set("fbasedataid_id", (Object)workAddrId);
                        destWkAddr.add((Object)dynamicObject);
                    }
                }
                dest.set("salarytype", src.get("salarytype"));
                dest.set("currency", src.get("currency"));
                dest.set("issalarynego", src.get("issalarynego"));
                dest.set("salarydown", src.get("salarydown"));
                dest.set("salaryup", src.get("salaryup"));
                dest.set("holdofftyp", src.get("holdofftyp"));
                dest.set("workexpdown", src.get("workexpdown"));
                dest.set("workexpup", src.get("workexpup"));
                dest.set("isworkexplimit", src.get("isworkexplimit"));
                dest.set("education", src.get("education"));
                dest.set("isedulimit", src.get("isedulimit"));
                dest.set("recruitnum", src.get("recruitnum"));
                dest.set("isrecnumlimit", src.get("isrecnumlimit"));
                dest.set("recmail", src.get("recmail"));
                dest.set("posrespon", src.get("posrespon"));
                dest.set("posqual", src.get("posqual"));
                dest.set("poshighlight", src.get("poshighlight"));
                dest.set("startdate", src.get("startdate"));
                dest.set("enddate", src.get("enddate"));
                if (!isSetChannel) {
                    return;
                }
                if (channelData == null) break block8;
                long channelId = channelData.getLong("channel_id");
                for (Object fieldName : fieldsByChannel = ChannelFieldEnum.getFieldsByChannel((long)channelId)) {
                    dest.set((String)fieldName, channelData.get((String)fieldName));
                }
                break block9;
            }
            long channelId = src.getLong("channel_id");
            fieldsByChannel = ChannelFieldEnum.getFieldsByChannel((long)channelId);
            if (!ArrayUtils.isNotEmpty((Object[])fieldsByChannel)) break block9;
            for (Object fieldName : fieldsByChannel) {
                dest.set((String)fieldName, src.get((String)fieldName));
            }
        }
    }
}

