/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.advertising.service;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tspr.business.domain.position.service.PositionDataHelper;
import kd.tsc.tspr.business.domain.position.service.permission.PositionPermService;
import kd.tsc.tspr.common.entity.advertising.HandlerResult;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.common.service.HRStructureTreeOrgHelper;
import org.apache.commons.lang3.tuple.Pair;

public class AdvertTplExDataHelper {
    private static final Log LOGGER = LogFactory.getLog(AdvertTplExDataHelper.class);
    private static final HRBaseServiceHelper ADVERTTPLEXDATAHELPER = new HRBaseServiceHelper("tspr_adverttplex");
    private static final String SELECT_PROPERTIES = "id,status,refreshtime,stoptime,pubtime,advertpubstatus,channel,position,approvalid";

    private AdvertTplExDataHelper() {
    }

    public static QFilter getAdvertOrgPerm(String filterKey) {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean superUser = PermissionServiceHelper.isSuperUser((long)currUserId);
        if (superUser) {
            return null;
        }
        List<Long> allPermOrgIds = PositionPermService.getInstance(null).getPositionHasPermOrgs();
        return new QFilter(filterKey, "in", allPermOrgIds);
    }

    public static QFilter getAdvertPositionPerm(String filterKey) {
        List<Long> positionIds = PositionPermService.getInstance(null).listHavePermPosition();
        return new QFilter(filterKey, "in", positionIds);
    }

    public static boolean getAdvertOrgPerm(Long userId) {
        return PermissionServiceHelper.isSuperUser((long)userId);
    }

    public static boolean getAdvertOrgPerm() {
        return AdvertTplExDataHelper.getAdvertOrgPerm(TSCRequestContext.getUserId());
    }

    @Deprecated
    public static QFilter getOrgPerm(String filterKey) {
        HasPermOrgResult userHasPermOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)TSCRequestContext.getUserId());
        List hasPermOrgIds = userHasPermOrgIds.getHasPermOrgs();
        return new QFilter(filterKey, "in", (Object)hasPermOrgIds);
    }

    public static List<Long> getAllPermOrgIds(String entityId) {
        Pair permOrg = HRStructureTreeOrgHelper.getIntHROrgStrucViewAndUserPermOrg((String)"tssrm", (String)entityId, (String)"47150e89000000ac");
        return (List)permOrg.getValue();
    }

    public Map<Long, HandlerResult> countAdvert(List<Long> param) {
        DynamicObject[] adverts;
        HashMap result = Maps.newHashMapWithExpectedSize((int)param.size());
        QFilter qFilter = new QFilter("position", "in", param);
        qFilter.and(new QFilter("channel", "!=", (Object)1180));
        for (DynamicObject advert : adverts = ADVERTTPLEXDATAHELPER.query("id,status,position", qFilter.toArray())) {
            DynamicObject position = advert.getDynamicObject("position");
            HandlerResult handlerResult = result.getOrDefault(position.getLong("id"), new HandlerResult());
            String status = advert.getString("status");
            handlerResult.setAdvStatus(status);
            result.put(position.getLong("id"), handlerResult);
        }
        return result;
    }

    public void calculatePosAdvNum(DynamicObject[] dbDataEntities) {
        List<Long> positionIds = Arrays.stream(dbDataEntities).map(adv -> adv.getDynamicObject("position").getLong("id")).collect(Collectors.toList());
        LOGGER.info("\u66f4\u65b0\u5e7f\u544a\u6570\u91cf\u7684\u804c\u4f4did,{}", (Object)JSONArray.toJSONString(positionIds));
        Map<Long, HandlerResult> positionAdvCounts = this.countAdvert(positionIds);
        PositionDataHelper.updatePubCountByPositionId(positionAdvCounts, positionIds);
    }

    public static AdvertTplExDataHelper getInstance() {
        return AdvertTplExDataHelperHolder.ADVERT_TPL_EX_DATA_HELPER;
    }

    public DynamicObject generateEmptyAdvert() {
        return ADVERTTPLEXDATAHELPER.generateEmptyDynamicObject();
    }

    public DynamicObject queryAdvert(Long advertId) {
        if (HRObjectUtils.isEmpty((Object)advertId)) {
            return this.generateEmptyAdvert();
        }
        return ADVERTTPLEXDATAHELPER.queryOne(SELECT_PROPERTIES, new QFilter("id", "=", (Object)advertId));
    }

    public DynamicObject[] getListDataFilterColumn(QFilter[] qFilters) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tspr_adverttplex");
        return helper.queryOriginalArray("id, position.id as posid, position.name as posname, channel.id as channelid, channel.name as channelname", qFilters);
    }

    public QFilter allAdvertFilter() {
        QFilter recruitTypeQFilter = this.recruitTypeQFilter();
        QFilter channelType = new QFilter("channel.resacqmthd.id", "not in", (Object)Lists.newArrayList((Object[])new Long[]{1050L, 1060L, 1080L}));
        return recruitTypeQFilter.and(channelType);
    }

    public QFilter pushAdvertFilter() {
        QFilter recruitTypeQFilter = this.recruitTypeQFilter();
        QFilter channelType = new QFilter("channel.resacqmthd.id", "in", (Object)Lists.newArrayList((Object[])new Long[]{1030L}));
        return recruitTypeQFilter.and(channelType);
    }

    private QFilter recruitTypeQFilter() {
        return new QFilter("reccategory.id", "=", (Object)1020L);
    }

    public QFilter dataPermQFilter() {
        List<Long> hashPermPositionIds = PositionPermService.getInstance(null).listHavePermPosition();
        return new QFilter("position.id", "in", hashPermPositionIds);
    }

    private static class AdvertTplExDataHelperHolder {
        private static final AdvertTplExDataHelper ADVERT_TPL_EX_DATA_HELPER = new AdvertTplExDataHelper();

        private AdvertTplExDataHelperHolder() {
        }
    }
}

