/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.advertising.service.valid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.fieldtip.DeleteRule;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.common.util.CommonUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CommonValidate {
    protected DynamicObject dyo;
    protected StringBuilder validResult = new StringBuilder();
    private static final String MODULE = CommonValidate.class.getName();

    public CommonValidate(DynamicObject commonDO) {
        this.dyo = commonDO;
    }

    public CommonValidate validateCommonInput(IFormView childView, IFormView parentView) {
        StringBuilder noticeMsg = new StringBuilder();
        ArrayList<FieldTip> fieldTipList = new ArrayList<FieldTip>();
        this.checkBaseData(fieldTipList, noticeMsg);
        this.checkRangeData(fieldTipList, noticeMsg);
        this.checkDateField(fieldTipList, noticeMsg);
        this.validResult = this.validResult.append((CharSequence)noticeMsg);
        this.showFieldTips(childView, parentView, fieldTipList);
        return this;
    }

    private void checkDateField(List<FieldTip> fieldTipList, StringBuilder noticeMsg) {
        String endDateMsg;
        String rangeMsg = this.validRangeTime(this.dyo, null);
        if (HRStringUtils.isNotEmpty((String)rangeMsg)) {
            noticeMsg.append("\"").append(rangeMsg).append("\"").append("\u3001");
            FieldTip upFieldTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "enddate", null);
            upFieldTip.setSuccess(true);
            fieldTipList.add(upFieldTip);
            fieldTipList.add(this.getFieldTipByProp("startdate", rangeMsg));
        }
        if (HRStringUtils.isNotEmpty((String)(endDateMsg = this.validEndDate(this.dyo, null)))) {
            noticeMsg.append("\"").append(endDateMsg).append("\"").append("\u3001");
            FieldTip upFieldTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "enddate", null);
            upFieldTip.setSuccess(true);
            fieldTipList.add(upFieldTip);
            fieldTipList.add(this.getFieldTipByProp("enddate", endDateMsg));
        }
    }

    private void checkRangeData(List<FieldTip> fieldTipList, StringBuilder noticeMsg) {
        String eduMsg;
        DynamicObject currency;
        DynamicObject salaryType;
        Pair<String, String> salaryMsg;
        String recNumMsg;
        String workExp2;
        String workExpMsg = CommonValidate.validateWorkExp(this.dyo);
        if (HRStringUtils.isNotEmpty((String)workExpMsg)) {
            noticeMsg.append("\"").append(workExpMsg).append("\"").append("\u3001");
            FieldTip upFieldTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "workexpup", null);
            upFieldTip.setSuccess(true);
            fieldTipList.add(upFieldTip);
            fieldTipList.add(this.getFieldTipByProp("workexpdown", workExpMsg));
        }
        if (HRStringUtils.isNotEmpty((String)(workExp2 = CommonValidate.validateWorkExp2(this.dyo)))) {
            String msg = ResManager.loadKDString((String)"\u5de5\u4f5c\u5e74\u9650", (String)(MODULE + "_13"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            noticeMsg.append("\"").append(msg).append("\"").append("\u3001");
            FieldTip upFieldTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "workexpup", null);
            upFieldTip.setSuccess(true);
            fieldTipList.add(upFieldTip);
            fieldTipList.add(this.getFieldTipByProp("workexpdown", CommonValidate.getValueNull()));
        }
        if (HRStringUtils.isNotEmpty((String)(recNumMsg = CommonValidate.validateRecNum(this.dyo)))) {
            noticeMsg.append("\"").append(recNumMsg).append("\"").append("\u3001");
            fieldTipList.add(this.getFieldTipByProp("recruitnum", CommonValidate.getValue0()));
        }
        if (null != (salaryMsg = CommonValidate.validateSalary(this.dyo))) {
            noticeMsg.append("\"").append((String)salaryMsg.getLeft()).append("\"").append("\u3001");
            FieldTip upFieldTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "salaryup", null);
            upFieldTip.setSuccess(true);
            fieldTipList.add(upFieldTip);
            fieldTipList.add(this.getFieldTipByProp("salarydown", (String)salaryMsg.getRight()));
        }
        if (!HRObjectUtils.isEmpty((Object)(salaryType = this.dyo.getDynamicObject("salarytype"))) && HRObjectUtils.isEmpty((Object)(currency = this.dyo.getDynamicObject("currency")))) {
            String msg = ResManager.loadKDString((String)"\u4ed8\u85aa\u5e01\u522b", (String)(MODULE + "_10"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            noticeMsg.append("\"").append(msg).append("\"").append("\u3001");
            fieldTipList.add(this.getFieldTipByProp("currency"));
        }
        if (HRStringUtils.isNotEmpty((String)(eduMsg = CommonValidate.validateEdu(this.dyo)))) {
            noticeMsg.append("\"").append(eduMsg).append("\"").append("\u3001");
            fieldTipList.add(this.getFieldTipByProp("education"));
        }
    }

    private void checkBaseData(List<FieldTip> fieldTipList, StringBuilder noticeMsg) {
        String msg;
        DynamicObjectCollection workAddrs;
        String msg2;
        if (HRObjectUtils.isEmpty((Object)this.dyo.getLocaleString("name"))) {
            msg2 = ResManager.loadKDString((String)"\u5e7f\u544a\u540d\u79f0", (String)(MODULE + "_1"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            noticeMsg.append("\"").append(msg2).append("\"").append("\u3001");
            fieldTipList.add(this.getFieldTipByProp("name"));
        }
        if (HRObjectUtils.isEmpty((Object)this.dyo.get("recruscene"))) {
            msg2 = ResManager.loadKDString((String)"\u62db\u8058\u573a\u666f", (String)(MODULE + "_2"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            noticeMsg.append("\"").append(msg2).append("\"").append("\u3001");
            fieldTipList.add(this.getFieldTipByProp("recruscene"));
        }
        if (HRObjectUtils.isEmpty((Object)this.dyo.get("poscategory"))) {
            msg2 = ResManager.loadKDString((String)"\u62db\u8058\u804c\u4f4d\u7c7b\u522b", (String)(MODULE + "_3"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            noticeMsg.append("\"").append(msg2).append("\"").append("\u3001");
            fieldTipList.add(this.getFieldTipByProp("poscategory"));
        }
        if (CollectionUtils.isEmpty((Collection)(workAddrs = this.dyo.getDynamicObjectCollection("workaddr")))) {
            msg = ResManager.loadKDString((String)"\u5de5\u4f5c\u5730\u70b9", (String)(MODULE + "_4"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            noticeMsg.append("\"").append(msg).append("\"").append("\u3001");
            fieldTipList.add(this.getFieldTipByProp("workaddr"));
        }
        if (HRObjectUtils.isEmpty((Object)this.dyo.get("posrespon"))) {
            msg = ResManager.loadKDString((String)"\u5de5\u4f5c\u804c\u8d23", (String)(MODULE + "_5"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            noticeMsg.append("\"").append(msg).append("\"").append("\u3001");
            fieldTipList.add(this.getFieldTipByProp("posrespon"));
        }
        if (HRObjectUtils.isEmpty((Object)this.dyo.get("posqual"))) {
            msg = ResManager.loadKDString((String)"\u4efb\u804c\u8981\u6c42", (String)(MODULE + "_6"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            noticeMsg.append("\"").append(msg).append("\"").append("\u3001");
            fieldTipList.add(this.getFieldTipByProp("posqual"));
        }
    }

    protected String validEndDate(DynamicObject dynObj, String channelName) {
        Date end = dynObj.getDate("enddate");
        if (null != end && CommonUtils.dateAfter((Date)CommonUtils.getBeginDate((Date)new Date()), (Date)end)) {
            String msg = ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u9700\u665a\u4e8e\u5f53\u524d\u65e5\u671f", (String)(MODULE + "_14"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            if (HRStringUtils.isNotEmpty((String)channelName)) {
                msg = channelName + ":" + msg;
            }
            return msg;
        }
        return null;
    }

    protected String validRangeTime(DynamicObject dynObj, String channelName) {
        Date start = dynObj.getDate("startdate");
        Date end = dynObj.getDate("enddate");
        if (start != null && null != end && CommonUtils.dateAfter((Date)start, (Date)end)) {
            String msg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u9700\u65e9\u4e8e\u622a\u6b62\u65e5\u671f", (String)(MODULE + "_14"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            if (HRStringUtils.isNotEmpty((String)channelName)) {
                msg = channelName + ":" + msg;
            }
            return msg;
        }
        return null;
    }

    protected void showFieldTips(IFormView childView, IFormView parentView, List<FieldTip> fieldTipList) {
        if (childView != null && parentView != null) {
            if (CollectionUtils.isNotEmpty(fieldTipList)) {
                childView.showFieldTips(fieldTipList);
                parentView.sendFormAction(childView);
            }
        } else if (childView != null && parentView == null) {
            childView.showFieldTips(fieldTipList);
        } else if (childView == null && null != parentView) {
            parentView.showFieldTips(fieldTipList);
        }
    }

    public static String validateEdu(DynamicObject dyo) {
        Object edu = dyo.get("education");
        Boolean isEduLimit = dyo.getBoolean("isedulimit");
        if (!isEduLimit.booleanValue() && HRObjectUtils.isEmpty((Object)edu)) {
            String msg = ResManager.loadKDString((String)"\u6700\u4f4e\u5b66\u5386", (String)(MODULE + "_9"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            return msg;
        }
        return null;
    }

    public static Pair<String, String> validateSalary(DynamicObject dyo) {
        Long salaryDown = dyo.getLong("salarydown");
        Long salaryUp = dyo.getLong("salaryup");
        boolean isSalaryNego = dyo.getBoolean("issalarynego");
        if (!isSalaryNego && salaryDown == 0L && salaryUp == 0L) {
            String msg = ResManager.loadKDString((String)"\u85aa\u8d44\u8303\u56f4", (String)(MODULE + "_12"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            return Pair.of((Object)msg, (Object)CommonValidate.getValueNull());
        }
        if (!isSalaryNego && salaryDown >= salaryUp && salaryUp != 0L) {
            String msg = ResManager.loadKDString((String)"\u85aa\u8d44\u4e0b\u9650\u5fc5\u987b\u5c0f\u4e8e\u85aa\u8d44\u4e0a\u9650", (String)(MODULE + "_8"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            return Pair.of((Object)msg, (Object)msg);
        }
        return null;
    }

    public static String validateRecNum(DynamicObject dyo) {
        boolean isRecnumLimit = dyo.getBoolean("isrecnumlimit");
        int recruitNum = dyo.getInt("recruitnum");
        if (!isRecnumLimit && recruitNum <= 0) {
            String msg = ResManager.loadKDString((String)"\u62db\u8058\u4eba\u6570", (String)(MODULE + "_7"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            return msg;
        }
        return null;
    }

    public static String validateWorkExp(DynamicObject dyo) {
        boolean isWorkExpLimit = dyo.getBoolean("isworkexplimit");
        int workExpDown = dyo.getInt("workexpdown");
        int workExpUp = dyo.getInt("workexpup");
        if (!isWorkExpLimit && workExpDown >= workExpUp && workExpUp != 0) {
            String msg = ResManager.loadKDString((String)"\u5de5\u4f5c\u5e74\u9650\u4e0b\u9650\u5fc5\u987b\u5c0f\u4e8e\u5de5\u4f5c\u5e74\u9650\u4e0a\u9650", (String)(MODULE + "_8"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            return msg;
        }
        return null;
    }

    public static String validateWorkExp2(DynamicObject dyo) {
        boolean isWorkExpLimit = dyo.getBoolean("isworkexplimit");
        int workExpDown = dyo.getInt("workexpdown");
        int workExpUp = dyo.getInt("workexpup");
        if (!isWorkExpLimit && workExpDown == 0 && workExpUp == 0) {
            return CommonValidate.getValueNull();
        }
        return null;
    }

    public CommonValidate validateCommonInput() {
        return this.validateCommonInput(null, null);
    }

    public CommonValidate validateCommonInput(IFormView formView) {
        return this.validateCommonInput(formView, null);
    }

    public StringBuilder wrapperNotice() {
        if (this.validResult.length() > 0) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199 ", (String)(MODULE + "_11"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            this.validResult = new StringBuilder(msg).append((CharSequence)this.validResult);
        }
        return this.validResult;
    }

    public StringBuilder getValidResult() {
        return this.validResult;
    }

    protected FieldTip getFieldTipByProp(String propName) {
        return this.getFieldTipByProp(propName, CommonValidate.getValueNull());
    }

    protected FieldTip getFieldTipByProp(String propName, String msg) {
        FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, propName, msg);
        DeleteRule deleteRule = new DeleteRule();
        deleteRule.setAction("isChange");
        deleteRule.setFields(Collections.singletonList(propName));
        tip.setDeleteRule(deleteRule);
        return tip;
    }

    public static String getValue0() {
        return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u6574\u6570", (String)(MODULE + "_0"), (String)"tsc-tspr-business", (Object[])new Object[0]);
    }

    public static String getValueNull() {
        return ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)(MODULE + "_NULL"), (String)"tsc-tspr-business", (Object[])new Object[0]);
    }
}

