/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.advertising.service.valid;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.fieldtip.DeleteRule;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tspr.business.domain.advertising.service.valid.CommonValidate;
import kd.tsc.tspr.common.util.CommonUtils;

public class FieldValidHelper {
    private static final String MODULE = FieldValidHelper.class.getName();
    private IFormView formView;
    private IDataModel dataModel;

    public FieldValidHelper(IFormView formView) {
        this.formView = formView;
        this.dataModel = formView.getModel();
    }

    public void validField(String field) {
        FieldTip fieldTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, field, null);
        fieldTip.setSuccess(true);
        this.formView.showFieldTip(fieldTip);
        DeleteRule deleteRule = new DeleteRule();
        deleteRule.setAction("isChange");
        deleteRule.setFields(Collections.singletonList(field));
        DynamicObject dyo = this.dataModel.getDataEntity();
        Object fieldValue = dyo.get(field);
        if (HRObjectUtils.isEmpty((Object)fieldValue)) {
            FieldTip newTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, field, CommonValidate.getValueNull());
            newTip.setDeleteRule(deleteRule);
            this.formView.showFieldTip(newTip);
        }
    }

    public void validFieldNumber(String field) {
        DynamicObject dyo = this.dataModel.getDataEntity();
        Integer fieldValue = dyo.getInt(field);
        if (fieldValue <= 0) {
            FieldTip fieldTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, field, null);
            fieldTip.setSuccess(true);
            this.formView.showFieldTip(fieldTip);
            DeleteRule deleteRule = new DeleteRule();
            deleteRule.setAction("isChange");
            deleteRule.setFields(Collections.singletonList(field));
            FieldTip newTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, field, CommonValidate.getValue0());
            newTip.setDeleteRule(deleteRule);
            this.formView.showFieldTip(newTip);
        }
    }

    public void validRangeField(String rangeUpField, String rangeDownField, String propertyName, String recourseId, String description) {
        DynamicObject positionDynObj = this.dataModel.getDataEntity();
        long rangeUp = positionDynObj.getLong(rangeUpField);
        long rangeDown = positionDynObj.getLong(rangeDownField);
        if (rangeDown >= rangeUp && rangeUp != 0L) {
            DeleteRule deleteRule = this.clearRangeTip(rangeUpField, rangeDownField);
            FieldTip salaryRangeTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, propertyName, ResManager.loadKDString((String)description, (String)recourseId, (String)"tsc-tspr-business", (Object[])new Object[0]));
            salaryRangeTip.setDeleteRule(deleteRule);
            this.formView.showFieldTip(salaryRangeTip);
        }
    }

    public boolean validRangeDate(String startField, String endField, boolean tipIsStart, String recourseId, String description) {
        DynamicObject dynObj = this.dataModel.getDataEntity();
        Date start = dynObj.getDate(startField);
        Date end = dynObj.getDate(endField);
        FieldTip rangeTip = null;
        boolean pass = true;
        String targetField = tipIsStart ? startField : endField;
        if (start != null && end != null && CommonUtils.dateAfter((Date)start, (Date)end)) {
            rangeTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, targetField, ResManager.loadKDString((String)description, (String)recourseId, (String)"tsc-tspr-business", (Object[])new Object[0]));
            pass = false;
        }
        if (null != rangeTip) {
            DeleteRule deleteRule = this.clearRangeTip(startField, endField);
            rangeTip.setDeleteRule(deleteRule);
            this.formView.showFieldTip(rangeTip);
        }
        return pass;
    }

    private DeleteRule clearRangeTip(String rangeUpField, String rangeDownField) {
        FieldTip upFieldTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, rangeUpField, null);
        FieldTip downFieldTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, rangeDownField, null);
        upFieldTip.setSuccess(true);
        downFieldTip.setSuccess(true);
        this.formView.showFieldTip(upFieldTip);
        this.formView.showFieldTip(downFieldTip);
        DeleteRule deleteRule = new DeleteRule();
        deleteRule.setAction("isChange");
        deleteRule.setFields(Arrays.asList(rangeUpField, rangeDownField));
        return deleteRule;
    }

    public String getRecruitNumShowText() {
        DynamicObject dataEntity = this.dataModel.getDataEntity(true);
        Boolean isRecnumLimit = dataEntity.getBoolean("isrecnumlimit");
        if (isRecnumLimit.booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u82e5\u5e72", (String)(MODULE + "_0"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            return msg;
        }
        Integer recruitNum = dataEntity.getInt("recruitnum");
        return String.valueOf(recruitNum);
    }

    public String getEducationShowText() {
        DynamicObject dataEntity = this.dataModel.getDataEntity(true);
        Boolean isEduLimit = dataEntity.getBoolean("isedulimit");
        if (isEduLimit.booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u4e0d\u9650", (String)(MODULE + "_1"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            return msg;
        }
        DynamicObject education = dataEntity.getDynamicObject("education");
        String eduName = education.getString("name");
        return eduName;
    }

    public String getWorkexpShowText() {
        DynamicObject dataEntity = this.dataModel.getDataEntity(true);
        Integer workexpDown = dataEntity.getInt("workexpdown");
        Integer workexpUp = dataEntity.getInt("workexpup");
        Boolean isWorkexpLimit = dataEntity.getBoolean("isworkexplimit");
        String result = "";
        if (isWorkexpLimit.booleanValue()) {
            String msg;
            result = msg = ResManager.loadKDString((String)"\u4e0d\u9650", (String)(MODULE + "_2"), (String)"tsc-tspr-business", (Object[])new Object[0]);
        } else if (workexpDown > 0 && workexpUp == 0) {
            String msg = ResManager.loadKDString((String)"\u5e74\u4ee5\u4e0a", (String)(MODULE + "_3"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            result = workexpDown + msg;
        } else if (workexpUp > 0 && workexpDown == 0) {
            String msg = ResManager.loadKDString((String)"\u5e74\u4ee5\u4e0b", (String)(MODULE + "_4"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            result = workexpUp + msg;
        }
        return result;
    }

    public String getSalaryShowText() {
        DynamicObject dataEntity = this.dataModel.getDataEntity(true);
        Long salaryDown = dataEntity.getLong("salarydown");
        Long salaryUp = dataEntity.getLong("salaryup");
        Boolean isSalaryNego = dataEntity.getBoolean("issalarynego");
        String result = "";
        if (isSalaryNego.booleanValue()) {
            String msg;
            result = msg = ResManager.loadKDString((String)"\u9762\u8bae", (String)(MODULE + "_5"), (String)"tsc-tspr-business", (Object[])new Object[0]);
        } else if (salaryDown > 0L && salaryUp == 0L) {
            String msg = ResManager.loadKDString((String)"\u4ee5\u4e0a", (String)(MODULE + "_6"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            result = salaryDown + msg;
        } else if (salaryDown == 0L && salaryUp > 0L) {
            String msg = ResManager.loadKDString((String)"\u4ee5\u4e0b", (String)(MODULE + "_7"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            result = salaryUp + msg;
        }
        return result;
    }
}

