/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileStatusHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileFilterHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileOfferHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileStdRsmHelper;
import kd.tsc.tspr.business.domain.hcf.SyncHcfHelper;
import kd.tsc.tspr.common.constants.api.QueryObject;
import kd.tsc.tsrbd.common.enums.TSRBDPreDataEnum;
import kd.tsc.tsrbs.business.domain.rsm.common.RsmCommonService;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;

public class AppFileDataHelper {
    private static final Log logger = LogFactory.getLog(AppFileDataHelper.class);

    private AppFileDataHelper() {
    }

    public static DynamicObject queryAppFileById(Object appFileId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tspr_appfile");
        return helper.queryOne(appFileId);
    }

    public static int queryOtherAppCount(Long mid, Long appFileId) {
        return AppFileStdRsmHelper.queryOtherAppCount(mid, appFileId);
    }

    public static boolean verifyPermOrgResult(HasPermOrgResult orgResult) {
        boolean verifyPerm = false;
        if (orgResult == null) {
            return false;
        }
        verifyPerm = orgResult.hasAllOrgPerm() ? true : orgResult.getHasPermOrgs() != null && !orgResult.getHasPermOrgs().isEmpty();
        return verifyPerm;
    }

    public static void updateAppFileFilterFeedBackData(List<Long> appFileIdList) {
        AppFileFilterHelper.updateAppFileFilterFeedBackData(appFileIdList);
    }

    public static List<Map<String, Object>> offerInit(DynamicObject[] dataEntities) {
        ArrayList offerCreateReqVos = Lists.newArrayList();
        for (DynamicObject dataEntity : dataEntities) {
            if (!AppFileOfferHelper.validateOfferStatus(dataEntity)) continue;
            HashMap offerCreateReqVo = Maps.newHashMap();
            offerCreateReqVo.put("appFileId", dataEntity.getLong("id"));
            offerCreateReqVo.put("busunitId", dataEntity.getLong("createorg.id"));
            offerCreateReqVo.put("busunitName", dataEntity.getString("createorg.name"));
            offerCreateReqVo.put("phone", dataEntity.getString("phone"));
            offerCreateReqVo.put("email", dataEntity.getString("email"));
            offerCreateReqVo.put("age", dataEntity.getInt("appres.age"));
            offerCreateReqVo.put("gender", dataEntity.getLong("appres.gender.id"));
            offerCreateReqVo.put("nationality", dataEntity.getString("appres.natreg.name"));
            offerCreateReqVo.put("nationalityId", dataEntity.getLong("appres.natreg.id"));
            offerCreateReqVo.put("userName", dataEntity.getString("name"));
            offerCreateReqVo.put("workage", dataEntity.getInt("appres.workingyears"));
            offerCreateReqVos.add(offerCreateReqVo);
        }
        Object obj = DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tso", (String)"socialOfferServiceApi", (String)"createOfferBatch", (Object[])new Object[]{SerializationUtils.toJsonString((Object)offerCreateReqVos)});
        if (obj != null && HRStringUtils.isNotEmpty((String)obj.toString())) {
            ArrayList returnData = (ArrayList)SerializationUtils.fromJsonString((String)obj.toString(), ArrayList.class);
            AppFileDataHelper.updateOfferStatus(returnData);
            return returnData;
        }
        return Lists.newArrayList();
    }

    public static void updateOfferStatus(List<Map<String, Object>> appFileIdOfferStatusList) {
        logger.info("updateOfferStatus.appFileList.data:{}", appFileIdOfferStatusList);
        ArrayList appFileIdList = Lists.newArrayListWithCapacity((int)appFileIdOfferStatusList.size());
        ArrayList offerStatusList = Lists.newArrayListWithCapacity((int)appFileIdOfferStatusList.size());
        ArrayList inductionStatusList = Lists.newArrayListWithCapacity((int)appFileIdOfferStatusList.size());
        ArrayList isDisCardList = Lists.newArrayListWithCapacity((int)appFileIdOfferStatusList.size());
        for (Map<String, Object> data : appFileIdOfferStatusList) {
            Object appFileId = data.get("appFileId");
            if (appFileId == null) continue;
            appFileIdList.add(Long.parseLong(appFileId.toString()));
            offerStatusList.add(data.get("offerStatus"));
            inductionStatusList.add(data.get("inductionStatus"));
            isDisCardList.add(data.get("appfileInProcess"));
        }
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject[] appFiles = AppFileHelper.queryAppFiles(appFileIdList, TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"offerstatus", "laborrelstatus", "filestatus", "emptime", "number", "stdrsm.id"}));
                HashMap idDyMaps = Maps.newHashMapWithExpectedSize((int)appFiles.length);
                for (DynamicObject appFile : appFiles) {
                    idDyMaps.put(appFile.getLong("id"), appFile);
                }
                ArrayList revertAppFiles = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
                for (int i = 0; i < appFileIdList.size(); ++i) {
                    DynamicObject appFile = (DynamicObject)idDyMaps.get(appFileIdList.get(i));
                    if (offerStatusList.get(i) != null) {
                        appFile.set("offerstatus", offerStatusList.get(i));
                    }
                    if (!"true".equals(isDisCardList.get(i)) || !AppFileHelper.isToBeEmployed(appFile)) continue;
                    revertAppFiles.add(appFile);
                }
                AppFileStatusHelper.revertInProcess(revertAppFiles);
                AppFileStatusHelper.setInductionStatus(appFileIdList, idDyMaps, inductionStatusList);
                AppFileHelper.update(appFiles);
            }
            catch (Exception ex) {
                tx.markRollback();
                logger.error("updateOfferStatus.error", (Throwable)ex);
                throw ex;
            }
        }
        AppFileDataHelper.syncDataToCandidate(appFileIdList, offerStatusList);
    }

    public static void addRsmToCandidate(Long appfileId) {
        long rsmId;
        DynamicObject appFile = AppFileHelper.queryOne(appfileId, "appres.id, number, name");
        Map<String, Object> candidateSyncMap = AppFileDataHelper.generateCandidateSyncVO(appFile, rsmId = appFile.getLong("appres.id"));
        if (candidateSyncMap == null) {
            return;
        }
        HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"saveOrUpdateCandidate", (Object[])new Object[]{candidateSyncMap});
    }

    public static void syncDataToCandidate(List<Long> appFileIdList, List<Object> offerStatusList) {
        DynamicObject[] appFiles = AppFileHelper.queryAppFiles(appFileIdList, "appres.id, number, name,tpsys,arfrsm");
        for (int i = 0; i < appFileIdList.size(); ++i) {
            DynamicObject appFile;
            if (!String.valueOf(TSRBDPreDataEnum.OFFER_STATUS_ACCEPTED.getId()).equals(String.valueOf(offerStatusList.get(i))) || (appFile = appFiles[i]).getString("tpsys") == null || !"MK".equals(appFile.getString("tpsys"))) continue;
            SyncHcfHelper.updateArfToCandidate(appFileIdList.get(i), true);
        }
    }

    private static Map<String, Object> generateCandidateSyncVO(DynamicObject appFile, Long rsmId) {
        AppResumeBo appResumeBo = RsmCommonService.getAppResumeBo((Long)rsmId);
        logger.info("generateCandidateSyncVO appResumeBo is {}", (Object)appResumeBo);
        if (appResumeBo == null) {
            return null;
        }
        RsmCommonService.loadSRAllListData((AppResumeBo)appResumeBo);
        DynamicObjectCollection dynColl = new DynamicObjectCollection();
        dynColl.add((Object)appResumeBo.getRsm());
        Map dyoCollMap = appResumeBo.getDyoCollMap();
        List collect = dyoCollMap.values().stream().collect(Collectors.toList());
        collect.add(dynColl);
        Long appFileId = appFile.getLong("id");
        String number = appFile.getString("number");
        String name = appFile.getString("name");
        HashMap<String, Object> candidateSyncMap = new HashMap<String, Object>(16);
        candidateSyncMap.put("apply", "rsm");
        candidateSyncMap.put("name", name);
        candidateSyncMap.put("number", number);
        candidateSyncMap.put("billNo", number);
        candidateSyncMap.put("dynCollList", collect);
        candidateSyncMap.put("appFileId", appFileId);
        logger.info("generateCandidateSyncVO candidateSyncVo is {}", candidateSyncMap);
        return candidateSyncMap;
    }

    private static void addRecNumbers(List<Long> appFileIdList, List<Object> offerStatusList) {
        try {
            DynamicObject[] appFiles = AppFileHelper.queryAppFiles(appFileIdList, "position.id");
            ArrayList positionIdList = Lists.newArrayList();
            for (int i = 0; i < appFileIdList.size(); ++i) {
                if (!String.valueOf(TSRBDPreDataEnum.OFFER_STATUS_ACCEPTED.getId()).equals(String.valueOf(offerStatusList.get(i)))) continue;
                positionIdList.add(appFiles[i].getLong("position.id"));
            }
            logger.info("updateOfferStatus.addRecNumbers.positionIdList:{}", (Object)positionIdList);
            if (!positionIdList.isEmpty()) {
                DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tsrpm", (String)"recReqServiceApi", (String)"addRecNumbers", (Object[])new Object[]{positionIdList});
            }
        }
        catch (Exception ex) {
            logger.error("updateOfferStatus.addRecNumbers.error", (Throwable)ex);
        }
    }

    public static void updateAppFileLastFilterFKStartTime(List<Long> appFileIdList, Date date) {
        DynamicObject[] appFiles;
        logger.info("updateAppFileLastFilterFKStartTime appFileList {}", appFileIdList);
        for (DynamicObject appFile : appFiles = AppFileHelper.queryAppFiles(appFileIdList, "lastfilterfkstarttime")) {
            appFile.set("lastfilterfkstarttime", (Object)date);
        }
        AppFileHelper.update(appFiles);
    }

    public static DynamicObject[] queryHireInfoAppFile(List<Long> appFileIdList) {
        logger.info("queryHireInfoAppFile.appFileIdList {}", appFileIdList);
        String selectProps = TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"empolyfeedbackresult", "jobrankstatus", "setsalarystatus", "employapprlsatatus", "employrecomnewesttime", "employapprlnewesttime", "lasthirejobrankstarttime", "lasthiresalarystartime"});
        return AppFileHelper.queryAppFiles(appFileIdList, selectProps);
    }

    public static void updateHireInfoAppFile(DynamicObject[] appFiles) {
        logger.info("updateHireInfoAppFile.appFiles");
        AppFileHelper.update(appFiles);
    }

    public static DynamicObject[] queryAppFileNameAndPhoto(List<Long> appFileIds) {
        String selectProperties = "id,name,appres.photo,appres,position";
        return AppFileHelper.queryAppFiles(appFileIds, selectProperties);
    }

    public static Map<Long, DynamicObject> getAppFileNameAndPhotoMap(List<Long> appFileIds) {
        DynamicObject[] appFiles = AppFileDataHelper.queryAppFileNameAndPhoto(appFileIds);
        HashMap<Long, DynamicObject> appFileMap = new HashMap<Long, DynamicObject>(appFileIds.size());
        for (int i = 0; i < appFiles.length; ++i) {
            appFileMap.put(appFiles[i].getLong("id"), appFiles[i]);
        }
        return appFileMap;
    }

    public static DynamicObject getAdminorgByAppFileId(Long appFileId) {
        String selectProperties = "id,adminorg";
        return AppFileHelper.queryOne(appFileId, selectProperties);
    }

    public static QueryObject getAppFileQueryObject(Set<String> selectProps, QFilter[] qFilters, String orderby, int pageSize, int pageNo, boolean isPage) {
        QueryObject queryObject = new QueryObject();
        ORM orm = ORM.create();
        int count = orm.count("AppFileListQuery.getAppFileQueryObject.count", "tspr_appfile", qFilters);
        int size = pageSize == 0 ? count : pageSize;
        queryObject.setCount(count);
        try (DataSet dataSet = AppFileDataHelper.getDataSet(String.join((CharSequence)",", selectProps), qFilters, orderby, isPage, pageSize, pageNo);){
            queryObject.setRows(dataSet, size);
        }
        return queryObject;
    }

    private static DataSet getDataSet(String selectProps, QFilter[] qFilters, String orderBy, boolean isPage, int pageSize, int pageNo) {
        if (isPage) {
            int start = pageNo <= 1 ? 0 : (pageNo - 1) * pageSize;
            return ORM.create().queryDataSet("AppFileListQuery.getDataSet.pageData", "tspr_appfile", selectProps, qFilters, orderBy, start, pageSize, (Distinctable)WithEntityEntryDistinctable.get());
        }
        return ORM.create().queryDataSet("AppFileListQuery.getDataSet", "tspr_appfile", selectProps, qFilters, orderBy);
    }

    public static void updateAppFileById(Long appFileId, Map<String, Object> updateFieldMap) {
        DynamicObject appFileDy = AppFileDataHelper.queryAppFileById(appFileId);
        for (Map.Entry<String, Object> entry : updateFieldMap.entrySet()) {
            appFileDy.set(entry.getKey(), entry.getValue());
        }
        AppFileHelper.update(new DynamicObject[]{appFileDy});
    }
}

