/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dtx.util.DynamicObjectSerializeUtil;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tspr.common.constants.appfile.AppFileFlowLockConstants;
import kd.tsc.tspr.common.constants.appfile.AppFileFlowLockStatusEnum;
import kd.tsc.tsrbd.business.domain.config.service.ConfigSysCfgParamHelper;
import kd.tsc.tsrbd.common.kdstring.TSCBaseKDString;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang3.tuple.Pair;

public class AppFileFlowLockHelper {
    private static final Log logger = LogFactory.getLog(AppFileFlowLockHelper.class);
    private static final int LOCK_TIME_DAYS = 5;
    private static final String KEY_FLOWLOCKTTL = "flowlockctl";
    private static final DistributeSessionlessCache FLOWLOCK_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("tsc_region");
    private static final HRBaseServiceHelper FLOW_LOCK_HELPER = new HRBaseServiceHelper("tspr_appfileflowlock");
    private static final String SELECT_PROPS = "stdrsmid,appfile,locktime,autounlocktime,locker,islocked,unlocktype";

    private AppFileFlowLockHelper() {
    }

    public static void lockAppFile(Long stdRsmId, Long appFileId, Date lockTime, Date autoUnLockTime) {
        AppFileFlowLockHelper.lockAppFile(stdRsmId, appFileId, lockTime, autoUnLockTime, TSCRequestContext.getUserId());
    }

    public static void lockAppFile(Long stdRsmId, Long appFileId, Date lockTime, Date autoUnLockTime, Long lockerId) {
        DynamicObject flowLockDy = AppFileFlowLockHelper.genFlowLockInfos(stdRsmId, appFileId, lockTime, autoUnLockTime, lockerId);
        logger.info("lockAppFile.stdRsmId:{},flowLockInfo:{},autoUnLockTime:{}", new Object[]{stdRsmId, flowLockDy, autoUnLockTime});
        flowLockDy.set("islocked", (Object)AppFileFlowLockConstants.STS_LOCKED);
        AppFileFlowLockHelper.saveLockInfos(new DynamicObject[]{flowLockDy});
    }

    public static void saveLockInfos(DynamicObject[] lockInfos) {
        try (TXHandle tx = TX.required();){
            try {
                logger.info("lockAppFiles:{},{}", (Object)lockInfos, (Object)lockInfos.length);
                FLOW_LOCK_HELPER.save(lockInfos);
                Set stdRsmIdSet = Arrays.stream(lockInfos).map(dyo -> dyo.getLong("stdrsmid")).collect(Collectors.toSet());
                Set lockIdSet = Arrays.stream(lockInfos).map(dyo -> dyo.getLong("id")).collect(Collectors.toSet());
                QFilter oldLockInfoFilter = new QFilter("stdrsmid", "in", stdRsmIdSet);
                oldLockInfoFilter.and("id", "not in", lockIdSet);
                FLOW_LOCK_HELPER.deleteByFilter(oldLockInfoFilter.toArray());
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("lockAppFiles.error", (Throwable)e);
                throw e;
            }
        }
    }

    public static void lockAppFile(DynamicObject appFile) {
        Date lockTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        Date autoUnLockTime = AppFileFlowLockHelper.getAutoUnLockTime(lockTime);
        AppFileFlowLockHelper.lockAppFile(appFile.getLong("stdrsm.id"), appFile.getLong("id"), lockTime, autoUnLockTime);
    }

    public static void lockAppFiles(List<Long> appFileIds, Long lockerId) {
        if (!appFileIds.isEmpty()) {
            DynamicObject[] appFiles = AppFileHelper.queryAppFiles(appFileIds, "stdrsm.id");
            List<Long> stdRsmIds = Arrays.stream(appFiles).map(dyo -> dyo.getLong("stdrsm.id")).collect(Collectors.toList());
            Date lockTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
            Map<Long, DynamicObject> flowLockInfos = AppFileFlowLockHelper.getFlowLockInfosByStdRsmId(stdRsmIds);
            for (DynamicObject appFile : appFiles) {
                Long stdRsmId = appFile.getLong("stdrsm.id");
                DynamicObject lockInfo = flowLockInfos.get(stdRsmId);
                if (lockInfo != null) continue;
                Date autoUnLockTime = AppFileFlowLockHelper.getAutoUnLockTime(lockTime);
                AppFileFlowLockHelper.lockAppFile(appFile.getLong("stdrsm.id"), appFile.getLong("id"), lockTime, autoUnLockTime, lockerId);
            }
        }
    }

    public static void unLockAppFile(List<Long> stdRsmIdList) {
        AppFileFlowLockHelper.unLockAppFile(stdRsmIdList, "0");
    }

    public static void unLockAppFile(List<Long> stdRsmIdList, String unLockType) {
        logger.info("unLockAppFile.stdRsmId:{},{}", stdRsmIdList, (Object)unLockType);
        try {
            DynamicObject[] flowLockInfos = AppFileFlowLockHelper.getFlowLockDys(stdRsmIdList, AppFileFlowLockConstants.STS_LOCKED);
            if (flowLockInfos.length > 0) {
                for (DynamicObject flowLockInfo : flowLockInfos) {
                    flowLockInfo.set("islocked", (Object)AppFileFlowLockConstants.STS_UNLOCKED);
                    flowLockInfo.set("unlocktype", (Object)unLockType);
                }
                AppFileFlowLockHelper.saveLockInfos(flowLockInfos);
            }
        }
        catch (RuntimeException ex) {
            logger.error("unLockAppFile.error:{}", stdRsmIdList, (Object)ex);
            throw ex;
        }
    }

    private static DynamicObject genFlowLockInfos(Long stdRsmId, Long appFileId, Date lockTime, Date autoUnLockTime, Long lockerId) {
        DynamicObject flowLockDy = FLOW_LOCK_HELPER.generateEmptyDynamicObject();
        flowLockDy.set("id", (Object)ID.genLongId());
        flowLockDy.set("stdrsmid", (Object)stdRsmId);
        flowLockDy.set("appfile", (Object)appFileId);
        flowLockDy.set("locktime", (Object)lockTime);
        flowLockDy.set("autounlocktime", (Object)autoUnLockTime);
        flowLockDy.set("locker", (Object)lockerId);
        return flowLockDy;
    }

    public static Map<Long, String> getFlowLockData(List<DynamicObject> appFiles) {
        return AppFileFlowLockHelper.getFlowLockData(appFiles, false);
    }

    public static Map<Long, String> getFlowLockData(List<DynamicObject> appFiles, boolean ignoreAppFileStatus) {
        HashMap result = Maps.newHashMap();
        logger.info("getFlowLockData.params:{}", appFiles.stream().map(dyo -> dyo.getLong("id")).toArray());
        List<Long> stdRsmIds = appFiles.stream().map(dyo -> dyo.getLong("stdrsm.id")).filter(id -> id != 0L).collect(Collectors.toList());
        Map<Long, DynamicObject> flowLockInfos = AppFileFlowLockHelper.getFlowLockInfosByStdRsmId(stdRsmIds);
        for (DynamicObject row : appFiles) {
            boolean status;
            long appFileId = row.getLong("id");
            long stdRsmId = row.getLong("stdrsm.id");
            DynamicObject lockInfo = flowLockInfos.get(stdRsmId);
            boolean bl = status = !ignoreAppFileStatus && !AppFileHelper.isInProcessOrEmp(row);
            if (lockInfo == null || status) {
                result.put(appFileId, AppFileFlowLockStatusEnum.UNLOCK.getStatus());
                continue;
            }
            if (HRObjectUtils.equals((Object)lockInfo.getLong("appfile.id"), (Object)appFileId)) {
                result.put(appFileId, AppFileFlowLockStatusEnum.BLUE_LOCK.getStatus());
                continue;
            }
            result.put(appFileId, AppFileFlowLockStatusEnum.GRAY_LOCK.getStatus());
        }
        logger.info("getFlowLockData.res:{}", (Object)result);
        return result;
    }

    public static Map<Long, DynamicObject> getFlowLockInfosByStdRsmId(List<Long> stdRsmIdList) {
        return AppFileFlowLockHelper.getFlowLockInfos(stdRsmIdList, AppFileFlowLockConstants.STS_LOCKED);
    }

    public static Map<Long, DynamicObject> getFlowLockInfos(List<Long> stdRsmIdList, Boolean isLocked) {
        HashMap result = Maps.newHashMap();
        if (!stdRsmIdList.isEmpty()) {
            DynamicObject[] flowLockInfos;
            for (DynamicObject flowLockInfo : flowLockInfos = AppFileFlowLockHelper.getFlowLockDys(stdRsmIdList, isLocked)) {
                result.put(flowLockInfo.getLong("stdrsmid"), flowLockInfo);
            }
        }
        logger.info("getFlowLockInfos.result:{}", (Object)result);
        return result;
    }

    private static DynamicObject[] getFlowLockDys(List<Long> stdRsmIdList, Boolean isLocked) {
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        QFilter[] qFilters = new QFilter[]{AppFileFlowLockHelper.getLockedQFilter(stdRsmIdList, nowTime, isLocked)};
        return FLOW_LOCK_HELPER.query(SELECT_PROPS, qFilters);
    }

    public static DynamicObject getFlowLockInfo(Long stdRsmId) {
        Map<Long, DynamicObject> flowLockInfos = AppFileFlowLockHelper.getFlowLockInfos(Collections.singletonList(stdRsmId), AppFileFlowLockConstants.STS_LOCKED);
        logger.info("getFlowLockInfo.stdRsmId:{},flowLockInfo:{}", (Object)stdRsmId, (Object)flowLockInfos.get(stdRsmId));
        return flowLockInfos.get(stdRsmId);
    }

    public static QFilter getLockedQFilter(List<Long> stdRsmIdList, Date currDate, boolean isLocked) {
        QFilter qFilter = new QFilter("autounlocktime", ">", (Object)currDate);
        qFilter.and("islocked", "=", (Object)isLocked);
        qFilter.and("stdrsmid", "in", stdRsmIdList);
        return qFilter;
    }

    public static Date getAutoUnLockTime(Date lockTime) {
        long flowLockTTL;
        Object flowLockTTLObj = ConfigSysCfgParamHelper.getTSRBDSystemParameter((String)KEY_FLOWLOCKTTL);
        if (flowLockTTLObj != null && (flowLockTTL = Long.parseLong(flowLockTTLObj.toString())) > 0L) {
            return HRDateTimeUtils.addMinute((Date)lockTime, (long)flowLockTTL);
        }
        return HRDateTimeUtils.addDay((Date)lockTime, (long)5L);
    }

    public static void showFlowLockInfoPage(Long appFileId, IFormView view) {
        DynamicObject appFile = AppFileHelper.queryOne(appFileId);
        Long stdRsmId = appFile.getLong("stdrsm.id");
        DynamicObject flowLockInfo = AppFileFlowLockHelper.getFlowLockInfo(stdRsmId);
        if (flowLockInfo != null) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tspr_appfileflowlockinfo");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("data", (Object)DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{flowLockInfo}, (DynamicObjectType)flowLockInfo.getDynamicObjectType()));
            view.showForm(showParameter);
        } else {
            view.showTipNotification(TSCBaseKDString.dataChangedTip());
        }
    }

    public static void showLockConfirm(AbstractFormPlugin plugin, List<Pair<String, String>> numberNamePairList) {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("lock", (IFormPlugin)plugin);
        String name = AppFileOpHelper.getErrorMulTipHead(numberNamePairList, false);
        String confirmMessage = String.format(Locale.ROOT, AppFileResManagerHelper.getLockSureDesc(), name);
        plugin.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    public static void showUnLockConfirm(AbstractFormPlugin plugin, List<Pair<String, String>> numberNamePairList) {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("unlock", (IFormPlugin)plugin);
        String name = AppFileOpHelper.getErrorMulTipHead(numberNamePairList, false);
        String confirmMessage = String.format(Locale.ROOT, AppFileResManagerHelper.getUnLockSureDesc(), name);
        plugin.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    public static void mergeCandidate(Long mainId, Long subId) {
        try (TXHandle tx = TX.required();){
            DynamicObject subStdFlowLockInfo = AppFileFlowLockHelper.getFlowLockInfo(subId);
            logger.info("mergeCandidate.subFlowLockInfo:{}", (Object)subStdFlowLockInfo);
            if (subStdFlowLockInfo == null) {
                return;
            }
            try {
                DynamicObject mainStdFlowLockInfo = AppFileFlowLockHelper.getFlowLockInfo(mainId);
                logger.info("mergeCandidate.mainFlowLockInfo:{}", (Object)mainStdFlowLockInfo);
                if (mainStdFlowLockInfo == null) {
                    long lockAppFileId = subStdFlowLockInfo.getLong("appfile.id");
                    DynamicObject lockAppFile = AppFileHelper.queryOne(lockAppFileId);
                    Long positionId = lockAppFile.getLong("position.id");
                    DynamicObject[] mainAppFiles = AppFileHelper.queryAppFiles("id", new QFilter[]{AppFileHelper.getInAppFileQFilter(mainId, positionId)});
                    if (mainAppFiles.length > 0) {
                        subStdFlowLockInfo.set("appfile", (Object)mainAppFiles[0].getLong("id"));
                    }
                    subStdFlowLockInfo.set("stdrsmid", (Object)mainId);
                    logger.info("mergeCandidate.to.mainFlowLockInfo:{},mainAppFiles:{}", (Object)subStdFlowLockInfo, (Object)mainAppFiles);
                    AppFileFlowLockHelper.saveLockInfos(new DynamicObject[]{subStdFlowLockInfo});
                } else {
                    AppFileFlowLockHelper.unLockAppFile(Collections.singletonList(subId));
                }
            }
            catch (Exception ex) {
                tx.markRollback();
                logger.error("mergeCandidate.error", (Throwable)ex);
                throw ex;
            }
        }
    }

    public static void eliminateAppFiles(DynamicObject[] appFiles) {
        Map<Long, String> flowLockData = AppFileFlowLockHelper.getFlowLockData(Lists.newArrayList((Object[])appFiles), true);
        List<Long> stdRsmIdList = Arrays.stream(appFiles).filter(appFile -> AppFileFlowLockStatusEnum.BLUE_LOCK.getStatus().equals(flowLockData.get(appFile.getLong("id")))).map(dyo -> dyo.getLong("stdrsm.id")).collect(Collectors.toList());
        AppFileFlowLockHelper.unLockAppFile(stdRsmIdList, "1");
    }

    public static void recoverAppFile(DynamicObject[] appFiles) {
        List<Long> stdRsmIdList = Arrays.stream(appFiles).map(dyo -> dyo.getLong("stdrsm.id")).collect(Collectors.toList());
        logger.info("recoverAppFile.stdRsmIdList{},appFiles:{}", stdRsmIdList, (Object)appFiles);
        Map<Long, DynamicObject> flowLockInfosHis = AppFileFlowLockHelper.getFlowLockInfos(stdRsmIdList, AppFileFlowLockConstants.STS_UNLOCKED);
        ArrayList updateFlowLockDyLists = Lists.newArrayListWithExpectedSize((int)flowLockInfosHis.size());
        for (DynamicObject appFile : appFiles) {
            Long lockedAppFileId;
            Long stdRsmId = appFile.getLong("stdrsm.id");
            Long appFileId = appFile.getLong("id");
            DynamicObject flowLockInfoHis = flowLockInfosHis.get(stdRsmId);
            if (flowLockInfoHis == null || !"1".equals(flowLockInfoHis.getString("unlocktype")) || !appFileId.equals(lockedAppFileId = Long.valueOf(flowLockInfoHis.getLong("appfile.id")))) continue;
            flowLockInfoHis.set("islocked", (Object)AppFileFlowLockConstants.STS_LOCKED);
            flowLockInfoHis.set("unlocktype", (Object)" ");
            updateFlowLockDyLists.add(flowLockInfoHis);
        }
        AppFileFlowLockHelper.saveLockInfos(updateFlowLockDyLists.toArray(new DynamicObject[0]));
    }

    public static Date getDate(String dateStr) {
        if (HRStringUtils.isNotEmpty((String)dateStr)) {
            try {
                return HRDateTimeUtils.parseDate((String)dateStr);
            }
            catch (ParseException e) {
                logger.error("AppFileFlowLockHelper.parseDateError", (Throwable)e);
            }
        }
        return null;
    }

    public static List<Long> getLockKeys() {
        QFilter qFilter = new QFilter("autounlocktime", ">", (Object)LocalDateTime.now());
        qFilter.and("islocked", "=", (Object)AppFileFlowLockConstants.STS_LOCKED);
        DynamicObject[] flowLockDys = FLOW_LOCK_HELPER.query(SELECT_PROPS, qFilter.toArray());
        return Arrays.stream(flowLockDys).map(dy -> dy.getLong("stdrsmid")).collect(Collectors.toList());
    }

    public static List<Long> getLockedAppFileIdList() {
        Map<Long, DynamicObject> lockedInfoMap = AppFileFlowLockHelper.getFlowLockInfosByStdRsmId(AppFileFlowLockHelper.getLockKeys());
        return lockedInfoMap.values().stream().map(map -> map.getLong("appfile.id")).collect(Collectors.toList());
    }

    public static boolean isLocked(DynamicObject appFile) {
        Long stdRsmId = appFile.getLong("stdrsm.id");
        DynamicObject flowLockInfo = AppFileFlowLockHelper.getFlowLockInfo(stdRsmId);
        return flowLockInfo != null;
    }

    public static void oldDataBase2NewDataBase() {
        Map oldDataMap = FLOWLOCK_CACHE.getAll("appfileflowlock");
        DynamicObjectCollection flowLockDyList = new DynamicObjectCollection();
        for (Map.Entry oldEntry : oldDataMap.entrySet()) {
            Map flowLockInfo = (Map)SerializationUtils.fromJsonString((String)((String)oldEntry.getValue()), Map.class);
            Long appFileId = Long.valueOf((String)flowLockInfo.get("appfile"));
            Long stdRsmId = Long.valueOf((String)flowLockInfo.get("stdrsm"));
            String lockTimeStr = (String)flowLockInfo.get("locktime");
            String autoUnLockTimeStr = (String)flowLockInfo.get("autounlocktime");
            Long lockerId = Long.valueOf((String)flowLockInfo.get("lockerid"));
            try {
                Date lockTime = HRDateTimeUtils.parseDate((String)lockTimeStr);
                Date autoUnLockTime = HRDateTimeUtils.parseDate((String)autoUnLockTimeStr);
                Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
                if (!now.before(autoUnLockTime) || FLOW_LOCK_HELPER.isExists(new QFilter("stdrsmid", "=", (Object)stdRsmId).and(new QFilter("appfile", "=", (Object)appFileId)).and(new QFilter("locktime", "=", (Object)lockTime)))) continue;
                DynamicObject flowLockDy = FLOW_LOCK_HELPER.generateEmptyDynamicObject();
                flowLockDy.set("id", (Object)ID.genLongId());
                flowLockDy.set("stdrsmid", (Object)stdRsmId);
                flowLockDy.set("appfile", (Object)appFileId);
                flowLockDy.set("locktime", (Object)lockTime);
                flowLockDy.set("autounlocktime", (Object)autoUnLockTime);
                flowLockDy.set("locker", (Object)lockerId);
                flowLockDy.set("islocked", (Object)Boolean.TRUE);
                flowLockDyList.add((Object)flowLockDy);
            }
            catch (ParseException e) {
                logger.error((Throwable)e);
            }
        }
        if (!flowLockDyList.isEmpty()) {
            FLOW_LOCK_HELPER.save(flowLockDyList);
        }
    }

    public static List<Pair<ExtendedDataEntity, String>> getValidateFlowLockStatusTipList(Collection<ExtendedDataEntity> dataEntities) {
        List<Long> stdRsmIdList = dataEntities.stream().map(dyo -> dyo.getDataEntity().getLong("stdrsm.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> lockInfoMap = AppFileFlowLockHelper.getFlowLockInfosByStdRsmId(stdRsmIdList);
        ArrayList tipList = Lists.newArrayListWithExpectedSize((int)dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject appFile = dataEntity.getDataEntity();
            Long stdRsmId = appFile.getLong("stdrsm.id");
            DynamicObject lockInfo = lockInfoMap.get(stdRsmId);
            if (lockInfo == null || appFile.getLong("id") != lockInfo.getLong("appfile.id") || String.valueOf(TSCRequestContext.getUserId()).equals(lockInfo.getString("locker.id"))) continue;
            String errorTip = String.format(ResManager.loadKDString((String)"\u5019\u9009\u4eba%s\u5df2\u88ab%s\u9501\u5b9a\uff0c\u4e0d\u80fd\u8fdb\u884c\u6dd8\u6c70", (String)"OutCandidateValidator_4", (String)"tsc-tspr-opplugin", (Object[])new Object[0]), appFile.getString("name"), lockInfo.getString("locker.name"));
            tipList.add(Pair.of((Object)dataEntity, (Object)errorTip));
        }
        return tipList;
    }

    public static void unLockEmpedAppFiles(List<DynamicObject> appFiles) {
        if (!appFiles.isEmpty()) {
            ArrayList unLockStdRsmIds = Lists.newArrayListWithExpectedSize((int)appFiles.size());
            List<Long> stdRsmIds = appFiles.stream().map(dyo -> dyo.getLong("stdrsm.id")).filter(id -> id != 0L).collect(Collectors.toList());
            Map<Long, DynamicObject> flowLockInfos = AppFileFlowLockHelper.getFlowLockInfosByStdRsmId(stdRsmIds);
            for (DynamicObject appFile : appFiles) {
                long appFileId = appFile.getLong("id");
                long stdRsmId = appFile.getLong("stdrsm.id");
                DynamicObject lockInfo = flowLockInfos.get(stdRsmId);
                if (lockInfo == null || !HRObjectUtils.equals((Object)lockInfo.getLong("appfile.id"), (Object)appFileId)) continue;
                unLockStdRsmIds.add(stdRsmId);
            }
            AppFileFlowLockHelper.unLockAppFile(unLockStdRsmIds, "2");
        }
    }
}

