/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.ChangeStageStatusHelper;
import kd.tsc.tspr.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tspr.common.constants.appfile.AppFileConstants;
import kd.tsc.tspr.common.constants.appfile.AppFileOperateEnum;
import kd.tsc.tspr.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tspr.common.hire.HireVerifyResult;
import kd.tsc.tsrbd.business.domain.perm.PermissionHelper;
import kd.tsc.tsrbd.common.utils.PageUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.base.MiddleGroundPersonHelper;
import org.apache.commons.lang3.tuple.Pair;

public class AppFileHelper {
    private static final Log LOG = LogFactory.getLog(AppFileHelper.class);
    private static final HRBaseServiceHelper APP_FILE_SERVICE_HELPER = new HRBaseServiceHelper("tspr_appfile");
    private static final long ONE_MIN = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;

    private AppFileHelper() {
    }

    public static DynamicObject[] queryAppFiles(List<Long> appFileIdList, String fields) {
        QFilter qFilter = new QFilter("id", "in", appFileIdList);
        return APP_FILE_SERVICE_HELPER.query(fields, qFilter.toArray());
    }

    public static void update(DynamicObject[] appFiles) {
        if (null != appFiles && appFiles.length > 0) {
            APP_FILE_SERVICE_HELPER.update(appFiles);
        }
    }

    public static DynamicObject queryOne(long id, String fields) {
        return APP_FILE_SERVICE_HELPER.queryOne(fields, (Object)id);
    }

    public static DynamicObject queryOriginalOne(String fields, long id) {
        return APP_FILE_SERVICE_HELPER.queryOriginalOne(fields, (Object)id);
    }

    public static DynamicObject queryOne(long id) {
        return APP_FILE_SERVICE_HELPER.queryOne((Object)id);
    }

    public static void bindAppFileResume(DynamicObject[] appFileObjects) {
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        DynamicObject[] updateDynamicObject = new DynamicObject[appFileObjects.length];
        for (DynamicObject appFileObject : appFileObjects) {
            DynamicObject dynamicObject = APP_FILE_SERVICE_HELPER.generateDynamicObject((Object)appFileObject.getLong("id"), "id,isbinddelyrec,modifytime,modifier");
            dynamicObject.set("isbinddelyrec", (Object)"1");
            dynamicObject.set("modifytime", (Object)nowTime);
            dynamicObject.set("modifier", (Object)TSCRequestContext.getUserId());
            updateDynamicObject[i] = dynamicObject;
        }
        AppFileHelper.update(updateDynamicObject);
    }

    public static void invokeTransferPosOp(ListSelectedRowCollection selectedRows, IFormView view) {
        if (selectedRows != null && !selectedRows.isEmpty()) {
            OperateOption transferOp = OperateOption.create();
            transferOp.setVariableValue("position", String.valueOf(selectedRows.get(0).getPrimaryKeyValue()));
            transferOp.setVariableValue("istpeliminate", view.getPageCache().get("istpeliminate"));
            OperationResult operationResult = view.invokeOperation("transferpos", transferOp);
            if (operationResult.isSuccess()) {
                view.showSuccessNotification(operationResult.getMessage());
            }
        }
    }

    public static void invokeEliminateOp(DynamicObject eliminateModel, IFormView view) {
        Long reasonId = eliminateModel.getLong("eliminationreason.id");
        ILocaleString desc = eliminateModel.getLocaleString("description");
        OperateOption eliminateOp = OperateOption.create();
        eliminateOp.setVariableValue("eliminationreason", String.valueOf(reasonId));
        eliminateOp.setVariableValue("description", SerializationUtils.toJsonString((Object)desc));
        OperationResult operationResult = view.invokeOperation("eliminate", eliminateOp);
        if (operationResult.isSuccess()) {
            view.showSuccessNotification(operationResult.getMessage());
        }
    }

    public static DynamicObject getLastFileStatusRecord(Long appFileId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tspr_appfilestatusrec");
        DynamicObject[] records = helper.query("createtime", new QFilter[]{new QFilter("appfile", "=", (Object)appFileId)});
        if (records.length > 0) {
            return records[0];
        }
        return null;
    }

    public static String calDuration(Date startDate, Date endDate) {
        if (endDate == null || startDate == null) {
            return "0";
        }
        long endTime = endDate.getTime();
        long startTime = startDate.getTime();
        long gap = endTime - endTime % 60000L - (startTime - startTime % 60000L);
        return AppFileHelper.calDuration(gap);
    }

    public static String calDuration(Long gap) {
        long day = gap / 86400000L;
        long hour = gap % 86400000L / 3600000L;
        long min = gap % 3600000L / 60000L;
        StringBuilder result = new StringBuilder();
        if (day > 0L) {
            result.append(day).append('d');
            if (hour == 0L && min == 0L) {
                return result.toString();
            }
        }
        result.append(hour).append('h').append(min).append("min");
        return result.toString();
    }

    public static DynamicObjectCollection getProcStagesByProcId(Long procId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        return helper.queryOriginalCollection("entryentity.rqmtstg.id,entryentity.rqmtstg.name,entryentity.seq", new QFilter[]{new QFilter("id", "=", (Object)procId)}, "entryentity.seq");
    }

    public static Date getEndDateByStatus(DynamicObject appFile) {
        Date endDate = null;
        if (AppFileHelper.isInvalid(appFile) || AppFileHelper.isEndEmployed(appFile)) {
            DynamicObject lastFileStatusRecord = AppFileHelper.getLastFileStatusRecord(appFile.getLong("id"));
            endDate = lastFileStatusRecord != null ? lastFileStatusRecord.getDate("createtime") : HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        } else if (AppFileHelper.isOut(appFile)) {
            endDate = appFile.getDate("eliminatetime");
        } else if (AppFileHelper.isEmployed(appFile)) {
            endDate = appFile.getDate("emptime");
        }
        return endDate;
    }

    public static void showFillAddCandidatePage(IFormView view) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("tstpm_srrsm");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)showParameter);
    }

    public static DynamicObject findAppFileByRsmId(Long rsmId) {
        String queryProp = "id,name,isbinddelyrec,phone,email,jobstatus,birthday,highesteduschool,highesteducation,appres,deliveryrec,applytime,resacqmthd,recruchnlnm,highestspecialty";
        QFilter qFilter = new QFilter("appres", "=", (Object)rsmId);
        return APP_FILE_SERVICE_HELPER.queryOne(queryProp, qFilter.toArray());
    }

    public static HireVerifyResult verifyApprovalBatch(List<Long> appFileIds) {
        String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tso", (String)"hireApprovalServiceApi", (String)"verifyApprovalBatch", (Object[])new Object[]{appFileIds});
        return (HireVerifyResult)JSON.parseObject((String)resultStr, HireVerifyResult.class);
    }

    public static Pair<Long, Long> getPositionAndStageByAppFileId(Long appFileId) {
        DynamicObject appFile = APP_FILE_SERVICE_HELPER.queryOne("position.id,recrustg.id", (Object)appFileId);
        return Pair.of((Object)appFile.getLong("position.id"), (Object)appFile.getLong("recrustg.id"));
    }

    public static void showPositionFormView(long positionId, IFormView view) {
        Long userId = TSCRequestContext.getUserId();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setPageId(userId + positionId + view.getPageId());
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setFormId("tssrm_position_view");
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setPkId((Object)positionId);
        baseShowParameter.setCustomParam("isSimpleView", (Object)true);
        String pageId = PageUtils.getPageId((String)String.valueOf(positionId), (String)"tssrm", (String)"tssrm_position_view", (String)view.getFormShowParameter().getRootPageId());
        baseShowParameter.setPageId(pageId);
        view.showForm((FormShowParameter)baseShowParameter);
    }

    public static void showErrorNotification(DynamicObject positionObject, IFormView view) {
        DynamicObject manageInfoByPositionBo = PositionManageServiceHelper.getManageInfoByPositionBo(positionObject.getLong("id"));
        DynamicObjectCollection positionPrincipalCollection = manageInfoByPositionBo.getDynamicObjectCollection("posprin");
        ArrayList<Long> userIdList = new ArrayList<Long>(positionPrincipalCollection.size());
        for (DynamicObject positionPrincipalObject : positionPrincipalCollection) {
            userIdList.add(positionPrincipalObject.getLong("fbasedataid.id"));
        }
        DynamicObject[] userObjects = ChangeStageStatusHelper.queryUser(userIdList);
        StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u60a8\u6682\u65e0\u8be5\u804c\u4f4d\u7684\u67e5\u770b\u6743\u9650\uff0c\u53ef\u8054\u7cfb\u804c\u4f4d\u8d1f\u8d23\u4eba", (String)"AppFileHelper_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
        for (int i = 0; i < 3 && i < userObjects.length; ++i) {
            sb.append(userObjects[i].getString("name")).append(userObjects[i].getString("phone"));
            if (i == 2 || i == userObjects.length - 1) continue;
            sb.append('\u3001');
        }
        if (userObjects.length > 3) {
            sb.append(ResManager.loadKDString((String)"\u7b49", (String)"AppFileHelper_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
        }
        if (view instanceof BaseView) {
            view.showTipNotification(sb.toString());
        } else if (view.getParentView() != null) {
            view.getParentView().showErrorNotification(sb.toString());
            view.sendFormAction(view.getParentView());
        }
    }

    public static int queryRepeatDeliveryCount(Long appFileId) {
        int count;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tstpm_srrsm");
        try (DataSet dataSet = helper.queryDataSet("AppFileDataHelper.queryRepeatDeliveryCount", "delivery.id", new QFilter("appfile", "=", (Object)appFileId).toArray());){
            count = dataSet.count("delivery.id", true);
        }
        return count;
    }

    public static DynamicObject[] queryAppFiles(String fields, QFilter[] qFilters) {
        return APP_FILE_SERVICE_HELPER.query(fields, qFilters);
    }

    public static boolean isInProcess(DynamicObject appFile) {
        return AppFileConstants.APP_FILE_STATUS_IN.equals(appFile.getString("filestatus"));
    }

    public static boolean isInProcess(String fileStatus) {
        return AppFileConstants.APP_FILE_STATUS_IN.equals(fileStatus);
    }

    public static boolean isOut(DynamicObject appFile) {
        return AppFileConstants.APP_FILE_STATUS_OUT.equals(appFile.getString("filestatus"));
    }

    public static boolean isOut(String fileStatus) {
        return AppFileConstants.APP_FILE_STATUS_OUT.equals(fileStatus);
    }

    public static boolean isInvalid(DynamicObject appFile) {
        return AppFileConstants.APP_FILE_STATUS_INVALID.equals(appFile.getString("filestatus"));
    }

    public static boolean isInvalid(String fileStatus) {
        return AppFileConstants.APP_FILE_STATUS_INVALID.equals(fileStatus);
    }

    public static boolean isToBeEmployed(DynamicObject appFile) {
        return AppFileConstants.APP_FILE_STATUS_TBEMP.equals(appFile.getString("filestatus"));
    }

    public static boolean isToBeEmployed(String fileStatus) {
        return AppFileConstants.APP_FILE_STATUS_TBEMP.equals(fileStatus);
    }

    public static boolean isEmployed(DynamicObject appFile) {
        return AppFileConstants.APP_FILE_STATUS_EMPED.equals(appFile.getString("filestatus"));
    }

    public static boolean isEmployed(String fileStatus) {
        return AppFileConstants.APP_FILE_STATUS_EMPED.equals(fileStatus);
    }

    public static boolean isEndEmployed(DynamicObject appFile) {
        return AppFileConstants.APP_FILE_STATUS_ENDEMP.equals(appFile.getString("filestatus"));
    }

    public static boolean isEndEmployed(String fileStatus) {
        return AppFileConstants.APP_FILE_STATUS_ENDEMP.equals(fileStatus);
    }

    public static boolean isInProcessOrEmp(DynamicObject appFile) {
        String fileStatus = appFile.getString("filestatus");
        return AppFileConstants.APP_FILE_STATUS_IN.equals(fileStatus) || AppFileConstants.APP_FILE_STATUS_TBEMP.equals(fileStatus);
    }

    public static boolean isInEmpStatus(DynamicObject appFile) {
        String fileStatus = appFile.getString("filestatus");
        return AppFileConstants.APP_FILE_STATUS_EMPED.equals(fileStatus) || AppFileConstants.APP_FILE_STATUS_TBEMP.equals(fileStatus) || AppFileConstants.APP_FILE_STATUS_ENDEMP.equals(fileStatus);
    }

    public static String getFileStatusDesc(DynamicObject appFile) {
        AppFileStatusEnum statusEnum = AppFileStatusEnum.getEnum((String)appFile.getString("filestatus"));
        if (statusEnum != null) {
            return statusEnum.getText().loadKDString();
        }
        return "";
    }

    public static QFilter getInAppFileQFilter(Long stdRsmId, Long positionId) {
        return new QFilter("position", "=", (Object)positionId).and(new QFilter("stdrsm", "=", (Object)stdRsmId)).and(new QFilter("filestatus", "=", (Object)AppFileConstants.APP_FILE_STATUS_IN));
    }

    public static Map<String, Long> queryCandidateIds(List<String> appFileNumbers) {
        HRBaseServiceHelper hcfHelper = new HRBaseServiceHelper("hcf_candidate");
        DynamicObject[] candidates = hcfHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("number", "in", appFileNumbers)});
        return Arrays.stream(candidates).collect(Collectors.toMap(dyo -> dyo.getString("number"), dyo -> dyo.getLong("id"), (aa, bb) -> aa));
    }

    public static void setLaborTypeAndHireTime(List<Long> empedAppFileIds, List<String> empedAppFileNumbers, Map<Long, DynamicObject> idDyMaps) {
        if (!empedAppFileIds.isEmpty()) {
            Map<String, Long> candidateMap = AppFileHelper.queryCandidateIds(empedAppFileNumbers);
            Map empDataMap = MiddleGroundPersonHelper.getEmployeeData(new ArrayList<Long>(candidateMap.values()));
            LOG.info("setLaborTypeAndHireTime.params:{},{}", candidateMap, (Object)empDataMap);
            for (Long empedAppFileId : empedAppFileIds) {
                DynamicObject appFile = idDyMaps.get(empedAppFileId);
                String number = appFile.getString("number");
                JSONObject jsonObject = (JSONObject)empDataMap.get(candidateMap.get(number));
                if (jsonObject == null) continue;
                appFile.set("emptime", (Object)jsonObject.getDate("startdate"));
                appFile.set("laborrelstatus", jsonObject.get((Object)"laborreltype"));
            }
        }
    }

    public static void setEndEmpTime(List<Long> endEmpAppFileIds, List<String> endEmpAppFileNumbers, Map<Long, DynamicObject> idDyMaps) {
        if (!endEmpAppFileIds.isEmpty()) {
            Map<String, Long> candidateMap = AppFileHelper.queryCandidateIds(endEmpAppFileNumbers);
            Map empDataMap = MiddleGroundPersonHelper.getEmployeeData(new ArrayList<Long>(candidateMap.values()));
            LOG.info("setEndEmpTime.params:{},{}", candidateMap, (Object)empDataMap);
            for (Long endEmpAppFileId : endEmpAppFileIds) {
                DynamicObject appFile = idDyMaps.get(endEmpAppFileId);
                String number = appFile.getString("number");
                JSONObject jsonObject = (JSONObject)empDataMap.get(candidateMap.get(number));
                if (jsonObject == null) continue;
                appFile.set("endemptime", (Object)jsonObject.getDate("enddate"));
            }
        }
    }

    public static void checkAppFilePermAndSetVisible(IFormView view, Set<String> hideCtrlKey) {
        int opSize = AppFileOperateEnum.values().length;
        HashMap hasChecked = Maps.newHashMapWithExpectedSize((int)opSize);
        HashSet notHasPermSet = Sets.newHashSetWithExpectedSize((int)opSize);
        HashSet hasPermSet = Sets.newHashSetWithExpectedSize((int)opSize);
        HashSet notHandleBtnSet = Sets.newHashSetWithExpectedSize((int)opSize);
        AppFileHelper.handleTransAndTalent(notHandleBtnSet, hasChecked, hideCtrlKey, view);
        AppFileHelper.handleMarkAndExamination(notHandleBtnSet, hasChecked, hideCtrlKey, view);
        for (AppFileOperateEnum appFileOperateEnum : AppFileOperateEnum.values()) {
            String ctrlKey = appFileOperateEnum.getCtrlKey();
            if (notHandleBtnSet.contains(ctrlKey) || hideCtrlKey.contains(ctrlKey)) continue;
            boolean hasPerm = AppFileHelper.hasPerm(appFileOperateEnum, hasChecked, view);
            if (hasPerm) {
                hasPermSet.add(appFileOperateEnum.getCtrlKey());
                continue;
            }
            notHasPermSet.add(appFileOperateEnum.getCtrlKey());
        }
        if (!hasPermSet.isEmpty()) {
            view.setVisible(Boolean.TRUE, hasPermSet.toArray(new String[0]));
        }
        if (!notHasPermSet.isEmpty()) {
            view.setVisible(Boolean.FALSE, notHasPermSet.toArray(new String[0]));
        }
    }

    private static void handleMarkAndExamination(Set<String> notHandleBtnSet, Map<String, Boolean> hasChecked, Set<String> hideCtrlKey, IFormView view) {
        boolean hasMarkPerm = false;
        if (!hideCtrlKey.contains(AppFileOperateEnum.REGMARK.getCtrlKey())) {
            hasMarkPerm = AppFileHelper.hasPerm(AppFileOperateEnum.REGMARK, hasChecked, view);
        }
        boolean hasExaminationPerm = false;
        if (!hideCtrlKey.contains(AppFileOperateEnum.EXAMINATION.getCtrlKey())) {
            hasExaminationPerm = AppFileHelper.hasPerm(AppFileOperateEnum.EXAMINATION, hasChecked, view);
        }
        if (hasMarkPerm && hasExaminationPerm) {
            view.setVisible(Boolean.TRUE, new String[]{AppFileOperateEnum.REGMARK.getCtrlKey(), AppFileOperateEnum.EXAMINATION.getCtrlKey()});
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.EXAMINATION_1.getCtrlKey()});
        } else if (hasMarkPerm) {
            view.setVisible(Boolean.TRUE, new String[]{AppFileOperateEnum.REGMARK.getCtrlKey()});
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.EXAMINATION.getCtrlKey(), AppFileOperateEnum.EXAMINATION_1.getCtrlKey()});
        } else if (hasExaminationPerm) {
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.REGMARK.getCtrlKey(), AppFileOperateEnum.EXAMINATION.getCtrlKey()});
            view.setVisible(Boolean.TRUE, new String[]{AppFileOperateEnum.EXAMINATION_1.getCtrlKey()});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.REGMARK.getCtrlKey(), AppFileOperateEnum.EXAMINATION.getCtrlKey(), AppFileOperateEnum.EXAMINATION_1.getCtrlKey()});
        }
        notHandleBtnSet.add(AppFileOperateEnum.REGMARK.getCtrlKey());
        notHandleBtnSet.add(AppFileOperateEnum.EXAMINATION.getCtrlKey());
        notHandleBtnSet.add(AppFileOperateEnum.EXAMINATION_1.getCtrlKey());
    }

    private static void handleTransAndTalent(Set<String> notHandleBtnSet, Map<String, Boolean> hasChecked, Set<String> hideCtrlKey, IFormView view) {
        boolean hasTransferPerm = false;
        if (!hideCtrlKey.contains(AppFileOperateEnum.TRANSFERPOS.getCtrlKey())) {
            hasTransferPerm = AppFileHelper.hasPerm(AppFileOperateEnum.TRANSFERPOS, hasChecked, view);
        }
        boolean hasSaveTalentPerm = false;
        if (!hideCtrlKey.contains(AppFileOperateEnum.SAVETALENT.getCtrlKey())) {
            hasSaveTalentPerm = AppFileHelper.hasPerm(AppFileOperateEnum.SAVETALENT, hasChecked, view);
        }
        if (hasTransferPerm && hasSaveTalentPerm) {
            view.setVisible(Boolean.TRUE, new String[]{AppFileOperateEnum.TRANSFERPOS.getCtrlKey(), AppFileOperateEnum.SAVETALENT.getCtrlKey()});
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.SAVETALENT_1.getCtrlKey()});
        } else if (hasTransferPerm) {
            view.setVisible(Boolean.TRUE, new String[]{AppFileOperateEnum.TRANSFERPOS.getCtrlKey()});
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.SAVETALENT.getCtrlKey(), AppFileOperateEnum.SAVETALENT_1.getCtrlKey()});
        } else if (hasSaveTalentPerm) {
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.TRANSFERPOS.getCtrlKey(), AppFileOperateEnum.SAVETALENT.getCtrlKey()});
            view.setVisible(Boolean.TRUE, new String[]{AppFileOperateEnum.SAVETALENT_1.getCtrlKey()});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.TRANSFERPOS.getCtrlKey(), AppFileOperateEnum.SAVETALENT.getCtrlKey(), AppFileOperateEnum.SAVETALENT_1.getCtrlKey()});
        }
        notHandleBtnSet.add(AppFileOperateEnum.TRANSFERPOS.getCtrlKey());
        notHandleBtnSet.add(AppFileOperateEnum.SAVETALENT.getCtrlKey());
        notHandleBtnSet.add(AppFileOperateEnum.SAVETALENT_1.getCtrlKey());
    }

    private static boolean hasPerm(AppFileOperateEnum appFileOperateEnum, Map<String, Boolean> hasChecked, IFormView view) {
        Map opInfo;
        String permissionId;
        String entityId = view.getEntityId();
        if (view instanceof IListView) {
            entityId = ((IListView)view).getBillFormId();
        }
        if (HRStringUtils.isNotEmpty((String)(permissionId = (String)(opInfo = EntityMetadataCache.getDataEntityOperate((String)entityId, (String)appFileOperateEnum.getOpRightKey())).get("permission")))) {
            Boolean hasPerm = hasChecked.get(permissionId);
            if (hasPerm == null) {
                hasPerm = PermissionHelper.hasOpPerm((String)entityId, (String)permissionId, (Object)view.getModel().getDataEntity().getPkValue());
                hasChecked.put(permissionId, hasPerm);
            }
            return hasPerm;
        }
        return true;
    }

    public static boolean hasTobeEmployedAppFile(Long mainStdRsmId, Long subStdRsmId) {
        QFilter subQFilter;
        String queryProp = String.join((CharSequence)",", "id", "position.id");
        DynamicObject[] subAppFiles = AppFileHelper.queryAppFiles(queryProp, (subQFilter = AppFileHelper.getAppFileStatusQFilter(subStdRsmId, AppFileConstants.APP_FILE_STATUS_TBEMP)).toArray());
        if (subAppFiles != null && subAppFiles.length > 0) {
            HashSet positionIdSet = Sets.newHashSetWithExpectedSize((int)subAppFiles.length);
            for (DynamicObject dy : subAppFiles) {
                DynamicObject positionDy = dy.getDynamicObject("position");
                if (positionDy == null) continue;
                positionIdSet.add(positionDy.getLong("id"));
            }
            QFilter stdRsmQFilter = new QFilter("stdrsm", "=", (Object)mainStdRsmId);
            QFilter positionQFilter = new QFilter("position", "in", (Object)positionIdSet);
            DynamicObject[] mainAppFiles = AppFileHelper.queryAppFiles(queryProp, stdRsmQFilter.and(positionQFilter).toArray());
            if (mainAppFiles != null && mainAppFiles.length > 0) {
                return true;
            }
        }
        return false;
    }

    private static QFilter getAppFileStatusQFilter(Long stdRsmId, String appFileStatus) {
        QFilter stdRsmQFilter = new QFilter("stdrsm", "=", (Object)stdRsmId);
        QFilter statusQFilter = new QFilter("filestatus", "=", (Object)appFileStatus);
        return stdRsmQFilter.and(statusQFilter);
    }

    public static boolean getAppfileOfStagAndStatIsRef(Long stageId, List<Long> statIds) {
        QFilter qFilter = new QFilter("recrustg", "=", (Object)stageId).and("recrustat", "in", statIds);
        DynamicObject query = APP_FILE_SERVICE_HELPER.queryOne("id", qFilter.toArray());
        QFilter qFilter2 = new QFilter("outrecrustg", "=", (Object)stageId).and("outrecrustat", "in", statIds);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_appfiletrace");
        DynamicObject query2 = hrBaseServiceHelper.queryOne("id", qFilter2);
        return !Objects.isNull(query) || !Objects.isNull(query2);
    }
}

