/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.WebApiContext;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tspr.common.constants.api.ApiCommonConstants;
import kd.tsc.tsrbd.common.dto.TSCBaseResponseDTO;
import kd.tsc.tsrbd.common.enums.TSCErrorCodeEnum;
import org.apache.commons.lang3.tuple.Pair;

public class AppFileOpHelper {
    private static final Log logger = LogFactory.getLog(AppFileOpHelper.class);

    private AppFileOpHelper() {
    }

    public static void handleConfirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent, AbstractFormPlugin plugin) {
        if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            if ("lock".equals(messageBoxClosedEvent.getCallBackId())) {
                plugin.getView().invokeOperation("lock");
            } else if ("unlock".equals(messageBoxClosedEvent.getCallBackId())) {
                plugin.getView().invokeOperation("unlock");
            }
        }
    }

    public static void showFormArrangeInterview(List<Long> appFileIds, AbstractFormPlugin plugin) {
        AppFileOpHelper.showFormArrangeInterview(appFileIds, plugin, null);
    }

    public static void showFormArrangeInterview(List<Long> appFileIds, AbstractFormPlugin plugin, String errorTip) {
        if (!appFileIds.isEmpty()) {
            BaseShowParameter formShowParameter = new BaseShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setFormId("tssrm_argintv");
            formShowParameter.setCustomParam("appFileId", appFileIds);
            Pair<Long, Long> positionAndStage = AppFileHelper.getPositionAndStageByAppFileId(appFileIds.get(0));
            formShowParameter.setCustomParam("position", positionAndStage.getLeft());
            formShowParameter.setCustomParam("recrustg", positionAndStage.getRight());
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5b89\u6392\u9762\u8bd5", (String)"ArrangeIntvOperate_1", (String)"tsc-tspr-business", (Object[])new Object[0]));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "tssrm_argintv"));
            formShowParameter.setShowTitle(true);
            formShowParameter.setCustomParam("errorTip", (Object)errorTip);
            plugin.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public static String getErrorMulTipHead(List<DynamicObject> appFiles) {
        if (appFiles.size() > 3) {
            String tip = AppFileResManagerHelper.getErrorMulTipHeadLocalDesc();
            String one = AppFileOpHelper.getNoName(appFiles.get(0));
            String two = AppFileOpHelper.getNoName(appFiles.get(1));
            String three = AppFileOpHelper.getNoName(appFiles.get(2));
            return String.format(tip, one, two, three, appFiles.size());
        }
        return String.format(Locale.ROOT, "%s", appFiles.stream().map(AppFileOpHelper::getNoName).collect(Collectors.joining("\u3001")));
    }

    public static String getErrorMulTipHead(List<Pair<String, String>> numberNamePairList, boolean isShowNumber) {
        if (numberNamePairList.size() > 3) {
            String three;
            String two;
            String one;
            String tip = AppFileResManagerHelper.getErrorMulTipHeadLocalDesc();
            if (isShowNumber) {
                one = AppFileOpHelper.getNoName((String)numberNamePairList.get(0).getLeft(), (String)numberNamePairList.get(0).getRight());
                two = AppFileOpHelper.getNoName((String)numberNamePairList.get(1).getLeft(), (String)numberNamePairList.get(1).getRight());
                three = AppFileOpHelper.getNoName((String)numberNamePairList.get(2).getLeft(), (String)numberNamePairList.get(2).getRight());
            } else {
                one = (String)numberNamePairList.get(0).getRight();
                two = (String)numberNamePairList.get(1).getRight();
                three = (String)numberNamePairList.get(2).getRight();
            }
            return String.format(tip, one, two, three, numberNamePairList.size());
        }
        if (isShowNumber) {
            return String.format(Locale.ROOT, "%s", numberNamePairList.stream().map(pair -> AppFileOpHelper.getNoName((String)pair.getLeft(), (String)pair.getRight())).collect(Collectors.joining("\u3001")));
        }
        return String.format(Locale.ROOT, "%s", numberNamePairList.stream().map(Pair::getRight).collect(Collectors.joining("\u3001")));
    }

    public static String getNoName(DynamicObject appFile) {
        return AppFileOpHelper.getNoName(appFile.getString("number"), appFile.getString("name"));
    }

    public static String getNoName(String number, String name) {
        return String.format(Locale.ROOT, "%s: %s", number, name);
    }

    public static void showOperationResult(AbstractFormPlugin plugin, AfterDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateName = operate.getOperateName().getLocaleValue();
        logger.info("showOperationResult.opName:{}", (Object)operateName);
        OperationResult operationResult = args.getOperationResult();
        operationResult.setShowMessage(false);
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        if (errorInfos.size() + operationResult.getSuccessPkIds().size() > 1 && !operationResult.getSuccessPkIds().isEmpty()) {
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setFormId("tspr_appfileopresult");
            parameters.setShowTitle(false);
            parameters.setCustomParam("operateName", (Object)operateName);
            Map<Object, Object> pkNumbers = Maps.newHashMap();
            if (operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty()) {
                if (!operationResult.getBillNos().isEmpty()) {
                    pkNumbers.putAll(operationResult.getBillNos());
                } else {
                    pkNumbers = operationResult.getSuccessPkIds().stream().collect(Collectors.toMap(pkId -> pkId, oo -> oo));
                }
            }
            parameters.setCustomParam("pkNumbers", (Object)pkNumbers);
            parameters.setCustomParam("successPkIds", (Object)operationResult.getSuccessPkIds());
            DataEntitySerializerOption option = new DataEntitySerializerOption();
            option.setIncludeComplexProperty(true);
            String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
            parameters.setCustomParam("operationresult", (Object)serialResult);
            int successCount = operationResult.getSuccessPkIds().size();
            String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c\u53ef\u4ee5\u7ee7\u7eed\u8fdb\u884c%2$s%3$s\u6761\uff0c\u5931\u8d25\u7684%4$s\u6761", (String)"AppFileOpHelper_3", (String)"tsc-tspr-business", (Object[])new Object[0]), operationResult.getBillCount(), "", successCount, operationResult.getBillCount() - successCount);
            parameters.setCustomParam("title", (Object)title);
            ArrayList list = Lists.newArrayList();
            int len = errorInfos.size();
            for (int index = 0; index < 5 && index < len; ++index) {
                list.add(((IOperateInfo)errorInfos.get(index)).getMessage());
            }
            parameters.setCustomParam("hasMore", (Object)(errorInfos.size() > 5 ? 1 : 0));
            parameters.setCustomParam("errorMsg", (Object)list);
            parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, operate.getOperateKey() + "operateresult"));
            plugin.getView().showForm(parameters);
        } else {
            plugin.getView().showOperationResult(operationResult);
        }
    }

    public static ValidateResult validateAppFiles(List<Long> appFileIdList, String opName, boolean ignoreNumber) {
        ValidateResult validateResult = new ValidateResult();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("opname", opName);
        operateOption.setVariableValue("ignorenumber", String.valueOf(ignoreNumber));
        OperationResult operationResult = new OperationServiceImpl().localInvokeOperation("validateappfile", "tspr_appfile", appFileIdList.toArray(), operateOption);
        validateResult.setBillNos(operationResult.getBillNos());
        for (IOperateInfo iOperateInfo : operationResult.getAllErrorOrValidateInfo()) {
            validateResult.addErrorInfo((OperateErrorInfo)iOperateInfo);
        }
        validateResult.setSuccessPkIds(operationResult.getSuccessPkIds());
        validateResult.setBillCount(operationResult.getBillCount());
        return validateResult;
    }

    public static String getOpName(OperateOption operateOption, AbstractValidator validator) {
        String opName;
        if (operateOption != null && HRStringUtils.isNotEmpty((String)(opName = operateOption.getVariableValue("opname", null)))) {
            return opName;
        }
        return validator.getOperationName();
    }

    public static List<String> validateKeys(Collection<String> inputKeys) {
        ArrayList noKeys = Lists.newArrayList();
        Set keys = EntityMetadataCache.getDataEntityType((String)"tspr_appfile").getAllFields().keySet();
        for (String key : inputKeys) {
            if (keys.contains(key)) continue;
            noKeys.add(key);
        }
        return noKeys;
    }

    public static TSCBaseResponseDTO getValidateExtFieldsRet(WebApiContext ctx, List<String> extFields, String extField) {
        Object extFieldsObj = ctx.getData().get(extField);
        if (extFieldsObj instanceof String) {
            if (HRStringUtils.isNotEmpty((String)extFieldsObj.toString())) {
                Collections.addAll(extFields, extFieldsObj.toString().split(","));
                List<String> nokeys = AppFileOpHelper.validateKeys(extFields);
                if (!nokeys.isEmpty()) {
                    return TSCBaseResponseDTO.fail((TSCErrorCodeEnum)TSCErrorCodeEnum.PARAM_VERIFICATION_FAILED, (String)ApiCommonConstants.getErrorParamDesc((String)extField));
                }
            }
        } else if (extFieldsObj != null) {
            return TSCBaseResponseDTO.fail((TSCErrorCodeEnum)TSCErrorCodeEnum.PARAM_TYPE_MISMATCH, (String)ApiCommonConstants.getErrorFmtParamDesc((String)extField));
        }
        return null;
    }
}

