/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileOpRecordService;
import kd.tsc.tspr.common.constants.appfile.AppFileConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class AppFileStatusHelper {
    private static final Log logger = LogFactory.getLog(AppFileStatusHelper.class);
    private static final HRBaseServiceHelper RECORD_HELPER = new HRBaseServiceHelper("tspr_appfilestatusrec");

    private AppFileStatusHelper() {
    }

    public static void invalidAppFiles(DynamicObject[] appFiles) {
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        for (DynamicObject appFile : appFiles) {
            appFile.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_INVALID);
            appFile.set("eliminatetime", (Object)nowTime);
            appFile.set("modifytime", (Object)nowTime);
            appFile.set("modifier", (Object)TSCRequestContext.getUserId());
        }
        AppFileHelper.update(appFiles);
        AppFileStatusHelper.addStatusRecordByInvalidOp(Arrays.stream(appFiles).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
    }

    public static void addStatusRecordByInvalidOp(List<Long> appFileIds) {
        DynamicObject[] records = new DynamicObject[appFileIds.size()];
        int index = 0;
        for (Long appFileId : appFileIds) {
            DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFileId, TSCRequestContext.getUserId(), "5", HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            recordDy.set("reason", null);
            recordDy.set("oldfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_INVALID);
            records[index] = recordDy;
            ++index;
        }
        RECORD_HELPER.save(records);
    }

    public static void eliminateAppFile(DynamicObject[] appFiles, String type, Long reasonId, Map<String, String> detailedReason) {
        logger.info("eliminateAppFile.params:{},{},{},{}", new Object[]{appFiles, type, reasonId, detailedReason});
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        logger.info("eliminate appfile start");
        for (DynamicObject dataEntity : appFiles) {
            dataEntity.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_OUT);
            dataEntity.set("eliminatetime", (Object)nowTime);
            dataEntity.set("modifytime", (Object)nowTime);
            dataEntity.set("modifier", (Object)TSCRequestContext.getUserId());
        }
        AppFileHelper.bindAppFileResume(appFiles);
        AppFileHelper.update(appFiles);
        List<Long> appFileIds = Arrays.stream(appFiles).map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
        AppFileStatusHelper.addStatusRecord(appFileIds, type, reasonId, detailedReason);
        AppFileFlowLockHelper.eliminateAppFiles(appFiles);
        List<Long> appFileIdList = Arrays.stream(appFiles).map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
        AppFileOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), OpDefEnum.ELIMINATE, appFileIdList, null);
        logger.info("eliminate appfile end");
    }

    private static void addStatusRecord(List<Long> appFileIds, String type, Long reasonId, Map<String, String> detailedReason) {
        switch (type) {
            case "6": 
            case "2": 
            case "3": {
                AppFileStatusHelper.addStatusRecordByTransferEliminateOp(appFileIds, type);
                break;
            }
            case "1": {
                AppFileStatusHelper.addStatusRecordByEliminateOp(appFileIds, reasonId, detailedReason);
                break;
            }
        }
    }

    public static void addStatusRecordByTransferEliminateOp(List<Long> appFileIds, String type) {
        DynamicObject[] records = new DynamicObject[appFileIds.size()];
        int index = 0;
        for (Long appFileId : appFileIds) {
            DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFileId, TSCRequestContext.getUserId(), type, HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            recordDy.set("reason", null);
            if ("3".equals(type)) {
                recordDy.set("oldfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_OUT);
            } else {
                recordDy.set("oldfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            }
            recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_OUT);
            records[index] = recordDy;
            ++index;
        }
        RECORD_HELPER.save(records);
    }

    public static void addStatusRecordByRecoverOp(List<Long> appFileIds) {
        DynamicObject[] records = new DynamicObject[appFileIds.size()];
        int index = 0;
        for (Long appFileId : appFileIds) {
            DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFileId, TSCRequestContext.getUserId(), "4", HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            recordDy.set("reason", null);
            recordDy.set("detailedreason", (Object)ResManager.loadKDString((String)"\u7cfb\u7edf\u6062\u590d", (String)"AppFileStatusHelper_0", (String)"tsc-tsrbs-business", (Object[])new Object[0]));
            recordDy.set("oldfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_OUT);
            recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            records[index] = recordDy;
            ++index;
        }
        RECORD_HELPER.save(records);
    }

    public static void addStatusRecordByEliminateOp(List<Long> appFileIds, Long reasonId, Map<String, String> detailedReason) {
        DynamicObject[] records = new DynamicObject[appFileIds.size()];
        int index = 0;
        for (Long appFileId : appFileIds) {
            DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFileId, TSCRequestContext.getUserId(), "1", HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            recordDy.set("reason", (Object)reasonId);
            recordDy.set("detailedreason", detailedReason);
            recordDy.set("oldfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_OUT);
            records[index] = recordDy;
            ++index;
        }
        RECORD_HELPER.save(records);
    }

    public static DynamicObject generateStatusRecord(Long appFileId, Long operatorId, String operateType, Date operateTime) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tspr_appfilestatusrec");
        DynamicObject dynamicObject = helper.generateEmptyDynamicObject();
        dynamicObject.set("appFile", (Object)appFileId);
        dynamicObject.set("operator", (Object)operatorId);
        dynamicObject.set("operatetype", (Object)operateType);
        dynamicObject.set("operatetime", (Object)operateTime);
        dynamicObject.set("createtime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        dynamicObject.set("creator", (Object)TSCRequestContext.getUserId());
        return dynamicObject;
    }

    public static void revertInProcess(List<DynamicObject> appFiles) {
        DynamicObject[] records = new DynamicObject[appFiles.size()];
        int index = 0;
        for (DynamicObject appFile : appFiles) {
            appFile.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFile.getLong("id"), TSCRequestContext.getUserId(), "10", HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            recordDy.set("oldfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_TBEMP);
            recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            records[index] = recordDy;
            ++index;
        }
        RECORD_HELPER.save(records);
    }

    public static void setInductionStatus(List<Long> appFileIdList, Map<Long, DynamicObject> idDyMaps, List<Object> inductionStatusList) {
        ArrayList locksAppFileIds = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
        ArrayList unLockAppFiles = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
        ArrayList empedAppFileIds = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
        ArrayList empedAppFileNumbers = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
        ArrayList endEmpAppFileIds = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
        ArrayList endEmpAppFileNumbers = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
        ArrayList statusRecordList = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
        for (int i = 0; i < appFileIdList.size(); ++i) {
            DynamicObject appFile = idDyMaps.get(appFileIdList.get(i));
            if (inductionStatusList.get(i) == null) continue;
            String inductionStatusStr = inductionStatusList.get(i).toString();
            String oldFileStatus = appFile.getString("filestatus");
            if ("1".equals(inductionStatusStr) && AppFileHelper.isInProcess(appFile)) {
                AppFileStatusHelper.setTBEmpData(locksAppFileIds, statusRecordList, appFile, oldFileStatus);
                continue;
            }
            if ("2".equals(inductionStatusStr) && AppFileHelper.isToBeEmployed(appFile)) {
                AppFileStatusHelper.setEmpedData(unLockAppFiles, empedAppFileIds, empedAppFileNumbers, statusRecordList, appFile, oldFileStatus);
                continue;
            }
            if (!"3".equals(inductionStatusStr) || !AppFileHelper.isToBeEmployed(appFile)) continue;
            AppFileStatusHelper.setEndEmpData(unLockAppFiles, endEmpAppFileIds, endEmpAppFileNumbers, statusRecordList, appFile, oldFileStatus);
        }
        logger.debug("setInductionStatus.statusRecordList:{}", (Object)statusRecordList);
        RECORD_HELPER.save(statusRecordList.toArray(new DynamicObject[0]));
        AppFileFlowLockHelper.lockAppFiles(locksAppFileIds, TSCRequestContext.getUserId());
        AppFileFlowLockHelper.unLockEmpedAppFiles(unLockAppFiles);
        AppFileHelper.setLaborTypeAndHireTime(empedAppFileIds, empedAppFileNumbers, idDyMaps);
        AppFileHelper.setEndEmpTime(endEmpAppFileIds, endEmpAppFileNumbers, idDyMaps);
    }

    private static void setEndEmpData(List<DynamicObject> unLockAppFiles, List<Long> endEmpAppFileIds, List<String> endEmpAppFileNumbers, List<DynamicObject> statusRecordList, DynamicObject appFile, String oldFileStatus) {
        appFile.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_ENDEMP);
        unLockAppFiles.add(appFile);
        DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFile.getLong("id"), TSCRequestContext.getUserId(), "9", HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        recordDy.set("oldfilestatus", (Object)oldFileStatus);
        recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_ENDEMP);
        statusRecordList.add(recordDy);
        endEmpAppFileIds.add(appFile.getLong("id"));
        endEmpAppFileNumbers.add(appFile.getString("number"));
    }

    private static void setEmpedData(List<DynamicObject> unLockAppFiles, List<Long> empedAppFileIds, List<String> empedAppFileNumbers, List<DynamicObject> statusRecordList, DynamicObject appFile, String oldFileStatus) {
        appFile.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_EMPED);
        unLockAppFiles.add(appFile);
        empedAppFileIds.add(appFile.getLong("id"));
        empedAppFileNumbers.add(appFile.getString("number"));
        DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFile.getLong("id"), TSCRequestContext.getUserId(), "8", HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        recordDy.set("oldfilestatus", (Object)oldFileStatus);
        recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_EMPED);
        statusRecordList.add(recordDy);
    }

    private static void setTBEmpData(List<Long> locksAppFileIds, List<DynamicObject> statusRecordList, DynamicObject appFile, String oldFileStatus) {
        appFile.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_TBEMP);
        locksAppFileIds.add(appFile.getLong("id"));
        DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFile.getLong("id"), TSCRequestContext.getUserId(), "7", HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        recordDy.set("oldfilestatus", (Object)oldFileStatus);
        recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_TBEMP);
        statusRecordList.add(recordDy);
    }
}

