/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.ProcessInstHelper;
import kd.tsc.tspr.business.domain.intreco.service.IntrecoBusinessHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class ChangeStageStatusHelper {
    private ChangeStageStatusHelper() {
    }

    public static DynamicObjectCollection queryReasonCollection(long statusId) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("tsrbd_recrustatnew");
        QFilter filter = new QFilter("id", "=", (Object)statusId);
        String queryField = "rsnselrecru.id,rsnselrecru.entryid,rsnselrecru.sel,rsnselrecru.reasonnumber";
        DynamicObject[] dynamicObjects = baseServiceHelper.query(queryField, filter.toArray(), "rsnselrecru.seq asc");
        DynamicObjectCollection collection = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection reasonCollection = dynamicObject.getDynamicObjectCollection("rsnselrecru");
            collection.addAll((Collection)reasonCollection);
        }
        return collection;
    }

    public static void saveStageTrace(long stageId, long statusId, long reasonId, DynamicObject[] appFiles) {
        HRBaseServiceHelper traceServiceHelper = new HRBaseServiceHelper("tspr_appfiletrace");
        DynamicObjectCollection saveObjectCollection = new DynamicObjectCollection();
        DynamicObjectCollection saveProcInstCollection = new DynamicObjectCollection();
        long userId = TSCRequestContext.getUserId();
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        for (DynamicObject appFileObject : appFiles) {
            long oldStageId = appFileObject.getLong("recrustg.id");
            long oldStatusId = appFileObject.getLong("recrustat.id");
            if (stageId == oldStageId && statusId == oldStatusId) continue;
            long appFileId = appFileObject.getLong("id");
            DynamicObject saveObject = traceServiceHelper.generateEmptyDynamicObject();
            saveObject.set("appfile", (Object)appFileId);
            ChangeStageStatusHelper.setProcRecord(stageId, statusId, reasonId, saveObject, nowTime, oldStageId, oldStatusId);
            ChangeStageStatusHelper.setProcRecordOfSys(saveObject, userId, nowTime);
            saveObjectCollection.add((Object)saveObject);
            IntrecoBusinessHelper.updateRecommendStatusDate(appFileId, nowTime);
            Object procObj = appFileObject.get("recruproc");
            long procId = procObj instanceof DynamicObject ? ((DynamicObject)procObj).getLong("id") : ((Long)procObj).longValue();
            DynamicObject saveProcInst = ProcessInstHelper.genProcessInst(procId, "tspr_appfile", appFileId);
            saveProcInst.set("bizfid", (Object)appFileId);
            saveProcInst.set("recrustg", (Object)stageId);
            saveProcInst.set("recrustat", (Object)statusId);
            ChangeStageStatusHelper.setProcRecord(stageId, statusId, reasonId, saveProcInst, nowTime, oldStageId, oldStatusId);
            ChangeStageStatusHelper.setProcRecordOfSys(saveObject, userId, nowTime);
            saveProcInstCollection.add((Object)saveProcInst);
        }
        ChangeStageStatusHelper.updateAppFileStage(stageId, statusId, appFiles);
        if (!saveObjectCollection.isEmpty()) {
            traceServiceHelper.save(saveObjectCollection);
        }
        if (!saveProcInstCollection.isEmpty()) {
            traceServiceHelper.save(saveProcInstCollection);
        }
    }

    private static void setProcRecord(long stageId, long statusId, long reasonId, DynamicObject saveObject, Date nowTime, long oldStageId, long oldStatusId) {
        saveObject.set("inrecrustg", (Object)stageId);
        saveObject.set("outrecrustg", (Object)oldStageId);
        saveObject.set("inrecrustat", (Object)statusId);
        saveObject.set("outrecrustat", (Object)oldStatusId);
        saveObject.set("recrursn", (Object)reasonId);
        saveObject.set("inctlinktime", (Object)nowTime);
        saveObject.set("inctstatustime", (Object)nowTime);
    }

    private static void setProcRecordOfSys(DynamicObject saveObject, long userId, Date nowTime) {
        saveObject.set("creator", (Object)userId);
        saveObject.set("createtime", (Object)nowTime);
        saveObject.set("modifier", (Object)userId);
        saveObject.set("modifytime", (Object)nowTime);
    }

    public static void saveStageTraceUpdateAppFile(long stageId, long statusId, long reasonId, DynamicObject[] appFiles) {
        ChangeStageStatusHelper.saveStageTrace(stageId, statusId, reasonId, appFiles);
        AppFileHelper.update(appFiles);
    }

    public static void saveStageTraceNoUpdateAppFile(long stageId, long statusId, long reasonId, DynamicObject[] appFiles) {
        ChangeStageStatusHelper.saveStageTrace(stageId, statusId, reasonId, appFiles);
    }

    private static void updateAppFileStage(long stageId, long statusId, DynamicObject[] appFiles) {
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        for (DynamicObject appFile : appFiles) {
            appFile.set("recrustg", (Object)stageId);
            appFile.set("recrustat", (Object)statusId);
            appFile.set("enterlinktime", (Object)nowTime);
        }
    }

    public static DynamicObjectCollection queryProcessEntryStage(long processId) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        String queryField = "entryentity.id,entryentity.rqmtstg,entryentity.entryid,entryentity.seq,subentryentity.jobstatus,entryentity.subentryentity";
        QFilter qFilter = new QFilter("id", "=", (Object)processId);
        DynamicObject[] processObjects = baseServiceHelper.query(queryField, qFilter.toArray(), "entryentity.seq asc,entryentity.subentryentity.seq asc");
        DynamicObjectCollection stageCollection = new DynamicObjectCollection();
        for (DynamicObject processObject : processObjects) {
            DynamicObjectCollection entryObjectCollection = processObject.getDynamicObjectCollection("entryentity");
            stageCollection.addAll((Collection)entryObjectCollection);
        }
        return stageCollection;
    }

    public static DynamicObject[] queryUser(List<Long> userId) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("bos_user");
        QFilter qFilter = new QFilter("id", "in", userId);
        return baseServiceHelper.query("name,phone", qFilter.toArray(), "id asc");
    }

    public static DynamicObject getStageById(long stageId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_recrustgnew");
        return serviceHelper.queryOne((Object)stageId);
    }

    public static DynamicObject getStatusById(long statusId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_recrustatnew");
        return serviceHelper.queryOne((Object)statusId);
    }
}

