/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class ProcessInstHelper {
    private static final Log logger = LogFactory.getLog(ProcessInstHelper.class);
    private static final String BIZ_FID = "bizfid";
    private static final String BOID = "boid";
    private static final String ENTITY = "entity";
    private static final String RECRUSTGTYP = "recrustgtyp";
    private static final String FIELD_RECRUSTG = "recrustg";

    public static DynamicObject genProcessInst(Long process, String entity, Long bizFid) {
        String boId;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tspr_processinst");
        DynamicObject[] processInstArray = ProcessInstHelper.getProcessInst(process, entity, bizFid);
        DynamicObject processInst = new DynamicObject((DynamicObjectType)entityType);
        if (processInstArray.length > 0) {
            boId = processInstArray[0].getString(BOID);
        } else {
            String uuid = UUID.randomUUID().toString();
            boId = uuid.replaceAll("-", "");
        }
        processInst.set("rqmtproc", (Object)process);
        processInst.set(BOID, (Object)boId);
        processInst.set(ENTITY, (Object)entity);
        processInst.set(BIZ_FID, (Object)bizFid);
        return processInst;
    }

    public static void saveProcessInst(DynamicObject dy) {
        ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_processinst").save(new DynamicObject[]{dy});
    }

    public static DynamicObject[] getProcessInst(Long process, String entity, Long bizFid) {
        QFilter filter = new QFilter("rqmtproc.id", "=", (Object)process);
        filter.and(new QFilter(BIZ_FID, "=", (Object)bizFid));
        if (HRStringUtils.isNotEmpty((String)entity)) {
            filter.and(ENTITY, "=", (Object)entity);
        }
        logger.info("ProcessInstHelper.getProcessInst.filter:[{}]", (Object)filter);
        return ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_processinst").loadDynamicObjectArray(new QFilter[]{filter});
    }

    public static DynamicObject[] getProcessInst(Long process, Long recrustgtyp, Date limitDate) {
        QFilter filter = new QFilter("rqmtproc.id", "=", (Object)process);
        filter.and(FIELD_RECRUSTG, "=", (Object)recrustgtyp);
        if (Objects.nonNull(limitDate)) {
            filter.and(new QFilter("createtime", "<=", (Object)limitDate));
        }
        logger.info("ProcessInstHelper.getProcessInst.filter:[{}]", (Object)filter);
        return ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_processinst").loadDynamicObjectArray(new QFilter[]{filter});
    }

    public static DynamicObject[] getProcessInstDysByStage(Long process, List<Long> stageIds) {
        QFilter filter = new QFilter("rqmtproc.id", "=", (Object)process);
        filter.and("recrustg.id", "in", stageIds);
        return ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_processinst").loadDynamicObjectArray(new QFilter[]{filter});
    }
}

