/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.form;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tspr.business.domain.bgsurvey.service.BackgroundSurveyDomainService;
import kd.tsc.tspr.business.domain.exam.service.ExamDomainService;
import kd.tsc.tspr.common.constants.appfile.AppFileOperateEnum;
import kd.tsc.tspr.common.constants.appfile.AppFileTabEnum;
import kd.tsc.tspr.common.constants.label.AppfileLabelShowParam;
import kd.tsc.tsrbd.business.domain.perm.PermissionHelper;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbs.business.domain.rsm.common.RsmCommonService;
import org.apache.commons.collections.CollectionUtils;

public class AppFileTabHelper {
    private static final Log LOG = LogFactory.getLog(AppFileTabHelper.class);
    private static final String SUB_VIEW_STATUS = "subViewStatus";

    public static void previewOriginalResume(Object appFileId, String originFlex, DynamicObject appRes, String targetKey, IFormView view, boolean isSkipCheckPerm) {
        RsmCommonService.getInstance().previewOriginalResume(appFileId, originFlex, appRes, targetKey, view, isSkipCheckPerm);
    }

    public static void showAppResPage(String targetKey, String cacheKey, AbstractFormPlugin plugin, DynamicObject appRes, OperationStatus subViewStatus) {
        BaseShowParameter appResShowParameter = new BaseShowParameter();
        appResShowParameter.setPkId(appRes.getPkValue());
        appResShowParameter.setFormId("tstpm_srrsm_layout");
        appResShowParameter.setStatus(subViewStatus);
        appResShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        appResShowParameter.setSendToClient(true);
        appResShowParameter.getOpenStyle().setTargetKey(targetKey);
        appResShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "tstpm_srrsm"));
        plugin.getView().showForm((FormShowParameter)appResShowParameter);
        plugin.getPageCache().put(cacheKey, appResShowParameter.getPageId());
    }

    public static void showAppResPage(String targetKey, String cacheKey, AbstractFormPlugin plugin, DynamicObject appRes, OperationStatus subViewStatus, String formId) {
        BaseShowParameter appResShowParameter = new BaseShowParameter();
        appResShowParameter.setPkId(appRes.getPkValue());
        appResShowParameter.setFormId(formId);
        appResShowParameter.setStatus(subViewStatus);
        appResShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        appResShowParameter.setSendToClient(true);
        appResShowParameter.getOpenStyle().setTargetKey(targetKey);
        appResShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "tstpm_srrsm"));
        plugin.getView().showForm((FormShowParameter)appResShowParameter);
        plugin.getPageCache().put(cacheKey, appResShowParameter.getPageId());
    }

    public static void showExamWrittenTab(Long appFileId, String targetKey, IFormView view, OperationStatus subViewStatus) {
        if (ExamDomainService.existWrittenDataByAppFileId(appFileId)) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("tssrm_examwritten");
            AppFileTabHelper.openTabForm(appFileId, targetKey, view, subViewStatus, listShowParameter);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{targetKey});
        }
    }

    public static void showExaminationTab(Long appFileId, String targetKey, IFormView view, OperationStatus subViewStatus) {
        if (ExamDomainService.existExaminationDataByAppFileId(appFileId)) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("tssrm_examination");
            AppFileTabHelper.openTabForm(appFileId, targetKey, view, subViewStatus, listShowParameter);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{targetKey});
        }
    }

    private static void openTabForm(Long appFileId, String targetKey, IFormView view, OperationStatus subViewStatus, ListShowParameter listShowParameter) {
        listShowParameter.setFormId("tssrm_otherappfilelist");
        listShowParameter.setCustomParam("appFileId", (Object)appFileId);
        listShowParameter.setStatus(subViewStatus);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.setSendToClient(true);
        listShowParameter.getOpenStyle().setTargetKey(targetKey);
        view.showForm((FormShowParameter)listShowParameter);
        view.setVisible(Boolean.TRUE, new String[]{targetKey});
    }

    public static void initAssessTab(String tabKey, String intvTargetKey, String filterTargetKey, Long appFileId, IFormView view, OperationStatus subViewStatus) {
        Boolean isShowAssessTab = AppFileTabHelper.hasIntvData(appFileId) || AppFileTabHelper.hasFilterData(appFileId);
        view.setVisible(isShowAssessTab, new String[]{tabKey});
        if (isShowAssessTab.booleanValue()) {
            AppFileTabHelper.initInterviewAssess(intvTargetKey, appFileId, view, subViewStatus);
            AppFileTabHelper.initFilterFeedback(filterTargetKey, appFileId, view, subViewStatus);
        }
    }

    public static void initInterviewAssess(String targetKey, long appFileId, IFormView view, OperationStatus subViewStatus) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tssrm_assessment");
        showParameter.setCustomParam("applicationid", (Object)String.valueOf(appFileId));
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setCustomParam(SUB_VIEW_STATUS, (Object)subViewStatus.getValue());
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setSendToClient(true);
        view.showForm(showParameter);
    }

    public static void initInterviewAssessTab(String targetKey, long appFileId, IFormView view, boolean isSkipCheckPerm) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_intveval");
        QFilter qFilter = new QFilter("appfile.id", "in", (Object)appFileId);
        Object[] interassDys = serviceHelper.query(new QFilter[]{qFilter}, "createtime desc");
        if (HRArrayUtils.isEmpty((Object[])interassDys)) {
            view.setVisible(Boolean.FALSE, new String[]{"panel_interview", "evalflex"});
            view.setVisible(Boolean.TRUE, new String[]{"nointerassflex", "noevalletter"});
            return;
        }
        long interAssId = interassDys[0].getLong("id");
        List attachments = AttachmentServiceHelper.getAttachments((String)"tspr_intveval", (Object)interAssId, (String)"attachmentpanelap");
        if (CollectionUtils.isEmpty((Collection)attachments)) {
            view.setVisible(Boolean.FALSE, new String[]{"panel_interview", "evalflex"});
            view.setVisible(Boolean.TRUE, new String[]{"nointerassflex", "noevalletter"});
            return;
        }
        String filePath = (String)((Map)attachments.get(0)).get("relativeUrl");
        if (HRStringUtils.isEmpty((String)filePath)) {
            view.setVisible(Boolean.FALSE, new String[]{"panel_interview", "evalflex"});
            view.setVisible(Boolean.TRUE, new String[]{"nointerassflex", "noevalletter"});
            return;
        }
        RsmCommonService.previewFile((String)filePath, (String)targetKey, (IFormView)view, (String)"tsrsc_interassfile", (boolean)isSkipCheckPerm);
        view.setVisible(Boolean.TRUE, new String[]{"panel_interview", "evalflex"});
        view.setVisible(Boolean.FALSE, new String[]{"nointerassflex", "noevalletter"});
    }

    public static void initFilterFeedback(String targetKey, long appFileId, IFormView view, OperationStatus subViewStatus) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsivp_rsmfl_feedbacklist");
        showParameter.setCustomParam("appFileId", (Object)appFileId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setStatus(subViewStatus);
        showParameter.setCustomParam(SUB_VIEW_STATUS, (Object)subViewStatus.getValue());
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setSendToClient(true);
        view.showForm(showParameter);
    }

    public static void initHireTab(String targetKey, DynamicObject dataEntity, IFormView view, OperationStatus subViewStatus) {
        Long appFileId = dataEntity.getLong("id");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tssrm_hireinappfile");
        showParameter.setCustomParam("appFileId", (Object)appFileId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setStatus(subViewStatus);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setSendToClient(true);
        view.showForm(showParameter);
        view.setVisible(Boolean.TRUE, new String[]{targetKey});
    }

    public static void initOtherTab(String targetKey, DynamicObject dataEntity, IFormView view) {
        Long stdRsmMid = dataEntity.getLong("stdrsm.mid");
        Long id = dataEntity.getLong("id");
        LOG.debug("initOtherTab.id:", (Object)id);
        int otherAppCount = AppFileDataHelper.queryOtherAppCount(stdRsmMid, id);
        if (otherAppCount == 0) {
            view.setVisible(Boolean.FALSE, new String[]{targetKey});
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{targetKey});
        String otherCount = otherAppCount >= 100 ? "99+" : String.valueOf(otherAppCount);
        ((TabPage)view.getControl(targetKey)).setText(new LocaleString(String.format(Locale.ROOT, AppFileResManagerHelper.getOtherAppFileDesc(), otherCount)));
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey(targetKey);
        listShowParameter.setFormId("tssrm_otherappfilelist");
        listShowParameter.setBillFormId("tssrm_appfile_otherlist");
        listShowParameter.setSendToClient(true);
        listShowParameter.setCustomParam("stdrsm.mid", (Object)stdRsmMid);
        listShowParameter.setCustomParam("id", (Object)id);
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static void initOfferTab(String targetKey, DynamicObject dataEntity, IFormView view, OperationStatus subViewStatus) {
        Boolean isShowOffer = Boolean.FALSE;
        try {
            isShowOffer = (Boolean)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tso", (String)"offerBaseServiceApi", (String)"hasOfferData", (Object[])new Object[]{dataEntity.getLong("id")});
        }
        catch (Exception ex) {
            LOG.error("offerBaseServiceApi.hasOfferData.error:", (Throwable)ex);
            view.showErrorNotification("offerBaseServiceApi.hasOfferData.error");
        }
        if (isShowOffer.booleanValue()) {
            FormShowParameter showParameter = new FormShowParameter();
            String formId = "tso_offerinfocard";
            if (subViewStatus == OperationStatus.VIEW) {
                formId = "tso_offerinfocard_view";
            }
            showParameter.setFormId(formId);
            showParameter.setCustomParam("appfile", (Object)dataEntity.getLong("id"));
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.setStatus(subViewStatus);
            showParameter.getOpenStyle().setTargetKey(targetKey);
            showParameter.setSendToClient(true);
            view.showForm(showParameter);
        }
        view.setVisible(isShowOffer, new String[]{targetKey});
    }

    public static void initOpRecordTab(String targetKey, DynamicObject dataEntity, IFormView view) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("bizobj", (Object)dataEntity.getString("id"));
        parameter.setCustomParam("entitytype", (Object)"tspr_appfile");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.setFormId("tsrbs_oprecord_list");
        parameter.getOpenStyle().setTargetKey(targetKey);
        parameter.setSendToClient(true);
        view.showForm(parameter);
    }

    private static boolean hasIntvData(Long appFileId) {
        HRBaseServiceHelper intvHelper = new HRBaseServiceHelper("tspr_argintv");
        return intvHelper.isExists(new QFilter("intvcandate.fbasedataid", "=", (Object)appFileId));
    }

    private static boolean hasFilterData(Long appFileId) {
        HRBaseServiceHelper filterHelper = new HRBaseServiceHelper("tspr_resumefilter");
        return filterHelper.isExists(new QFilter("appfile", "=", (Object)appFileId));
    }

    public static boolean isShowOriginResumeTab(DynamicObject appFile) {
        return HRStringUtils.isNotEmpty((String)appFile.getString("appres.resumestoadd"));
    }

    public static boolean isShowAssessInfoTab(DynamicObject appFile) {
        Long appFileId = appFile.getLong("id");
        return AppFileTabHelper.hasIntvData(appFileId) || AppFileTabHelper.hasFilterData(appFileId);
    }

    public static void showBGCheck(DynamicObject appfile, IFormView view, OperationStatus subViewStatus) {
        Long appFileId = (Long)appfile.getPkValue();
        DynamicObject backgroundSurvey = BackgroundSurveyDomainService.getBackgroundSurveyByAppFile(appFileId);
        if (backgroundSurvey != null) {
            String permItemId;
            String formId = view.getEntityId();
            if (PermissionHelper.hasOpPerm((String)formId, (String)(permItemId = "2C8JVDE25MYW"), (Object)appFileId)) {
                BaseShowParameter showParameter = new BaseShowParameter();
                showParameter.setFormId("tssrm_bakgroundsurvey");
                showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.getOpenStyle().setTargetKey(AppFileTabEnum.BG_CHECK.getTabKey());
                showParameter.setSendToClient(true);
                showParameter.setPkId(backgroundSurvey.getPkValue());
                view.showForm((FormShowParameter)showParameter);
                view.setVisible(Boolean.valueOf(true), new String[]{AppFileTabEnum.BG_CHECK.getTabKey()});
                view.setVisible(Boolean.valueOf(false), new String[]{AppFileOperateEnum.BARBGCHECK.getCtrlKey()});
            } else {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("tssrm_backgroundnoperm");
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                formShowParameter.setStatus(OperationStatus.VIEW);
                formShowParameter.getOpenStyle().setTargetKey(AppFileTabEnum.BG_CHECK.getTabKey());
                formShowParameter.setSendToClient(true);
                view.showForm(formShowParameter);
                view.setVisible(Boolean.valueOf(true), new String[]{AppFileTabEnum.BG_CHECK.getTabKey()});
            }
        } else {
            view.setVisible(Boolean.valueOf(AppFileTabHelper.isShowBGCheckTab(appfile)), new String[]{AppFileTabEnum.BG_CHECK.getTabKey()});
        }
    }

    public static boolean isShowBGCheckTab(DynamicObject appFile) {
        return false;
    }

    public static void showAppFileLabelPage(IFormView view, DynamicObject appFile, boolean isShowButton, boolean isHideMoreBtn, List<String> excludeCategorys) {
        FormShowParameter viewParameter = view.getFormShowParameter();
        LOG.info("showAppFileLabelPage.view.params:{}", (Object)viewParameter.getCustomParams());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrbd_label_show");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("labelshowflex");
        showParameter.setCustomParam("id", (Object)appFile.getLong("id"));
        showParameter.setCustomParam("type", (Object)String.valueOf(LabelTagObjTypeEnum.APPFILE.getId()));
        HashMap pairMap = Maps.newHashMap();
        pairMap.put(String.valueOf(LabelTagObjTypeEnum.OUT_RESUME.getId()), appFile.getString("appres.id"));
        showParameter.setCustomParam("typeIdList", (Object)pairMap);
        showParameter.setCustomParam("isshowbutton", (Object)isShowButton);
        showParameter.setCustomParam("ishidemorebtn", (Object)isHideMoreBtn);
        showParameter.setCustomParam("useorg", viewParameter.getCustomParam("useorg"));
        showParameter.setCustomParam("pagetype", (Object)"detail");
        showParameter.setSendToClient(true);
        showParameter.setCustomParam("excludeCategorys", excludeCategorys);
        view.showForm(showParameter);
    }

    public static void showAppFileListLabelPage(IFormView view, DynamicObject appFile, List<String> excludeCategorys) {
        FormShowParameter viewParameter = view.getFormShowParameter();
        LOG.info("showAppFileLabelPage.view.params:{}", (Object)viewParameter.getCustomParams());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrbd_label_show");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("labelshowflex");
        showParameter.setCustomParam("id", (Object)appFile.getLong("id"));
        showParameter.setCustomParam("type", (Object)String.valueOf(LabelTagObjTypeEnum.APPFILE.getId()));
        HashMap pairMap = Maps.newHashMap();
        pairMap.put(String.valueOf(LabelTagObjTypeEnum.OUT_RESUME.getId()), appFile.getString("appres.id"));
        showParameter.setCustomParam("typeIdList", (Object)pairMap);
        showParameter.setCustomParam("isshowbutton", (Object)false);
        showParameter.setCustomParam("ishidemorebtn", (Object)false);
        showParameter.setCustomParam("useorg", viewParameter.getCustomParam("useorg"));
        showParameter.setSendToClient(true);
        showParameter.setCustomParam("excludeCategorys", excludeCategorys);
        view.showForm(showParameter);
    }

    public static void showAppFileDefaultLabelPage(AppfileLabelShowParam appfileLabelShowParam) {
        FormShowParameter viewParameter = appfileLabelShowParam.getView().getFormShowParameter();
        LOG.info("showAppFileLabelPage.view.params:{}", (Object)viewParameter.getCustomParams());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrbd_label_show_default");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("labelshowflex");
        showParameter.setCustomParam("id", (Object)appfileLabelShowParam.getAppFile().getLong("id"));
        showParameter.setCustomParam("type", (Object)String.valueOf(LabelTagObjTypeEnum.APPFILE.getId()));
        showParameter.setCustomParam("aiId", (Object)appfileLabelShowParam.getAppFile().getString("appres.id"));
        showParameter.setCustomParam("aiTypeId", (Object)String.valueOf(LabelTagObjTypeEnum.OUT_RESUME.getId()));
        HashMap pairMap = Maps.newHashMap();
        pairMap.put(String.valueOf(LabelTagObjTypeEnum.OUT_RESUME.getId()), appfileLabelShowParam.getAppFile().getString("appres.id"));
        showParameter.setCustomParam("typeIdList", (Object)pairMap);
        showParameter.setCustomParam("isCanEditLabel", (Object)appfileLabelShowParam.getCanEditLabel());
        showParameter.setCustomParam("isShowMyLabel", (Object)appfileLabelShowParam.getShowMyLabel());
        showParameter.setCustomParam("isFold", (Object)appfileLabelShowParam.getFold());
        showParameter.setCustomParam("useorg", (Object)appfileLabelShowParam.getOrgId());
        showParameter.setCustomParam("pagetype", (Object)"detail");
        showParameter.setSendToClient(true);
        if (appfileLabelShowParam.getExcludeCategorys() == null) {
            showParameter.setCustomParam("excludeCategorys", (Object)Lists.newArrayList((Object[])new String[]{"C"}));
        } else {
            appfileLabelShowParam.getExcludeCategorys().add("C");
            showParameter.setCustomParam("excludeCategorys", (Object)appfileLabelShowParam.getExcludeCategorys());
        }
        appfileLabelShowParam.getView().showForm(showParameter);
        String rootPageId = appfileLabelShowParam.getView().getFormShowParameter().getRootPageId();
        String pageId = appfileLabelShowParam.getView().getFormShowParameter().getPageId();
        appfileLabelShowParam.getView().getPageCache().put(rootPageId + pageId + "tsrbd_label_show_default", showParameter.getPageId());
    }

    public static void showBGCheck(DynamicObject appfile, IFormView view) {
        view.setVisible(Boolean.valueOf(AppFileTabHelper.isShowBGCheckTab(appfile)), new String[]{AppFileTabEnum.BG_CHECK.getTabKey()});
    }

    public static void activeTab(IFormView view, AppFileTabEnum tabEnum) {
        Tab tabAp = (Tab)view.getControl("tabap");
        tabAp.activeTab(tabEnum.getTabKey());
    }
}

