/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.list;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFilePositionHelper;
import kd.tsc.tspr.common.constants.appfile.AppFileConstants;
import kd.tsc.tspr.common.constants.appfile.AppFileListConstants;
import kd.tsc.tspr.common.constants.appfile.AppFileOperateEnum;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.business.domain.process.helper.ProcessConfigModalHelper;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbs.common.utils.ListViewUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AppFileListHelper {
    private static final Log logger = LogFactory.getLog(AppFileListHelper.class);
    private static final List<String> LIST_ALL_OPERATES = Lists.newArrayList((Object[])new String[]{AppFileOperateEnum.OPENFILLRESADD.getCtrlKey(), AppFileOperateEnum.ANALYSISRESADD.getCtrlKey(), AppFileOperateEnum.ADDTAG.getCtrlKey(), AppFileOperateEnum.REMOVETAG.getCtrlKey(), AppFileOperateEnum.TRANSFERPOS.getCtrlKey(), AppFileOperateEnum.SAVETALENT.getCtrlKey(), AppFileOperateEnum.CHANGESTAGE.getCtrlKey(), AppFileOperateEnum.ELIMINATE.getCtrlKey(), AppFileOperateEnum.RECOVER.getCtrlKey(), AppFileOperateEnum.LOCK.getCtrlKey(), AppFileOperateEnum.FILTER.getCtrlKey(), AppFileOperateEnum.ARRANGEANINTERVIEW.getCtrlKey(), AppFileOperateEnum.HIRERECOMEND.getCtrlKey(), AppFileOperateEnum.HIREJOBRANK.getCtrlKey(), AppFileOperateEnum.HIRESALARY.getCtrlKey(), AppFileOperateEnum.HIREAPPROVAL.getCtrlKey()});

    private AppFileListHelper() {
    }

    public static void reload(AbstractListPlugin listPlugin) {
        if (listPlugin.getView() instanceof ListView) {
            ((ListView)listPlugin.getView()).refresh();
        }
        AppFileListHelper.refreshChildViews(listPlugin);
    }

    public static void refreshChildViews(AbstractListPlugin listPlugin) {
        String childViewStr = listPlugin.getView().getPageCache().get("childviews");
        if (HRStringUtils.isNotEmpty((String)childViewStr)) {
            Map childViews = (Map)SerializationUtils.fromJsonString((String)childViewStr, Map.class);
            for (String childViewPageId : childViews.values()) {
                IFormView view = listPlugin.getView().getView(childViewPageId);
                if (view == null) continue;
                view.invokeOperation("refresh");
                listPlugin.getView().sendFormAction(view);
            }
        }
    }

    public static boolean verifySameRecruitmentProcess(List<Long> appFileIds) {
        if (appFileIds == null || appFileIds.isEmpty()) {
            return false;
        }
        HRBaseServiceHelper dbServiceAppFile = new HRBaseServiceHelper("tspr_appfile");
        DynamicObject[] appFiles = dbServiceAppFile.query("recruproc.id", new QFilter("id", "in", appFileIds).toArray());
        if (appFiles == null || appFiles.length == 0) {
            return false;
        }
        boolean result = true;
        Long recruitmentProcessId = null;
        for (DynamicObject appFile : appFiles) {
            Long eachDataRecruitmentProcessId = appFile.getLong("recruproc.id");
            if (recruitmentProcessId == null) {
                recruitmentProcessId = appFile.getLong("recruproc.id");
                continue;
            }
            if (eachDataRecruitmentProcessId.equals(recruitmentProcessId)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static List<Long> getAfterDoOpPkIds(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperationResult() != null) {
            return afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().stream().map(pkId -> (Long)pkId).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public static List<Long> getSelectPkIds(AbstractListPlugin plugin) {
        return ListViewUtils.getSelectPkIds((AbstractListPlugin)plugin);
    }

    public static List<Long> getSelectedPkList(AbstractListPlugin plugin, List<Long> pkList) {
        return ListViewUtils.getSelectedPkList((AbstractListPlugin)plugin, pkList);
    }

    public static QFilter getIsInProcessQFilter() {
        return new QFilter("filestatus", "in", (Object)AppFileConstants.APP_FILE_STATUS_IN);
    }

    public static QFilter getFlowLockQFilter() {
        QFilter unLockQFilter = new QFilter("stdrsm.id", "not in", AppFileFlowLockHelper.getLockKeys());
        QFilter lockedQFilter = new QFilter("id", "in", AppFileFlowLockHelper.getLockedAppFileIdList());
        logger.info("getFlowLockQFilter.qfilter:{},{}", (Object)unLockQFilter, (Object)lockedQFilter);
        return unLockQFilter.or(lockedQFilter);
    }

    public static void setCommonLabelQFilter(SetFilterEvent setFilterEvent, String labelIdStr) {
        String labelRangeAppFileSQL = " ( select ftagobjid from t_tspr_label_tagobj where flabelid in (" + labelIdStr + ") and ftagobjtypeid = " + LabelTagObjTypeEnum.APPFILE.getId() + " )";
        String labelRangeResumeSQL = " ( select ftagobjid from t_tstpm_rsmlabel where flabelid in (" + labelIdStr + ") and ftagobjtypeid = " + LabelTagObjTypeEnum.OUT_RESUME.getId() + " )";
        logger.info("handleCommonFilter.labelIdStr {}", (Object)labelIdStr);
        QFilter labelQFilter = QFilter.sqlExpress((String)"id", (String)"in", (String)labelRangeAppFileSQL).or(QFilter.sqlExpress((String)"appres", (String)"in", (String)labelRangeResumeSQL));
        setFilterEvent.getQFilters().add(labelQFilter);
    }

    public static QFilter getLabelSchemaFilter(QFilter qFilter) {
        QFilter newCandidateSchameQfilter;
        qFilter.__setProperty("name");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbd_label");
        qFilter.and(LabelDataHelper.getLabelQfilter((List)Lists.newArrayList((Object[])new Long[]{LabelTagObjTypeEnum.APPFILE.getId(), LabelTagObjTypeEnum.OUT_RESUME.getId()})));
        DynamicObjectCollection labelColl = helper.queryOriginalCollection("id", qFilter.toArray());
        if (labelColl.isEmpty()) {
            newCandidateSchameQfilter = new QFilter("1", "!=", (Object)1);
        } else {
            String labelIdStr = labelColl.stream().map(dyo -> dyo.getString("id")).collect(Collectors.joining(","));
            String labelAppFileSqlFmt = " ( select ftagobjid from t_tspr_label_tagobj where flabelid in (%s) and ftagobjtypeid = %s )";
            String labelRangeAppFileSQL = String.format(labelAppFileSqlFmt, labelIdStr, LabelTagObjTypeEnum.APPFILE.getId());
            String labelResumeSqlFmt = " ( select ftagobjid from t_tstpm_rsmlabel where flabelid in (%s) and ftagobjtypeid = %s )";
            String labelRangeResumeSQL = String.format(labelResumeSqlFmt, labelIdStr, LabelTagObjTypeEnum.OUT_RESUME.getId());
            newCandidateSchameQfilter = QFilter.sqlExpress((String)"id", (String)"in", (String)labelRangeAppFileSQL).or(QFilter.sqlExpress((String)"appres", (String)"in", (String)labelRangeResumeSQL));
        }
        return newCandidateSchameQfilter;
    }

    public static void handleOperateBtnAndField(long procId, long stgId, Map<String, Integer> colMap, Pair<Collection<String>, Collection<String>> operationVisibleTuple) {
        logger.info("handleOperateBtnAndField.start.params:{},{}", (Object)procId, (Object)stgId);
        AppFileListHelper.handleOperateVisible(procId, stgId, operationVisibleTuple);
        AppFileListHelper.handleFieldVisible(procId, stgId, colMap);
        logger.info("handleOperateBtnAndField.result\uff1a{},{}", colMap, operationVisibleTuple);
    }

    public static void handleFieldVisible(long procId, long stgId, Map<String, Integer> colMap) {
        DynamicObject[] fieldConfigs;
        for (DynamicObject fieldConfig : fieldConfigs = ProcessConfigModalHelper.getFieldConfig((Long)procId, (Long)stgId, (Long)1020L)) {
            int isDisplay = fieldConfig.getBoolean("isdisplay") ? 11 : 10;
            colMap.put(fieldConfig.getString("field.ctrlkey"), isDisplay);
        }
        logger.debug("handleFieldVisible.res:{},{},{}", new Object[]{procId, stgId, colMap});
    }

    public static void handleOperateVisible(long procId, long stgId, Pair<Collection<String>, Collection<String>> operationVisibleTuple) {
        DynamicObject[] operateConfigs = ProcessConfigModalHelper.getOperateConfig((Long)procId, (Long)stgId, (Long)1020L);
        Set visibleOpSet = Arrays.stream(operateConfigs).filter(cfg -> cfg.getBoolean("islistdisplay")).map(cfg -> cfg.getString("operate.ctrlkey")).collect(Collectors.toSet());
        for (String operate : LIST_ALL_OPERATES) {
            if (visibleOpSet.contains(operate)) {
                ((Collection)operationVisibleTuple.getLeft()).add(operate);
                continue;
            }
            ((Collection)operationVisibleTuple.getRight()).add(operate);
        }
        logger.debug("handleOperateVisible.res:{},{},{}", new Object[]{procId, stgId, operationVisibleTuple});
    }

    public static boolean handleOutMaxSelectNum(AbstractListPlugin listPlugin, int maxSelectedNums) {
        BillList billList = (BillList)listPlugin.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() > maxSelectedNums) {
            listPlugin.getView().showTipNotification(String.format(Locale.ROOT, AppFileResManagerHelper.getMaxNumSelectTip(), maxSelectedNums));
            return true;
        }
        return false;
    }

    public static void validateCurrOpIsExist(AbstractListPlugin listPlugin, BeforeItemClickEvent evt) {
        if (HRStringUtils.isEmpty((String)evt.getOperationKey()) || "refresh".equals(evt.getOperationKey()) || "close".equals(evt.getOperationKey())) {
            return;
        }
        for (AppFileOperateEnum value : AppFileOperateEnum.values()) {
            if (!evt.getOperationKey().startsWith(value.getOpKey())) continue;
            long[] procInfoArr = AppFileListHelper.getProcIdAndStgId(listPlugin);
            long procId = procInfoArr[0];
            long stgId = procInfoArr[1];
            Pair operationVisibleTuple = Pair.of((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
            AppFileListHelper.handleOperateVisible(procId, stgId, (Pair<Collection<String>, Collection<String>>)operationVisibleTuple);
            if (!((Collection)operationVisibleTuple.getLeft()).stream().noneMatch(ctrlKey -> value.getCtrlKey().equals(ctrlKey))) break;
            listPlugin.getView().showTipNotification(AppFileResManagerHelper.getDataChangedTip());
            evt.setCancel(true);
            break;
        }
    }

    public static long[] getProcIdAndStgId(AbstractListPlugin listPlugin) {
        long[] procInfoArr = new long[2];
        String posIdStr = listPlugin.getPageCache().get(AppFileListConstants.KET_FILTER_POSITION_ID);
        if (HRStringUtils.isNotEmpty((String)posIdStr)) {
            long positionId = Long.parseLong(posIdStr);
            String stgIdStr = listPlugin.getPageCache().get(AppFileListConstants.KET_FILTER_RECRUSTG_ID);
            DynamicObject positionManage = AppFilePositionHelper.queryManageInfo(positionId, "recruproc");
            if (positionManage != null) {
                procInfoArr[0] = positionManage.getLong("recruproc.id");
                if (HRStringUtils.isNotEmpty((String)stgIdStr)) {
                    procInfoArr[1] = Long.parseLong(stgIdStr);
                }
            }
        }
        return procInfoArr;
    }

    public static void putProcInfoToCache(AbstractListPlugin listPlugin, long positionId, long stgId) {
        if (positionId != 0L) {
            listPlugin.getPageCache().put(AppFileListConstants.KET_FILTER_POSITION_ID, String.valueOf(positionId));
            listPlugin.getPageCache().put(AppFileListConstants.KET_FILTER_RECRUSTG_ID, String.valueOf(stgId));
        } else {
            listPlugin.getPageCache().remove(AppFileListConstants.KET_FILTER_POSITION_ID);
            listPlugin.getPageCache().remove(AppFileListConstants.KET_FILTER_RECRUSTG_ID);
        }
    }

    public static void setListFieldVisible(BillList billList, Map<String, Integer> tplAllColMap) {
        List items = billList.getItems();
        if (!items.isEmpty() && items.get(0) instanceof ListGridView) {
            ListGridView listGridView = (ListGridView)items.get(0);
            List listColumns = listGridView.getItems();
            for (Control control : listColumns) {
                IListColumn listColumn = (IListColumn)control;
                Integer visibleIntVal = tplAllColMap.get(listColumn.getListFieldKey());
                if (visibleIntVal != null) {
                    listColumn.setVisible(visibleIntVal.intValue());
                    continue;
                }
                listColumn.setVisible(10);
            }
        }
    }
}

