/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.list;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.list.DicConvertHelper;
import kd.tsc.tspr.business.domain.appfile.list.entity.AppFileListDetailViewVO;
import kd.tsc.tsrbs.business.domain.rsm.service.CandidateSortHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;
import org.apache.commons.lang3.StringUtils;

public class AppFileListViewDetailHelper {
    private static final int YEAR_MONTH = 12;

    private AppFileListViewDetailHelper() {
    }

    public static AppFileListDetailViewVO getAppFileListDetailViewVOByAppRsmId(Long appRsmId) {
        if (appRsmId == null || appRsmId == 0L) {
            return null;
        }
        AppFileListDetailViewVO appFileListDetailViewVO = new AppFileListDetailViewVO(true);
        HRBaseServiceHelper dbServiceRsm = new HRBaseServiceHelper("tstpm_srrsm");
        String queryColumn = "photo ,gender ,age ,workingyears ,highesteduschool.name ,highestspecialty ,highesteducation.name ,workstartdate ,workendingdate ,workcreatetime ,positionname ,companyname,lengthofwork,photo";
        DynamicObject resumeDyn = dbServiceRsm.queryOne(queryColumn, (Object)appRsmId);
        if (resumeDyn == null) {
            return appFileListDetailViewVO;
        }
        appFileListDetailViewVO.setHeadAddress(resumeDyn.getString("photo"));
        appFileListDetailViewVO.setSex(DicConvertHelper.getResumeGender().get(resumeDyn.getString("gender")));
        if (resumeDyn.getInt("age") > 0) {
            String age = ResManager.loadKDString((String)"%s\u5c81", (String)"AppFileListViewDetailHelper_0", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            appFileListDetailViewVO.setAge(String.format(Locale.ROOT, age, resumeDyn.getInt("age")));
        }
        if (resumeDyn.getInt("workingyears") > 0) {
            String workExp = ResManager.loadKDString((String)"%s\u5de5\u4f5c\u7ecf\u9a8c", (String)"AppFileListViewDetailHelper_1", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            appFileListDetailViewVO.setWorkYears(String.format(Locale.ROOT, workExp, ResumeAnalysisHelper.getWorkYearShow((int)resumeDyn.getInt("workingyears"))));
        }
        appFileListDetailViewVO.setSchool(resumeDyn.getString("highesteduschool.name"));
        appFileListDetailViewVO.setMajor(resumeDyn.getString("highestspecialty"));
        appFileListDetailViewVO.setDegree(resumeDyn.getString("highesteducation.name"));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tstpm_srrsmworkexp");
        DynamicObjectCollection workCollections = helper.queryOriginalCollection(TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"positionname", "companyname", "startdate", "endingdate", "createtime"}), new QFilter[]{new QFilter("rsm", "=", resumeDyn.getPkValue())});
        AppFileListViewDetailHelper.setWorkExp(appFileListDetailViewVO, workCollections);
        return appFileListDetailViewVO;
    }

    private static void setWorkExp(AppFileListDetailViewVO appFileListDetailViewVO, DynamicObjectCollection workCollections) {
        String lengthOfWork;
        int workTime;
        Date endDate;
        Date startDate;
        if (appFileListDetailViewVO == null) {
            return;
        }
        DynamicObject latestWorkExpFirst = null;
        DynamicObject latestWorkExpSecond = null;
        if (workCollections != null && !workCollections.isEmpty()) {
            Object[] dynamicObjectArr = new DynamicObject[workCollections.size()];
            workCollections.toArray(dynamicObjectArr);
            List objects = CandidateSortHelper.sortExperience((DynamicObject[])dynamicObjectArr, (String)"startdate", (String)"endingdate", (String)"createtime");
            if (objects.size() > 0) {
                latestWorkExpFirst = (DynamicObject)objects.get(0);
            }
            if (objects.size() > 1) {
                latestWorkExpSecond = (DynamicObject)objects.get(1);
            }
        }
        if (latestWorkExpFirst != null) {
            appFileListDetailViewVO.setPositionFirst(latestWorkExpFirst.getString("positionname"));
            appFileListDetailViewVO.setCompanyNameFirst(latestWorkExpFirst.getString("companyname"));
            startDate = latestWorkExpFirst.getDate("startdate");
            endDate = latestWorkExpFirst.getDate("endingdate");
            appFileListDetailViewVO.setWorkTimeFirst(AppFileListViewDetailHelper.formatBetweenTwoDate(startDate, endDate));
            workTime = ResumeAnalysisHelper.calculateDuration((Date)startDate, (Date)endDate);
            lengthOfWork = ResumeAnalysisHelper.conversionDuration((int)workTime);
            lengthOfWork = HRStringUtils.isEmpty((String)lengthOfWork) ? "" : "(" + lengthOfWork + ")";
            appFileListDetailViewVO.setWorkTimeCountFirst(lengthOfWork);
        }
        if (latestWorkExpSecond != null) {
            appFileListDetailViewVO.setPositionSecond(latestWorkExpSecond.getString("positionname"));
            appFileListDetailViewVO.setCompanyNameSecond(latestWorkExpSecond.getString("companyname"));
            startDate = latestWorkExpSecond.getDate("startdate");
            endDate = latestWorkExpSecond.getDate("endingdate");
            appFileListDetailViewVO.setWorkTimeSecond(AppFileListViewDetailHelper.formatBetweenTwoDate(startDate, endDate));
            workTime = ResumeAnalysisHelper.calculateDuration((Date)startDate, (Date)endDate);
            lengthOfWork = ResumeAnalysisHelper.conversionDuration((int)workTime);
            lengthOfWork = StringUtils.isBlank((CharSequence)lengthOfWork) ? "" : "(" + lengthOfWork + ")";
            appFileListDetailViewVO.setWorkTimeCountSecond(lengthOfWork);
        }
    }

    private static String formatBetweenTwoDate(Date startDate, Date endDate) {
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startYear = "";
        String endYear = "";
        if (startDate != null) {
            startYear = yearMonthFormat.format(startDate);
        }
        if (endDate != null) {
            endYear = yearMonthFormat.format(endDate);
        }
        return String.format("%s~%s", startYear, endYear);
    }

    public static String conversionDuration(int totalMonth) {
        if (totalMonth <= 0) {
            return "";
        }
        String yearStr = "";
        String monthStr = "";
        int year = totalMonth / 12;
        int month = totalMonth % 12;
        if (year > 0) {
            String kdYearStr = ResManager.loadKDString((String)"\u5e74", (String)"AppFileListViewDetailHelper_2", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            yearStr = year + kdYearStr;
        }
        if (month > 0) {
            String kdMonthStr = ResManager.loadKDString((String)"\u4e2a\u6708", (String)"AppFileListViewDetailHelper_3", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            monthStr = month + kdMonthStr;
        }
        if (HRStringUtils.isNotEmpty((String)yearStr) || HRStringUtils.isNotEmpty((String)monthStr)) {
            return "(" + yearStr + monthStr + ")";
        }
        return "";
    }
}

