/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.operation;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tspr.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tspr.business.domain.appfile.operation.AppFileOperate;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;

public class ArrangeIntvOperate
implements AppFileOperate {
    private static final Log logger = LogFactory.getLog(ArrangeIntvOperate.class);
    private static final int ARRANGEINTV_MAX_SELECT_NUM = 200;

    @Override
    public boolean supportBefore(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
        return "arrangeaninterview".equals(operate.getOperateKey());
    }

    @Override
    public void handleBefore(AbstractFormPlugin plugin, BeforeDoOperationEventArgs args) {
        if (plugin instanceof AbstractListPlugin && AppFileListHelper.handleOutMaxSelectNum((AbstractListPlugin)plugin, 200)) {
            args.setCancel(true);
            return;
        }
        List appFileIds = args.getListSelectedData().stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] appFiles = AppFileHelper.queryAppFiles(TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"position.id", "recrustg.id"}), new QFilter("id", "in", appFileIds).toArray());
        Long positionId = appFiles[0].getLong("position.id");
        Long stageId = appFiles[0].getLong("recrustg.id");
        if (!Arrays.stream(appFiles).allMatch(dyo -> HRObjectUtils.equals((Object)positionId, (Object)dyo.getLong("position.id")) && HRObjectUtils.equals((Object)stageId, (Object)dyo.getLong("recrustg.id")))) {
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u540c\u804c\u4f4d\u540c\u73af\u8282\u7684\u5019\u9009\u4eba\u8fdb\u884c\u5b89\u6392\u9762\u8bd5", (String)"ArrangeIntvOperate_0", (String)"tsc-tspr-business", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    @Override
    public boolean supportAfter(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        return "arrangeaninterview".equals(afterDoOperationEventArgs.getOperateKey());
    }

    @Override
    public void handleAfter(AbstractFormPlugin plugin, AfterDoOperationEventArgs args) {
        logger.info("arrangeIntvOp.handleAfter.start.{}", (Object)args.getOperateKey());
        if (!args.getOperationResult().isSuccess()) {
            AppFileOpHelper.showOperationResult(plugin, args);
            return;
        }
        List<Long> pkIds = AppFileListHelper.getAfterDoOpPkIds(args);
        if (plugin instanceof AbstractListPlugin) {
            pkIds = AppFileListHelper.getSelectedPkList((AbstractListPlugin)plugin, pkIds);
        }
        AppFileOpHelper.showFormArrangeInterview(pkIds, plugin, "");
    }

    @Override
    public boolean supportCloseCallBack(ClosedCallBackEvent closeCallBack) {
        return "arrangeaninterviewoperateresult".equals(closeCallBack.getActionId()) || "tssrm_argintv".equals(closeCallBack.getActionId());
    }

    @Override
    public void handleCloseCallBack(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack) {
        if ("tssrm_argintv".equals(closeCallBack.getActionId())) {
            this.refresh(plugin);
        } else {
            List returnData = (List)closeCallBack.getReturnData();
            if (returnData != null) {
                List<Long> pkIds = returnData.stream().map(Object::toString).map(Long::valueOf).collect(Collectors.toList());
                if (plugin instanceof AbstractListPlugin) {
                    pkIds = AppFileListHelper.getSelectedPkList((AbstractListPlugin)plugin, pkIds);
                }
                AppFileOpHelper.showFormArrangeInterview(pkIds, plugin, "");
            }
        }
    }
}

