/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.operation;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tspr.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tspr.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tspr.business.domain.appfile.operation.AppFileOperate;

public class ChangeStageStatusOperate
implements AppFileOperate {
    private static final Log logger = LogFactory.getLog(ChangeStageStatusOperate.class);

    @Override
    public boolean supportAfter(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        return "changestagestatus".equals(afterDoOperationEventArgs.getOperateKey()) || "changestageright".equals(afterDoOperationEventArgs.getOperateKey());
    }

    @Override
    public void handleAfter(AbstractFormPlugin plugin, AfterDoOperationEventArgs args) {
        if (args.getOperationResult().getSuccessPkIds().isEmpty()) {
            AppFileOpHelper.showOperationResult(plugin, args);
            return;
        }
        logger.info("ChangeStageStatusOperate.handleAfter");
        if ("changestagestatus".equals(args.getOperateKey())) {
            this.refresh(plugin);
        } else {
            List<Long> pkIds = AppFileListHelper.getAfterDoOpPkIds(args);
            if (pkIds.isEmpty()) {
                return;
            }
            if (this.verifySameRecruitmentProcess(pkIds, plugin.getView())) {
                this.showFormChangeStageStatus(pkIds, plugin);
            }
        }
    }

    @Override
    public boolean supportCloseCallBack(ClosedCallBackEvent closeCallBack) {
        return "changestageright".equals(closeCallBack.getActionId());
    }

    @Override
    public void handleCloseCallBack(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack) {
        DynamicObject returnData = (DynamicObject)closeCallBack.getReturnData();
        if (returnData != null) {
            ChangeStageStatusOperate.doChangeStageAndStatusOp(returnData, plugin.getView());
        }
    }

    private boolean verifySameRecruitmentProcess(List<Long> appFileIdList, IFormView view) {
        if (!AppFileListHelper.verifySameRecruitmentProcess(appFileIdList)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u76f8\u540c\u6d41\u7a0b\u4e0b\u7684\u5019\u9009\u4eba\u8fdb\u884c\u8f6c\u79fb\u73af\u8282\u72b6\u6001", (String)"ChangeStageStatusOperate_0", (String)"tsc-tspr-business", (Object[])new Object[0]);
            view.showErrorNotification(msg);
            return false;
        }
        return true;
    }

    public void showFormChangeStageStatus(List<Long> appFileIdList, AbstractFormPlugin plugin) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("tssrm_changestagestatus");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "changestageright"));
        formShowParameter.setCustomParam("appFileIdList", appFileIdList);
        plugin.getView().showForm(formShowParameter);
    }

    public static void doChangeStageAndStatusOp(DynamicObject returnData, IFormView view) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("recruitmentstage", returnData.getString("recruitmentstage"));
        operateOption.setVariableValue("recruitmentstatus", returnData.getString("recruitmentstatus"));
        operateOption.setVariableValue("reason", returnData.getString("reason"));
        OperationResult operationResult = view.invokeOperation("changestagestatus", operateOption);
        if (operationResult.isSuccess()) {
            view.showSuccessNotification(operationResult.getMessage());
        }
    }
}

