/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.operation;

import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tspr.business.domain.appfile.operation.AppFileOperate;

public class ExamOperate
implements AppFileOperate {
    private static final Log logger = LogFactory.getLog(ExamOperate.class);

    @Override
    public boolean supportAfter(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        return "regmark".equals(afterDoOperationEventArgs.getOperateKey());
    }

    @Override
    public void handleAfter(AbstractFormPlugin plugin, AfterDoOperationEventArgs args) {
        if ("regmark".equals(args.getOperateKey())) {
            DynamicObject dataEntity = plugin.getView().getModel().getDataEntity();
            Long appFileId = dataEntity.getLong("id");
            ExamOperate.showExamWrittenNewPage(appFileId, plugin.getView(), new CloseCallBack((IFormPlugin)plugin, "tssrm_examwritten"));
        }
    }

    @Override
    public boolean supportCloseCallBack(ClosedCallBackEvent closeCallBack) {
        return "tssrm_examwritten".equals(closeCallBack.getActionId());
    }

    @Override
    public void handleCloseCallBack(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack) {
        if ("refresh".equals(closeCallBack.getReturnData())) {
            this.refresh(plugin);
        }
    }

    public static void showExamWrittenNewPage(Long appFileId, IFormView view, CloseCallBack closeCallBack) {
        logger.info("showExamWrittenNewPage.{}", (Object)appFileId);
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("tssrm_examwritten");
        baseShowParameter.setCustomParam("appFileId", (Object)appFileId);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setStatus(OperationStatus.ADDNEW);
        baseShowParameter.setCloseCallBack(closeCallBack);
        view.showForm((FormShowParameter)baseShowParameter);
    }
}

