/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.operation;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tspr.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tspr.business.domain.appfile.operation.AppFileOperate;
import kd.tsc.tspr.business.domain.hire.jobrank.HireJobRankKDStringHelper;
import kd.tsc.tspr.business.domain.hire.recommend.HireRecommendKDStringHelper;
import kd.tsc.tspr.business.domain.hire.salary.HireSalaryKDStringHelper;
import kd.tsc.tspr.business.domain.hire.service.HireAppFileService;

public class HireOperate
implements AppFileOperate {
    private static final Log logger = LogFactory.getLog(HireOperate.class);
    private static final Map<String, String> VALIDATE_KEY_MAP = Maps.newHashMapWithExpectedSize((int)4);

    @Override
    public boolean supportBefore(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
        return "hireapproval".equals(operate.getOperateKey());
    }

    @Override
    public void handleBefore(AbstractFormPlugin plugin, BeforeDoOperationEventArgs args) {
        ListView listView;
        ListSelectedRowCollection selectedRows;
        if (plugin.getView() instanceof ListView && (selectedRows = (listView = (ListView)plugin.getView()).getSelectedRows()).size() != 1) {
            args.setCancel(true);
            listView.showTipNotification(AppFileResManagerHelper.getOnlySelectOneDesc());
        }
    }

    @Override
    public boolean supportAfter(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        return VALIDATE_KEY_MAP.containsKey(operateKey);
    }

    @Override
    public void handleAfter(AbstractFormPlugin plugin, AfterDoOperationEventArgs args) {
        logger.info("HireOperate.handleAfter");
        List<Long> pkIds = AppFileListHelper.getAfterDoOpPkIds(args);
        ValidateResult hireValidateResult = HireAppFileService.filterAppFileByEvent(VALIDATE_KEY_MAP.get(args.getOperateKey()), pkIds);
        for (OperateErrorInfo operateErrorInfo : hireValidateResult.getAllErrorInfo()) {
            args.getOperationResult().addErrorInfo(operateErrorInfo);
        }
        if (!args.getOperationResult().isSuccess()) {
            AppFileOpHelper.showOperationResult(plugin, args);
        } else if (!pkIds.isEmpty()) {
            this.openHirePage(plugin, args.getOperateKey(), pkIds);
        }
    }

    @Override
    public boolean supportCloseCallBack(ClosedCallBackEvent closeCallBack) {
        String opKey = closeCallBack.getActionId();
        if (opKey.endsWith("operateresult")) {
            opKey = opKey.substring(0, opKey.length() - "operateresult".length());
        }
        return VALIDATE_KEY_MAP.containsKey(opKey);
    }

    @Override
    public void handleCloseCallBack(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack) {
        String actionId = closeCallBack.getActionId();
        if (actionId.endsWith("operateresult")) {
            this.continueHireOp(plugin, closeCallBack, actionId);
        } else {
            this.showHireOpResult(plugin, closeCallBack);
        }
    }

    private void continueHireOp(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack, String actionId) {
        String opKey = actionId.substring(0, actionId.length() - "operateresult".length());
        List returnData = (List)closeCallBack.getReturnData();
        if (returnData != null) {
            List<Long> pkIds = returnData.stream().map(Object::toString).map(Long::valueOf).collect(Collectors.toList());
            this.openHirePage(plugin, opKey, pkIds);
        }
    }

    private void showHireOpResult(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack) {
        String returnData;
        if (closeCallBack.getReturnData() != null && VALIDATE_KEY_MAP.containsKey(closeCallBack.getActionId()) && HRStringUtils.isNotEmpty((String)(returnData = (String)closeCallBack.getReturnData()))) {
            OperationResult operationResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)returnData, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
            plugin.getView().showOperationResult(operationResult);
            if (operationResult.isSuccess()) {
                this.refresh(plugin);
            }
        }
    }

    private void openHirePage(AbstractFormPlugin plugin, String operateKey, List<Long> pkIds) {
        if (plugin.getView() instanceof ListView) {
            switch (operateKey) {
                case "hirerecomend": {
                    this.openHireRecommendBatchPage(plugin, pkIds);
                    break;
                }
                case "hirejobrank": {
                    this.openJobRankBatchPage(plugin, pkIds);
                    break;
                }
                case "hiresalary": {
                    HireOperate.openSalaryBatchPage(plugin, pkIds);
                    break;
                }
                case "hireapproval": {
                    this.openHireApprovalBox(plugin, pkIds.get(0));
                    break;
                }
            }
        } else {
            DynamicObject appFileObject = plugin.getView().getModel().getDataEntity();
            long appFileId = appFileObject.getLong("id");
            switch (operateKey) {
                case "hirerecomend": {
                    this.openRecommendBox(plugin, appFileId);
                    break;
                }
                case "hirejobrank": {
                    this.openJobRankBox(plugin, appFileId);
                    break;
                }
                case "hiresalary": {
                    HireOperate.openSalaryBox(plugin, appFileId);
                    break;
                }
                case "hireapproval": {
                    this.openHireApprovalBox(plugin, appFileId);
                    break;
                }
            }
        }
    }

    private void openHireApprovalBox(AbstractFormPlugin plugin, Long appFileId) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("tso_hireapprovalsingle");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "hireapproval"));
        formShowParameter.setCustomParam("appFileId", (Object)appFileId);
        plugin.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void openHireRecommendBatchPage(AbstractFormPlugin plugin, List<Long> pkIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("tssrm_hirerecinitiate");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "hirerecomend"));
        formShowParameter.setCustomParam("appFileId", pkIds);
        formShowParameter.setCaption(HireRecommendKDStringHelper.hireRecommendName());
        plugin.getView().showForm(formShowParameter);
    }

    private static void openSalaryBox(AbstractFormPlugin plugin, long appFileId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("tssrm_hiresalarybox");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "hiresalary"));
        formShowParameter.setCustomParam("appFileId", (Object)appFileId);
        plugin.getView().showForm(formShowParameter);
    }

    private static void openSalaryBatchPage(AbstractFormPlugin plugin, List<Long> pkIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCaption(HireSalaryKDStringHelper.startSalaryCaption());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("tssrm_hiresalarybatchinit");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "hiresalary"));
        formShowParameter.setCustomParam("appFileId", pkIds);
        plugin.getView().showForm(formShowParameter);
    }

    private void openRecommendBox(AbstractFormPlugin plugin, Long appFileId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("tssrm_hirerecinitsingle");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "hirerecomend"));
        formShowParameter.setCustomParam("appFileId", (Object)appFileId);
        formShowParameter.setCaption(HireRecommendKDStringHelper.hireRecommendName());
        plugin.getView().showForm(formShowParameter);
    }

    private void openJobRankBox(AbstractFormPlugin plugin, Long appFileId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("tssrm_hirejobrankbox");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "hirejobrank"));
        formShowParameter.setCustomParam("appFileId", (Object)appFileId);
        formShowParameter.setCaption(HireJobRankKDStringHelper.hireJobRank());
        plugin.getView().showForm(formShowParameter);
    }

    private void openJobRankBatchPage(AbstractFormPlugin plugin, List<Long> pkIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("tssrm_jobrankbatchinit");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "hirejobrank"));
        formShowParameter.setCustomParam("appFileId", pkIds);
        formShowParameter.setCaption(HireJobRankKDStringHelper.hireJobRank());
        plugin.getView().showForm(formShowParameter);
    }

    static {
        VALIDATE_KEY_MAP.put("hirerecomend", "hireRecommend");
        VALIDATE_KEY_MAP.put("hirejobrank", "hireJobRank");
        VALIDATE_KEY_MAP.put("hiresalary", "hireSalary");
        VALIDATE_KEY_MAP.put("hireapproval", "hireApproval");
    }
}

