/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.operation;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tspr.business.domain.appfile.operation.AppFileOperate;
import kd.tsc.tspr.business.domain.appfile.service.AppFileOfferHelper;
import kd.tsc.tsrbd.business.domain.common.service.TscMutexHelper;

public class OfferOperate
implements AppFileOperate {
    private static final Log logger = LogFactory.getLog(OfferOperate.class);

    @Override
    public boolean supportAfter(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        return "addoffer".equals(afterDoOperationEventArgs.getOperateKey());
    }

    @Override
    public void handleAfter(AbstractFormPlugin plugin, AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.addOffer(plugin);
        } else {
            AppFileOpHelper.showOperationResult(plugin, args);
        }
    }

    @Override
    public boolean supportCloseCallBack(ClosedCallBackEvent closeCallBack) {
        return "tso_offerbase_info".equals(closeCallBack.getActionId());
    }

    @Override
    public void handleCloseCallBack(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack) {
        this.refresh(plugin);
    }

    private void addOffer(AbstractFormPlugin plugin) {
        logger.info("addOffer.start");
        DynamicObject dataEntity = plugin.getView().getModel().getDataEntity();
        long appFileOrgId = dataEntity.getLong("createorg.id");
        boolean hasOfferRight = AppFileOfferHelper.hasAddOfferRight(appFileOrgId);
        if (hasOfferRight) {
            DynamicObject originAppFile = AppFileHelper.queryOne(dataEntity.getLong("id"));
            if (!AppFileOfferHelper.validateOfferStatus(originAppFile)) {
                plugin.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5019\u9009\u4eba%s\u7684offer\u72b6\u6001\u4e0d\u662f\u5df2\u5e9f\u5f03\u6216\u6ca1\u6709offer\u6570\u636e", (String)"OfferOperate_0", (String)"tsc-tspr-business", (Object[])new Object[0]), dataEntity.getString("name")));
            } else if (HRStringUtils.isEmpty((String)dataEntity.getString("phone")) || HRStringUtils.isEmpty((String)dataEntity.getString("email"))) {
                String noPhoneAndEmailTipFmt = AppFileResManagerHelper.getNoPhoneAndEmailTip();
                plugin.getView().showTipNotification(String.format(Locale.ROOT, noPhoneAndEmailTipFmt, dataEntity.getString("name")));
            } else {
                this.showAddOfferPage(dataEntity, plugin);
            }
        } else {
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709'\u5019\u9009\u4eba\u7ba1\u7406'\u7684\u65b0\u589eoffer\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"OfferOperate_1", (String)"tsc-tspr-business", (Object[])new Object[0]));
        }
    }

    private void showAddOfferPage(DynamicObject dataEntity, AbstractFormPlugin plugin) {
        List<Map<String, Object>> maps;
        try {
            maps = AppFileDataHelper.offerInit(new DynamicObject[]{dataEntity});
        }
        catch (KDBizException kdBizException) {
            logger.error("showAddOfferPage.error", (Throwable)kdBizException);
            plugin.getView().showTipNotification(kdBizException.getMessage());
            return;
        }
        if (maps != null && !maps.isEmpty()) {
            StringBuilder mutexTip;
            Object offerId = maps.get(0).get("offerId");
            boolean requireMutex = TscMutexHelper.requireMutex((String)"tso_offerbase", (Object)offerId, (String)"edit", (StringBuilder)(mutexTip = new StringBuilder()));
            if (requireMutex) {
                this.showAddOfferInfoPage(offerId, dataEntity, plugin);
            } else {
                plugin.getView().showTipNotification(mutexTip.toString());
            }
        }
    }

    private void showAddOfferInfoPage(Object offerPk, DynamicObject appfile, AbstractFormPlugin plugin) {
        BillShowParameter offerFormShowParam = new BillShowParameter();
        offerFormShowParam.setFormId("tso_offerbase_info");
        offerFormShowParam.setStatus(OperationStatus.EDIT);
        offerFormShowParam.setCustomParam("offerPageStatus", (Object)OperationStatus.EDIT);
        offerFormShowParam.setCustomParam("add_offer", (Object)"1");
        offerFormShowParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        offerFormShowParam.setCaption("offer-" + appfile.getString("name"));
        offerFormShowParam.setPkId(offerPk);
        offerFormShowParam.setPageId(plugin.getView().getPageId() + "tso_offerbase_info" + offerPk);
        offerFormShowParam.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "tso_offerbase_info"));
        plugin.getView().showForm((FormShowParameter)offerFormShowParam);
    }
}

