/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.operation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tspr.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tspr.business.domain.appfile.operation.AppFileOperate;
import kd.tsc.tspr.business.domain.appfile.service.AppFileOpRecordService;
import kd.tsc.tspr.business.domain.appfile.service.AppFileStdRsmHelper;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class SaveTalentOperate
implements AppFileOperate {
    private static final Log logger = LogFactory.getLog(SaveTalentOperate.class);

    @Override
    public boolean supportAfter(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        return "savetalent".equals(afterDoOperationEventArgs.getOperateKey());
    }

    @Override
    public void handleAfter(AbstractFormPlugin plugin, AfterDoOperationEventArgs args) {
        String pageNumber;
        ArrayList selectPkIds;
        if (plugin instanceof AbstractListPlugin) {
            selectPkIds = AppFileListHelper.getSelectPkIds((AbstractListPlugin)plugin);
            pageNumber = ((ListView)plugin.getView()).getBillFormId();
        } else {
            selectPkIds = Lists.newArrayList((Object[])new Long[]{plugin.getView().getModel().getDataEntity().getLong("id")});
            pageNumber = plugin.getView().getEntityId();
        }
        AppFileStdRsmHelper.validateTalentRight(plugin, selectPkIds, pageNumber);
    }

    @Override
    public boolean supportCloseCallBack(ClosedCallBackEvent closeCallBack) {
        return "savetalent".equals(closeCallBack.getActionId()) || "tstpm_talenttreelistf7".equals(closeCallBack.getActionId());
    }

    @Override
    public void handleCloseCallBack(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack) {
        if ("savetalent".equals(closeCallBack.getActionId())) {
            List returnData = (List)closeCallBack.getReturnData();
            if (returnData != null) {
                List<Long> candidateIds = returnData.stream().map(Object::toString).map(Long::valueOf).collect(Collectors.toList());
                logger.info("selectTalentPool.selectIds:{}", candidateIds);
                AppFileStdRsmHelper.selectTalentPool(plugin, candidateIds);
            }
        } else {
            ListSelectedRowCollection returnDataColl = (ListSelectedRowCollection)closeCallBack.getReturnData();
            if (returnDataColl != null) {
                AppFileStdRsmHelper.saveTalent(plugin, returnDataColl);
                this.addOpRecord(plugin, returnDataColl);
            }
        }
    }

    private void addOpRecord(AbstractFormPlugin plugin, ListSelectedRowCollection returnDataColl) {
        List candidateIds = (List)SerializationUtils.fromJsonString((String)plugin.getPageCache().get("candidateidswithrights"), List.class);
        ArrayList selectPkIds = plugin instanceof AbstractListPlugin ? AppFileListHelper.getSelectPkIds((AbstractListPlugin)plugin) : Lists.newArrayList((Object[])new Long[]{plugin.getView().getModel().getDataEntity().getLong("id")});
        DynamicObject[] appFiles = AppFileHelper.queryAppFiles("stdrsm.id", new QFilter[]{new QFilter("id", "in", (Object)selectPkIds), new QFilter("stdrsm.id", "in", (Object)candidateIds)});
        List<Long> appFileIdList = Arrays.stream(appFiles).map(DataEntityBase::getPkValue).map(obj -> (Long)obj).collect(Collectors.toList());
        List talentNameList = returnDataColl.stream().map(ListSelectedRow::getName).collect(Collectors.toList());
        AppFileOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), OpDefEnum.SAVE_TALENT, appFileIdList, Collections.singletonMap("talentNameList", talentNameList));
    }
}

