/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.qacheck;

import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tspr.common.constants.appfile.qacheck.AppFileQACheckConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class QACheckDataHelper {
    private static final Log logger = LogFactory.getLog(QACheckDataHelper.class);
    private static HRBaseServiceHelper service = new HRBaseServiceHelper("tspr_qacheck");

    private QACheckDataHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static int getUnQACheckNum() {
        logger.info("QACheckDataHelper.getUnQACheckNum");
        QFilter handlerQFilter = new QFilter("handler", "=", (Object)TSCRequestContext.getUserId());
        QFilter statusQFilter = new QFilter("auditstatus", "=", (Object)AppFileQACheckConstants.AuditStatus.TEMP.getStatus());
        QFilter[] qFilterArr = new QFilter[]{handlerQFilter, statusQFilter};
        try (DataSet rows = service.queryDataSet("getUnQACheckNum", "id", qFilterArr);){
            int n = rows.count("id", true);
            return n;
        }
    }

    public static DynamicObject getQACheckById(Long id) {
        return service.queryOne((Object)id);
    }

    public static DynamicObject[] getQACheckByAppFileId(Long appFileId) {
        QFilter qFilter = new QFilter("appfile", "=", (Object)appFileId);
        return service.query("id,appfile,createtime,handler,description,handletime,auditstatus,recrustg,result", qFilter.toArray(), " createtime desc");
    }
}

