/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.service;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.resumefilter.service.ResumeFilterHelper;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;

public class AppFileFilterHelper {
    private static final Log logger = LogFactory.getLog(AppFileFilterHelper.class);
    private static final String KEY_FILTERFEEDBACKSTATUS = "filterfeedbackstatus";
    private static final String KEY_FILTERFEEDBACKCONCLUSION = "filterfeedbackconclusion";
    private static final String[] FILTER_KEYS = new String[]{"nofkfilterfknum", "suitfilterfknum", "nosuitfilterfknum", "tfposfilterfknum", "pendfilterfknum"};

    private AppFileFilterHelper() {
    }

    public static boolean isExistFilterTaskByAppFileId(Long appFileId) {
        logger.info("AppFileFilterHelper.isExistFilterTaskByAppFileId {}", (Object)appFileId);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tspr_resumefilter");
        return helper.isExists(new QFilter[]{new QFilter("appfile", "=", (Object)appFileId)});
    }

    public static void updateAppFileFilterFeedBackData(List<Long> appFileIdList) {
        logger.info("updateAppFileFilterFeedBackData {}", appFileIdList);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tspr_resumefilter");
        try (DataSet dataSet = helper.queryDataSet("AppFileList.updateAppFileFilterFeedBackData", "appfile,filterfeedbackstatus,filterfeedbackconclusion", new QFilter("appfile", "in", appFileIdList).toArray());){
            DataSet finish = dataSet.groupBy(new String[]{"appfile", KEY_FILTERFEEDBACKSTATUS, KEY_FILTERFEEDBACKCONCLUSION}).count().finish();
            Iterator iterator = finish.iterator();
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)appFileIdList.size());
            while (iterator.hasNext()) {
                Row rs = (Row)iterator.next();
                Long appfileId = rs.getLong("appfile");
                int[] arr = dataMap.computeIfAbsent(appfileId, pk -> new int[5]);
                String status = rs.getString(KEY_FILTERFEEDBACKSTATUS);
                Integer count = rs.getInteger("count");
                if ("3".equals(status)) {
                    arr[rs.getInteger((String)KEY_FILTERFEEDBACKCONCLUSION).intValue()] = count;
                    continue;
                }
                arr[0] = arr[0] + count;
            }
            AppFileFilterHelper.updateFilterStatus(appFileIdList, dataMap);
        }
    }

    public static void updateFilterStatus(List<Long> appFileIdList, Map<Long, int[]> dataMap) {
        DynamicObject[] appFiles;
        for (DynamicObject appFile : appFiles = AppFileHelper.queryAppFiles(appFileIdList, TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"nofkfilterfknum", "suitfilterfknum", "nosuitfilterfknum", "pendfilterfknum", "tfposfilterfknum", "filterstatus"}))) {
            AppFileFilterHelper.setAppFileFilterField(dataMap, appFile);
        }
        AppFileHelper.update(appFiles);
    }

    private static void setAppFileFilterField(Map<Long, int[]> dataMap, DynamicObject appFile) {
        int[] arr = dataMap.get(appFile.getLong("id"));
        if (arr != null) {
            for (int i = 0; i < FILTER_KEYS.length; ++i) {
                appFile.set(FILTER_KEYS[i], (Object)arr[i]);
            }
            StringBuilder filterStatusSb = new StringBuilder(",");
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] <= 0) continue;
                filterStatusSb.append(i + 1).append(",");
            }
            appFile.set("filterstatus", (Object)filterStatusSb.toString());
        }
    }

    public static DynamicObject queryOneResumeFilterTaskByPk(Object resumeFilterTasksPk) {
        return ResumeFilterHelper.queryOneResumeFilterTaskByPk(resumeFilterTasksPk);
    }
}

