/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.service;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.tsc.tspr.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tspr.common.constants.appfile.AppFileOperateEnum;

public class AppFileFlowLockControlHelper {
    private static final Log LOG = LogFactory.getLog(AppFileFlowLockControlHelper.class);
    private static Set<String> lockSet = Sets.newHashSet();
    private static ThreadPool lockThreadPool = ThreadPools.newCachedThreadPool((String)"appFileLock!@##$#", (int)3, (int)30, (String)"tspr");

    private AppFileFlowLockControlHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void lockAppFiles(final List<Long> appFileIdList, final Long lockerId, final AppFileOperateEnum appFileOperateEnum, final boolean directLock) {
        LOG.info("AppFileFlowLockControlHelper.lockAppFiles:{},{},{},{}", new Object[]{appFileIdList, lockerId, appFileOperateEnum.getOpKey(), directLock});
        lockThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                if (!directLock && !AppFileFlowLockControlHelper.isConfig(appFileOperateEnum.getOpKey())) {
                    LOG.info("this appFileOperateEnum not need lock");
                    return;
                }
                LOG.info("this appFileOperateEnum need lock");
                AppFileFlowLockHelper.lockAppFiles(appFileIdList, lockerId);
            }
        });
    }

    private static boolean isConfig(String opKey) {
        return AppFileFlowLockControlHelper.loadLockSet().contains(opKey);
    }

    private static Set<String> loadLockSet() {
        return lockSet;
    }

    static {
        lockSet.add(AppFileOperateEnum.FILTER.getOpKey());
        lockSet.add(AppFileOperateEnum.ARRANGEANINTERVIEW.getOpKey());
        lockSet.add(AppFileOperateEnum.HIRERECOMEND.getOpKey());
        lockSet.add(AppFileOperateEnum.HIREJOBRANK.getOpKey());
        lockSet.add(AppFileOperateEnum.HIRESALARY.getOpKey());
        lockSet.add(AppFileOperateEnum.HIREAPPROVAL.getOpKey());
    }
}

