/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tspr.business.domain.appfile.service.AppFilePositionHelper;
import kd.tsc.tsrbd.common.enums.DatePeriodEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;

public class AppFileHomePageHelper {
    private static final Log logger = LogFactory.getLog(AppFileHomePageHelper.class);
    private static final HRBaseServiceHelper APP_FILE_HELPER = new HRBaseServiceHelper("tspr_appfile");
    private static final HRBaseServiceHelper INTV_HELPER = new HRBaseServiceHelper("tspr_argintv");
    private static final HRBaseServiceHelper FILTER_HELPER = new HRBaseServiceHelper("tspr_resumefilter");
    private static final String KEY_INTVCANDATE = "intvcandate.fbasedataid";
    private static final String INTV_SELECTPROPS = "intvcandate.fbasedataid,intvcandate.fbasedataid.intvprogress,intvcandate.fbasedataid.intvevalresult,arrangeantime";
    private static final String INTV_FILTER_PROPS = "intvcandate.fbasedataid.recruproc";
    private static final String KEY_INTV_PROGRESS = "intvcandate.fbasedataid.intvprogress";
    private static final String KEY_INTV_RESULT = "intvcandate.fbasedataid.intvevalresult";
    private static final String INTV_ORDER_PROPS = "intvcandate.fbasedataid,arrangeantime desc";
    private static final String POS_RECR = "recruproc";

    private AppFileHomePageHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Integer> getFilterCandidateData(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId) {
        Object procDataSet;
        logger.info("getFilterCandidateData start {} {} {} {}", new Object[]{isOwner, recruitProcId, timeRangeType, orgId});
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        HRBaseServiceHelper appFileHelper = new HRBaseServiceHelper("tspr_appfile");
        QFilter[] qFilters = AppFileHomePageHelper.getTobeFilterWaitedQFilter(isOwner, recruitProcId, startDate, orgId);
        try (DataSet finish = null;
             DataSet dataSet = appFileHelper.queryDataSet("AppFileDataHelper.getFilterCandidateData.p", "id,recrustg,recrustat,recruproc", qFilters);){
            procDataSet = AppFileHomePageHelper.getDataSetFirstStageAndStatusProc(recruitProcId);
            Throwable throwable = null;
            try {
                JoinDataSet joinDataSet = dataSet.join((DataSet)procDataSet, JoinType.INNER).on(POS_RECR, "id").on("recrustg", "entryentity.rqmtstg").on("recrustat", "entryentity.subentryentity.jobstatus");
                finish = joinDataSet.select(new String[]{"id"}, new String[0]).finish();
                int beginCount = finish.count("id", true);
                result.put("begin", beginCount);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (procDataSet != null) {
                    if (throwable != null) {
                        try {
                            procDataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        procDataSet.close();
                    }
                }
            }
        }
        HRBaseServiceHelper filterHelper = new HRBaseServiceHelper("tspr_resumefilter");
        qFilters = AppFileHomePageHelper.getFilterSentQFilter(isOwner, recruitProcId, startDate, orgId);
        DataSet dataSet = filterHelper.queryDataSet("AppFileDataHelper.getFilterCandidateData.f", "appfile", qFilters);
        procDataSet = null;
        try {
            int inCount = dataSet.count("appfile", true);
            result.put("in", inCount);
        }
        catch (Throwable throwable) {
            procDataSet = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (procDataSet != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)procDataSet).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        List<Map<String, Object>> filterFinishedList = AppFileHomePageHelper.getFilterFinishedList(qFilters);
        long endCount = filterFinishedList.stream().filter(stat -> "3".equals(stat.get("filterfeedbackstatus"))).count();
        result.put("end", (int)endCount);
        return result;
    }

    public static Map<String, Integer> getInterviewCandidateData(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId) {
        logger.info("getInterviewCandidateData {},{},{},{}", new Object[]{isOwner, recruitProcId, timeRangeType, orgId});
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        DynamicObjectCollection appFiles = FILTER_HELPER.queryOriginalCollection("appfile", AppFileHomePageHelper.getQFilterToBeArranged(isOwner, recruitProcId, startDate, orgId));
        Set appFileIds = appFiles.stream().map(dy -> dy.getLong("appfile")).collect(Collectors.toSet());
        logger.info("getInterviewCandidateData.appFileIds:{}", appFileIds);
        try (DataSet dataSet = INTV_HELPER.queryDataSet("AppFileDataHelper.getInterviewCandidateData.begin", KEY_INTVCANDATE, new QFilter[]{new QFilter(KEY_INTVCANDATE, "in", appFileIds)});){
            int interviewedCount = dataSet.count(KEY_INTVCANDATE, true);
            result.put("begin", appFileIds.size() - interviewedCount);
        }
        Set<Map<String, Object>> interviewerInfoSet = AppFileHomePageHelper.getIntvAppFilesInfos(isOwner, recruitProcId, startDate, orgId);
        long inCount = interviewerInfoSet.stream().filter(map -> "A".equals(map.get(KEY_INTV_PROGRESS))).count();
        logger.info("getIntvAppFilesInfos.set:{}", interviewerInfoSet);
        result.put("in", (int)inCount);
        long endCount = interviewerInfoSet.stream().filter(map -> "C".equals(map.get(KEY_INTV_PROGRESS)) && "A".equals(map.get(KEY_INTV_RESULT))).count();
        result.put("end", (int)endCount);
        return result;
    }

    public static Set<Long> queryTobeArrangedAppFileIdList(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId) {
        logger.info("queryTobeArrangedAppFileIdList start {} {} {}", new Object[]{isOwner, recruitProcId, timeRangeType, orgId});
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        DynamicObjectCollection appFiles = FILTER_HELPER.queryOriginalCollection("appfile", AppFileHomePageHelper.getQFilterToBeArranged(isOwner, recruitProcId, startDate, orgId));
        Set<Long> appFileIds = appFiles.stream().map(dy -> dy.getLong("appfile")).collect(Collectors.toSet());
        try (DataSet dataSet = INTV_HELPER.queryDataSet("AppFileDataHelper.getInterviewCandidateData.queryTobeArrangedAppFileIdList", KEY_INTVCANDATE, new QFilter[]{new QFilter(KEY_INTVCANDATE, "in", appFileIds)});){
            for (Row row : dataSet) {
                appFileIds.remove(row.getLong(KEY_INTVCANDATE));
            }
        }
        logger.debug("queryTobeArrangedAppFileIdList result {}", appFileIds);
        return appFileIds;
    }

    private static QFilter[] getQFilterToBeArranged(boolean isOwner, Long recruitProcId, LocalDate startDate, Long orgId) {
        if (startDate != null) {
            return new QFilter[]{AppFilePositionHelper.getPositionRightQFilter("recruitmentposition", isOwner, orgId), new QFilter("appfile.recruproc", "=", (Object)recruitProcId), new QFilter("createtime", ">=", (Object)startDate), new QFilter("filterfeedbackconclusion", "=", (Object)"1")};
        }
        return new QFilter[]{AppFilePositionHelper.getPositionRightQFilter("recruitmentposition", isOwner, orgId), new QFilter("appfile.recruproc", "=", (Object)recruitProcId), new QFilter("filterfeedbackconclusion", "=", (Object)"1")};
    }

    /*
     * Exception decompiling
     */
    private static Set<Map<String, Object>> getIntvAppFilesInfos(boolean isOwner, Long recruitProcId, LocalDate startDate, Long orgId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> queryTobeFilterWaitedAppFileIdSet(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId) {
        logger.info("queryTobeFilterWaitedAppFileIdSet start {} {} {} {}}", new Object[]{isOwner, recruitProcId, timeRangeType, orgId});
        HashSet appFileIdSet = Sets.newHashSet();
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        HRBaseServiceHelper appFileHelper = new HRBaseServiceHelper("tspr_appfile");
        QFilter[] qFilters = AppFileHomePageHelper.getTobeFilterWaitedQFilter(isOwner, recruitProcId, startDate, orgId);
        try (DataSet finish = null;
             DataSet dataSet = appFileHelper.queryDataSet("AppFileDataHelper.getFilterCandidateData.p", "id,recrustg,recrustat,recruproc", qFilters);
             DataSet procDataSet = AppFileHomePageHelper.getDataSetFirstStageAndStatusProc(recruitProcId);){
            JoinDataSet joinDataSet = dataSet.join(procDataSet, JoinType.INNER).on(POS_RECR, "id").on("recrustg", "entryentity.rqmtstg").on("recrustat", "entryentity.subentryentity.jobstatus");
            finish = joinDataSet.select(new String[]{"id"}, new String[0]).finish();
            finish.forEach(row -> appFileIdSet.add(row.getLong("id")));
        }
        return appFileIdSet;
    }

    public static DataSet getDataSetFirstStageAndStatusProc(Long recruitProcId) {
        HRBaseServiceHelper procHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        return procHelper.queryDataSet("AppFileDataHelper.getFilterCandidateData.r", "id,entryentity.rqmtstg,entryentity.subentryentity.jobstatus", new QFilter[]{new QFilter("entryentity.seq", "=", (Object)1), new QFilter("entryentity.subentryentity.seq", "=", (Object)1), new QFilter("id", "=", (Object)recruitProcId)});
    }

    public static QFilter[] getTobeFilterWaitedQFilter(boolean isOwner, Long recruitProcId, LocalDate startDate, Long orgId) {
        QFilter positionRightQFilter = AppFilePositionHelper.getPositionRightQFilter("position", isOwner, orgId);
        QFilter recProcQFilter = new QFilter(POS_RECR, "=", (Object)recruitProcId);
        if (startDate != null) {
            return new QFilter[]{positionRightQFilter, recProcQFilter, new QFilter("createtime", ">=", (Object)startDate)};
        }
        return new QFilter[]{positionRightQFilter, recProcQFilter};
    }

    public static Set<Long> queryFilterSentAppFileIdSet(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId) {
        logger.info("queryFilterSentAppFileIdSet start {} {} {} {}}", new Object[]{isOwner, recruitProcId, timeRangeType, orgId});
        HashSet appFileIdSet = Sets.newHashSet();
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        HRBaseServiceHelper filterHelper = new HRBaseServiceHelper("tspr_resumefilter");
        QFilter[] qFilters = AppFileHomePageHelper.getFilterSentQFilter(isOwner, recruitProcId, startDate, orgId);
        try (DataSet dataSet = filterHelper.queryDataSet("AppFileDataHelper.queryFilterSentAppFileIdSet.f", "appfile", qFilters);){
            dataSet.forEach(row -> appFileIdSet.add(row.getLong("appfile")));
        }
        return appFileIdSet;
    }

    public static QFilter[] getFilterSentQFilter(boolean isOwner, Long recruitProcId, LocalDate startDate, Long orgId) {
        if (startDate != null) {
            return new QFilter[]{AppFilePositionHelper.getPositionRightQFilter("recruitmentposition", isOwner, orgId), new QFilter("appfile.recruproc", "=", (Object)recruitProcId), new QFilter("createtime", ">=", (Object)startDate), new QFilter("appfile", "!=", (Object)0L)};
        }
        return new QFilter[]{AppFilePositionHelper.getPositionRightQFilter("recruitmentposition", isOwner, orgId), new QFilter("appfile.recruproc", "=", (Object)recruitProcId), new QFilter("appfile", "!=", (Object)0L)};
    }

    public static Set<Long> queryFilterFinishedAppFileIdSet(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId) {
        logger.info("queryFilterFinishedAppFileIdSet start {} {} {} {}}", new Object[]{isOwner, recruitProcId, timeRangeType, orgId});
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        QFilter[] qFilters = AppFileHomePageHelper.getFilterSentQFilter(isOwner, recruitProcId, startDate, orgId);
        List<Map<String, Object>> filterFinishedList = AppFileHomePageHelper.getFilterFinishedList(qFilters);
        return filterFinishedList.stream().filter(stat -> "3".equals(stat.get("filterfeedbackstatus"))).map(map -> (Long)map.get("appfile")).collect(Collectors.toSet());
    }

    public static List<Map<String, Object>> getFilterFinishedList(QFilter[] qFilters) {
        LinkedList<Map<String, Object>> firstRowList = new LinkedList<Map<String, Object>>();
        HRBaseServiceHelper filterHelper = new HRBaseServiceHelper("tspr_resumefilter");
        String selectProps = "id,appfile,filterfeedbackstatus,createtime";
        try (DataSet dataSet = filterHelper.queryDataSet("AppFileDataHelper.getFilterCandidateData.fi", selectProps, qFilters, "appfile,createtime DESC,filterfeedbackstatus DESC");){
            for (Row row : dataSet) {
                Long appFileId = row.getLong("appfile");
                if (!firstRowList.isEmpty() && HRObjectUtils.equals((Object)firstRowList.getLast().get("appfile"), (Object)appFileId)) continue;
                HashMap objectMap = Maps.newHashMapWithExpectedSize((int)2);
                objectMap.put("appfile", appFileId);
                objectMap.put("filterfeedbackstatus", row.getString("filterfeedbackstatus"));
                firstRowList.add(objectMap);
            }
        }
        return firstRowList;
    }

    public static Set<Long> queryTobeInterviewedAppFileIdList(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId) {
        logger.info("queryTobeInterviewedAppFileIdList {},{},{},{}", new Object[]{isOwner, recruitProcId, timeRangeType, orgId});
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        Set<Map<String, Object>> firstRowList = AppFileHomePageHelper.getIntvAppFilesInfos(isOwner, recruitProcId, startDate, orgId);
        logger.info("queryTobeInterviewedAppFileIdList.resSet:{}", firstRowList);
        return firstRowList.stream().filter(map -> "A".equals(map.get(KEY_INTV_PROGRESS))).map(map -> (Long)map.get(KEY_INTVCANDATE)).collect(Collectors.toSet());
    }

    public static Set<Long> queryToBeAdvancedAppFileIdList(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId) {
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        Set<Map<String, Object>> firstRowList = AppFileHomePageHelper.getIntvAppFilesInfos(isOwner, recruitProcId, startDate, orgId);
        Set<Long> appFileIds = firstRowList.stream().filter(map -> "C".equals(map.get(KEY_INTV_PROGRESS)) && "A".equals(map.get(KEY_INTV_RESULT))).map(map -> (Long)map.get(KEY_INTVCANDATE)).collect(Collectors.toSet());
        logger.debug("queryToBeAdvancedAppFileIdList result {}", appFileIds);
        return appFileIds;
    }

    public static Map<String, Integer> getHireCandidateData(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId) {
        logger.info("getHireCandidateData {},{},{},{}", new Object[]{isOwner, recruitProcId, timeRangeType, orgId});
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        QFilter[] waitedHireQFilter = AppFileHomePageHelper.getWaitedHireQFilter(isOwner, recruitProcId, startDate, orgId);
        result.put("begin", APP_FILE_HELPER.queryOriginalArray("id", waitedHireQFilter).length);
        QFilter[] hireAuditingQFilter = AppFileHomePageHelper.getHireAuditingQFilter(isOwner, recruitProcId, startDate, orgId);
        result.put("in", APP_FILE_HELPER.queryOriginalArray("id", hireAuditingQFilter).length);
        QFilter[] hireAuditedQFilter = AppFileHomePageHelper.getHireAuditedQFilter(isOwner, recruitProcId, startDate, orgId);
        result.put("end", APP_FILE_HELPER.queryOriginalArray("id", hireAuditedQFilter).length);
        logger.info("getHireCandidateData.genQfilter:{},{},{}", new Object[]{waitedHireQFilter, hireAuditingQFilter, hireAuditedQFilter});
        return result;
    }

    public static Set<Long> getWaitedHireAppFileIdSet(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId) {
        logger.info("getWaitedHireAppFileIdSet {},{},{},{}", new Object[]{isOwner, recruitProcId, timeRangeType, orgId});
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        DynamicObjectCollection collection = APP_FILE_HELPER.queryOriginalCollection("id", AppFileHomePageHelper.getWaitedHireQFilter(isOwner, recruitProcId, startDate, orgId));
        return collection.stream().map(dyo -> dyo.getLong("id")).collect(Collectors.toSet());
    }

    public static QFilter[] getWaitedHireQFilter(boolean isOwner, Long recruitProcId, LocalDate startDate, Long orgId) {
        QFilter hireStatusQFilter = new QFilter("employapprlsatatus", "in", (Object)Lists.newArrayList((Object[])new String[]{" ", "F"}));
        QFilter fbQFilter = new QFilter("empolyfeedbackresult", "in", (Object)new String[]{"Y", "W", "U"});
        QFilter jBQFilter = new QFilter("jobrankstatus", "!=", (Object)"W");
        QFilter salQFilter = new QFilter("setsalarystatus", "!=", (Object)"W");
        if (startDate != null) {
            fbQFilter.and(new QFilter("employrecomnewesttime", ">=", (Object)startDate));
            jBQFilter.and(new QFilter("lasthirejobrankstarttime", ">=", (Object)startDate));
            salQFilter.and(new QFilter("lasthiresalarystartime", ">=", (Object)startDate));
        }
        return new QFilter[]{AppFilePositionHelper.getPositionRightQFilter("position", isOwner, orgId), new QFilter(POS_RECR, "=", (Object)recruitProcId), fbQFilter.or(jBQFilter).or(salQFilter), hireStatusQFilter};
    }

    public static Set<Long> getHireAuditingAppFileIdSet(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId) {
        logger.info("getHireAuditingAppFileIdSet {},{},{},{}", new Object[]{isOwner, recruitProcId, timeRangeType, orgId});
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        DynamicObjectCollection collection = APP_FILE_HELPER.queryOriginalCollection("id", AppFileHomePageHelper.getHireAuditingQFilter(isOwner, recruitProcId, startDate, orgId));
        return collection.stream().map(dyo -> dyo.getLong("id")).collect(Collectors.toSet());
    }

    public static QFilter[] getHireAuditingQFilter(boolean isOwner, Long recruitProcId, LocalDate startDate, Long orgId) {
        QFilter qFilter = new QFilter("employapprlsatatus", "in", (Object)new String[]{"A", "B", "D", "G"});
        if (startDate != null) {
            qFilter.and(new QFilter("employapprlnewesttime", ">=", (Object)startDate));
        }
        return new QFilter[]{AppFilePositionHelper.getPositionRightQFilter("position", isOwner, orgId), new QFilter(POS_RECR, "=", (Object)recruitProcId), qFilter};
    }

    public static Set<Long> getHireAuditedAppFileIdSet(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId) {
        logger.info("getHireAuditedAppFileIdSet {},{},{},{}", new Object[]{isOwner, recruitProcId, timeRangeType, orgId});
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        DynamicObjectCollection collection = APP_FILE_HELPER.queryOriginalCollection("id", AppFileHomePageHelper.getHireAuditedQFilter(isOwner, recruitProcId, startDate, orgId));
        return collection.stream().map(dyo -> dyo.getLong("id")).collect(Collectors.toSet());
    }

    public static QFilter[] getHireAuditedQFilter(boolean isOwner, Long recruitProcId, LocalDate startDate, Long orgId) {
        QFilter qFilter = new QFilter("employapprlsatatus", "in", (Object)new String[]{"C", "E"});
        if (startDate != null) {
            qFilter.and(new QFilter("employapprlnewesttime", ">=", (Object)startDate));
        }
        return new QFilter[]{AppFilePositionHelper.getPositionRightQFilter("position", isOwner, orgId), new QFilter(POS_RECR, "=", (Object)recruitProcId), qFilter};
    }

    public static Collection<Long> getOfferWaitedIds(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId) {
        try {
            logger.info("getOfferWaitedIds.params:{},{},{},{}", new Object[]{isOwner, recruitProcId, timeRangeType, orgId});
            return (Collection)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tso", (String)"offerBaseServiceApi", (String)"getPreApplyOfferList", (Object[])new Object[]{!isOwner, recruitProcId, timeRangeType, orgId});
        }
        catch (Exception ex) {
            logger.error("getOfferWaitedIds.error", (Throwable)ex);
            return Sets.newHashSet();
        }
    }

    public static Collection<Long> getOfferInIds(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId) {
        try {
            logger.info("getOfferInIds.params:{},{},{},{}", new Object[]{isOwner, recruitProcId, timeRangeType, orgId});
            return (Collection)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tso", (String)"offerBaseServiceApi", (String)"getApplyingOfferList", (Object[])new Object[]{!isOwner, recruitProcId, timeRangeType, orgId});
        }
        catch (Exception ex) {
            logger.error("getOfferInIds.error", (Throwable)ex);
            return Sets.newHashSet();
        }
    }

    public static Collection<Long> getOfferDoneIds(boolean isOwner, Long recruitProcId, String timeRangeType, Long orgId) {
        try {
            logger.info("getOfferDoneIds.params:{},{},{},{}", new Object[]{isOwner, recruitProcId, timeRangeType, orgId});
            return (Collection)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tso", (String)"offerBaseServiceApi", (String)"getAlrSendOfferList", (Object[])new Object[]{!isOwner, recruitProcId, timeRangeType, orgId});
        }
        catch (Exception ex) {
            logger.error("getOfferDoneIds.error", (Throwable)ex);
            return Sets.newHashSet();
        }
    }
}

