/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.list.entity.AppFileIntInfoVO;
import kd.tsc.tspr.business.domain.appfile.list.entity.IntInfoVO;
import kd.tsc.tspr.business.domain.intv.service.QueryHelper;
import kd.tsc.tspr.common.entity.intv.response.IntvInfoDTO;

public class AppFileInvHelper {
    private static final Log LOG = LogFactory.getLog(AppFileInvHelper.class);

    private AppFileInvHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static List<Map<String, Object>> getCandidateIntInfo(List<Long> candidateIdList) {
        if (candidateIdList == null) {
            LOG.warn("AppFileInvHelper.candidateIdList.is null");
            return Collections.emptyList();
        }
        LOG.info("AppFileInvHelper.getCandidateIntInfo:[{}]", candidateIdList);
        Object[] dys = (DynamicObject[])HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"getCandidateByCandidateIds", (Object[])new Object[]{candidateIdList});
        if (HRArrayUtils.isEmpty((Object[])dys)) {
            LOG.warn("AppFileInvHelper.getCandidate.is null");
            return Collections.emptyList();
        }
        Map<Long, Long> appFile2Candidate = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("appfileid"), dy -> dy.getLong("id")));
        LOG.info("AppFileInvHelper.appFile2Candidate:[{}]", appFile2Candidate);
        Set<Long> appFileIdSet = appFile2Candidate.keySet();
        if (appFileIdSet.isEmpty()) {
            LOG.warn("AppFileInvHelper.appFileIdList.is empty");
            return Collections.emptyList();
        }
        LOG.info("AppFileInvHelper.appFileIdSet:[{}]", appFileIdSet);
        String fields = "adminorg,position,modifytime";
        ArrayList<Long> appFileIdList = new ArrayList<Long>(appFileIdSet);
        Object[] appFileList = AppFileHelper.queryAppFiles(appFileIdList, fields);
        if (HRArrayUtils.isEmpty((Object[])appFileList)) {
            LOG.warn("AppFileInvHelper.appFileList.is empty");
            return Collections.emptyList();
        }
        Map<Long, List<IntvInfoDTO>> infoByAppFileIdList = QueryHelper.selectIntvInfoByAppFileIdList(appFileIdList);
        ArrayList appFileIntInfoVOList = Lists.newArrayListWithExpectedSize((int)candidateIdList.size());
        for (Object appFile : appFileList) {
            AppFileIntInfoVO appFileIntInfoVO = new AppFileIntInfoVO();
            IntInfoVO intInfoVO = new IntInfoVO();
            intInfoVO.setInterviewOrg(appFile.getString("position.adminorg.name"));
            intInfoVO.setInterviewOrgId(appFile.getLong("position.adminorg.id"));
            intInfoVO.setInterviewPosId(appFile.getLong("position.id"));
            intInfoVO.setInterviewPos(appFile.getString("position.name"));
            intInfoVO.setSource(appFile.getString("position.reccategory.name"));
            if (Objects.nonNull(infoByAppFileIdList)) {
                intInfoVO.setIntInfoList(infoByAppFileIdList.get(appFile.getLong("id")));
            }
            appFileIntInfoVO.setInfo(intInfoVO);
            appFileIntInfoVO.setUpdateDate(appFile.getString("modifytime"));
            appFileIntInfoVO.setCandidateId(appFile.getString("id"));
            appFileIntInfoVOList.add(appFileIntInfoVO);
        }
        String s = JSONObject.toJSONString((Object)appFileIntInfoVOList);
        return (List)JSONObject.parseObject((String)s, List.class);
    }
}

