/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.common.enums.TSRBDPreDataEnum;

public class AppFileOfferHelper {
    private static final Log LOG = LogFactory.getLog(AppFileOfferHelper.class);

    private AppFileOfferHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean validateOfferStatus(DynamicObject appFile) {
        try {
            Long appFileId = appFile.getLong("id");
            LOG.info("validateOfferStatus.appFileId:{}", (Object)appFileId);
            return (Boolean)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tso", (String)"offerBaseServiceApi", (String)"isInvalid", (Object[])new Object[]{appFileId});
        }
        catch (Exception ex) {
            LOG.error("validateOfferStatus.error", (Throwable)ex);
            return false;
        }
    }

    public static boolean validateInOfferStage(DynamicObject appFile) {
        long stageId = appFile.getLong("recrustg.id");
        return AppFileOfferHelper.validateInOfferStage(stageId);
    }

    public static boolean validateInOfferStage(Long stageId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbd_recrustgnew");
        DynamicObject stage = helper.queryOne((Object)stageId);
        return TSRBDPreDataEnum.RECSTGTYPE_OFFER.getId().equals(stage.getLong("group.id"));
    }

    public static boolean hasAddOfferRight(Long appFileOrgId) {
        try {
            return (Boolean)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tso", (String)"offerPermissServiceApi", (String)"hasOfferPermiss", (Object[])new Object[]{"btn_new_offer", appFileOrgId});
        }
        catch (Exception ex) {
            LOG.error("appFile.hasAddOfferRight.error", (Throwable)ex);
            return Boolean.FALSE;
        }
    }
}

