/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.service;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileRightHelper;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class AppFilePositionHelper {
    private static final Log logger = LogFactory.getLog(AppFilePositionHelper.class);
    private static final String POS_PROC_STG = "recruproc.entryentity.rqmtstg";

    private AppFilePositionHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<Long, String> queryPosPrinByAppFileId(List<Long> posIds) {
        DynamicObject[] positions;
        logger.info("AppFilePositionHelper.queryPosPrinByAppFileId.posIds {}", posIds);
        HashMap resMap = Maps.newHashMapWithExpectedSize((int)posIds.size());
        HRBaseServiceHelper posHelper = new HRBaseServiceHelper("tspr_positionmanage");
        String posprinField = "position,posprin";
        for (DynamicObject positionManage : positions = posHelper.query(posprinField, new QFilter("position", "in", posIds).toArray())) {
            DynamicObjectCollection posprin = positionManage.getDynamicObjectCollection("posprin");
            if (posprin == null) continue;
            Long id = positionManage.getLong("position.id");
            String posprinNames = posprin.stream().map(po -> po.getDynamicObject("fbasedataid")).filter(Objects::nonNull).sorted(Comparator.comparingLong(aa -> aa.getLong("id"))).map(jj -> jj.getString("name")).collect(Collectors.joining("\u3001"));
            resMap.put(id, posprinNames);
        }
        return resMap;
    }

    public static QFilter getPositionRightQFilter(Long orgId) {
        Long secLevelId;
        long userId = TSCRequestContext.getUserId();
        HasPermOrgResult posResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)"tssrm", (String)"tssrm_position_add", (String)"47150e89000000ac");
        if (!posResult.hasAllOrgPerm() && !posResult.getHasPermOrgs().contains(orgId)) {
            return new QFilter("1", "!=", (Object)1);
        }
        QFilter rightQFilter = new QFilter("createorg", "=", (Object)orgId);
        QFilter userAdminOrgFilter = TSCBizDataPermService.getUserAdminOrgsQFilter((Long)TSCRequestContext.getUserId(), (String)"tssrm", (String)"tssrm_position_add", (String)"47150e89000000ac", (String)"adminorg", Collections.emptyMap(), (String)"adminorgs.fbasedataid");
        if (userAdminOrgFilter != null) {
            rightQFilter.and(userAdminOrgFilter);
        }
        List<Long> orgIds = Collections.singletonList(orgId);
        QFilter dataPermissionFilter = ((PermissionService)ServiceFactory.getService(PermissionService.class)).getDataRuleWithoutDim(userId, AppMetadataCache.getAppInfo((String)"tssrm").getId(), "tssrm_position_add", "47150e89000000ac", orgIds);
        if (!posResult.hasAllOrgPerm() && (secLevelId = AppFileRightHelper.getUserSecLevelId(userId)) != null) {
            rightQFilter.and(AppFileRightHelper.getPostionSecLevelQFilter(secLevelId, userId));
        }
        if (dataPermissionFilter != null) {
            rightQFilter.and(dataPermissionFilter);
        }
        return rightQFilter;
    }

    public static QFilter getPositionRightQFilter(String position, boolean isOwner, Long orgId) {
        QFilter positionRightQFilter = AppFilePositionHelper.getPositionRightQFilter(orgId);
        if (isOwner) {
            QFilter qFilter = new QFilter("manageinfo.posprin.fbasedataid", "=", (Object)TSCRequestContext.getUserId());
            positionRightQFilter.and(qFilter);
        }
        DynamicObjectCollection positions = new HRBaseServiceHelper("tssrm_position_add").queryOriginalCollection("id", new QFilter[]{positionRightQFilter});
        return new QFilter(position, "in", positions.stream().map(pos -> pos.getLong("id")).collect(Collectors.toList()));
    }

    public static List<Long> queryPosProcStageIdList(long positionId) {
        HRBaseServiceHelper posHelper = new HRBaseServiceHelper("tspr_positionmanage");
        DynamicObjectCollection stageColl = posHelper.queryOriginalCollection(POS_PROC_STG, new QFilter("position", "=", (Object)positionId).toArray(), "recruproc.entryentity.seq");
        return stageColl.stream().map(dyo -> dyo.getLong(POS_PROC_STG)).collect(Collectors.toList());
    }

    public static List<Long> queryPosProcStageStatusIdList(long positionId, long stgId) {
        HRBaseServiceHelper posHelper = new HRBaseServiceHelper("tspr_positionmanage");
        DynamicObjectCollection statusColl = posHelper.queryOriginalCollection("recruproc.entryentity.subentryentity.jobstatus", new QFilter[]{new QFilter("position", "=", (Object)positionId), new QFilter(POS_PROC_STG, "=", (Object)stgId)}, "recruproc.entryentity.subentryentity.seq");
        return statusColl.stream().map(dyo -> dyo.getLong("recruproc.entryentity.subentryentity.jobstatus")).collect(Collectors.toList());
    }

    public static DynamicObject queryManageInfo(long positionId, String positionField) {
        HRBaseServiceHelper posHelper = new HRBaseServiceHelper("tspr_positionmanage");
        return posHelper.queryOne(positionField, new QFilter("position", "=", (Object)positionId).toArray());
    }

    public static DynamicObject[] queryPositions(QFilter positionQFilter) {
        HRBaseServiceHelper positionHelper = new HRBaseServiceHelper("tspr_position");
        return positionHelper.query("id,number,name", positionQFilter.toArray(), "positionpriority desc,modifytime desc,createtime desc");
    }
}

