/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.dynprocess.freeflow.WFAuditTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFDecisionOption;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowNode;
import kd.bos.workflow.engine.dynprocess.freeflow.WFParticipantEntity;
import kd.bos.workflow.engine.dynprocess.freeflow.WFProcess;
import kd.bos.workflow.engine.dynprocess.freeflow.WFUserTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tspr.business.domain.appfile.qacheck.QACheckKDStringHelper;
import kd.tsc.tspr.common.constants.appfile.qacheck.AppFileQACheckConstants;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.QuestionnaireHelper;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.question.IQuestionHandlerStrategy;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.question.QuestionContext;
import kd.tsc.tsrbd.common.entity.evalform.InspectDimensGroup;
import kd.tsc.tsrbd.common.entity.evalform.OptionGroup;
import kd.tsc.tsrbd.common.entity.evalform.SubjectGroup;
import kd.tsc.tsrbd.common.kdstring.TSCBaseKDString;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFAuditInfo;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFProcessInfo;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFUserInfo;
import kd.tsc.tsrbs.business.domain.workflow.service.FreeFlowImpl;
import kd.tsc.tsrbs.business.domain.workflow.service.FreeFlowInterface;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;

public class AppFileQACheckHelper {
    private static final Log LOG = LogFactory.getLog(AppFileQACheckHelper.class);
    public static final String CONSENT = "Consent";
    private static final FreeFlowInterface FREE_FLOW = FreeFlowImpl.freeFlowImpl;
    private static final ThreadPool QA_CHECK_THREAD_POOL = ThreadPools.newCachedThreadPool((String)"qacheck", (String)"tspr");
    private static final HRBaseServiceHelper QA_HELPER = new HRBaseServiceHelper("tspr_qacheck");

    private AppFileQACheckHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void buildTask(DynamicObject[] billDyns, String targetPage, String billPage) {
        QA_CHECK_THREAD_POOL.execute(() -> {
            try {
                DynamicObject[] upDateDyns;
                HashMap idAndFreeWorkMap = Maps.newHashMapWithExpectedSize((int)billDyns.length);
                ArrayList billIds = Lists.newArrayListWithExpectedSize((int)billDyns.length);
                for (DynamicObject billDyn : billDyns) {
                    String name = billDyn.getString("appfile.name");
                    WFProcess wfProcess = FREE_FLOW.initProcess(WFProcessInfo.init().setEntraBill(billDyn.getString("billno")).setEntraBillId(billDyn.getString("id")).setEntraBillName(name));
                    WFUserTask wfUserTask = FREE_FLOW.initWFUserTask(wfProcess, WFUserInfo.init());
                    wfProcess.addNextNode((WFFlowNode)wfUserTask);
                    ArrayList participant = Lists.newArrayListWithExpectedSize((int)1);
                    DynamicObject person = billDyn.getDynamicObject("handler");
                    String personId = person.getString("id");
                    WFParticipantEntity paritcipant = new WFParticipantEntity();
                    paritcipant.setType("person");
                    paritcipant.setValue(personId);
                    participant.add(paritcipant);
                    LOG.debug("AppFileQACheckHelper.buildTask.send.personId:{}", (Object)personId);
                    HashMap extPropMap = Maps.newHashMapWithExpectedSize((int)1);
                    HashMap extPropMapDetail = Maps.newHashMapWithExpectedSize((int)1);
                    extPropMapDetail.put("processingPage", targetPage);
                    extPropMap.put("properties", extPropMapDetail);
                    WFAuditInfo wfAuditInfo = WFAuditInfo.init().setParticipant((List)participant).setFormKey(billPage).setExtProps((Map)extPropMap).setDecisionOptions(AppFileQACheckHelper.initWFDecisionOptions());
                    WFAuditTask wfAuditTask = FREE_FLOW.initWFAuditTask(wfProcess, wfAuditInfo);
                    wfUserTask.addNextNode((WFFlowNode)wfAuditTask);
                    idAndFreeWorkMap.put(billDyn.getLong("id"), wfAuditTask.getId());
                    billIds.add(billDyn.getLong("id"));
                    FREE_FLOW.startFreeFlow(billPage, wfProcess.getEntraBillId(), wfProcess, "submit", (Map)Maps.newHashMap());
                }
                HRBaseServiceHelper helper = new HRBaseServiceHelper(billPage);
                for (DynamicObject upDateDyn : upDateDyns = helper.loadDynamicObjectArray(new QFilter("id", "in", (Object)billIds).toArray())) {
                    upDateDyn.set("flowtasknum", idAndFreeWorkMap.get(upDateDyn.getLong("id")));
                }
                helper.update(upDateDyns);
            }
            catch (RuntimeException ex) {
                LOG.error("AppFileQACheckHelper.buildTask.error", (Throwable)ex);
            }
        });
    }

    private static List<WFDecisionOption> initWFDecisionOptions() {
        ArrayList decisionOptions = Lists.newArrayListWithExpectedSize((int)1);
        WFDecisionOption agreeOption = new WFDecisionOption();
        agreeOption.setAuditType("approve");
        agreeOption.setDefaultDecision(true);
        agreeOption.setNumber(CONSENT);
        LocaleString localeString = new LocaleString();
        localeString.put(Lang.zh_CN.name(), (Object)AppFileResManagerHelper.getSubmitDesc());
        agreeOption.setName(localeString);
        decisionOptions.add(agreeOption);
        return decisionOptions;
    }

    public static void completeTask(List<Long> billIds, String entity) {
        DynamicObject[] billDyns;
        for (DynamicObject billDyn : billDyns = ServiceHelperCache.getHrBaseServiceHelper((String)entity).query("id,flowtasknum", new QFilter("id", "in", billIds).toArray())) {
            FREE_FLOW.completeTask(billDyn.getString("id"), billDyn.getString("flowtasknum"), Long.valueOf(TSCRequestContext.getUserId()), CONSENT, AppFileResManagerHelper.getSubmitDesc(), false);
        }
    }

    public static void cancelTask(List<Long> billIds) {
        try {
            for (Long billId : billIds) {
                WorkflowServiceHelper.abandonByBusienssKey((String)String.valueOf(billId));
            }
        }
        catch (RuntimeException cancelEx) {
            LOG.error("cancelTask.error:", (Throwable)cancelEx);
        }
    }

    public static List<InspectDimensGroup> getEvlConfigData(long evlId) {
        DynamicObject[] inspects = QuestionnaireHelper.findInspectDimOpByQuestionnaireId((String)String.valueOf(evlId));
        ArrayList<InspectDimensGroup> evalForm = new ArrayList<InspectDimensGroup>(inspects.length);
        ArrayList<SubjectGroup> subjects = new ArrayList<SubjectGroup>();
        ArrayList<OptionGroup> options = new ArrayList<OptionGroup>();
        for (DynamicObject inspect : inspects) {
            InspectDimensGroup inspectDimensGroup = new InspectDimensGroup();
            inspectDimensGroup.setId(inspect.getString("id"));
            inspectDimensGroup.setTitle(inspect.getString("name"));
            inspectDimensGroup.setDescription(inspect.getString("description"));
            inspectDimensGroup.setIndex(inspect.getInt("index"));
            DynamicObjectCollection questionentry = inspect.getDynamicObjectCollection("questionentry");
            for (DynamicObject question : questionentry) {
                AppFileQACheckHelper.handleQuestion(subjects, options, question);
            }
            inspectDimensGroup.setContent(subjects.stream().sorted(Comparator.comparing(SubjectGroup::getIndex)).collect(Collectors.toList()));
            subjects.clear();
            evalForm.add(inspectDimensGroup);
        }
        return evalForm.stream().sorted(Comparator.comparing(InspectDimensGroup::getIndex)).collect(Collectors.toList());
    }

    private static void handleQuestion(List<SubjectGroup> subjects, List<OptionGroup> options, DynamicObject question) {
        SubjectGroup subjectGroup = new SubjectGroup();
        subjectGroup.setqId(question.getString("id"));
        subjectGroup.setqTitle(question.getString("questioncontent"));
        subjectGroup.setqDesc(question.getString("questiondesc"));
        subjectGroup.setIsReqComment(Boolean.valueOf(question.getBoolean("requiredcomment")));
        subjectGroup.setIsRequired(Boolean.valueOf(question.getBoolean("required")));
        subjectGroup.setType(((IQuestionHandlerStrategy)QuestionContext.getStrategyMap().get(question.getString("questiontype"))).getQuestionTypeName());
        subjectGroup.setIsHaveComment(Boolean.valueOf(question.getBoolean("enablecomment")));
        subjectGroup.setIndex(question.getInt("seq"));
        DynamicObjectCollection optionsubentry = question.getDynamicObjectCollection("optionsubentry");
        for (DynamicObject option : optionsubentry) {
            OptionGroup optionGroup = new OptionGroup();
            optionGroup.setsId(option.getString("id"));
            optionGroup.setName(option.getString("optionname"));
            optionGroup.setIndex(option.getInt("seq"));
            options.add(optionGroup);
        }
        subjectGroup.setItems(options.stream().sorted(Comparator.comparing(OptionGroup::getIndex)).collect(Collectors.toList()));
        options.clear();
        subjects.add(subjectGroup);
    }

    public static void setResToEvlFormSys(String formDataJson, List<InspectDimensGroup> evlConfigData) {
        ArrayList formDataList = (ArrayList)SerializationUtils.fromJsonString((String)formDataJson, ArrayList.class);
        for (Map question : formDataList) {
            InspectDimensGroup inspectDimensGroup;
            Optional<SubjectGroup> subjectGroupOp;
            String inspectdimId = (String)question.get("inspectDimid");
            String inspectquId = (String)question.get("inspectQuid");
            Optional<InspectDimensGroup> inspectDimensGroupOp = evlConfigData.stream().filter(inspectItem -> HRStringUtils.equals((String)inspectItem.getId(), (String)inspectdimId)).findFirst();
            if (!inspectDimensGroupOp.isPresent() || !(subjectGroupOp = (inspectDimensGroup = inspectDimensGroupOp.get()).getContent().stream().filter(subjectItem -> HRStringUtils.equals((String)subjectItem.getqId(), (String)inspectquId)).findFirst()).isPresent()) continue;
            SubjectGroup subjectGroup = subjectGroupOp.get();
            String subjectType = subjectGroupOp.get().getType();
            if (HRStringUtils.equals((String)subjectType, (String)"simpleAnswer")) {
                subjectGroup.setSubAnswer((String)question.get("subAnswer"));
                continue;
            }
            subjectGroup.setSubComment((String)question.get("comment"));
            String optionId = (String)question.get("suboptionId");
            Optional<OptionGroup> optionGroupOptional = subjectGroup.getItems().stream().filter(optionItem -> HRStringUtils.equals((String)optionItem.getsId(), (String)optionId)).findFirst();
            if (!optionGroupOptional.isPresent()) continue;
            OptionGroup optionGroup = optionGroupOptional.get();
            optionGroup.setChecked(Boolean.TRUE);
        }
    }

    public static Map<Long, Long> getEvlFormIdByAppFile(DynamicObject[] appFiles) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)appFiles.length);
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("evltype", "=", (Object)"2");
        qFilter.and("issyspreset", "=", (Object)"1");
        qFilter.and("group", "in", (Object)appFiles[0].getLong("position.reccategory.id"));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbd_intvevlqunr");
        DynamicObject[] evlForms = helper.loadDynamicObjectArray(new QFilter[]{qFilter});
        HRBaseServiceHelper posHelper = new HRBaseServiceHelper("tspr_positionmanage");
        List posManageIds = Arrays.stream(appFiles).map(dyo -> dyo.getLong("position.manageinfo.id")).collect(Collectors.toList());
        DynamicObject[] posManages = posHelper.query("intvevlqunr.id", new QFilter("id", "in", posManageIds).toArray());
        Map<Long, DynamicObject> posManageMap = Arrays.stream(posManages).collect(Collectors.toMap(posManage -> posManage.getLong("id"), posManage -> posManage));
        for (DynamicObject appFile : appFiles) {
            long manageInfoId = appFile.getLong("position.manageinfo.id");
            DynamicObject manageInfo = posManageMap.get(manageInfoId);
            long evlFormId = 0L;
            if (manageInfo != null) {
                evlFormId = manageInfo.getLong("intvevlqunr.id");
            }
            if (evlFormId == 0L) {
                evlFormId = evlForms[0].getLong("id");
            }
            resultMap.put(appFile.getLong("id"), evlFormId);
        }
        return resultMap;
    }

    public static void submitData(IFormView qaCheckView, String result, String formData, String description) {
        DynamicObject qaCheckDyo = qaCheckView.getModel().getDataEntity();
        qaCheckDyo.set("result", (Object)result);
        qaCheckDyo.set("formdata", (Object)formData);
        qaCheckDyo.set("description", (Object)description);
        qaCheckView.invokeOperation("submit");
    }

    public static void showQACheckInfoPop(IFormView view, DynamicObject appFile, String qaCheckIdStr) {
        DynamicObject qaCheck = AppFileQACheckHelper.getQACheckInfo(appFile.getPkValue());
        if (HRObjectUtils.equals((Object)qaCheckIdStr, (Object)qaCheck.getString("id"))) {
            FormShowParameter showParameter = new FormShowParameter();
            AppFileQACheckHelper.handleQAInfoShowParameter(qaCheck, showParameter);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCaption(String.format(Locale.ROOT, QACheckKDStringHelper.qaCheckCaption(), appFile.getString("name")));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss styleCss = new StyleCss();
            showParameter.getOpenStyle().setInlineStyleCss(styleCss);
            showParameter.getOpenStyle().getInlineStyleCss().setWidth("700px");
            showParameter.getOpenStyle().getInlineStyleCss().setHeight("450px");
            view.showForm(showParameter);
        } else {
            view.showTipNotification(TSCBaseKDString.dataChangedTip());
        }
    }

    public static DynamicObject getQACheckInfo(Object appFileId) {
        return QA_HELPER.queryOne(TSCBaseUtils.getSelectProperties((String)"tspr_qacheck"), new QFilter[]{new QFilter("appfile", "=", appFileId)}, " createtime desc");
    }

    public static void handleQAInfoShowParameter(DynamicObject dataEntity, FormShowParameter showParameter) {
        showParameter.setFormId("tspr_qacheckinfo");
        long evlFormId = dataEntity.getLong("evlform.id");
        showParameter.setCustomParam("evlform", (Object)String.valueOf(evlFormId));
        showParameter.setCustomParam("formdata", (Object)dataEntity.getString("formdata"));
        showParameter.setCustomParam("result", (Object)dataEntity.getString("result"));
        showParameter.setCustomParam("description", (Object)dataEntity.getString("description"));
        showParameter.setCustomParam("billPkId", (Object)dataEntity.getString("id"));
    }

    public static boolean validateIsExistQa(Long appFileId, String actionKey, AbstractFormPlugin plugin) {
        DynamicObject[] qaChecks = QA_HELPER.query("auditstatus", new QFilter[]{new QFilter("appfile", "=", (Object)appFileId)}, "createtime desc");
        if (Arrays.stream(qaChecks).anyMatch(dyo -> AppFileQACheckConstants.AuditStatus.TEMP.getStatus().equals(dyo.getString("auditstatus")))) {
            ConfirmCallBackListener tempCallBack = new ConfirmCallBackListener(actionKey, (IFormPlugin)plugin);
            plugin.getView().showConfirm(QACheckKDStringHelper.cancelTaskConfirm(), MessageBoxOptions.OKCancel, tempCallBack);
            return true;
        }
        if (Arrays.stream(qaChecks).anyMatch(dyo -> AppFileQACheckConstants.AuditStatus.SUBMITED.getStatus().equals(dyo.getString("auditstatus")))) {
            ConfirmCallBackListener submitCallBack = new ConfirmCallBackListener(actionKey, (IFormPlugin)plugin);
            plugin.getView().showConfirm(QACheckKDStringHelper.desertQaConfirm(), MessageBoxOptions.OKCancel, submitCallBack);
            return true;
        }
        return false;
    }

    public static void desertQACheck(Long appFileId) {
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject[] qaChecks = QA_HELPER.query("auditstatus,flowtasknum", new QFilter[]{new QFilter("appfile", "=", (Object)appFileId)}, "createtime desc");
                ArrayList cancelTaskIds = Lists.newArrayListWithExpectedSize((int)qaChecks.length);
                for (DynamicObject qaCheck : qaChecks) {
                    if (AppFileQACheckConstants.AuditStatus.TEMP.getStatus().equals(qaCheck.getString("auditstatus")) && HRStringUtils.isNotEmpty((String)qaCheck.getString("flowtasknum"))) {
                        cancelTaskIds.add(qaCheck.getLong("id"));
                    }
                    qaCheck.set("auditstatus", (Object)AppFileQACheckConstants.AuditStatus.DESERT.getStatus());
                }
                if (!cancelTaskIds.isEmpty()) {
                    AppFileQACheckHelper.cancelTask(cancelTaskIds);
                }
                QA_HELPER.update(qaChecks);
            }
            catch (RuntimeException ex) {
                LOG.error("desertQACheck.error:", (Throwable)ex);
                tx.markRollback();
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    public static OperationResult validateAppFileQARight(String entityId, Long appFileId) {
        return OperationServiceHelper.executeOperate((String)"qacheckright", (String)entityId, (Object[])new Object[]{appFileId}, null);
    }

    public static void startTask(Long appFileId, DynamicObject qaUser) {
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject[] appFiles = AppFileHelper.queryAppFiles(Collections.singletonList(appFileId), "createorg,position,recrustg,qacheckresult");
                Map<Long, Long> evlFormResMap = AppFileQACheckHelper.getEvlFormIdByAppFile(appFiles);
                DynamicObject[] billDyns = new DynamicObject[appFiles.length];
                for (int i = 0; i < appFiles.length; ++i) {
                    DynamicObject appfile = appFiles[i];
                    HRBaseServiceHelper helper = new HRBaseServiceHelper("tspr_qacheck");
                    DynamicObject billDyn = helper.generateEmptyDynamicObject();
                    billDyn.set("auditstatus", (Object)"A");
                    billDyn.set("appfile", (Object)appfile);
                    billDyn.set("recrustg", appfile.get("recrustg"));
                    billDyn.set("handler", (Object)qaUser);
                    billDyn.set("evlform", (Object)evlFormResMap.get(appFileId));
                    billDyn.set("creator", (Object)TSCRequestContext.getUserId());
                    billDyn.set("createtime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
                    billDyns[i] = billDyn;
                    appfile.set("qacheckresult", (Object)AppFileQACheckConstants.Status.NOT_FEEDBACK.getStatus());
                }
                AppFileHelper.update(appFiles);
                OperationServiceHelper.executeOperate((String)"save", (String)"tspr_qacheck", (DynamicObject[])billDyns, null);
                AppFileQACheckHelper.buildTask(billDyns, "tspr_tasktobill", "tspr_qacheck");
            }
            catch (RuntimeException ex) {
                LOG.error("AppFileQACheckHelper.startTask.error", (Throwable)ex);
                tx.markRollback();
                throw ex;
            }
        }
    }

    public static Set<Long> getAllHRPersonIds() {
        DynamicObjectCollection relations = QueryServiceHelper.query((String)"hrpi_personuserrel", (String)"user", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        return relations.stream().map(dyo -> dyo.getLong("user")).collect(Collectors.toSet());
    }
}

