/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.common.constants.position.PositionManageConstants;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecuserHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class AppFileRightHelper {
    private static final Log LOG = LogFactory.getLog(AppFileRightHelper.class);
    private static final PermissionService PERM_SERVICE = (PermissionService)ServiceFactory.getService(PermissionService.class);

    private AppFileRightHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static HasPermOrgResult getManagePermResult(String permItemId, Long userId) {
        return AppFileRightHelper.getPermOrgResult("tssrm", "tssrm_appfile_viewm", userId, permItemId);
    }

    public static HasPermOrgResult getMyChargePermResult(String permItemId, Long userId) {
        return AppFileRightHelper.getPermOrgResult("tssrm", "tssrm_appfile_viewc", userId, permItemId);
    }

    public static HasPermOrgResult getPermOrgResult(String appId, String pageId, Long userId, String permItemId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)pageId);
        String orgViewType = PermCommonUtil.getPermOrgViewSchemeByOrgField((MainEntityType)dataEntityType, (String)"createorg");
        return PermissionServiceHelper.getAllPermOrgs((long)userId, (String)orgViewType, (String)appId, (String)pageId, (String)permItemId);
    }

    public static List<Long> getAllPermOrg(String appId, String pageId, Long userId, String permItemId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)pageId);
        String orgViewType = PermCommonUtil.getPermOrgViewSchemeByOrgField((MainEntityType)dataEntityType, (String)"createorg");
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)orgViewType, (String)appId, (String)pageId, (String)permItemId);
        return allPermOrgs.hasAllOrgPerm() ? OrgUnitServiceHelper.getAllOrg((String)orgViewType) : allPermOrgs.getHasPermOrgs();
    }

    public static boolean hasRight(Long appFileId, String appId, Long userId, String permItem) {
        if (HRStringUtils.equals((String)"tssrm", (String)appId)) {
            boolean hasManageAppFileRight = !AppFileRightHelper.hasAppFileRight(Lists.newArrayList((Object[])new Long[]{appFileId}), userId, "tssrm_appfile_viewm", permItem, false).isEmpty();
            boolean hasChargeAppFileRight = !AppFileRightHelper.hasAppFileRight(Lists.newArrayList((Object[])new Long[]{appFileId}), userId, "tssrm_appfile_viewc", permItem, true).isEmpty();
            return hasManageAppFileRight || hasChargeAppFileRight;
        }
        return false;
    }

    public static Map<Long, Boolean> hasRight(List<Long> appFileIds, String appId, Long userId, String permItem) {
        Map<Long, Boolean> rightMap = appFileIds.stream().collect(Collectors.toMap(pkId -> pkId, boo -> Boolean.FALSE));
        if (HRStringUtils.equals((String)"tssrm", (String)appId)) {
            List<Long> manageRightIds = AppFileRightHelper.hasAppFileRight(appFileIds, userId, "tssrm_appfile_viewm", permItem, false);
            List<Long> chargeRightIds = AppFileRightHelper.hasAppFileRight(appFileIds, userId, "tssrm_appfile_viewc", permItem, true);
            for (Long manageRightId : manageRightIds) {
                rightMap.put(manageRightId, Boolean.TRUE);
            }
            for (Long chargeRightId : chargeRightIds) {
                rightMap.put(chargeRightId, Boolean.TRUE);
            }
        }
        return rightMap;
    }

    public static List<Long> hasAppFileRight(List<Long> appFileIdList, Long userId, String pageNumber, String permItemId, boolean isOwner) {
        Long secLevelId;
        QFilter userAdminOrgFilter;
        HasPermOrgResult permResult;
        LOG.info("hasTSSRMManageRight.params:{},{},{},{}", new Object[]{appFileIdList, userId, permItemId, isOwner});
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            return new ArrayList<Long>(appFileIdList);
        }
        QFilter qFilter = new QFilter("id", "in", appFileIdList);
        if (isOwner) {
            qFilter.and("position.manageinfo.posprin.fbasedataid", "=", (Object)userId);
        }
        if (!(permResult = AppFileRightHelper.getPermOrgResult("tssrm", pageNumber, userId, permItemId)).hasAllOrgPerm()) {
            qFilter.and("createorg", "in", (Object)permResult.getHasPermOrgs());
        }
        if ((userAdminOrgFilter = TSCBizDataPermService.getUserAdminOrgsQFilter((Long)TSCRequestContext.getUserId(), (String)"tssrm", (String)pageNumber, (String)"47150e89000000ac", (String)"adminorg", Collections.emptyMap(), (String)"adminorg")) != null) {
            qFilter.and(userAdminOrgFilter);
        }
        if ((secLevelId = AppFileRightHelper.getUserSecLevelId(userId)) != null) {
            QFilter secLevelQFilter = AppFileRightHelper.getSecLevelQFilter(secLevelId, userId);
            qFilter.and(secLevelQFilter);
        }
        if (!permResult.hasAllOrgPerm()) {
            QFilter dataPermissionFilter = PERM_SERVICE.getDataRuleWithoutDim(userId.longValue(), AppMetadataCache.getAppInfo((String)"tssrm").getId(), pageNumber, permItemId, permResult.getHasPermOrgs());
            qFilter.and(dataPermissionFilter);
        }
        LOG.info("hasAppFileRight.qfilter:{}", (Object)qFilter);
        return Arrays.stream(AppFileHelper.queryAppFiles("id", qFilter.toArray())).map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
    }

    public static QFilter getAppFileRightQFilter(String appFileFieldPre, Long userId, String permItemId) {
        QFilter qFilter;
        HasPermOrgResult managePermResult = AppFileRightHelper.getManagePermResult(permItemId, userId);
        if (!managePermResult.hasAllOrgPerm()) {
            Long secLevelId;
            qFilter = new QFilter(appFileFieldPre + "createorg", "in", (Object)managePermResult.getHasPermOrgs());
            QFilter userAdminOrgFilter = TSCBizDataPermService.getUserAdminOrgsQFilter((Long)TSCRequestContext.getUserId(), (String)"tssrm", (String)"tssrm_appfile_viewm", (String)"47150e89000000ac", (String)"adminorg", Collections.emptyMap(), (String)(appFileFieldPre + "adminorg"));
            if (userAdminOrgFilter != null) {
                qFilter.and(userAdminOrgFilter);
            }
            if ((secLevelId = AppFileRightHelper.getUserSecLevelId(userId)) != null) {
                QFilter secLevelQFilter = AppFileRightHelper.getSecLevelQFilter(secLevelId, userId, appFileFieldPre);
                qFilter.and(secLevelQFilter);
            }
        } else {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"tspr_appfile");
            String orgViewType = PermCommonUtil.getPermOrgViewSchemeByOrgField((MainEntityType)dataEntityType, (String)"createorg");
            qFilter = new QFilter(appFileFieldPre + "createorg", "in", (Object)OrgUnitServiceHelper.getAllOrg((String)orgViewType));
        }
        return qFilter;
    }

    public static QFilter getSecLevelQFilter(Long secLevelId, Long userId, String appFilePre) {
        if (secLevelId == null) {
            return null;
        }
        return new QFilter(appFilePre + "position" + '.' + "manageinfo" + ".seclevel", ">=", (Object)secLevelId).or(new QFilter(appFilePre + "position" + '.' + "creator", "=", (Object)userId));
    }

    public static QFilter getSecLevelQFilter(Long secLevelId, Long userId) {
        return AppFileRightHelper.getSecLevelQFilter(secLevelId, userId, "");
    }

    public static Long getUserSecLevelId(Long userId) {
        DynamicObject securityLevel = SecuserHelper.queryUserSecurityLevel((Long)userId, (Long)PositionManageConstants.SECLEVEL_NUMBER);
        if (securityLevel != null) {
            return securityLevel.getLong("id");
        }
        return null;
    }

    public static QFilter getPostionSecLevelQFilter(Long secLevelId, Long currUserId) {
        QFilter qFilter = new QFilter("manageinfo.seclevel", ">=", (Object)secLevelId);
        return qFilter.or(new QFilter("creator", "=", (Object)currUserId));
    }
}

