/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.service;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileStatusHelper;
import kd.tsc.tspr.business.domain.appfile.ChangeStageStatusHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileOpRecordService;
import kd.tsc.tspr.common.constants.appfile.AppFileConstants;
import kd.tsc.tsrbd.business.domain.cfgresurule.service.CfgResumeRuleHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.common.RsmCommonService;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import kd.tsc.tsrbs.common.enums.rsm.RsmSourceEnum;
import org.apache.commons.lang3.ObjectUtils;

public class AppFileRsmHelper {
    private static final Log logger = LogFactory.getLog(AppFileRsmHelper.class);
    private static final HRBaseServiceHelper APP_FILE_HELPER = new HRBaseServiceHelper("tspr_appfile");
    private static final HRBaseServiceHelper RSN_HELPER = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_srrsm");

    private AppFileRsmHelper() {
    }

    public static void saveAppFileOperation(DynamicObject appFile, DynamicObject position, AppResumeBo resumeBo) {
        boolean isNew;
        logger.info("saveAppFileOperation.params:{}{}{}", new Object[]{appFile, position, resumeBo});
        boolean bl = isNew = !appFile.getDataEntityState().getFromDatabase();
        if (isNew) {
            appFile.set("isbinddelyrec", (Object)"0");
            appFile.set("creator", (Object)TSCRequestContext.getUserId());
            appFile.set("createtime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            appFile.set("status", (Object)"C");
            appFile.set("masterid", (Object)appFile.getLong("id"));
            long creatOrgId = AppFileRsmHelper.getCreateOrgId(appFile, position);
            String formId = "";
            formId = "MK".equals(resumeBo.getTpSys()) ? "tsrsc_appfile_view" : "tssrm_appfile";
            String number = CodeRuleServiceHelper.getNumber((String)formId, (DynamicObject)appFile, (String)String.valueOf(creatOrgId));
            appFile.set("number", (Object)number);
            appFile.set("createorg", (Object)creatOrgId);
            appFile.set("adminorg", (Object)position.getLong("adminorg.id"));
            appFile.set("positionsnap", position.get("vid"));
            appFile.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            appFile.set("validrecruchnlnm", (Object)resumeBo.getDelivery().getLong("recruchnlnm.id"));
            appFile.set("jobrankstatus", (Object)"W");
            appFile.set("setsalarystatus", (Object)"W");
            HRBaseServiceHelper posHelper = new HRBaseServiceHelper("tspr_positionmanage");
            DynamicObject positionManage = posHelper.queryOne("recruproc", new QFilter("position", "=", (Object)position.getLong("id")));
            if (ObjectUtils.isNotEmpty((Object)positionManage)) {
                Long procId = positionManage.getLong("recruproc.id");
                appFile.set("recruproc", (Object)procId);
                HRBaseServiceHelper processHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
                DynamicObject recProcess = processHelper.queryOne((Object)procId);
                DynamicObjectCollection entries = recProcess.getDynamicObjectCollection("entryentity");
                if (!entries.isEmpty()) {
                    DynamicObject firstEntry = (DynamicObject)entries.get(0);
                    long stgId = firstEntry.getLong("rqmtstg.id");
                    DynamicObjectCollection subEntries = firstEntry.getDynamicObjectCollection("subentryentity");
                    long statId = 0L;
                    if (!subEntries.isEmpty()) {
                        DynamicObject firstSubEntry = (DynamicObject)subEntries.get(0);
                        statId = firstSubEntry.getLong("jobstatus.id");
                    }
                    ChangeStageStatusHelper.saveStageTraceNoUpdateAppFile(stgId, statId, 0L, new DynamicObject[]{appFile});
                }
            }
        }
        RsmCommonService.updateAppFileByAppResume((DynamicObject)appFile, (AppResumeBo)resumeBo);
        RsmCommonService.updateAppFileDeliveryByAppResume((DynamicObject)appFile, (AppResumeBo)resumeBo);
        if (isNew) {
            APP_FILE_HELPER.saveOne(appFile);
            ArrayList appFileIdList = Lists.newArrayList((Object[])new Long[]{appFile.getLong("id")});
            AppFileOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), OpDefEnum.CREATE, appFileIdList, null);
        } else {
            APP_FILE_HELPER.updateOne(appFile);
        }
    }

    private static long getCreateOrgId(DynamicObject appFile, DynamicObject position) {
        long creatOrgId = position.getLong("createorg.id");
        String tpdataid = appFile.getString("tpdataid");
        if (HRStringUtils.isEmpty((String)tpdataid)) {
            return creatOrgId;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_atsmsgrecord");
        QFilter qFilter = new QFilter("tpdataid", "=", (Object)tpdataid);
        DynamicObject atsDy = serviceHelper.loadDynamicObject(qFilter);
        if (HRObjectUtils.isEmpty((Object)atsDy)) {
            return creatOrgId;
        }
        String tptenantid = atsDy.getString("tptenantid");
        if (HRStringUtils.isEmpty((String)tptenantid)) {
            return creatOrgId;
        }
        HRBaseServiceHelper tenantServiceHelper = new HRBaseServiceHelper("tsrsc_partner_tenant");
        QFilter tenantFilter = new QFilter("apikey", "=", (Object)tptenantid);
        DynamicObject tenantDy = tenantServiceHelper.loadDynamicObject(tenantFilter);
        if (HRObjectUtils.isEmpty((Object)tenantDy)) {
            return creatOrgId;
        }
        creatOrgId = tenantDy.getLong("hrorgfield.id");
        return creatOrgId;
    }

    public static DynamicObject findAppFileByRsmId(long rsmId) {
        DynamicObject rsmDy;
        DynamicObject appFileDy = AppFileHelper.findAppFileByRsmId(rsmId);
        if (appFileDy == null && null != (rsmDy = RSN_HELPER.queryOne("appfile", (Object)rsmId))) {
            long appFileId = rsmDy.getLong("appfile.id");
            appFileDy = AppFileHelper.queryOne(appFileId);
        }
        return appFileDy;
    }

    public static void filterEliminateCandidate(Long appFileId, Long rsmId, Long positionId) {
        logger.info("filterEliminateCandidate.params:{},{},{}", new Object[]{appFileId, rsmId, positionId});
        DynamicObject appFile = AppFileHelper.queryOne(appFileId);
        if (positionId != null && CfgResumeRuleHelper.isCandidateEliminated((long)rsmId, (long)positionId)) {
            AppFileStatusHelper.eliminateAppFile(new DynamicObject[]{appFile}, "2", null, null);
        } else {
            DynamicObject rsm = RSN_HELPER.queryOne((Object)rsmId);
            String rsmSource = rsm.getString("rsmsource");
            logger.info("filterEliminateCandidate.validate:{}", (Object)rsmSource);
            if (RsmSourceEnum.EMAIL.getCode().equals(rsmSource) && AppFileConstants.APP_FILE_STATUS_OUT.equals(appFile.getString("filestatus"))) {
                AppFileStatusHelper.eliminateAppFile(new DynamicObject[]{appFile}, "3", null, null);
            }
        }
    }
}

