/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileFlowLockControlHelper;
import kd.tsc.tspr.common.constants.appfile.AppFileOperateEnum;
import kd.tsc.tspr.common.constants.appfile.AppFileStatusEnum;

public class AppFileService {
    private static final Log logger = LogFactory.getLog(AppFileService.class);
    private static final AppFileService appFileService = new AppFileService();

    public static AppFileService getInstance() {
        return appFileService;
    }

    private AppFileService() {
    }

    public ValidateResult validateAppFileInProcessAndLocked(List<Long> appFileIdList) {
        logger.info("validateAppFileInProcessAndLocked.appFileIds:{}", appFileIdList);
        return AppFileOpHelper.validateAppFiles(appFileIdList, null, true);
    }

    public ValidateResult validateAppFileInProcessAndLocked(List<Long> appFileIdList, String operationName) {
        logger.info("validateAppFileInProcessAndLocked.appFileIds:{}\uff0cwith operationName", appFileIdList);
        return AppFileOpHelper.validateAppFiles(appFileIdList, operationName, true);
    }

    public ValidateResult validateAppFileInProcessAndLocked(List<Long> appFileIdList, String operationName, boolean ignoreNumber) {
        logger.info("validateAppFileInProcessAndLocked.appFileIds:{}", appFileIdList);
        return AppFileOpHelper.validateAppFiles(appFileIdList, operationName, ignoreNumber);
    }

    public void lockAppFiles(List<Long> appFileIdList, Long lockerId) {
        logger.info("lockAppFiles.appFileIds:{},{}", appFileIdList, (Object)lockerId);
        AppFileFlowLockHelper.lockAppFiles(appFileIdList, lockerId);
    }

    public void lockAppFiles(List<Long> appFileIdList, Long lockerId, AppFileOperateEnum appFileOperateEnum, boolean directLock) {
        logger.info("lockAppFiles.appFileIds:{},{},{},{}", new Object[]{appFileIdList, lockerId, appFileOperateEnum, directLock});
        AppFileFlowLockControlHelper.lockAppFiles(appFileIdList, lockerId, appFileOperateEnum, directLock);
    }

    public void breakupAppFile(Long appFileId) {
        HashMap<String, Object> updateAppFileFieldMap = new HashMap<String, Object>(1);
        updateAppFileFieldMap.put("filestatus", AppFileStatusEnum.ENDEMP.getValue());
        AppFileDataHelper.updateAppFileById(appFileId, updateAppFileFieldMap);
    }

    public Map<String, DynamicObject> getResumeInfoByAppFileId(Long appFileId) {
        Map resultMap = null;
        try {
            DynamicObject appFileDy = AppFileDataHelper.queryAppFileById(appFileId);
            Long resumeId = Optional.ofNullable(appFileDy).map(a -> a.getDynamicObject("appres").getLong("id")).orElse(0L);
            resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)"rsmServiceApi", (String)"queryResumeById", (Object[])new Object[]{resumeId});
        }
        catch (Exception ex) {
            logger.error("AppFileService=>tsc.tstpm.rsmServiceApi.queryResumeById error", (Throwable)ex);
        }
        return resultMap;
    }
}

